<?php
/**
 * Cherry-services-list hooks.
 *
 * @package Swanxy
 */

// Customization cherry-services-list plugin.
add_filter( 'cherry_services_list_meta_options_args', 'swanxy_change_services_list_icon_pack' );
add_filter( 'cherry_services_default_icon_format', 'swanxy_cherry_services_default_icon_format' );
add_filter( 'cherry_services_listing_templates_list', 'swanxy_cherry_services_listing_templates_list' );
add_filter( 'cherry_services_features_title_format', 'swanxy_cherry_services_features_title_format' );
add_filter( 'cherry_services_styles', 'swanxy_dequeue_cherry_services_grid_style' );

/**
 * Change cherry-services-list icon pack.
 */
function swanxy_change_services_list_icon_pack( $fields ) {

	$fields['fields']['cherry-services-icon']['auto_parse'] = true ;
	$fields['fields']['cherry-services-icon']['icon_data'] = array(
		'icon_set'    => 'swanxyNucleoOutline',
		'icon_css'    => SWANXY_THEME_CSS . '/nucleo-outline.css',
		'icon_base'   => 'nc-icon-outline',
		'icon_prefix' => '',
	);

	return $fields;
}

/**
 * Change cherry-services-list icon format
 *
 * @return string
 */
function swanxy_cherry_services_default_icon_format( $icon_format ) {
	return '<i class="nc-icon-outline %s"></i>';
}

/**
 *  Add template to cherry services-list templates list;
 */
function swanxy_cherry_services_listing_templates_list( $tmpl_list ) {

	$tmpl_list['media-icon-float'] = 'media-icon-float.tmpl';

	return $tmpl_list;
}

/**
 * Change cherry-services features title format.
 */
function swanxy_cherry_services_features_title_format( $title_format ) {
	return '<h5 class="service-features_title">%s</h5>';
}

/**
 * Dequeue cherry-services grid style.
 *
 * @param array $styles Cherry services list styles.
 *
 * @return array
 */
function swanxy_dequeue_cherry_services_grid_style ( $styles = array() ) {

	unset( $styles['cherry-services-grid'] );

	return $styles;
}
