SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;


DROP TABLE IF EXISTS `wp_bp_activity`;
CREATE TABLE IF NOT EXISTS `wp_bp_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `component` varchar(75) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(75) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `primary_link` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `secondary_item_id` bigint(20) DEFAULT NULL,
  `date_recorded` datetime NOT NULL,
  `hide_sitewide` tinyint(1) DEFAULT '0',
  `mptt_left` int(11) NOT NULL DEFAULT '0',
  `mptt_right` int(11) NOT NULL DEFAULT '0',
  `is_spam` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `date_recorded` (`date_recorded`),
  KEY `user_id` (`user_id`),
  KEY `item_id` (`item_id`),
  KEY `secondary_item_id` (`secondary_item_id`),
  KEY `component` (`component`),
  KEY `type` (`type`),
  KEY `mptt_left` (`mptt_left`),
  KEY `mptt_right` (`mptt_right`),
  KEY `hide_sitewide` (`hide_sitewide`),
  KEY `is_spam` (`is_spam`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_bp_activity` (`id`, `user_id`, `component`, `type`, `action`, `content`, `primary_link`, `item_id`, `secondary_item_id`, `date_recorded`, `hide_sitewide`, `mptt_left`, `mptt_right`, `is_spam`) VALUES
(1, 1, 'members', 'last_activity', '', '', '', 0, NULL, '2017-05-10 14:29:41', 0, 0, 0, 0);

DROP TABLE IF EXISTS `wp_bp_activity_meta`;
CREATE TABLE IF NOT EXISTS `wp_bp_activity_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `activity_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `activity_id` (`activity_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `wp_bp_notifications`;
CREATE TABLE IF NOT EXISTS `wp_bp_notifications` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `item_id` bigint(20) NOT NULL,
  `secondary_item_id` bigint(20) DEFAULT NULL,
  `component_name` varchar(75) COLLATE utf8mb4_unicode_ci NOT NULL,
  `component_action` varchar(75) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_notified` datetime NOT NULL,
  `is_new` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `secondary_item_id` (`secondary_item_id`),
  KEY `user_id` (`user_id`),
  KEY `is_new` (`is_new`),
  KEY `component_name` (`component_name`),
  KEY `component_action` (`component_action`),
  KEY `useritem` (`user_id`,`is_new`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `wp_bp_notifications_meta`;
CREATE TABLE IF NOT EXISTS `wp_bp_notifications_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `notification_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `notification_id` (`notification_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `wp_bp_xprofile_data`;
CREATE TABLE IF NOT EXISTS `wp_bp_xprofile_data` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `field_id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `field_id` (`field_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_bp_xprofile_data` (`id`, `field_id`, `user_id`, `value`, `last_updated`) VALUES
(1, 1, 1, 'admin', '2017-05-10 13:57:23');

DROP TABLE IF EXISTS `wp_bp_xprofile_fields`;
CREATE TABLE IF NOT EXISTS `wp_bp_xprofile_fields` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `group_id` bigint(20) UNSIGNED NOT NULL,
  `parent_id` bigint(20) UNSIGNED NOT NULL,
  `type` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_required` tinyint(1) NOT NULL DEFAULT '0',
  `is_default_option` tinyint(1) NOT NULL DEFAULT '0',
  `field_order` bigint(20) NOT NULL DEFAULT '0',
  `option_order` bigint(20) NOT NULL DEFAULT '0',
  `order_by` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `can_delete` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `parent_id` (`parent_id`),
  KEY `field_order` (`field_order`),
  KEY `can_delete` (`can_delete`),
  KEY `is_required` (`is_required`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_bp_xprofile_fields` (`id`, `group_id`, `parent_id`, `type`, `name`, `description`, `is_required`, `is_default_option`, `field_order`, `option_order`, `order_by`, `can_delete`) VALUES
(1, 1, 0, 'textbox', 'Name', '', 1, 0, 0, 0, '', 0);

DROP TABLE IF EXISTS `wp_bp_xprofile_groups`;
CREATE TABLE IF NOT EXISTS `wp_bp_xprofile_groups` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_order` bigint(20) NOT NULL DEFAULT '0',
  `can_delete` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `can_delete` (`can_delete`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_bp_xprofile_groups` (`id`, `name`, `description`, `group_order`, `can_delete`) VALUES
(1, 'Base', '', 0, 0);

DROP TABLE IF EXISTS `wp_bp_xprofile_meta`;
CREATE TABLE IF NOT EXISTS `wp_bp_xprofile_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `object_id` bigint(20) NOT NULL,
  `object_type` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `wp_commentmeta`;
CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `wp_comments`;
CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_comments` (`comment_ID`, `comment_post_ID`, `comment_author`, `comment_author_email`, `comment_author_url`, `comment_author_IP`, `comment_date`, `comment_date_gmt`, `comment_content`, `comment_karma`, `comment_approved`, `comment_agent`, `comment_type`, `comment_parent`, `user_id`) VALUES
(26, 3520, 'Brian Williamson', 'm@m.com', '', '::1', '2017-05-15 12:34:01', '2017-05-15 12:34:01', 'Thank you for your opinion! I\'m glad that you found this article interesting, and I hope to continue this topic in further publications.', 0, '1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:53.0) Gecko/20100101 Firefox/53.0', '', 0, 1),
(27, 3520, 'Brian Williamson', 'm@m.com', '', '::1', '2017-05-15 12:34:11', '2017-05-15 12:34:11', 'Very useful post! Thanks for sharing! Now I’ll be planning my visit to your company to pick the best strategy for my business.', 0, '1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:53.0) Gecko/20100101 Firefox/53.0', '', 26, 1),
(28, 3520, 'Brian Williamson', 'm@m.com', '', '::1', '2017-05-15 12:34:16', '2017-05-15 12:34:16', 'Very useful post! Thanks for sharing! Now I’ll be planning my visit to your company to pick the best strategy for my business.', 0, '1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:53.0) Gecko/20100101 Firefox/53.0', '', 0, 1);

DROP TABLE IF EXISTS `wp_ewwwio_images`;
CREATE TABLE IF NOT EXISTS `wp_ewwwio_images` (
  `id` int(14) UNSIGNED NOT NULL AUTO_INCREMENT,
  `attachment_id` bigint(20) UNSIGNED DEFAULT NULL,
  `gallery` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resize` varchar(75) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `converted` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `results` varchar(75) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image_size` int(10) UNSIGNED DEFAULT NULL,
  `orig_size` int(10) UNSIGNED DEFAULT NULL,
  `backup` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `level` int(5) UNSIGNED DEFAULT NULL,
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `updates` int(5) UNSIGNED DEFAULT NULL,
  `updated` timestamp NULL DEFAULT '1970-12-31 22:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `trace` blob,
  UNIQUE KEY `id` (`id`),
  KEY `path_image_size` (`path`(191),`image_size`),
  KEY `attachment_info` (`gallery`(3),`attachment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1815 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_ewwwio_images` (`id`, `attachment_id`, `gallery`, `resize`, `path`, `converted`, `results`, `image_size`, `orig_size`, `backup`, `level`, `pending`, `updates`, `updated`, `trace`) VALUES
(1, 3807, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700.jpg', '', 'Reduced by 39.9% (801.1 KB)', 1234368, 2054707, '', NULL, 0, 1, '2017-05-19 08:14:18', NULL),
(2, 3807, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-295x222.jpg', '', 'Reduced by 4.0% (622 B)', 14885, 15507, '', NULL, 0, 1, '2017-05-19 08:14:18', NULL),
(3, 3807, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-300x300.jpg', '', 'Reduced by 4.3% (713 B)', 15891, 16604, '', NULL, 0, 1, '2017-05-19 08:14:18', NULL),
(4, 3807, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-768x768.jpg', '', 'Reduced by 13.1% (13.6 KB)', 92509, 106394, '', NULL, 0, 1, '2017-05-19 08:14:19', NULL),
(5, 3807, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-1024x1024.jpg', '', 'Reduced by 12.9% (22.2 KB)', 152534, 175218, '', NULL, 0, 1, '2017-05-19 08:14:19', NULL),
(6, 3807, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-769x431.jpg', '', 'Reduced by 3.2% (3.2 KB)', 98292, 101520, '', NULL, 0, 1, '2017-05-19 08:14:19', NULL),
(7, 3807, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-418x315.jpg', '', 'Reduced by 3.3% (1.0 KB)', 30818, 31870, '', NULL, 0, 1, '2017-05-19 08:14:19', NULL),
(8, 3807, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-150x150.jpg', '', 'Reduced by 10.1% (443 B)', 3928, 4371, '', NULL, 0, 1, '2017-05-19 08:14:19', NULL),
(9, 3807, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-158x88.jpg', '', 'Reduced by 9.1% (418 B)', 4191, 4609, '', NULL, 0, 1, '2017-05-19 08:14:19', NULL),
(10, 3807, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-400x400.jpg', '', 'Reduced by 4.0% (1.1 KB)', 28281, 29457, '', NULL, 0, 1, '2017-05-19 08:14:20', NULL),
(11, 3807, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-650x490.jpg', '', 'Reduced by 3.2% (2.4 KB)', 73665, 76119, '', NULL, 0, 1, '2017-05-19 08:14:20', NULL),
(12, 3807, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-418x418.jpg', '', 'Reduced by 3.8% (1.2 KB)', 31665, 32919, '', NULL, 0, 1, '2017-05-19 08:14:20', NULL),
(13, 3807, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-886x668.jpg', '', 'Reduced by 12.5% (16.3 KB)', 117219, 133904, '', NULL, 0, 1, '2017-05-19 08:14:20', NULL),
(14, 3807, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-886x315.jpg', '', 'Reduced by 11.0% (13.0 KB)', 107814, 121154, '', NULL, 0, 1, '2017-05-19 08:14:20', NULL),
(15, 3807, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-1920x1080.jpg', '', 'Reduced by 14.2% (60.8 KB)', 376095, 438324, '', NULL, 0, 1, '2017-05-19 08:14:21', NULL),
(16, 3807, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-1920x820.jpg', '', 'Reduced by 13.3% (55.8 KB)', 372587, 429750, '', NULL, 0, 1, '2017-05-19 08:14:21', NULL),
(17, 3807, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-512x512.jpg', '', 'Reduced by 3.5% (1.6 KB)', 46580, 48268, '', NULL, 0, 1, '2017-05-19 08:14:21', NULL),
(18, 3807, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-141x188.jpg', '', 'Reduced by 8.4% (447 B)', 4853, 5300, '', NULL, 0, 1, '2017-05-19 08:14:21', NULL),
(19, 3807, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-418x560.jpg', '', 'Reduced by 3.2% (1.5 KB)', 44605, 46101, '', NULL, 0, 1, '2017-05-19 08:14:21', NULL),
(20, 3807, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-301x226.jpg', '', 'Reduced by 4.0% (645 B)', 15678, 16323, '', NULL, 0, 1, '2017-05-19 08:14:21', NULL),
(21, 3807, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-480x362.jpg', '', 'Reduced by 3.2% (1.3 KB)', 40298, 41620, '', NULL, 0, 1, '2017-05-19 08:14:22', NULL),
(22, 3807, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_436473700-1355x1020.jpg', '', 'Reduced by 14.3% (37.7 KB)', 231592, 270209, '', NULL, 0, 1, '2017-05-19 08:14:22', NULL),
(23, 3808, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402.jpg', '', 'Reduced by 45.8% (693.0 KB)', 840957, 1550593, '', NULL, 0, 1, '2017-05-19 08:14:27', NULL),
(24, 3808, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-295x222.jpg', '', 'Reduced by 3.6% (499 B)', 13431, 13930, '', NULL, 0, 1, '2017-05-19 08:14:27', NULL),
(25, 3808, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-300x233.jpg', '', 'Reduced by 3.5% (511 B)', 13973, 14484, '', NULL, 0, 1, '2017-05-19 08:14:27', NULL),
(26, 3808, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-768x598.jpg', '', 'Reduced by 3.4% (2.5 KB)', 75231, 77840, '', NULL, 0, 1, '2017-05-19 08:14:27', NULL),
(27, 3808, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-1024x797.jpg', '', 'Reduced by 9.0% (10.9 KB)', 113152, 124308, '', NULL, 0, 1, '2017-05-19 08:14:27', NULL),
(28, 3808, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-769x431.jpg', '', 'Reduced by 3.1% (2.1 KB)', 67875, 70052, '', NULL, 0, 1, '2017-05-19 08:14:27', NULL),
(29, 3808, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-418x315.jpg', '', 'Reduced by 2.9% (753 B)', 25647, 26400, '', NULL, 0, 1, '2017-05-19 08:14:27', NULL),
(30, 3808, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-150x150.jpg', '', 'Reduced by 6.6% (406 B)', 5748, 6154, '', NULL, 0, 1, '2017-05-19 08:14:27', NULL),
(31, 3808, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-158x88.jpg', '', 'Reduced by 9.6% (388 B)', 3651, 4039, '', NULL, 0, 1, '2017-05-19 08:14:28', NULL),
(32, 3808, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-400x400.jpg', '', 'Reduced by 2.6% (964 B)', 35737, 36701, '', NULL, 0, 1, '2017-05-19 08:14:28', NULL),
(33, 3808, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-650x490.jpg', '', 'Reduced by 2.9% (1.6 KB)', 56308, 57994, '', NULL, 0, 1, '2017-05-19 08:14:28', NULL),
(34, 3808, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-418x325.jpg', '', 'Reduced by 2.7% (731 B)', 25867, 26598, '', NULL, 0, 1, '2017-05-19 08:14:28', NULL),
(35, 3808, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-886x668.jpg', '', 'Reduced by 3.8% (3.7 KB)', 94660, 98405, '', NULL, 0, 1, '2017-05-19 08:14:28', NULL),
(36, 3808, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-886x315.jpg', '', 'Reduced by 3.6% (2.1 KB)', 58372, 60562, '', NULL, 0, 1, '2017-05-19 08:14:28', NULL),
(37, 3808, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-1920x1080.jpg', '', 'Reduced by 10.5% (28.5 KB)', 249427, 278627, '', NULL, 0, 1, '2017-05-19 08:14:29', NULL),
(38, 3808, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-1920x820.jpg', '', 'Reduced by 10.3% (22.5 KB)', 200837, 223899, '', NULL, 0, 1, '2017-05-19 08:14:29', NULL),
(39, 3808, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-512x512.jpg', '', 'Reduced by 2.7% (1.5 KB)', 55380, 56903, '', NULL, 0, 1, '2017-05-19 08:14:29', NULL),
(40, 3808, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-141x188.jpg', '', 'Reduced by 5.4% (420 B)', 7408, 7828, '', NULL, 0, 1, '2017-05-19 08:14:29', NULL),
(41, 3808, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-418x560.jpg', '', 'Reduced by 2.8% (1.6 KB)', 54184, 55773, '', NULL, 0, 1, '2017-05-19 08:14:29', NULL),
(42, 3808, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-301x226.jpg', '', 'Reduced by 3.5% (507 B)', 13888, 14395, '', NULL, 0, 1, '2017-05-19 08:14:29', NULL),
(43, 3808, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-480x362.jpg', '', 'Reduced by 2.7% (910 B)', 33011, 33921, '', NULL, 0, 1, '2017-05-19 08:14:30', NULL),
(44, 3808, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_557818402-1355x1020.jpg', '', 'Reduced by 10.0% (18.4 KB)', 169803, 188614, '', NULL, 0, 1, '2017-05-19 08:14:30', NULL),
(45, 3809, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621.jpg', '', 'Reduced by 43.8% (663.4 KB)', 870581, 1549901, '', NULL, 0, 1, '2017-05-19 08:14:34', NULL),
(46, 3809, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-295x222.jpg', '', 'Reduced by 3.5% (589 B)', 16003, 16592, '', NULL, 0, 1, '2017-05-19 08:14:35', NULL),
(47, 3809, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-300x200.jpg', '', 'Reduced by 3.5% (552 B)', 15271, 15823, '', NULL, 0, 1, '2017-05-19 08:14:35', NULL),
(48, 3809, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-768x512.jpg', '', 'Reduced by 2.9% (2.4 KB)', 82651, 85082, '', NULL, 0, 1, '2017-05-19 08:14:35', NULL),
(49, 3809, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-1024x682.jpg', '', 'Reduced by 6.9% (9.1 KB)', 126352, 135716, '', NULL, 0, 1, '2017-05-19 08:14:35', NULL),
(50, 3809, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-769x431.jpg', '', 'Reduced by 2.8% (2.3 KB)', 82181, 84572, '', NULL, 0, 1, '2017-05-19 08:14:35', NULL),
(51, 3809, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-418x315.jpg', '', 'Reduced by 2.7% (859 B)', 31016, 31875, '', NULL, 0, 1, '2017-05-19 08:14:35', NULL),
(52, 3809, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-150x150.jpg', '', 'Reduced by 7.1% (446 B)', 5826, 6272, '', NULL, 0, 1, '2017-05-19 08:14:35', NULL),
(53, 3809, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-158x88.jpg', '', 'Reduced by 8.8% (418 B)', 4329, 4747, '', NULL, 0, 1, '2017-05-19 08:14:36', NULL),
(54, 3809, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-400x400.jpg', '', 'Reduced by 2.9% (1.0 KB)', 35199, 36252, '', NULL, 0, 1, '2017-05-19 08:14:36', NULL),
(55, 3809, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-650x490.jpg', '', 'Reduced by 2.8% (1.9 KB)', 67290, 69242, '', NULL, 0, 1, '2017-05-19 08:14:36', NULL),
(56, 3809, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-418x279.jpg', '', 'Reduced by 2.8% (812 B)', 28590, 29402, '', NULL, 0, 1, '2017-05-19 08:14:36', NULL),
(57, 3809, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-886x668.jpg', '', 'Reduced by 7.1% (7.9 KB)', 106739, 114853, '', NULL, 0, 1, '2017-05-19 08:14:36', NULL),
(58, 3809, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-886x315.jpg', '', 'Reduced by 3.2% (2.9 KB)', 91170, 94140, '', NULL, 0, 1, '2017-05-19 08:14:36', NULL),
(59, 3809, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-1920x1080.jpg', '', 'Reduced by 8.4% (27.4 KB)', 304133, 332185, '', NULL, 0, 1, '2017-05-19 08:14:37', NULL),
(60, 3809, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-1920x820.jpg', '', 'Reduced by 7.5% (23.3 KB)', 292329, 316194, '', NULL, 0, 1, '2017-05-19 08:14:37', NULL),
(61, 3809, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-512x512.jpg', '', 'Reduced by 3.2% (1.7 KB)', 53758, 55539, '', NULL, 0, 1, '2017-05-19 08:14:37', NULL),
(62, 3809, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-141x188.jpg', '', 'Reduced by 6.1% (458 B)', 7007, 7465, '', NULL, 0, 1, '2017-05-19 08:14:37', NULL),
(63, 3809, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-418x560.jpg', '', 'Reduced by 3.2% (1.6 KB)', 49088, 50728, '', NULL, 0, 1, '2017-05-19 08:14:37', NULL),
(64, 3809, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-301x226.jpg', '', 'Reduced by 3.4% (601 B)', 16950, 17551, '', NULL, 0, 1, '2017-05-19 08:14:37', NULL),
(65, 3809, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-480x362.jpg', '', 'Reduced by 2.4% (992 B)', 39823, 40815, '', NULL, 0, 1, '2017-05-19 08:14:38', NULL),
(66, 3809, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_554230621-1355x1020.jpg', '', 'Reduced by 8.3% (17.8 KB)', 200414, 218661, '', NULL, 0, 1, '2017-05-19 08:14:38', NULL),
(67, 3810, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174.jpg', '', 'Reduced by 4.4% (49.2 KB)', 1092993, 1143360, '', NULL, 0, 1, '2017-05-19 08:14:50', NULL),
(68, 3810, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-295x222.jpg', '', 'Reduced by 3.3% (437 B)', 13001, 13438, '', NULL, 0, 1, '2017-05-19 08:14:51', NULL),
(69, 3810, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-300x294.jpg', '', 'Reduced by 2.8% (473 B)', 16170, 16643, '', NULL, 0, 1, '2017-05-19 08:14:51', NULL),
(70, 3810, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-768x754.jpg', '', 'Reduced by 1.2% (1.0 KB)', 90596, 91659, '', NULL, 0, 1, '2017-05-19 08:14:51', NULL),
(71, 3810, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-1024x1005.jpg', '', 'Reduced by 3.7% (5.7 KB)', 152592, 158445, '', NULL, 0, 1, '2017-05-19 08:14:51', NULL),
(72, 3810, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-769x431.jpg', '', 'Reduced by 1.4% (869 B)', 62258, 63127, '', NULL, 0, 1, '2017-05-19 08:14:51', NULL),
(73, 3810, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-418x315.jpg', '', 'Reduced by 2.2% (547 B)', 24645, 25192, '', NULL, 0, 1, '2017-05-19 08:14:51', NULL),
(74, 3810, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-150x150.jpg', '', 'Reduced by 7.2% (393 B)', 5085, 5478, '', NULL, 0, 1, '2017-05-19 08:14:52', NULL),
(75, 3810, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-158x88.jpg', '', 'Reduced by 9.3% (379 B)', 3714, 4093, '', NULL, 0, 1, '2017-05-19 08:14:52', NULL),
(76, 3810, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-400x400.jpg', '', 'Reduced by 2.2% (604 B)', 27231, 27835, '', NULL, 0, 1, '2017-05-19 08:14:52', NULL),
(77, 3810, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-650x490.jpg', '', 'Reduced by 1.5% (840 B)', 56032, 56872, '', NULL, 0, 1, '2017-05-19 08:14:52', NULL),
(78, 3810, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-418x410.jpg', '', 'Reduced by 2.0% (604 B)', 29489, 30093, '', NULL, 0, 1, '2017-05-19 08:14:52', NULL),
(79, 3810, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-886x668.jpg', '', 'Reduced by 1.2% (1.2 KB)', 101064, 102309, '', NULL, 0, 1, '2017-05-19 08:14:53', NULL),
(80, 3810, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-886x315.jpg', '', 'Reduced by 1.6% (943 B)', 57055, 57998, '', NULL, 0, 1, '2017-05-19 08:14:53', NULL),
(81, 3810, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-1920x1080.jpg', '', 'Reduced by 3.2% (10.6 KB)', 331368, 342265, '', NULL, 0, 1, '2017-05-19 08:14:53', NULL),
(82, 3810, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-1920x820.jpg', '', 'Reduced by 3.1% (8.4 KB)', 270335, 278892, '', NULL, 0, 1, '2017-05-19 08:14:53', NULL),
(83, 3810, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-512x512.jpg', '', 'Reduced by 1.6% (719 B)', 42944, 43663, '', NULL, 0, 1, '2017-05-19 08:14:54', NULL),
(84, 3810, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-141x188.jpg', '', 'Reduced by 6.5% (408 B)', 5892, 6300, '', NULL, 0, 1, '2017-05-19 08:14:54', NULL),
(85, 3810, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-418x560.jpg', '', 'Reduced by 1.7% (698 B)', 41492, 42190, '', NULL, 0, 1, '2017-05-19 08:14:54', NULL),
(86, 3810, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-301x226.jpg', '', 'Reduced by 3.0% (431 B)', 13710, 14141, '', NULL, 0, 1, '2017-05-19 08:14:54', NULL),
(87, 3810, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-480x362.jpg', '', 'Reduced by 1.9% (626 B)', 31653, 32279, '', NULL, 0, 1, '2017-05-19 08:14:54', NULL),
(88, 3810, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_221359174-1355x1020.jpg', '', 'Reduced by 3.5% (7.8 KB)', 218573, 226515, '', NULL, 0, 1, '2017-05-19 08:14:54', NULL),
(89, 3811, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772.jpg', '', 'Reduced by 11.6% (116.3 KB)', 905453, 1024546, '', NULL, 0, 1, '2017-05-19 08:14:59', NULL),
(90, 3811, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-295x222.jpg', '', 'Reduced by 3.0% (426 B)', 13729, 14155, '', NULL, 0, 1, '2017-05-19 08:14:59', NULL),
(91, 3811, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-300x221.jpg', '', 'Reduced by 3.1% (437 B)', 13538, 13975, '', NULL, 0, 1, '2017-05-19 08:14:59', NULL),
(92, 3811, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-768x566.jpg', '', 'Reduced by 1.2% (1.0 KB)', 91556, 92628, '', NULL, 0, 1, '2017-05-19 08:14:59', NULL),
(93, 3811, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-1024x754.jpg', '', 'Reduced by 8.7% (14.0 KB)', 149959, 164281, '', NULL, 0, 1, '2017-05-19 08:15:00', NULL),
(94, 3811, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-769x431.jpg', '', 'Reduced by 0.7% (588 B)', 88350, 88938, '', NULL, 0, 1, '2017-05-19 08:15:00', NULL),
(95, 3811, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-418x315.jpg', '', 'Reduced by 1.8% (518 B)', 27692, 28210, '', NULL, 0, 1, '2017-05-19 08:15:00', NULL),
(96, 3811, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-150x150.jpg', '', 'Reduced by 5.7% (373 B)', 6209, 6582, '', NULL, 0, 1, '2017-05-19 08:15:00', NULL),
(97, 3811, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-158x88.jpg', '', 'Reduced by 9.0% (372 B)', 3769, 4141, '', NULL, 0, 1, '2017-05-19 08:15:00', NULL),
(98, 3811, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-400x400.jpg', '', 'Reduced by 1.2% (541 B)', 43560, 44101, '', NULL, 0, 1, '2017-05-19 08:15:00', NULL),
(99, 3811, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-650x490.jpg', '', 'Reduced by 1.3% (868 B)', 67947, 68815, '', NULL, 0, 1, '2017-05-19 08:15:01', NULL),
(100, 3811, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-418x308.jpg', '', 'Reduced by 2.0% (543 B)', 26540, 27083, '', NULL, 0, 1, '2017-05-19 08:15:01', NULL),
(101, 3811, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-886x668.jpg', '', 'Reduced by 8.4% (10.6 KB)', 118332, 129234, '', NULL, 0, 1, '2017-05-19 08:15:01', NULL),
(102, 3811, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-886x315.jpg', '', 'Reduced by 1.0% (841 B)', 85552, 86393, '', NULL, 0, 1, '2017-05-19 08:15:01', NULL),
(103, 3811, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-1920x1080.jpg', '', 'Reduced by 8.2% (38.5 KB)', 443375, 482795, '', NULL, 0, 1, '2017-05-19 08:15:01', NULL),
(104, 3811, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-1920x820.jpg', '', 'Reduced by 8.0% (32.2 KB)', 381012, 413981, '', NULL, 0, 1, '2017-05-19 08:15:02', NULL),
(105, 3811, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-512x512.jpg', '', 'Reduced by 0.8% (576 B)', 72227, 72803, '', NULL, 0, 1, '2017-05-19 08:15:02', NULL),
(106, 3811, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-141x188.jpg', '', 'Reduced by 4.5% (389 B)', 8323, 8712, '', NULL, 0, 1, '2017-05-19 08:15:02', NULL),
(107, 3811, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-418x560.jpg', '', 'Reduced by 1.1% (824 B)', 76525, 77349, '', NULL, 0, 1, '2017-05-19 08:15:02', NULL),
(108, 3811, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-301x226.jpg', '', 'Reduced by 2.9% (418 B)', 14033, 14451, '', NULL, 0, 1, '2017-05-19 08:15:02', NULL),
(109, 3811, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-480x362.jpg', '', 'Reduced by 1.6% (582 B)', 36608, 37190, '', NULL, 0, 1, '2017-05-19 08:15:02', NULL),
(110, 3811, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_328648772-1355x1020.jpg', '', 'Reduced by 8.6% (24.3 KB)', 262395, 287228, '', NULL, 0, 1, '2017-05-19 08:15:03', NULL),
(111, 3813, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060.jpg', '', 'Reduced by 7.8% (76.1 KB)', 916317, 994238, '', NULL, 0, 1, '2017-05-19 08:15:10', NULL),
(112, 3813, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-295x222.jpg', '', 'Reduced by 2.7% (470 B)', 16961, 17431, '', NULL, 0, 1, '2017-05-19 08:15:10', NULL),
(113, 3813, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-300x199.jpg', '', 'Reduced by 2.9% (448 B)', 14908, 15356, '', NULL, 0, 1, '2017-05-19 08:15:11', NULL),
(114, 3813, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-768x509.jpg', '', 'Reduced by 1.2% (1.1 KB)', 92263, 93401, '', NULL, 0, 1, '2017-05-19 08:15:11', NULL),
(115, 3813, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-1024x678.jpg', '', 'Reduced by 7.0% (11.2 KB)', 152110, 163602, '', NULL, 0, 1, '2017-05-19 08:15:11', NULL),
(116, 3813, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-769x431.jpg', '', 'Reduced by 1.2% (940 B)', 78200, 79140, '', NULL, 0, 1, '2017-05-19 08:15:11', NULL),
(117, 3813, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-418x315.jpg', '', 'Reduced by 1.8% (607 B)', 33634, 34241, '', NULL, 0, 1, '2017-05-19 08:15:11', NULL),
(118, 3813, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-150x150.jpg', '', 'Reduced by 5.7% (396 B)', 6515, 6911, '', NULL, 0, 1, '2017-05-19 08:15:11', NULL),
(119, 3813, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-158x88.jpg', '', 'Reduced by 8.6% (386 B)', 4095, 4481, '', NULL, 0, 1, '2017-05-19 08:15:11', NULL),
(120, 3813, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-400x400.jpg', '', 'Reduced by 1.6% (645 B)', 39921, 40566, '', NULL, 0, 1, '2017-05-19 08:15:12', NULL),
(121, 3813, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-650x490.jpg', '', 'Reduced by 1.2% (972 B)', 79908, 80880, '', NULL, 0, 1, '2017-05-19 08:15:12', NULL),
(122, 3813, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-418x277.jpg', '', 'Reduced by 1.9% (558 B)', 28263, 28821, '', NULL, 0, 1, '2017-05-19 08:15:12', NULL),
(123, 3813, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-886x668.jpg', '', 'Reduced by 7.1% (10.1 KB)', 136846, 147230, '', NULL, 0, 1, '2017-05-19 08:15:12', NULL),
(124, 3813, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-886x315.jpg', '', 'Reduced by 1.4% (857 B)', 61427, 62284, '', NULL, 0, 1, '2017-05-19 08:15:12', NULL),
(125, 3813, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-1920x1080.jpg', '', 'Reduced by 6.2% (25.7 KB)', 397976, 424337, '', NULL, 0, 1, '2017-05-19 08:15:12', NULL),
(126, 3813, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-1920x820.jpg', '', 'Reduced by 6.2% (18.5 KB)', 285789, 304766, '', NULL, 0, 1, '2017-05-19 08:15:13', NULL),
(127, 3813, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-512x512.jpg', '', 'Reduced by 1.3% (867 B)', 64869, 65736, '', NULL, 0, 1, '2017-05-19 08:15:13', NULL),
(128, 3813, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-141x188.jpg', '', 'Reduced by 5.4% (412 B)', 7194, 7606, '', NULL, 0, 1, '2017-05-19 08:15:13', NULL),
(129, 3813, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-418x560.jpg', '', 'Reduced by 1.3% (723 B)', 55816, 56539, '', NULL, 0, 1, '2017-05-19 08:15:13', NULL),
(130, 3813, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-301x226.jpg', '', 'Reduced by 2.5% (456 B)', 17877, 18333, '', NULL, 0, 1, '2017-05-19 08:15:13', NULL),
(131, 3813, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-480x362.jpg', '', 'Reduced by 1.6% (702 B)', 43797, 44499, '', NULL, 0, 1, '2017-05-19 08:15:13', NULL),
(132, 3813, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_567559060-1355x1020.jpg', '', 'Reduced by 6.6% (20.9 KB)', 300565, 321945, '', NULL, 0, 1, '2017-05-19 08:15:14', NULL),
(133, 3814, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597.jpg', '', 'Reduced by 10.9% (94.5 KB)', 789581, 886398, '', NULL, 0, 1, '2017-05-19 08:15:18', NULL),
(134, 3814, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-295x222.jpg', '', 'Reduced by 2.4% (668 B)', 27203, 27871, '', NULL, 0, 1, '2017-05-19 08:15:18', NULL),
(135, 3814, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-300x169.jpg', '', 'Reduced by 2.8% (523 B)', 18113, 18636, '', NULL, 0, 1, '2017-05-19 08:15:18', NULL),
(136, 3814, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-768x432.jpg', '', 'Reduced by 1.6% (1.4 KB)', 93745, 95224, '', NULL, 0, 1, '2017-05-19 08:15:19', NULL),
(137, 3814, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-1024x576.jpg', '', 'Reduced by 7.9% (11.7 KB)', 138920, 150855, '', NULL, 0, 1, '2017-05-19 08:15:19', NULL),
(138, 3814, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-769x431.jpg', '', 'Reduced by 1.6% (1.5 KB)', 93701, 95210, '', NULL, 0, 1, '2017-05-19 08:15:19', NULL),
(139, 3814, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-418x315.jpg', '', 'Reduced by 1.9% (988 B)', 51295, 52283, '', NULL, 0, 1, '2017-05-19 08:15:19', NULL),
(140, 3814, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-150x150.jpg', '', 'Reduced by 4.2% (492 B)', 11132, 11624, '', NULL, 0, 1, '2017-05-19 08:15:19', NULL),
(141, 3814, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-158x88.jpg', '', 'Reduced by 6.7% (378 B)', 5280, 5658, '', NULL, 0, 1, '2017-05-19 08:15:19', NULL),
(142, 3814, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-400x400.jpg', '', 'Reduced by 2.2% (1.4 KB)', 63645, 65049, '', NULL, 0, 1, '2017-05-19 08:15:19', NULL),
(143, 3814, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-650x490.jpg', '', 'Reduced by 8.2% (8.7 KB)', 99973, 108857, '', NULL, 0, 1, '2017-05-19 08:15:20', NULL),
(144, 3814, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-418x235.jpg', '', 'Reduced by 2.0% (686 B)', 33095, 33781, '', NULL, 0, 1, '2017-05-19 08:15:20', NULL),
(145, 3814, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-886x668.jpg', '', 'Reduced by 7.8% (13.3 KB)', 161772, 175412, '', NULL, 0, 1, '2017-05-19 08:15:20', NULL),
(146, 3814, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-886x315.jpg', '', 'Reduced by 1.7% (1.3 KB)', 75355, 76691, '', NULL, 0, 1, '2017-05-19 08:15:20', NULL),
(147, 3814, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-1920x1080.jpg', '', 'Reduced by 7.5% (27.4 KB)', 344878, 372902, '', NULL, 0, 1, '2017-05-19 08:15:20', NULL),
(148, 3814, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-1920x820.jpg', '', 'Reduced by 7.5% (20.9 KB)', 261812, 283163, '', NULL, 0, 1, '2017-05-19 08:15:21', NULL),
(149, 3814, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-512x512.jpg', '', 'Reduced by 2.0% (1.9 KB)', 95749, 97718, '', NULL, 0, 1, '2017-05-19 08:15:21', NULL),
(150, 3814, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-141x188.jpg', '', 'Reduced by 4.2% (595 B)', 13579, 14174, '', NULL, 0, 1, '2017-05-19 08:15:21', NULL),
(151, 3814, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-418x560.jpg', '', 'Reduced by 2.2% (1.9 KB)', 85027, 86984, '', NULL, 0, 1, '2017-05-19 08:15:21', NULL),
(152, 3814, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-301x226.jpg', '', 'Reduced by 2.4% (690 B)', 28460, 29150, '', NULL, 0, 1, '2017-05-19 08:15:21', NULL),
(153, 3814, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-480x362.jpg', '', 'Reduced by 1.9% (1.2 KB)', 64661, 65901, '', NULL, 0, 1, '2017-05-19 08:15:21', NULL),
(154, 3814, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_180932597-1355x1020.jpg', '', 'Reduced by 6.9% (21.6 KB)', 296254, 318332, '', NULL, 0, 1, '2017-05-19 08:15:22', NULL),
(155, 3815, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070.jpg', '', 'Reduced by 10.6% (72.1 KB)', 624138, 697993, '', NULL, 0, 1, '2017-05-19 08:15:26', NULL),
(156, 3815, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-295x222.jpg', '', 'Reduced by 3.7% (400 B)', 10444, 10844, '', NULL, 0, 1, '2017-05-19 08:15:26', NULL),
(157, 3815, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-293x300.jpg', '', 'Reduced by 3.9% (488 B)', 11980, 12468, '', NULL, 0, 1, '2017-05-19 08:15:26', NULL),
(158, 3815, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-768x788.jpg', '', 'Reduced by 2.3% (1.5 KB)', 64755, 66262, '', NULL, 0, 1, '2017-05-19 08:15:27', NULL),
(159, 3815, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-999x1024.jpg', '', 'Reduced by 7.7% (7.9 KB)', 97852, 105986, '', NULL, 0, 1, '2017-05-19 08:15:27', NULL),
(160, 3815, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-769x431.jpg', '', 'Reduced by 1.9% (844 B)', 42810, 43654, '', NULL, 0, 1, '2017-05-19 08:15:27', NULL),
(161, 3815, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-418x315.jpg', '', 'Reduced by 2.4% (467 B)', 19338, 19805, '', NULL, 0, 1, '2017-05-19 08:15:27', NULL),
(162, 3815, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-150x150.jpg', '', 'Reduced by 8.4% (377 B)', 4098, 4475, '', NULL, 0, 1, '2017-05-19 08:15:27', NULL),
(163, 3815, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-158x88.jpg', '', 'Reduced by 11.5% (376 B)', 2889, 3265, '', NULL, 0, 1, '2017-05-19 08:15:27', NULL),
(164, 3815, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-400x400.jpg', '', 'Reduced by 2.6% (548 B)', 20442, 20990, '', NULL, 0, 1, '2017-05-19 08:15:28', NULL),
(165, 3815, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-650x490.jpg', '', 'Reduced by 1.7% (726 B)', 42030, 42756, '', NULL, 0, 1, '2017-05-19 08:15:28', NULL),
(166, 3815, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-418x429.jpg', '', 'Reduced by 2.6% (585 B)', 22057, 22642, '', NULL, 0, 1, '2017-05-19 08:15:28', NULL),
(167, 3815, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-886x668.jpg', '', 'Reduced by 1.6% (1.2 KB)', 73358, 74540, '', NULL, 0, 1, '2017-05-19 08:15:28', NULL),
(168, 3815, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-886x315.jpg', '', 'Reduced by 2.1% (780 B)', 36863, 37643, '', NULL, 0, 1, '2017-05-19 08:15:28', NULL),
(169, 3815, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-1920x1080.jpg', '', 'Reduced by 6.7% (15.0 KB)', 213798, 229156, '', NULL, 0, 1, '2017-05-19 08:15:28', NULL),
(170, 3815, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-1920x820.jpg', '', 'Reduced by 6.4% (11.2 KB)', 168051, 179502, '', NULL, 0, 1, '2017-05-19 08:15:29', NULL),
(171, 3815, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-512x512.jpg', '', 'Reduced by 2.3% (730 B)', 31101, 31831, '', NULL, 0, 1, '2017-05-19 08:15:29', NULL),
(172, 3815, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-141x188.jpg', '', 'Reduced by 6.5% (372 B)', 5350, 5722, '', NULL, 0, 1, '2017-05-19 08:15:29', NULL),
(173, 3815, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-418x560.jpg', '', 'Reduced by 1.8% (615 B)', 33898, 34513, '', NULL, 0, 1, '2017-05-19 08:15:29', NULL),
(174, 3815, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-301x226.jpg', '', 'Reduced by 3.7% (415 B)', 10907, 11322, '', NULL, 0, 1, '2017-05-19 08:15:29', NULL),
(175, 3815, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-480x362.jpg', '', 'Reduced by 2.0% (504 B)', 24445, 24949, '', NULL, 0, 1, '2017-05-19 08:15:29', NULL),
(176, 3815, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_208656070-1355x1020.jpg', '', 'Reduced by 6.7% (10.5 KB)', 149794, 160590, '', NULL, 0, 1, '2017-05-19 08:15:30', NULL),
(1595, 3845, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-480x362.jpg', '', 'Reduced by 3.8% (826 B)', 21149, 21975, '', NULL, 0, 1, '2017-05-19 09:14:04', NULL),
(1594, 3845, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-301x226.jpg', '', 'Reduced by 5.1% (514 B)', 9479, 9993, '', NULL, 0, 1, '2017-05-19 09:14:04', NULL),
(1593, 3845, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-418x560.jpg', '', 'Reduced by 2.9% (1,013 B)', 34011, 35024, '', NULL, 0, 1, '2017-05-19 09:14:04', NULL),
(1592, 3845, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-141x188.jpg', '', 'Reduced by 6.4% (379 B)', 5502, 5881, '', NULL, 0, 1, '2017-05-19 09:14:04', NULL),
(1591, 3845, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-512x512.jpg', '', 'Reduced by 3.8% (1.2 KB)', 29598, 30776, '', NULL, 0, 1, '2017-05-19 09:14:04', NULL),
(1590, 3845, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1920x820.jpg', '', 'Reduced by 9.6% (18.6 KB)', 180217, 199274, '', NULL, 0, 1, '2017-05-19 09:14:04', NULL),
(1589, 3845, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1920x1080.jpg', '', 'Reduced by 9.8% (21.9 KB)', 207607, 230050, '', NULL, 0, 1, '2017-05-19 09:14:04', NULL),
(1588, 3845, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-886x315.jpg', '', 'Reduced by 2.3% (1,022 B)', 43149, 44171, '', NULL, 0, 1, '2017-05-19 09:14:03', NULL),
(1587, 3845, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-886x668.jpg', '', 'Reduced by 3.8% (2.3 KB)', 59944, 62309, '', NULL, 0, 1, '2017-05-19 09:14:03', NULL),
(1586, 3845, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-418x359.jpg', '', 'Reduced by 4.9% (872 B)', 16807, 17679, '', NULL, 0, 1, '2017-05-19 09:14:03', NULL),
(1585, 3845, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-650x490.jpg', '', 'Reduced by 3.6% (1.3 KB)', 35411, 36739, '', NULL, 0, 1, '2017-05-19 09:14:03', NULL),
(1584, 3845, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-400x400.jpg', '', 'Reduced by 4.1% (822 B)', 19455, 20277, '', NULL, 0, 1, '2017-05-19 09:14:03', NULL),
(1583, 3845, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-158x88.jpg', '', 'Reduced by 10.9% (381 B)', 3122, 3503, '', NULL, 0, 1, '2017-05-19 09:14:03', NULL),
(1582, 3845, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-150x150.jpg', '', 'Reduced by 9.3% (394 B)', 3831, 4225, '', NULL, 0, 1, '2017-05-19 09:14:02', NULL),
(1581, 3845, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-418x315.jpg', '', 'Reduced by 4.2% (717 B)', 16545, 17262, '', NULL, 0, 1, '2017-05-19 09:14:02', NULL),
(1580, 3845, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-769x431.jpg', '', 'Reduced by 2.8% (1.3 KB)', 45147, 46447, '', NULL, 0, 1, '2017-05-19 09:14:02', NULL),
(1579, 3845, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1024x880.jpg', '', 'Reduced by 4.5% (3.6 KB)', 76754, 80401, '', NULL, 0, 1, '2017-05-19 09:14:02', NULL),
(1577, 3845, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-300x258.jpg', '', 'Reduced by 5.4% (552 B)', 9720, 10272, '', NULL, 0, 1, '2017-05-19 09:14:02', NULL),
(1578, 3845, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-768x660.jpg', '', 'Reduced by 4.3% (2.1 KB)', 47630, 49747, '', NULL, 0, 1, '2017-05-19 09:14:02', NULL),
(1576, 3845, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-295x222.jpg', '', 'Reduced by 5.0% (491 B)', 9244, 9735, '', NULL, 0, 1, '2017-05-19 09:14:02', NULL),
(1575, 3845, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2.jpg', '', 'Reduced by 18.6% (198.2 KB)', 891096, 1094095, '', NULL, 0, 1, '2017-05-19 09:14:02', NULL),
(1574, 3844, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1355x1020.jpg', '', 'Reduced by 6.5% (6.1 KB)', 90707, 96965, '', NULL, 0, 1, '2017-05-19 09:13:57', NULL),
(199, 3812, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941.jpg', '', 'Reduced by 6.7% (66.5 KB)', 950056, 1018181, '', NULL, 0, 1, '2017-05-19 08:15:45', NULL),
(200, 3812, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-295x222.jpg', '', 'Reduced by 4.5% (429 B)', 9086, 9515, '', NULL, 0, 1, '2017-05-19 08:15:45', NULL),
(201, 3812, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-300x300.jpg', '', 'Reduced by 3.7% (459 B)', 11951, 12410, '', NULL, 0, 1, '2017-05-19 08:15:45', NULL),
(202, 3812, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-768x768.jpg', '', 'Reduced by 2.0% (1.5 KB)', 72405, 73897, '', NULL, 0, 1, '2017-05-19 08:15:45', NULL),
(203, 3812, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-1024x1024.jpg', '', 'Reduced by 7.1% (9.1 KB)', 121415, 130683, '', NULL, 0, 1, '2017-05-19 08:15:45', NULL),
(204, 3812, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-769x431.jpg', '', 'Reduced by 1.9% (852 B)', 43225, 44077, '', NULL, 0, 1, '2017-05-19 08:15:45', NULL),
(205, 3812, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-418x315.jpg', '', 'Reduced by 3.1% (557 B)', 17489, 18046, '', NULL, 0, 1, '2017-05-19 08:15:45', NULL),
(206, 3812, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-150x150.jpg', '', 'Reduced by 8.8% (371 B)', 3868, 4239, '', NULL, 0, 1, '2017-05-19 08:15:46', NULL),
(207, 3812, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-158x88.jpg', '', 'Reduced by 12.9% (376 B)', 2543, 2919, '', NULL, 0, 1, '2017-05-19 08:15:46', NULL),
(208, 3812, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-400x400.jpg', '', 'Reduced by 2.9% (603 B)', 20356, 20959, '', NULL, 0, 1, '2017-05-19 08:15:46', NULL),
(209, 3812, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-650x490.jpg', '', 'Reduced by 2.1% (895 B)', 41074, 41969, '', NULL, 0, 1, '2017-05-19 08:15:46', NULL),
(210, 3812, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-418x418.jpg', '', 'Reduced by 3.0% (693 B)', 22235, 22928, '', NULL, 0, 1, '2017-05-19 08:15:46', NULL),
(211, 3812, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-886x668.jpg', '', 'Reduced by 1.8% (1.3 KB)', 75762, 77116, '', NULL, 0, 1, '2017-05-19 08:15:46', NULL),
(212, 3812, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-886x315.jpg', '', 'Reduced by 2.0% (753 B)', 36579, 37332, '', NULL, 0, 1, '2017-05-19 08:15:46', NULL),
(213, 3812, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-1920x1080.jpg', '', 'Reduced by 6.4% (15.4 KB)', 231726, 247530, '', NULL, 0, 1, '2017-05-19 08:15:47', NULL),
(214, 3812, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-1920x820.jpg', '', 'Reduced by 6.4% (11.7 KB)', 174338, 186271, '', NULL, 0, 1, '2017-05-19 08:15:47', NULL),
(215, 3812, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-512x512.jpg', '', 'Reduced by 2.6% (855 B)', 32084, 32939, '', NULL, 0, 1, '2017-05-19 08:15:47', NULL),
(216, 3812, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-141x188.jpg', '', 'Reduced by 7.4% (396 B)', 4938, 5334, '', NULL, 0, 1, '2017-05-19 08:15:47', NULL),
(217, 3812, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-418x560.jpg', '', 'Reduced by 1.8% (645 B)', 35939, 36584, '', NULL, 0, 1, '2017-05-19 08:15:47', NULL),
(218, 3812, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-301x226.jpg', '', 'Reduced by 4.3% (431 B)', 9564, 9995, '', NULL, 0, 1, '2017-05-19 08:15:47', NULL),
(219, 3812, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-480x362.jpg', '', 'Reduced by 2.7% (614 B)', 22544, 23158, '', NULL, 0, 1, '2017-05-19 08:15:47', NULL),
(220, 3812, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_222371941-1355x1020.jpg', '', 'Reduced by 6.8% (11.6 KB)', 162656, 174528, '', NULL, 0, 1, '2017-05-19 08:15:48', NULL);
INSERT INTO `wp_ewwwio_images` (`id`, `attachment_id`, `gallery`, `resize`, `path`, `converted`, `results`, `image_size`, `orig_size`, `backup`, `level`, `pending`, `updates`, `updated`, `trace`) VALUES
(221, 3816, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334.jpg', '', 'Reduced by 8.4% (50.0 KB)', 560539, 611750, '', NULL, 0, 1, '2017-05-19 08:15:52', NULL),
(222, 3816, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-295x222.jpg', '', 'Reduced by 3.9% (412 B)', 10109, 10521, '', NULL, 0, 1, '2017-05-19 08:15:52', NULL),
(223, 3816, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-300x167.jpg', '', 'Reduced by 5.2% (399 B)', 7278, 7677, '', NULL, 0, 1, '2017-05-19 08:15:52', NULL),
(224, 3816, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-768x427.jpg', '', 'Reduced by 1.6% (726 B)', 44958, 45684, '', NULL, 0, 1, '2017-05-19 08:15:53', NULL),
(225, 3816, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-1024x570.jpg', '', 'Reduced by 1.3% (1,023 B)', 79294, 80317, '', NULL, 0, 1, '2017-05-19 08:15:53', NULL),
(226, 3816, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-769x431.jpg', '', 'Reduced by 1.6% (765 B)', 45917, 46682, '', NULL, 0, 1, '2017-05-19 08:15:53', NULL),
(227, 3816, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-418x315.jpg', '', 'Reduced by 2.4% (494 B)', 20054, 20548, '', NULL, 0, 1, '2017-05-19 08:15:53', NULL),
(228, 3816, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-150x150.jpg', '', 'Reduced by 8.7% (374 B)', 3926, 4300, '', NULL, 0, 1, '2017-05-19 08:15:53', NULL),
(229, 3816, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-158x88.jpg', '', 'Reduced by 12.6% (355 B)', 2453, 2808, '', NULL, 0, 1, '2017-05-19 08:15:53', NULL),
(230, 3816, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-400x400.jpg', '', 'Reduced by 2.3% (585 B)', 24527, 25112, '', NULL, 0, 1, '2017-05-19 08:15:53', NULL),
(231, 3816, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-650x490.jpg', '', 'Reduced by 1.6% (771 B)', 47876, 48647, '', NULL, 0, 1, '2017-05-19 08:15:54', NULL),
(232, 3816, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-418x233.jpg', '', 'Reduced by 3.2% (448 B)', 13754, 14202, '', NULL, 0, 1, '2017-05-19 08:15:54', NULL),
(233, 3816, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-886x668.jpg', '', 'Reduced by 1.2% (1,021 B)', 86562, 87583, '', NULL, 0, 1, '2017-05-19 08:15:54', NULL),
(234, 3816, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-886x315.jpg', '', 'Reduced by 1.2% (663 B)', 55478, 56141, '', NULL, 0, 1, '2017-05-19 08:15:54', NULL),
(235, 3816, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-1920x1080.jpg', '', 'Reduced by 6.7% (16.5 KB)', 234937, 251846, '', NULL, 0, 1, '2017-05-19 08:15:54', NULL),
(236, 3816, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-1920x820.jpg', '', 'Reduced by 5.7% (13.4 KB)', 224921, 238598, '', NULL, 0, 1, '2017-05-19 08:15:54', NULL),
(237, 3816, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-512x512.jpg', '', 'Reduced by 1.6% (661 B)', 40236, 40897, '', NULL, 0, 1, '2017-05-19 08:15:55', NULL),
(238, 3816, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-141x188.jpg', '', 'Reduced by 8.0% (380 B)', 4351, 4731, '', NULL, 0, 1, '2017-05-19 08:15:55', NULL),
(239, 3816, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-418x560.jpg', '', 'Reduced by 1.6% (608 B)', 36271, 36879, '', NULL, 0, 1, '2017-05-19 08:15:55', NULL),
(240, 3816, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-301x226.jpg', '', 'Reduced by 3.9% (422 B)', 10509, 10931, '', NULL, 0, 1, '2017-05-19 08:15:55', NULL),
(241, 3816, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-480x362.jpg', '', 'Reduced by 2.0% (537 B)', 26019, 26556, '', NULL, 0, 1, '2017-05-19 08:15:55', NULL),
(242, 3816, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_533331334-1355x1020.jpg', '', 'Reduced by 6.1% (11.1 KB)', 175520, 186929, '', NULL, 0, 1, '2017-05-19 08:15:55', NULL),
(243, 3821, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479.jpg', '', 'Reduced by 6.2% (29.3 KB)', 456986, 487027, '', NULL, 0, 1, '2017-05-19 08:16:03', NULL),
(244, 3821, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-295x222.jpg', '', 'Reduced by 3.3% (436 B)', 12851, 13287, '', NULL, 0, 1, '2017-05-19 08:16:03', NULL),
(245, 3821, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-300x200.jpg', '', 'Reduced by 3.5% (431 B)', 11919, 12350, '', NULL, 0, 1, '2017-05-19 08:16:03', NULL),
(246, 3821, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-768x513.jpg', '', 'Reduced by 1.4% (686 B)', 49783, 50469, '', NULL, 0, 1, '2017-05-19 08:16:03', NULL),
(247, 3821, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-1024x684.jpg', '', 'Reduced by 1.2% (908 B)', 77612, 78520, '', NULL, 0, 1, '2017-05-19 08:16:03', NULL),
(248, 3821, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-769x431.jpg', '', 'Reduced by 1.4% (635 B)', 44277, 44912, '', NULL, 0, 1, '2017-05-19 08:16:04', NULL),
(249, 3821, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-418x315.jpg', '', 'Reduced by 2.0% (457 B)', 22131, 22588, '', NULL, 0, 1, '2017-05-19 08:16:04', NULL),
(250, 3821, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-150x150.jpg', '', 'Reduced by 6.1% (397 B)', 6091, 6488, '', NULL, 0, 1, '2017-05-19 08:16:04', NULL),
(251, 3821, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-158x88.jpg', '', 'Reduced by 8.7% (387 B)', 4050, 4437, '', NULL, 0, 1, '2017-05-19 08:16:04', NULL),
(252, 3821, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-400x400.jpg', '', 'Reduced by 1.9% (499 B)', 26375, 26874, '', NULL, 0, 1, '2017-05-19 08:16:04', NULL),
(253, 3821, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-650x490.jpg', '', 'Reduced by 1.3% (591 B)', 43315, 43906, '', NULL, 0, 1, '2017-05-19 08:16:04', NULL),
(254, 3821, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-418x279.jpg', '', 'Reduced by 2.4% (476 B)', 19668, 20144, '', NULL, 0, 1, '2017-05-19 08:16:04', NULL),
(255, 3821, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-886x668.jpg', '', 'Reduced by 1.2% (831 B)', 69958, 70789, '', NULL, 0, 1, '2017-05-19 08:16:05', NULL),
(256, 3821, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-886x315.jpg', '', 'Reduced by 1.5% (568 B)', 38087, 38655, '', NULL, 0, 1, '2017-05-19 08:16:05', NULL),
(257, 3821, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-1920x1080.jpg', '', 'Reduced by 2.9% (5.4 KB)', 184328, 189809, '', NULL, 0, 1, '2017-05-19 08:16:05', NULL),
(258, 3821, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-1920x820.jpg', '', 'Reduced by 2.8% (4.2 KB)', 149734, 154029, '', NULL, 0, 1, '2017-05-19 08:16:05', NULL),
(259, 3821, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-512x512.jpg', '', 'Reduced by 1.5% (579 B)', 38883, 39462, '', NULL, 0, 1, '2017-05-19 08:16:05', NULL),
(260, 3821, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-141x188.jpg', '', 'Reduced by 5.9% (426 B)', 6762, 7188, '', NULL, 0, 1, '2017-05-19 08:16:05', NULL),
(261, 3821, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-418x560.jpg', '', 'Reduced by 1.5% (564 B)', 36232, 36796, '', NULL, 0, 1, '2017-05-19 08:16:06', NULL),
(262, 3821, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-301x226.jpg', '', 'Reduced by 3.0% (413 B)', 13469, 13882, '', NULL, 0, 1, '2017-05-19 08:16:06', NULL),
(263, 3821, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-480x362.jpg', '', 'Reduced by 1.8% (499 B)', 27111, 27610, '', NULL, 0, 1, '2017-05-19 08:16:06', NULL),
(264, 3821, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562748479-1355x1020.jpg', '', 'Reduced by 2.8% (3.8 KB)', 134991, 138879, '', NULL, 0, 1, '2017-05-19 08:16:06', NULL),
(265, 3822, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279.jpg', '', 'Reduced by 12.8% (59.5 KB)', 414255, 475231, '', NULL, 0, 1, '2017-05-19 08:16:10', NULL),
(266, 3822, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-295x222.jpg', '', 'Reduced by 6.2% (566 B)', 8557, 9123, '', NULL, 0, 1, '2017-05-19 08:16:11', NULL),
(267, 3822, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-300x214.jpg', '', 'Reduced by 6.6% (578 B)', 8183, 8761, '', NULL, 0, 1, '2017-05-19 08:16:11', NULL),
(268, 3822, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-768x548.jpg', '', 'Reduced by 3.0% (1.6 KB)', 50855, 52445, '', NULL, 0, 1, '2017-05-19 08:16:11', NULL),
(269, 3822, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-1024x731.jpg', '', 'Reduced by 2.8% (2.5 KB)', 89001, 91554, '', NULL, 0, 1, '2017-05-19 08:16:11', NULL),
(270, 3822, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-769x431.jpg', '', 'Reduced by 2.6% (1.3 KB)', 48874, 50164, '', NULL, 0, 1, '2017-05-19 08:16:11', NULL),
(271, 3822, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-418x315.jpg', '', 'Reduced by 4.4% (762 B)', 16748, 17510, '', NULL, 0, 1, '2017-05-19 08:16:11', NULL),
(272, 3822, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-150x150.jpg', '', 'Reduced by 9.7% (431 B)', 3999, 4430, '', NULL, 0, 1, '2017-05-19 08:16:11', NULL),
(273, 3822, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-158x88.jpg', '', 'Reduced by 14.1% (414 B)', 2518, 2932, '', NULL, 0, 1, '2017-05-19 08:16:12', NULL),
(274, 3822, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-400x400.jpg', '', 'Reduced by 2.8% (754 B)', 25871, 26625, '', NULL, 0, 1, '2017-05-19 08:16:12', NULL),
(275, 3822, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-650x490.jpg', '', 'Reduced by 3.1% (1.3 KB)', 39922, 41212, '', NULL, 0, 1, '2017-05-19 08:16:12', NULL),
(276, 3822, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-418x298.jpg', '', 'Reduced by 4.6% (733 B)', 15287, 16020, '', NULL, 0, 1, '2017-05-19 08:16:12', NULL),
(277, 3822, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-886x668.jpg', '', 'Reduced by 2.7% (2.0 KB)', 73781, 75822, '', NULL, 0, 1, '2017-05-19 08:16:12', NULL),
(278, 3822, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-886x315.jpg', '', 'Reduced by 2.4% (1.1 KB)', 46691, 47862, '', NULL, 0, 1, '2017-05-19 08:16:12', NULL),
(279, 3822, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-1920x1080.jpg', '', 'Reduced by 10.4% (27.2 KB)', 240947, 268798, '', NULL, 0, 1, '2017-05-19 08:16:13', NULL),
(280, 3822, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-1920x820.jpg', '', 'Reduced by 9.8% (21.7 KB)', 204165, 226414, '', NULL, 0, 1, '2017-05-19 08:16:13', NULL),
(281, 3822, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-512x512.jpg', '', 'Reduced by 2.4% (1.0 KB)', 42385, 43439, '', NULL, 0, 1, '2017-05-19 08:16:13', NULL),
(282, 3822, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-141x188.jpg', '', 'Reduced by 7.0% (418 B)', 5521, 5939, '', NULL, 0, 1, '2017-05-19 08:16:13', NULL),
(283, 3822, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-418x560.jpg', '', 'Reduced by 2.0% (941 B)', 46725, 47666, '', NULL, 0, 1, '2017-05-19 08:16:13', NULL),
(284, 3822, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-301x226.jpg', '', 'Reduced by 6.2% (583 B)', 8803, 9386, '', NULL, 0, 1, '2017-05-19 08:16:13', NULL),
(285, 3822, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-480x362.jpg', '', 'Reduced by 3.6% (825 B)', 21853, 22678, '', NULL, 0, 1, '2017-05-19 08:16:13', NULL),
(286, 3822, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_556612279-1355x1020.jpg', '', 'Reduced by 11.0% (18.1 KB)', 150347, 168882, '', NULL, 0, 1, '2017-05-19 08:16:14', NULL),
(287, 3823, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770.jpg', '', 'Reduced by 7.4% (32.9 KB)', 420908, 454639, '', NULL, 0, 1, '2017-05-19 08:16:18', NULL),
(288, 3823, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-295x222.jpg', '', 'Reduced by 3.5% (493 B)', 13677, 14170, '', NULL, 0, 1, '2017-05-19 08:16:18', NULL),
(289, 3823, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-300x200.jpg', '', 'Reduced by 3.7% (493 B)', 12848, 13341, '', NULL, 0, 1, '2017-05-19 08:16:18', NULL),
(290, 3823, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-768x513.jpg', '', 'Reduced by 1.5% (828 B)', 53646, 54474, '', NULL, 0, 1, '2017-05-19 08:16:18', NULL),
(291, 3823, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-1024x684.jpg', '', 'Reduced by 1.4% (1.1 KB)', 82578, 83728, '', NULL, 0, 1, '2017-05-19 08:16:19', NULL),
(292, 3823, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-769x431.jpg', '', 'Reduced by 1.7% (801 B)', 46026, 46827, '', NULL, 0, 1, '2017-05-19 08:16:19', NULL),
(293, 3823, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-418x315.jpg', '', 'Reduced by 2.1% (504 B)', 23443, 23947, '', NULL, 0, 1, '2017-05-19 08:16:19', NULL),
(294, 3823, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-150x150.jpg', '', 'Reduced by 6.3% (408 B)', 6049, 6457, '', NULL, 0, 1, '2017-05-19 08:16:19', NULL),
(295, 3823, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-158x88.jpg', '', 'Reduced by 8.8% (419 B)', 4318, 4737, '', NULL, 0, 1, '2017-05-19 08:16:19', NULL),
(296, 3823, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-400x400.jpg', '', 'Reduced by 2.0% (531 B)', 26120, 26651, '', NULL, 0, 1, '2017-05-19 08:16:19', NULL),
(297, 3823, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-650x490.jpg', '', 'Reduced by 1.5% (690 B)', 45936, 46626, '', NULL, 0, 1, '2017-05-19 08:16:19', NULL),
(298, 3823, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-418x279.jpg', '', 'Reduced by 2.4% (531 B)', 21447, 21978, '', NULL, 0, 1, '2017-05-19 08:16:20', NULL),
(299, 3823, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-886x668.jpg', '', 'Reduced by 1.4% (1.0 KB)', 72787, 73819, '', NULL, 0, 1, '2017-05-19 08:16:20', NULL),
(300, 3823, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-886x315.jpg', '', 'Reduced by 1.8% (732 B)', 40244, 40976, '', NULL, 0, 1, '2017-05-19 08:16:20', NULL),
(301, 3823, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-1920x1080.jpg', '', 'Reduced by 3.7% (6.8 KB)', 178358, 185271, '', NULL, 0, 1, '2017-05-19 08:16:20', NULL),
(302, 3823, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-1920x820.jpg', '', 'Reduced by 3.9% (5.6 KB)', 141298, 147027, '', NULL, 0, 1, '2017-05-19 08:16:20', NULL),
(303, 3823, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-512x512.jpg', '', 'Reduced by 1.7% (659 B)', 38222, 38881, '', NULL, 0, 1, '2017-05-19 08:16:20', NULL),
(304, 3823, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-141x188.jpg', '', 'Reduced by 6.1% (426 B)', 6521, 6947, '', NULL, 0, 1, '2017-05-19 08:16:21', NULL),
(305, 3823, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-418x560.jpg', '', 'Reduced by 1.8% (620 B)', 33736, 34356, '', NULL, 0, 1, '2017-05-19 08:16:21', NULL),
(306, 3823, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-301x226.jpg', '', 'Reduced by 3.4% (501 B)', 14205, 14706, '', NULL, 0, 1, '2017-05-19 08:16:21', NULL),
(307, 3823, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-480x362.jpg', '', 'Reduced by 1.8% (525 B)', 28874, 29399, '', NULL, 0, 1, '2017-05-19 08:16:21', NULL),
(308, 3823, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_447365770-1355x1020.jpg', '', 'Reduced by 3.4% (4.7 KB)', 136159, 140946, '', NULL, 0, 1, '2017-05-19 08:16:21', NULL),
(1679, 3850, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-512x512.jpg', '', 'Reduced by 12.6% (1.7 KB)', 12166, 13913, '', NULL, 0, 1, '2017-05-19 09:14:44', NULL),
(1678, 3850, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-1920x820.jpg', '', 'Reduced by 15.1% (9.7 KB)', 55640, 65546, '', NULL, 0, 1, '2017-05-19 09:14:44', NULL),
(1677, 3850, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-1920x1080.jpg', '', 'Reduced by 15.2% (12.6 KB)', 71952, 84826, '', NULL, 0, 1, '2017-05-19 09:14:44', NULL),
(1676, 3850, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-886x315.jpg', '', 'Reduced by 14.8% (2.0 KB)', 11491, 13492, '', NULL, 0, 1, '2017-05-19 09:14:44', NULL),
(1675, 3850, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-886x668.jpg', '', 'Reduced by 14.9% (3.8 KB)', 22163, 26047, '', NULL, 0, 1, '2017-05-19 09:14:44', NULL),
(1674, 3850, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-418x359.jpg', '', 'Reduced by 13.2% (1.2 KB)', 7902, 9102, '', NULL, 0, 1, '2017-05-19 09:14:43', NULL),
(1673, 3850, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-650x490.jpg', '', 'Reduced by 13.5% (2.1 KB)', 13928, 16101, '', NULL, 0, 1, '2017-05-19 09:14:43', NULL),
(1672, 3850, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-400x400.jpg', '', 'Reduced by 11.8% (1.1 KB)', 8565, 9712, '', NULL, 0, 1, '2017-05-19 09:14:43', NULL),
(1671, 3850, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-158x88.jpg', '', 'Reduced by 19.2% (394 B)', 1655, 2049, '', NULL, 0, 1, '2017-05-19 09:14:43', NULL),
(1670, 3850, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-150x150.jpg', '', 'Reduced by 14.9% (405 B)', 2309, 2714, '', NULL, 0, 1, '2017-05-19 09:14:43', NULL),
(1669, 3850, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-418x315.jpg', '', 'Reduced by 12.5% (1.0 KB)', 7365, 8421, '', NULL, 0, 1, '2017-05-19 09:14:43', NULL),
(1668, 3850, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-769x431.jpg', '', 'Reduced by 13.3% (2.2 KB)', 14700, 16952, '', NULL, 0, 1, '2017-05-19 09:14:43', NULL),
(1667, 3850, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-1024x880.jpg', '', 'Reduced by 16.2% (5.6 KB)', 29635, 35354, '', NULL, 0, 1, '2017-05-19 09:14:43', NULL),
(1666, 3850, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-768x660.jpg', '', 'Reduced by 15.3% (3.3 KB)', 19004, 22432, '', NULL, 0, 1, '2017-05-19 09:14:42', NULL),
(1665, 3850, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-300x258.jpg', '', 'Reduced by 13.4% (750 B)', 4836, 5586, '', NULL, 0, 1, '2017-05-19 09:14:42', NULL),
(1663, 3850, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2.jpg', '', 'Reduced by 33.5% (195.3 KB)', 397046, 597019, '', NULL, 0, 1, '2017-05-19 09:14:42', NULL),
(1664, 3850, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-295x222.jpg', '', 'Reduced by 13.1% (664 B)', 4421, 5085, '', NULL, 0, 1, '2017-05-19 09:14:42', NULL),
(1662, 3848, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-1355x1020.jpg', '', 'Reduced by 8.8% (7.0 KB)', 74607, 81812, '', NULL, 0, 1, '2017-05-19 09:14:35', NULL),
(1661, 3848, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-480x362.jpg', '', 'Reduced by 8.0% (1.1 KB)', 12660, 13763, '', NULL, 0, 1, '2017-05-19 09:14:35', NULL),
(1660, 3848, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-301x226.jpg', '', 'Reduced by 9.3% (647 B)', 6288, 6935, '', NULL, 0, 1, '2017-05-19 09:14:35', NULL),
(1659, 3848, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-418x560.jpg', '', 'Reduced by 6.3% (1.3 KB)', 19193, 20483, '', NULL, 0, 1, '2017-05-19 09:14:34', NULL),
(1658, 3848, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-141x188.jpg', '', 'Reduced by 10.1% (440 B)', 3905, 4345, '', NULL, 0, 1, '2017-05-19 09:14:34', NULL),
(331, 3817, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653.jpg', '', 'Reduced by 6.5% (38.8 KB)', 571069, 610780, '', NULL, 0, 1, '2017-05-19 08:16:36', NULL),
(332, 3817, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-295x222.jpg', '', 'Reduced by 3.4% (471 B)', 13443, 13914, '', NULL, 0, 1, '2017-05-19 08:16:36', NULL),
(333, 3817, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-300x200.jpg', '', 'Reduced by 3.6% (450 B)', 12061, 12511, '', NULL, 0, 1, '2017-05-19 08:16:36', NULL),
(334, 3817, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-768x512.jpg', '', 'Reduced by 1.5% (872 B)', 58338, 59210, '', NULL, 0, 1, '2017-05-19 08:16:36', NULL),
(335, 3817, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-1024x682.jpg', '', 'Reduced by 1.2% (1.2 KB)', 97746, 98933, '', NULL, 0, 1, '2017-05-19 08:16:36', NULL),
(336, 3817, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-769x431.jpg', '', 'Reduced by 1.7% (849 B)', 49637, 50486, '', NULL, 0, 1, '2017-05-19 08:16:36', NULL),
(337, 3817, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-418x315.jpg', '', 'Reduced by 2.2% (560 B)', 24567, 25127, '', NULL, 0, 1, '2017-05-19 08:16:37', NULL),
(338, 3817, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-150x150.jpg', '', 'Reduced by 6.3% (437 B)', 6552, 6989, '', NULL, 0, 1, '2017-05-19 08:16:37', NULL),
(339, 3817, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-158x88.jpg', '', 'Reduced by 9.2% (389 B)', 3832, 4221, '', NULL, 0, 1, '2017-05-19 08:16:37', NULL),
(340, 3817, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-400x400.jpg', '', 'Reduced by 2.1% (701 B)', 32804, 33505, '', NULL, 0, 1, '2017-05-19 08:16:37', NULL),
(341, 3817, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-650x490.jpg', '', 'Reduced by 1.4% (736 B)', 51737, 52473, '', NULL, 0, 1, '2017-05-19 08:16:37', NULL),
(342, 3817, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-418x279.jpg', '', 'Reduced by 2.4% (511 B)', 21080, 21591, '', NULL, 0, 1, '2017-05-19 08:16:37', NULL),
(343, 3817, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-886x668.jpg', '', 'Reduced by 1.1% (1,019 B)', 89926, 90945, '', NULL, 0, 1, '2017-05-19 08:16:37', NULL),
(344, 3817, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-886x315.jpg', '', 'Reduced by 2.2% (852 B)', 38731, 39583, '', NULL, 0, 1, '2017-05-19 08:16:38', NULL),
(345, 3817, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-1920x1080.jpg', '', 'Reduced by 3.3% (7.9 KB)', 238680, 246793, '', NULL, 0, 1, '2017-05-19 08:16:38', NULL),
(346, 3817, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-1920x820.jpg', '', 'Reduced by 3.1% (5.4 KB)', 175587, 181149, '', NULL, 0, 1, '2017-05-19 08:16:38', NULL),
(347, 3817, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-512x512.jpg', '', 'Reduced by 1.6% (832 B)', 51187, 52019, '', NULL, 0, 1, '2017-05-19 08:16:38', NULL),
(348, 3817, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-141x188.jpg', '', 'Reduced by 5.2% (439 B)', 7979, 8418, '', NULL, 0, 1, '2017-05-19 08:16:38', NULL),
(349, 3817, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-418x560.jpg', '', 'Reduced by 1.4% (757 B)', 52959, 53716, '', NULL, 0, 1, '2017-05-19 08:16:38', NULL),
(350, 3817, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-301x226.jpg', '', 'Reduced by 3.2% (463 B)', 14176, 14639, '', NULL, 0, 1, '2017-05-19 08:16:39', NULL),
(351, 3817, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-480x362.jpg', '', 'Reduced by 2.0% (617 B)', 30707, 31324, '', NULL, 0, 1, '2017-05-19 08:16:39', NULL),
(352, 3817, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_156723653-1355x1020.jpg', '', 'Reduced by 3.4% (6.4 KB)', 185032, 191539, '', NULL, 0, 1, '2017-05-19 08:16:39', NULL),
(353, 3818, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036.jpg', '', 'Reduced by 10.1% (59.7 KB)', 541772, 602914, '', NULL, 0, 1, '2017-05-19 08:16:43', NULL),
(354, 3818, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-295x222.jpg', '', 'Reduced by 3.7% (693 B)', 18022, 18715, '', NULL, 0, 1, '2017-05-19 08:16:43', NULL),
(355, 3818, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-300x200.jpg', '', 'Reduced by 4.1% (655 B)', 15303, 15958, '', NULL, 0, 1, '2017-05-19 08:16:44', NULL),
(356, 3818, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-768x512.jpg', '', 'Reduced by 1.9% (1.4 KB)', 74987, 76442, '', NULL, 0, 1, '2017-05-19 08:16:44', NULL),
(357, 3818, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-1024x682.jpg', '', 'Reduced by 7.7% (9.4 KB)', 115586, 125201, '', NULL, 0, 1, '2017-05-19 08:16:44', NULL),
(358, 3818, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-769x431.jpg', '', 'Reduced by 2.0% (1.3 KB)', 64747, 66044, '', NULL, 0, 1, '2017-05-19 08:16:44', NULL),
(359, 3818, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-418x315.jpg', '', 'Reduced by 2.8% (939 B)', 32385, 33324, '', NULL, 0, 1, '2017-05-19 08:16:44', NULL),
(360, 3818, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-150x150.jpg', '', 'Reduced by 6.0% (539 B)', 8440, 8979, '', NULL, 0, 1, '2017-05-19 08:16:44', NULL),
(361, 3818, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-158x88.jpg', '', 'Reduced by 9.0% (449 B)', 4546, 4995, '', NULL, 0, 1, '2017-05-19 08:16:44', NULL),
(362, 3818, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-400x400.jpg', '', 'Reduced by 2.4% (1.0 KB)', 43732, 44801, '', NULL, 0, 1, '2017-05-19 08:16:44', NULL),
(363, 3818, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-650x490.jpg', '', 'Reduced by 2.0% (1.4 KB)', 68787, 70194, '', NULL, 0, 1, '2017-05-19 08:16:45', NULL),
(364, 3818, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-418x279.jpg', '', 'Reduced by 3.3% (911 B)', 26895, 27806, '', NULL, 0, 1, '2017-05-19 08:16:45', NULL),
(365, 3818, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-886x668.jpg', '', 'Reduced by 7.6% (8.9 KB)', 109755, 118832, '', NULL, 0, 1, '2017-05-19 08:16:45', NULL),
(366, 3818, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-886x315.jpg', '', 'Reduced by 2.1% (1.1 KB)', 54786, 55937, '', NULL, 0, 1, '2017-05-19 08:16:45', NULL),
(367, 3818, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-1920x1080.jpg', '', 'Reduced by 7.0% (20.9 KB)', 283006, 304420, '', NULL, 0, 1, '2017-05-19 08:16:45', NULL),
(368, 3818, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-1920x820.jpg', '', 'Reduced by 7.0% (16.7 KB)', 226865, 243925, '', NULL, 0, 1, '2017-05-19 08:16:46', NULL),
(369, 3818, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-512x512.jpg', '', 'Reduced by 2.0% (1.4 KB)', 67142, 68534, '', NULL, 0, 1, '2017-05-19 08:16:46', NULL),
(370, 3818, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-141x188.jpg', '', 'Reduced by 5.5% (606 B)', 10319, 10925, '', NULL, 0, 1, '2017-05-19 08:16:46', NULL),
(371, 3818, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-418x560.jpg', '', 'Reduced by 2.1% (1.4 KB)', 66812, 68278, '', NULL, 0, 1, '2017-05-19 08:16:46', NULL),
(372, 3818, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-301x226.jpg', '', 'Reduced by 3.8% (729 B)', 18681, 19410, '', NULL, 0, 1, '2017-05-19 08:16:46', NULL),
(373, 3818, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-480x362.jpg', '', 'Reduced by 2.5% (1.0 KB)', 40974, 42025, '', NULL, 0, 1, '2017-05-19 08:16:46', NULL),
(374, 3818, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_302390036-1355x1020.jpg', '', 'Reduced by 6.9% (16.1 KB)', 222825, 239358, '', NULL, 0, 1, '2017-05-19 08:16:46', NULL),
(1766, 3879, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-480x362.jpg', '', 'Reduced by 4.9% (774 B)', 15148, 15922, '', NULL, 0, 1, '2017-05-19 10:18:36', NULL),
(1765, 3879, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-301x226.jpg', '', 'Reduced by 6.2% (498 B)', 7542, 8040, '', NULL, 0, 1, '2017-05-19 10:18:36', NULL),
(1764, 3879, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-418x560.jpg', '', 'Reduced by 3.4% (787 B)', 22299, 23086, '', NULL, 0, 1, '2017-05-19 10:18:36', NULL),
(1763, 3879, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-141x188.jpg', '', 'Reduced by 8.4% (392 B)', 4285, 4677, '', NULL, 0, 1, '2017-05-19 10:18:35', NULL),
(1762, 3879, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-512x512.jpg', '', 'Reduced by 4.7% (1.0 KB)', 21789, 22863, '', NULL, 0, 1, '2017-05-19 10:18:35', NULL),
(1761, 3879, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-663x315.jpg', '', 'Reduced by 6.8% (1.0 KB)', 14562, 15629, '', NULL, 0, 1, '2017-05-19 10:18:35', NULL),
(1760, 3879, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-418x418.jpg', '', 'Reduced by 4.7% (808 B)', 16351, 17159, '', NULL, 0, 1, '2017-05-19 10:18:35', NULL),
(1759, 3879, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-650x490.jpg', '', 'Reduced by 4.5% (1.1 KB)', 24348, 25494, '', NULL, 0, 1, '2017-05-19 10:18:35', NULL),
(1758, 3879, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-400x400.jpg', '', 'Reduced by 4.6% (720 B)', 14928, 15648, '', NULL, 0, 1, '2017-05-19 10:18:35', NULL),
(1757, 3879, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-158x88.jpg', '', 'Reduced by 14.6% (376 B)', 2207, 2583, '', NULL, 0, 1, '2017-05-19 10:18:35', NULL),
(1756, 3879, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-150x150.jpg', '', 'Reduced by 10.0% (405 B)', 3661, 4066, '', NULL, 0, 1, '2017-05-19 10:18:35', NULL),
(1755, 3879, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-418x315.jpg', '', 'Reduced by 5.0% (651 B)', 12376, 13027, '', NULL, 0, 1, '2017-05-19 10:18:34', NULL),
(1754, 3879, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-663x431.jpg', '', 'Reduced by 4.7% (1.1 KB)', 22847, 23985, '', NULL, 0, 1, '2017-05-19 10:18:34', NULL),
(1753, 3879, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-300x300.jpg', '', 'Reduced by 5.5% (574 B)', 9793, 10367, '', NULL, 0, 1, '2017-05-19 10:18:34', NULL),
(1752, 3879, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4-295x222.jpg', '', 'Reduced by 6.3% (490 B)', 7252, 7742, '', NULL, 0, 1, '2017-05-19 10:18:34', NULL),
(1751, 3879, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-4.jpg', '', 'Reduced by 1.5% (830 B)', 54387, 55217, '', NULL, 0, 1, '2017-05-19 10:18:34', NULL),
(1750, 3849, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-1355x1020.jpg', '', 'Reduced by 9.1% (11.1 KB)', 113544, 124930, '', NULL, 0, 1, '2017-05-19 09:15:10', NULL),
(1749, 3849, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-480x362.jpg', '', 'Reduced by 5.0% (895 B)', 17014, 17909, '', NULL, 0, 1, '2017-05-19 09:15:10', NULL),
(1748, 3849, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-301x226.jpg', '', 'Reduced by 6.0% (526 B)', 8198, 8724, '', NULL, 0, 1, '2017-05-19 09:15:10', NULL),
(1747, 3849, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-418x560.jpg', '', 'Reduced by 3.2% (1.0 KB)', 30720, 31749, '', NULL, 0, 1, '2017-05-19 09:15:09', NULL),
(1701, 3851, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-512x512.jpg', '', 'Reduced by 15.2% (1.7 KB)', 9827, 11586, '', NULL, 0, 1, '2017-05-19 09:14:52', NULL),
(1702, 3851, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-141x188.jpg', '', 'Reduced by 15.2% (411 B)', 2285, 2696, '', NULL, 0, 1, '2017-05-19 09:14:52', NULL),
(1703, 3851, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-418x560.jpg', '', 'Reduced by 12.3% (1.5 KB)', 10777, 12293, '', NULL, 0, 1, '2017-05-19 09:14:52', NULL),
(1704, 3851, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-301x226.jpg', '', 'Reduced by 16.4% (696 B)', 3547, 4243, '', NULL, 0, 1, '2017-05-19 09:14:52', NULL),
(1705, 3851, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-480x362.jpg', '', 'Reduced by 15.6% (1.3 KB)', 6979, 8267, '', NULL, 0, 1, '2017-05-19 09:14:52', NULL),
(1706, 3851, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-1355x1020.jpg', '', 'Reduced by 22.6% (9.6 KB)', 33767, 43601, '', NULL, 0, 1, '2017-05-19 09:14:52', NULL),
(1707, 3852, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2.jpg', '', 'Reduced by 37.9% (188.0 KB)', 315169, 507683, '', NULL, 0, 1, '2017-05-19 09:14:57', NULL),
(1708, 3852, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-295x222.jpg', '', 'Reduced by 13.9% (677 B)', 4195, 4872, '', NULL, 0, 1, '2017-05-19 09:14:57', NULL),
(1709, 3852, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-300x258.jpg', '', 'Reduced by 13.7% (723 B)', 4568, 5291, '', NULL, 0, 1, '2017-05-19 09:14:57', NULL),
(1710, 3852, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-768x660.jpg', '', 'Reduced by 16.7% (3.3 KB)', 17073, 20488, '', NULL, 0, 1, '2017-05-19 09:14:57', NULL),
(1711, 3852, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-1024x880.jpg', '', 'Reduced by 18.6% (5.9 KB)', 26451, 32505, '', NULL, 0, 1, '2017-05-19 09:14:57', NULL),
(1712, 3852, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-769x431.jpg', '', 'Reduced by 15.0% (2.2 KB)', 13028, 15319, '', NULL, 0, 1, '2017-05-19 09:14:58', NULL),
(1713, 3852, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-418x315.jpg', '', 'Reduced by 13.8% (1.0 KB)', 6647, 7707, '', NULL, 0, 1, '2017-05-19 09:14:58', NULL),
(1714, 3852, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-150x150.jpg', '', 'Reduced by 17.1% (452 B)', 2186, 2638, '', NULL, 0, 1, '2017-05-19 09:14:58', NULL),
(1715, 3852, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-158x88.jpg', '', 'Reduced by 20.3% (439 B)', 1727, 2166, '', NULL, 0, 1, '2017-05-19 09:14:58', NULL),
(1716, 3852, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-400x400.jpg', '', 'Reduced by 12.8% (1.1 KB)', 7942, 9104, '', NULL, 0, 1, '2017-05-19 09:14:58', NULL),
(1717, 3852, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-650x490.jpg', '', 'Reduced by 14.9% (2.2 KB)', 12625, 14828, '', NULL, 0, 1, '2017-05-19 09:14:58', NULL),
(1718, 3852, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-418x359.jpg', '', 'Reduced by 14.2% (1.2 KB)', 7279, 8486, '', NULL, 0, 1, '2017-05-19 09:14:58', NULL),
(1719, 3852, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-886x668.jpg', '', 'Reduced by 16.4% (3.8 KB)', 20040, 23972, '', NULL, 0, 1, '2017-05-19 09:14:58', NULL),
(1720, 3852, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-886x315.jpg', '', 'Reduced by 17.4% (2.0 KB)', 9897, 11985, '', NULL, 0, 1, '2017-05-19 09:14:59', NULL),
(1721, 3852, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-1920x1080.jpg', '', 'Reduced by 18.6% (13.6 KB)', 60757, 74681, '', NULL, 0, 1, '2017-05-19 09:14:59', NULL),
(1722, 3852, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-1920x820.jpg', '', 'Reduced by 19.8% (10.9 KB)', 45285, 56450, '', NULL, 0, 1, '2017-05-19 09:14:59', NULL),
(1723, 3852, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-512x512.jpg', '', 'Reduced by 13.3% (1.7 KB)', 11375, 13124, '', NULL, 0, 1, '2017-05-19 09:14:59', NULL),
(1724, 3852, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-141x188.jpg', '', 'Reduced by 13.0% (423 B)', 2837, 3260, '', NULL, 0, 1, '2017-05-19 09:14:59', NULL),
(1725, 3852, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-418x560.jpg', '', 'Reduced by 10.6% (1.4 KB)', 12415, 13883, '', NULL, 0, 1, '2017-05-19 09:14:59', NULL),
(1726, 3852, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-301x226.jpg', '', 'Reduced by 14.1% (693 B)', 4215, 4908, '', NULL, 0, 1, '2017-05-19 09:15:00', NULL),
(1727, 3852, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-480x362.jpg', '', 'Reduced by 13.5% (1.2 KB)', 8161, 9437, '', NULL, 0, 1, '2017-05-19 09:15:00', NULL),
(1728, 3852, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-2-1355x1020.jpg', '', 'Reduced by 19.3% (9.1 KB)', 38760, 48055, '', NULL, 0, 1, '2017-05-19 09:15:00', NULL),
(1729, 3849, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1.jpg', '', 'Reduced by 16.6% (197.8 KB)', 1019054, 1221566, '', NULL, 0, 1, '2017-05-19 09:15:07', NULL),
(1730, 3849, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-295x222.jpg', '', 'Reduced by 6.0% (503 B)', 7868, 8371, '', NULL, 0, 1, '2017-05-19 09:15:07', NULL),
(1731, 3849, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-300x258.jpg', '', 'Reduced by 5.6% (546 B)', 9237, 9783, '', NULL, 0, 1, '2017-05-19 09:15:07', NULL),
(1732, 3849, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-768x660.jpg', '', 'Reduced by 4.6% (2.1 KB)', 45365, 47534, '', NULL, 0, 1, '2017-05-19 09:15:07', NULL),
(1733, 3849, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-1024x880.jpg', '', 'Reduced by 4.4% (3.5 KB)', 77830, 81439, '', NULL, 0, 1, '2017-05-19 09:15:07', NULL),
(1734, 3849, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-769x431.jpg', '', 'Reduced by 6.1% (1.8 KB)', 27700, 29493, '', NULL, 0, 1, '2017-05-19 09:15:07', NULL),
(1735, 3849, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-418x315.jpg', '', 'Reduced by 5.1% (725 B)', 13533, 14258, '', NULL, 0, 1, '2017-05-19 09:15:08', NULL),
(1736, 3849, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-150x150.jpg', '', 'Reduced by 8.7% (390 B)', 4075, 4465, '', NULL, 0, 1, '2017-05-19 09:15:08', NULL),
(1737, 3849, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-158x88.jpg', '', 'Reduced by 14.0% (387 B)', 2376, 2763, '', NULL, 0, 1, '2017-05-19 09:15:08', NULL),
(1738, 3849, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-400x400.jpg', '', 'Reduced by 4.3% (798 B)', 17759, 18557, '', NULL, 0, 1, '2017-05-19 09:15:08', NULL),
(1739, 3849, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-650x490.jpg', '', 'Reduced by 4.9% (1.5 KB)', 28644, 30134, '', NULL, 0, 1, '2017-05-19 09:15:08', NULL),
(1740, 3849, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-418x359.jpg', '', 'Reduced by 4.6% (748 B)', 15644, 16392, '', NULL, 0, 1, '2017-05-19 09:15:08', NULL),
(1741, 3849, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-886x668.jpg', '', 'Reduced by 5.1% (2.7 KB)', 51195, 53953, '', NULL, 0, 1, '2017-05-19 09:15:08', NULL),
(1742, 3849, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-886x315.jpg', '', 'Reduced by 6.6% (1.7 KB)', 25128, 26910, '', NULL, 0, 1, '2017-05-19 09:15:09', NULL),
(1743, 3849, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-1920x1080.jpg', '', 'Reduced by 9.3% (19.4 KB)', 192933, 212785, '', NULL, 0, 1, '2017-05-19 09:15:09', NULL),
(1744, 3849, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-1920x820.jpg', '', 'Reduced by 9.0% (15.0 KB)', 156215, 171603, '', NULL, 0, 1, '2017-05-19 09:15:09', NULL),
(1745, 3849, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-512x512.jpg', '', 'Reduced by 4.0% (1.1 KB)', 27352, 28494, '', NULL, 0, 1, '2017-05-19 09:15:09', NULL),
(1746, 3849, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1-141x188.jpg', '', 'Reduced by 7.3% (413 B)', 5266, 5679, '', NULL, 0, 1, '2017-05-19 09:15:09', NULL),
(441, 3820, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746.jpg', '', 'Reduced by 6.2% (32.0 KB)', 492446, 525184, '', NULL, 0, 1, '2017-05-19 08:17:17', NULL),
(442, 3820, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-295x222.jpg', '', 'Reduced by 3.3% (529 B)', 15601, 16130, '', NULL, 0, 1, '2017-05-19 08:17:17', NULL),
(443, 3820, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-300x200.jpg', '', 'Reduced by 3.2% (489 B)', 14681, 15170, '', NULL, 0, 1, '2017-05-19 08:17:17', NULL),
(444, 3820, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-768x512.jpg', '', 'Reduced by 1.5% (927 B)', 61162, 62089, '', NULL, 0, 1, '2017-05-19 08:17:17', NULL),
(445, 3820, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-1024x683.jpg', '', 'Reduced by 1.4% (1.3 KB)', 93860, 95240, '', NULL, 0, 1, '2017-05-19 08:17:18', NULL);
INSERT INTO `wp_ewwwio_images` (`id`, `attachment_id`, `gallery`, `resize`, `path`, `converted`, `results`, `image_size`, `orig_size`, `backup`, `level`, `pending`, `updates`, `updated`, `trace`) VALUES
(446, 3820, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-769x431.jpg', '', 'Reduced by 1.5% (826 B)', 55953, 56779, '', NULL, 0, 1, '2017-05-19 08:17:18', NULL),
(447, 3820, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-418x315.jpg', '', 'Reduced by 2.3% (637 B)', 27047, 27684, '', NULL, 0, 1, '2017-05-19 08:17:18', NULL),
(448, 3820, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-150x150.jpg', '', 'Reduced by 5.9% (420 B)', 6752, 7172, '', NULL, 0, 1, '2017-05-19 08:17:18', NULL),
(449, 3820, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-158x88.jpg', '', 'Reduced by 7.6% (409 B)', 4996, 5405, '', NULL, 0, 1, '2017-05-19 08:17:18', NULL),
(450, 3820, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-400x400.jpg', '', 'Reduced by 2.1% (642 B)', 29714, 30356, '', NULL, 0, 1, '2017-05-19 08:17:18', NULL),
(451, 3820, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-650x490.jpg', '', 'Reduced by 1.8% (934 B)', 52303, 53237, '', NULL, 0, 1, '2017-05-19 08:17:18', NULL),
(452, 3820, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-418x279.jpg', '', 'Reduced by 2.4% (600 B)', 24579, 25179, '', NULL, 0, 1, '2017-05-19 08:17:18', NULL),
(453, 3820, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-886x668.jpg', '', 'Reduced by 1.7% (1.4 KB)', 82176, 83589, '', NULL, 0, 1, '2017-05-19 08:17:19', NULL),
(454, 3820, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-886x315.jpg', '', 'Reduced by 1.5% (771 B)', 50008, 50779, '', NULL, 0, 1, '2017-05-19 08:17:19', NULL),
(455, 3820, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-1920x1080.jpg', '', 'Reduced by 2.4% (5.1 KB)', 211730, 216907, '', NULL, 0, 1, '2017-05-19 08:17:19', NULL),
(456, 3820, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-1920x820.jpg', '', 'Reduced by 2.3% (4.0 KB)', 179012, 183158, '', NULL, 0, 1, '2017-05-19 08:17:19', NULL),
(457, 3820, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-512x512.jpg', '', 'Reduced by 1.8% (806 B)', 43247, 44053, '', NULL, 0, 1, '2017-05-19 08:17:19', NULL),
(458, 3820, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-141x188.jpg', '', 'Reduced by 5.8% (445 B)', 7285, 7730, '', NULL, 0, 1, '2017-05-19 08:17:19', NULL),
(459, 3820, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-418x560.jpg', '', 'Reduced by 2.1% (801 B)', 37756, 38557, '', NULL, 0, 1, '2017-05-19 08:17:19', NULL),
(460, 3820, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-301x226.jpg', '', 'Reduced by 3.1% (513 B)', 16258, 16771, '', NULL, 0, 1, '2017-05-19 08:17:20', NULL),
(461, 3820, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-480x362.jpg', '', 'Reduced by 2.2% (735 B)', 33046, 33781, '', NULL, 0, 1, '2017-05-19 08:17:20', NULL),
(462, 3820, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_508010746-1355x1020.jpg', '', 'Reduced by 2.3% (3.5 KB)', 151762, 155348, '', NULL, 0, 1, '2017-05-19 08:17:20', NULL),
(463, 3824, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890.jpg', '', 'Reduced by 7.0% (30.5 KB)', 416672, 447887, '', NULL, 0, 1, '2017-05-19 08:17:24', NULL),
(464, 3824, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-295x222.jpg', '', 'Reduced by 3.8% (425 B)', 10780, 11205, '', NULL, 0, 1, '2017-05-19 08:17:24', NULL),
(465, 3824, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-300x200.jpg', '', 'Reduced by 4.1% (414 B)', 9691, 10105, '', NULL, 0, 1, '2017-05-19 08:17:25', NULL),
(466, 3824, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-768x513.jpg', '', 'Reduced by 1.8% (774 B)', 41603, 42377, '', NULL, 0, 1, '2017-05-19 08:17:25', NULL),
(467, 3824, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-1024x684.jpg', '', 'Reduced by 1.6% (1.1 KB)', 66730, 67830, '', NULL, 0, 1, '2017-05-19 08:17:25', NULL),
(468, 3824, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-769x431.jpg', '', 'Reduced by 1.8% (672 B)', 36227, 36899, '', NULL, 0, 1, '2017-05-19 08:17:25', NULL),
(469, 3824, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-418x315.jpg', '', 'Reduced by 2.5% (467 B)', 18341, 18808, '', NULL, 0, 1, '2017-05-19 08:17:25', NULL),
(470, 3824, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-150x150.jpg', '', 'Reduced by 6.8% (393 B)', 5372, 5765, '', NULL, 0, 1, '2017-05-19 08:17:25', NULL),
(471, 3824, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-158x88.jpg', '', 'Reduced by 10.6% (387 B)', 3267, 3654, '', NULL, 0, 1, '2017-05-19 08:17:25', NULL),
(472, 3824, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-400x400.jpg', '', 'Reduced by 2.1% (505 B)', 23481, 23986, '', NULL, 0, 1, '2017-05-19 08:17:25', NULL),
(473, 3824, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-650x490.jpg', '', 'Reduced by 1.7% (634 B)', 36955, 37589, '', NULL, 0, 1, '2017-05-19 08:17:26', NULL),
(474, 3824, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-418x279.jpg', '', 'Reduced by 2.6% (434 B)', 15953, 16387, '', NULL, 0, 1, '2017-05-19 08:17:26', NULL),
(475, 3824, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-886x668.jpg', '', 'Reduced by 1.5% (909 B)', 61096, 62005, '', NULL, 0, 1, '2017-05-19 08:17:26', NULL),
(476, 3824, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-886x315.jpg', '', 'Reduced by 2.1% (638 B)', 30347, 30985, '', NULL, 0, 1, '2017-05-19 08:17:26', NULL),
(477, 3824, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-1920x1080.jpg', '', 'Reduced by 4.7% (8.0 KB)', 166275, 174430, '', NULL, 0, 1, '2017-05-19 08:17:26', NULL),
(478, 3824, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-1920x820.jpg', '', 'Reduced by 4.5% (6.0 KB)', 129447, 135613, '', NULL, 0, 1, '2017-05-19 08:17:26', NULL),
(479, 3824, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-512x512.jpg', '', 'Reduced by 1.5% (549 B)', 35212, 35761, '', NULL, 0, 1, '2017-05-19 08:17:26', NULL),
(480, 3824, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-141x188.jpg', '', 'Reduced by 6.2% (416 B)', 6270, 6686, '', NULL, 0, 1, '2017-05-19 08:17:27', NULL),
(481, 3824, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-418x560.jpg', '', 'Reduced by 1.4% (515 B)', 35374, 35889, '', NULL, 0, 1, '2017-05-19 08:17:27', NULL),
(482, 3824, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-301x226.jpg', '', 'Reduced by 3.6% (415 B)', 11065, 11480, '', NULL, 0, 1, '2017-05-19 08:17:27', NULL),
(483, 3824, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-480x362.jpg', '', 'Reduced by 2.2% (502 B)', 22715, 23217, '', NULL, 0, 1, '2017-05-19 08:17:27', NULL),
(484, 3824, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_562454890-1355x1020.jpg', '', 'Reduced by 3.9% (4.9 KB)', 122974, 127943, '', NULL, 0, 1, '2017-05-19 08:17:27', NULL),
(1637, 3847, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-418x560.jpg', '', 'Reduced by 6.9% (1.2 KB)', 16663, 17897, '', NULL, 0, 1, '2017-05-19 09:14:27', NULL),
(1636, 3847, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-141x188.jpg', '', 'Reduced by 11.1% (389 B)', 3122, 3511, '', NULL, 0, 1, '2017-05-19 09:14:27', NULL),
(1635, 3847, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-512x512.jpg', '', 'Reduced by 8.5% (1.4 KB)', 15728, 17194, '', NULL, 0, 1, '2017-05-19 09:14:27', NULL),
(1634, 3847, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-1920x820.jpg', '', 'Reduced by 10.4% (11.1 KB)', 97942, 109313, '', NULL, 0, 1, '2017-05-19 09:14:26', NULL),
(1633, 3847, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-1920x1080.jpg', '', 'Reduced by 10.1% (13.8 KB)', 126732, 140894, '', NULL, 0, 1, '2017-05-19 09:14:26', NULL),
(1632, 3847, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-886x315.jpg', '', 'Reduced by 7.6% (1.5 KB)', 18607, 20141, '', NULL, 0, 1, '2017-05-19 09:14:26', NULL),
(1631, 3847, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-886x668.jpg', '', 'Reduced by 9.8% (3.3 KB)', 30596, 33929, '', NULL, 0, 1, '2017-05-19 09:14:26', NULL),
(1630, 3847, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-418x359.jpg', '', 'Reduced by 9.1% (946 B)', 9504, 10450, '', NULL, 0, 1, '2017-05-19 09:14:26', NULL),
(1629, 3847, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-650x490.jpg', '', 'Reduced by 9.1% (1.8 KB)', 18153, 19969, '', NULL, 0, 1, '2017-05-19 09:14:26', NULL),
(1628, 3847, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-400x400.jpg', '', 'Reduced by 8.2% (938 B)', 10478, 11416, '', NULL, 0, 1, '2017-05-19 09:14:25', NULL),
(1627, 3847, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-158x88.jpg', '', 'Reduced by 16.4% (381 B)', 1945, 2326, '', NULL, 0, 1, '2017-05-19 09:14:25', NULL),
(1626, 3847, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-150x150.jpg', '', 'Reduced by 14.1% (407 B)', 2485, 2892, '', NULL, 0, 1, '2017-05-19 09:14:25', NULL),
(1625, 3847, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-418x315.jpg', '', 'Reduced by 8.5% (835 B)', 9001, 9836, '', NULL, 0, 1, '2017-05-19 09:14:25', NULL),
(1624, 3847, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-769x431.jpg', '', 'Reduced by 7.3% (1.7 KB)', 21603, 23304, '', NULL, 0, 1, '2017-05-19 09:14:25', NULL),
(1623, 3847, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-1024x880.jpg', '', 'Reduced by 10.9% (5.0 KB)', 41795, 46913, '', NULL, 0, 1, '2017-05-19 09:14:25', NULL),
(1622, 3847, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-768x660.jpg', '', 'Reduced by 10.4% (2.9 KB)', 25349, 28294, '', NULL, 0, 1, '2017-05-19 09:14:25', NULL),
(1621, 3847, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-300x258.jpg', '', 'Reduced by 9.4% (599 B)', 5793, 6392, '', NULL, 0, 1, '2017-05-19 09:14:24', NULL),
(1619, 3847, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1.jpg', '', 'Reduced by 20.3% (170.9 KB)', 686632, 861589, '', NULL, 0, 1, '2017-05-19 09:14:24', NULL),
(1620, 3847, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-295x222.jpg', '', 'Reduced by 9.5% (537 B)', 5136, 5673, '', NULL, 0, 1, '2017-05-19 09:14:24', NULL),
(1618, 3846, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1355x1020.jpg', '', 'Reduced by 5.7% (5.6 KB)', 95359, 101115, '', NULL, 0, 1, '2017-05-19 09:14:13', NULL),
(1617, 3846, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-480x362.jpg', '', 'Reduced by 5.6% (977 B)', 16394, 17371, '', NULL, 0, 1, '2017-05-19 09:14:12', NULL),
(1616, 3846, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-301x226.jpg', '', 'Reduced by 7.4% (591 B)', 7374, 7965, '', NULL, 0, 1, '2017-05-19 09:14:12', NULL),
(507, 3826, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534.jpg', '', 'Reduced by 11.2% (36.0 KB)', 293742, 330617, '', NULL, 0, 1, '2017-05-19 08:17:41', NULL),
(508, 3826, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-295x222.jpg', '', 'Reduced by 4.5% (436 B)', 9149, 9585, '', NULL, 0, 1, '2017-05-19 08:17:41', NULL),
(509, 3826, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-300x200.jpg', '', 'Reduced by 5.1% (444 B)', 8333, 8777, '', NULL, 0, 1, '2017-05-19 08:17:41', NULL),
(510, 3826, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-768x512.jpg', '', 'Reduced by 3.6% (1.2 KB)', 34027, 35283, '', NULL, 0, 1, '2017-05-19 08:17:41', NULL),
(511, 3826, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-1024x682.jpg', '', 'Reduced by 3.9% (2.1 KB)', 54084, 56257, '', NULL, 0, 1, '2017-05-19 08:17:41', NULL),
(512, 3826, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-769x431.jpg', '', 'Reduced by 3.1% (1.0 KB)', 32121, 33159, '', NULL, 0, 1, '2017-05-19 08:17:41', NULL),
(513, 3826, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-418x315.jpg', '', 'Reduced by 3.8% (612 B)', 15358, 15970, '', NULL, 0, 1, '2017-05-19 08:17:41', NULL),
(514, 3826, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-150x150.jpg', '', 'Reduced by 7.7% (381 B)', 4542, 4923, '', NULL, 0, 1, '2017-05-19 08:17:41', NULL),
(515, 3826, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-158x88.jpg', '', 'Reduced by 11.0% (387 B)', 3123, 3510, '', NULL, 0, 1, '2017-05-19 08:17:42', NULL),
(516, 3826, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-400x400.jpg', '', 'Reduced by 3.0% (582 B)', 18951, 19533, '', NULL, 0, 1, '2017-05-19 08:17:42', NULL),
(517, 3826, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-650x490.jpg', '', 'Reduced by 3.4% (1.0 KB)', 30152, 31222, '', NULL, 0, 1, '2017-05-19 08:17:42', NULL),
(518, 3826, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-418x279.jpg', '', 'Reduced by 4.0% (572 B)', 13771, 14343, '', NULL, 0, 1, '2017-05-19 08:17:42', NULL),
(519, 3826, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-886x668.jpg', '', 'Reduced by 3.4% (1.7 KB)', 49657, 51415, '', NULL, 0, 1, '2017-05-19 08:17:42', NULL),
(520, 3826, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-886x315.jpg', '', 'Reduced by 2.9% (869 B)', 29341, 30210, '', NULL, 0, 1, '2017-05-19 08:17:42', NULL),
(521, 3826, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-1920x1080.jpg', '', 'Reduced by 6.3% (9.1 KB)', 138493, 147834, '', NULL, 0, 1, '2017-05-19 08:17:42', NULL),
(522, 3826, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-1920x820.jpg', '', 'Reduced by 5.8% (7.2 KB)', 118996, 126362, '', NULL, 0, 1, '2017-05-19 08:17:43', NULL),
(523, 3826, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-512x512.jpg', '', 'Reduced by 2.7% (773 B)', 28205, 28978, '', NULL, 0, 1, '2017-05-19 08:17:43', NULL),
(524, 3826, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-141x188.jpg', '', 'Reduced by 6.6% (386 B)', 5437, 5823, '', NULL, 0, 1, '2017-05-19 08:17:43', NULL),
(525, 3826, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-418x560.jpg', '', 'Reduced by 2.4% (718 B)', 29518, 30236, '', NULL, 0, 1, '2017-05-19 08:17:43', NULL),
(526, 3826, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-301x226.jpg', '', 'Reduced by 4.6% (458 B)', 9451, 9909, '', NULL, 0, 1, '2017-05-19 08:17:43', NULL),
(527, 3826, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-480x362.jpg', '', 'Reduced by 3.5% (693 B)', 18880, 19573, '', NULL, 0, 1, '2017-05-19 08:17:43', NULL),
(528, 3826, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_316295534-1355x1020.jpg', '', 'Reduced by 5.8% (5.9 KB)', 97096, 103114, '', NULL, 0, 1, '2017-05-19 08:17:43', NULL),
(529, 3828, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896.jpg', '', 'Reduced by 17.6% (39.7 KB)', 191095, 231798, '', NULL, 0, 1, '2017-05-19 08:17:48', NULL),
(530, 3828, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-295x222.jpg', '', 'Reduced by 8.3% (488 B)', 5421, 5909, '', NULL, 0, 1, '2017-05-19 08:17:48', NULL),
(531, 3828, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-300x225.jpg', '', 'Reduced by 8.5% (519 B)', 5562, 6081, '', NULL, 0, 1, '2017-05-19 08:17:48', NULL),
(532, 3828, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-768x576.jpg', '', 'Reduced by 8.2% (2.0 KB)', 22568, 24585, '', NULL, 0, 1, '2017-05-19 08:17:48', NULL),
(533, 3828, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-1024x768.jpg', '', 'Reduced by 9.6% (3.6 KB)', 35027, 38726, '', NULL, 0, 1, '2017-05-19 08:17:48', NULL),
(534, 3828, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-769x431.jpg', '', 'Reduced by 5.7% (1.3 KB)', 21154, 22441, '', NULL, 0, 1, '2017-05-19 08:17:48', NULL),
(535, 3828, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-418x315.jpg', '', 'Reduced by 7.6% (747 B)', 9043, 9790, '', NULL, 0, 1, '2017-05-19 08:17:49', NULL),
(536, 3828, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-150x150.jpg', '', 'Reduced by 11.9% (388 B)', 2886, 3274, '', NULL, 0, 1, '2017-05-19 08:17:49', NULL),
(537, 3828, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-158x88.jpg', '', 'Reduced by 14.8% (374 B)', 2145, 2519, '', NULL, 0, 1, '2017-05-19 08:17:49', NULL),
(538, 3828, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-400x400.jpg', '', 'Reduced by 5.1% (645 B)', 11955, 12600, '', NULL, 0, 1, '2017-05-19 08:17:49', NULL),
(539, 3828, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-650x490.jpg', '', 'Reduced by 7.7% (1.4 KB)', 17753, 19226, '', NULL, 0, 1, '2017-05-19 08:17:49', NULL),
(540, 3828, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-418x314.jpg', '', 'Reduced by 7.8% (759 B)', 8981, 9740, '', NULL, 0, 1, '2017-05-19 08:17:49', NULL),
(541, 3828, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-886x668.jpg', '', 'Reduced by 9.0% (2.7 KB)', 28391, 31203, '', NULL, 0, 1, '2017-05-19 08:17:49', NULL),
(542, 3828, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-886x315.jpg', '', 'Reduced by 6.3% (1.1 KB)', 17340, 18502, '', NULL, 0, 1, '2017-05-19 08:17:49', NULL),
(543, 3828, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-1920x1080.jpg', '', 'Reduced by 10.9% (9.9 KB)', 82794, 92954, '', NULL, 0, 1, '2017-05-19 08:17:50', NULL),
(544, 3828, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-1920x820.jpg', '', 'Reduced by 10.4% (7.4 KB)', 65860, 73476, '', NULL, 0, 1, '2017-05-19 08:17:50', NULL),
(545, 3828, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-512x512.jpg', '', 'Reduced by 5.4% (999 B)', 17424, 18423, '', NULL, 0, 1, '2017-05-19 08:17:50', NULL),
(546, 3828, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-141x188.jpg', '', 'Reduced by 10.8% (371 B)', 3078, 3449, '', NULL, 0, 1, '2017-05-19 08:17:50', NULL),
(547, 3828, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-418x560.jpg', '', 'Reduced by 5.8% (974 B)', 15921, 16895, '', NULL, 0, 1, '2017-05-19 08:17:50', NULL),
(548, 3828, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-301x226.jpg', '', 'Reduced by 8.5% (521 B)', 5588, 6109, '', NULL, 0, 1, '2017-05-19 08:17:50', NULL),
(549, 3828, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-480x362.jpg', '', 'Reduced by 7.3% (876 B)', 11188, 12064, '', NULL, 0, 1, '2017-05-19 08:17:50', NULL),
(550, 3828, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_193476896-1355x1020.jpg', '', 'Reduced by 11.6% (6.9 KB)', 54010, 61080, '', NULL, 0, 1, '2017-05-19 08:17:50', NULL),
(1814, 3882, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-480x362.jpg', '', 'Reduced by 4.9% (772 B)', 15142, 15914, '', NULL, 0, 1, '2017-05-19 10:18:54', NULL),
(1813, 3882, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-301x226.jpg', '', 'Reduced by 6.2% (501 B)', 7524, 8025, '', NULL, 0, 1, '2017-05-19 10:18:54', NULL),
(1812, 3882, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-418x560.jpg', '', 'Reduced by 4.3% (885 B)', 19926, 20811, '', NULL, 0, 1, '2017-05-19 10:18:54', NULL),
(1810, 3882, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-512x512.jpg', '', 'Reduced by 5.9% (1.1 KB)', 18228, 19381, '', NULL, 0, 1, '2017-05-19 10:18:54', NULL),
(1809, 3882, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-663x315.jpg', '', 'Reduced by 5.0% (969 B)', 18446, 19415, '', NULL, 0, 1, '2017-05-19 10:18:54', NULL),
(1808, 3882, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-418x418.jpg', '', 'Reduced by 6.2% (906 B)', 13603, 14509, '', NULL, 0, 1, '2017-05-19 10:18:53', NULL),
(1807, 3882, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-650x490.jpg', '', 'Reduced by 4.7% (1.2 KB)', 24245, 25447, '', NULL, 0, 1, '2017-05-19 10:18:53', NULL),
(1806, 3882, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-400x400.jpg', '', 'Reduced by 5.9% (788 B)', 12597, 13385, '', NULL, 0, 1, '2017-05-19 10:18:53', NULL),
(1805, 3882, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-158x88.jpg', '', 'Reduced by 14.0% (386 B)', 2372, 2758, '', NULL, 0, 1, '2017-05-19 10:18:53', NULL),
(1802, 3882, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-663x431.jpg', '', 'Reduced by 4.3% (1.1 KB)', 24948, 26071, '', NULL, 0, 1, '2017-05-19 10:18:53', NULL),
(1801, 3882, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-300x300.jpg', '', 'Reduced by 6.7% (591 B)', 8175, 8766, '', NULL, 0, 1, '2017-05-19 10:18:53', NULL),
(1800, 3882, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-295x222.jpg', '', 'Reduced by 6.4% (501 B)', 7269, 7770, '', NULL, 0, 1, '2017-05-19 10:18:52', NULL),
(1799, 3882, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1.jpg', '', 'Reduced by 1.8% (839 B)', 46029, 46868, '', NULL, 0, 1, '2017-05-19 10:18:52', NULL),
(1798, 3881, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-480x362.jpg', '', 'Reduced by 5.3% (828 B)', 14804, 15632, '', NULL, 0, 1, '2017-05-19 10:18:48', NULL),
(1797, 3881, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-301x226.jpg', '', 'Reduced by 6.4% (530 B)', 7689, 8219, '', NULL, 0, 1, '2017-05-19 10:18:48', NULL),
(1796, 3881, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-418x560.jpg', '', 'Reduced by 4.1% (908 B)', 21432, 22340, '', NULL, 0, 1, '2017-05-19 10:18:48', NULL),
(1793, 3881, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-663x315.jpg', '', 'Reduced by 6.3% (1.0 KB)', 15368, 16410, '', NULL, 0, 1, '2017-05-19 10:18:47', NULL),
(1792, 3881, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-418x418.jpg', '', 'Reduced by 5.4% (905 B)', 15856, 16761, '', NULL, 0, 1, '2017-05-19 10:18:47', NULL),
(1791, 3881, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-650x490.jpg', '', 'Reduced by 5.3% (1.3 KB)', 23219, 24529, '', NULL, 0, 1, '2017-05-19 10:18:47', NULL),
(1790, 3881, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-400x400.jpg', '', 'Reduced by 4.9% (750 B)', 14423, 15173, '', NULL, 0, 1, '2017-05-19 10:18:47', NULL),
(1789, 3881, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-158x88.jpg', '', 'Reduced by 14.5% (399 B)', 2356, 2755, '', NULL, 0, 1, '2017-05-19 10:18:47', NULL),
(1788, 3881, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-150x150.jpg', '', 'Reduced by 10.2% (426 B)', 3742, 4168, '', NULL, 0, 1, '2017-05-19 10:18:47', NULL),
(1787, 3881, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-418x315.jpg', '', 'Reduced by 5.3% (683 B)', 12279, 12962, '', NULL, 0, 1, '2017-05-19 10:18:47', NULL),
(1782, 3880, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-480x362.jpg', '', 'Reduced by 3.1% (661 B)', 20374, 21035, '', NULL, 0, 1, '2017-05-19 10:18:42', NULL),
(1781, 3880, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-301x226.jpg', '', 'Reduced by 4.0% (413 B)', 9876, 10289, '', NULL, 0, 1, '2017-05-19 10:18:42', NULL),
(1780, 3880, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-418x560.jpg', '', 'Reduced by 1.6% (543 B)', 33704, 34247, '', NULL, 0, 1, '2017-05-19 10:18:42', NULL),
(1779, 3880, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-141x188.jpg', '', 'Reduced by 5.9% (373 B)', 5908, 6281, '', NULL, 0, 1, '2017-05-19 10:18:42', NULL),
(1771, 3880, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-418x315.jpg', '', 'Reduced by 3.2% (551 B)', 16535, 17086, '', NULL, 0, 1, '2017-05-19 10:18:41', NULL),
(1770, 3880, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-663x431.jpg', '', 'Reduced by 2.8% (934 B)', 32021, 32955, '', NULL, 0, 1, '2017-05-19 10:18:40', NULL),
(1769, 3880, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-300x300.jpg', '', 'Reduced by 3.6% (480 B)', 12957, 13437, '', NULL, 0, 1, '2017-05-19 10:18:40', NULL),
(1768, 3880, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-295x222.jpg', '', 'Reduced by 4.3% (427 B)', 9417, 9844, '', NULL, 0, 1, '2017-05-19 10:18:40', NULL),
(1767, 3880, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3.jpg', '', 'Reduced by 1.1% (879 B)', 78567, 79446, '', NULL, 0, 1, '2017-05-19 10:18:40', NULL),
(1700, 3851, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-1920x820.jpg', '', 'Reduced by 25.7% (11.7 KB)', 34751, 46768, '', NULL, 0, 1, '2017-05-19 09:14:52', NULL),
(1699, 3851, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-1920x1080.jpg', '', 'Reduced by 23.7% (14.8 KB)', 48588, 63711, '', NULL, 0, 1, '2017-05-19 09:14:51', NULL),
(1698, 3851, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-886x315.jpg', '', 'Reduced by 20.8% (2.1 KB)', 8253, 10422, '', NULL, 0, 1, '2017-05-19 09:14:51', NULL),
(1697, 3851, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-886x668.jpg', '', 'Reduced by 18.8% (3.9 KB)', 17459, 21496, '', NULL, 0, 1, '2017-05-19 09:14:51', NULL),
(1690, 3851, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-769x431.jpg', '', 'Reduced by 16.8% (2.2 KB)', 11232, 13506, '', NULL, 0, 1, '2017-05-19 09:14:50', NULL),
(1689, 3851, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-1024x880.jpg', '', 'Reduced by 21.4% (6.2 KB)', 23200, 29504, '', NULL, 0, 1, '2017-05-19 09:14:50', NULL),
(1688, 3851, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-768x660.jpg', '', 'Reduced by 19.0% (3.4 KB)', 15036, 18553, '', NULL, 0, 1, '2017-05-19 09:14:50', NULL),
(1687, 3851, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-300x258.jpg', '', 'Reduced by 16.1% (753 B)', 3913, 4666, '', NULL, 0, 1, '2017-05-19 09:14:50', NULL),
(1686, 3851, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-295x222.jpg', '', 'Reduced by 16.1% (681 B)', 3545, 4226, '', NULL, 0, 1, '2017-05-19 09:14:50', NULL),
(1685, 3851, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2.jpg', '', 'Reduced by 38.9% (182.3 KB)', 293129, 479760, '', NULL, 0, 1, '2017-05-19 09:14:49', NULL),
(1684, 3850, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-1355x1020.jpg', '', 'Reduced by 16.7% (8.6 KB)', 43854, 52670, '', NULL, 0, 1, '2017-05-19 09:14:45', NULL),
(1683, 3850, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-480x362.jpg', '', 'Reduced by 12.5% (1.2 KB)', 8851, 10121, '', NULL, 0, 1, '2017-05-19 09:14:45', NULL),
(1682, 3850, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-301x226.jpg', '', 'Reduced by 13.0% (685 B)', 4593, 5278, '', NULL, 0, 1, '2017-05-19 09:14:45', NULL),
(1681, 3850, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-418x560.jpg', '', 'Reduced by 10.1% (1.4 KB)', 13001, 14465, '', NULL, 0, 1, '2017-05-19 09:14:44', NULL),
(1680, 3850, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-2-141x188.jpg', '', 'Reduced by 13.0% (417 B)', 2799, 3216, '', NULL, 0, 1, '2017-05-19 09:14:44', NULL),
(749, 3828, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896.jpg', '', 'No savings', 191095, 191095, '', NULL, 0, 1, '2017-05-19 11:19:49', NULL),
(750, 3828, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-295x222.jpg', '', 'No savings', 5421, 5421, '', NULL, 0, 1, '2017-05-19 11:19:49', NULL),
(751, 3828, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-300x225.jpg', '', 'No savings', 5562, 5562, '', NULL, 0, 1, '2017-05-19 11:19:49', NULL),
(752, 3828, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-768x576.jpg', '', 'No savings', 22568, 22568, '', NULL, 0, 1, '2017-05-19 11:19:49', NULL),
(753, 3828, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-1024x768.jpg', '', 'No savings', 35027, 35027, '', NULL, 0, 1, '2017-05-19 11:19:49', NULL),
(754, 3828, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-769x431.jpg', '', 'No savings', 21154, 21154, '', NULL, 0, 1, '2017-05-19 11:19:49', NULL),
(755, 3828, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-418x315.jpg', '', 'No savings', 9043, 9043, '', NULL, 0, 1, '2017-05-19 11:19:50', NULL),
(756, 3828, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-150x150.jpg', '', 'No savings', 2886, 2886, '', NULL, 0, 1, '2017-05-19 11:19:50', NULL),
(757, 3828, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-158x88.jpg', '', 'No savings', 2145, 2145, '', NULL, 0, 1, '2017-05-19 11:19:50', NULL),
(758, 3828, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-400x400.jpg', '', 'No savings', 11955, 11955, '', NULL, 0, 1, '2017-05-19 11:19:50', NULL),
(759, 3828, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-650x490.jpg', '', 'No savings', 17753, 17753, '', NULL, 0, 1, '2017-05-19 11:19:50', NULL),
(760, 3828, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-418x314.jpg', '', 'No savings', 8981, 8981, '', NULL, 0, 1, '2017-05-19 11:19:50', NULL),
(761, 3828, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-886x668.jpg', '', 'No savings', 28391, 28391, '', NULL, 0, 1, '2017-05-19 11:19:50', NULL),
(762, 3828, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-886x315.jpg', '', 'No savings', 17340, 17340, '', NULL, 0, 1, '2017-05-19 11:19:50', NULL),
(763, 3828, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-1920x1080.jpg', '', 'No savings', 82794, 82794, '', NULL, 0, 1, '2017-05-19 11:19:51', NULL),
(764, 3828, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-1920x820.jpg', '', 'No savings', 65860, 65860, '', NULL, 0, 1, '2017-05-19 11:19:51', NULL),
(765, 3828, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-512x512.jpg', '', 'No savings', 17424, 17424, '', NULL, 0, 1, '2017-05-19 11:19:51', NULL),
(766, 3828, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-141x188.jpg', '', 'No savings', 3078, 3078, '', NULL, 0, 1, '2017-05-19 11:19:51', NULL),
(767, 3828, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-418x560.jpg', '', 'No savings', 15921, 15921, '', NULL, 0, 1, '2017-05-19 11:19:51', NULL),
(768, 3828, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-301x226.jpg', '', 'No savings', 5588, 5588, '', NULL, 0, 1, '2017-05-19 11:19:51', NULL),
(769, 3828, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-480x362.jpg', '', 'No savings', 11188, 11188, '', NULL, 0, 1, '2017-05-19 11:19:51', NULL),
(770, 3828, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_193476896-1355x1020.jpg', '', 'No savings', 54010, 54010, '', NULL, 0, 1, '2017-05-19 11:19:51', NULL),
(1657, 3848, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-512x512.jpg', '', 'Reduced by 7.8% (1.5 KB)', 17746, 19247, '', NULL, 0, 1, '2017-05-19 09:14:34', NULL),
(1656, 3848, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-1920x820.jpg', '', 'Reduced by 9.1% (14.0 KB)', 143554, 157907, '', NULL, 0, 1, '2017-05-19 09:14:34', NULL),
(1655, 3848, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-1920x1080.jpg', '', 'Reduced by 10.9% (18.1 KB)', 151025, 169547, '', NULL, 0, 1, '2017-05-19 09:14:34', NULL),
(1654, 3848, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-886x315.jpg', '', 'Reduced by 5.1% (1.4 KB)', 26894, 28350, '', NULL, 0, 1, '2017-05-19 09:14:33', NULL),
(1653, 3848, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-886x668.jpg', '', 'Reduced by 8.5% (3.1 KB)', 34559, 37780, '', NULL, 0, 1, '2017-05-19 09:14:33', NULL),
(1646, 3848, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-769x431.jpg', '', 'Reduced by 5.8% (1.6 KB)', 26346, 27980, '', NULL, 0, 1, '2017-05-19 09:14:32', NULL),
(1645, 3848, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-1024x880.jpg', '', 'Reduced by 9.8% (4.8 KB)', 45699, 50658, '', NULL, 0, 1, '2017-05-19 09:14:32', NULL),
(1644, 3848, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-768x660.jpg', '', 'Reduced by 9.5% (2.9 KB)', 28163, 31113, '', NULL, 0, 1, '2017-05-19 09:14:32', NULL),
(1643, 3848, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-300x258.jpg', '', 'Reduced by 9.4% (665 B)', 6436, 7101, '', NULL, 0, 1, '2017-05-19 09:14:32', NULL),
(1642, 3848, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-295x222.jpg', '', 'Reduced by 9.0% (613 B)', 6236, 6849, '', NULL, 0, 1, '2017-05-19 09:14:32', NULL),
(1641, 3848, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1.jpg', '', 'Reduced by 27.6% (188.1 KB)', 504108, 696683, '', NULL, 0, 1, '2017-05-19 09:14:32', NULL),
(1640, 3847, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-1355x1020.jpg', '', 'Reduced by 10.2% (7.4 KB)', 66453, 74028, '', NULL, 0, 1, '2017-05-19 09:14:27', NULL),
(1639, 3847, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-480x362.jpg', '', 'Reduced by 8.6% (1.0 KB)', 11035, 12070, '', NULL, 0, 1, '2017-05-19 09:14:27', NULL),
(1638, 3847, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1-301x226.jpg', '', 'Reduced by 9.4% (568 B)', 5506, 6074, '', NULL, 0, 1, '2017-05-19 09:14:27', NULL),
(793, 3826, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534.jpg', '', 'No savings', 293742, 293742, '', NULL, 0, 1, '2017-05-19 11:19:55', NULL),
(794, 3826, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-295x222.jpg', '', 'No savings', 9149, 9149, '', NULL, 0, 1, '2017-05-19 11:19:55', NULL),
(795, 3826, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-300x200.jpg', '', 'No savings', 8333, 8333, '', NULL, 0, 1, '2017-05-19 11:19:55', NULL),
(796, 3826, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-768x512.jpg', '', 'No savings', 34027, 34027, '', NULL, 0, 1, '2017-05-19 11:19:55', NULL),
(797, 3826, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-1024x682.jpg', '', 'No savings', 54084, 54084, '', NULL, 0, 1, '2017-05-19 11:19:55', NULL),
(798, 3826, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-769x431.jpg', '', 'No savings', 32121, 32121, '', NULL, 0, 1, '2017-05-19 11:19:56', NULL),
(799, 3826, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-418x315.jpg', '', 'No savings', 15358, 15358, '', NULL, 0, 1, '2017-05-19 11:19:56', NULL),
(800, 3826, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-150x150.jpg', '', 'No savings', 4542, 4542, '', NULL, 0, 1, '2017-05-19 11:19:56', NULL),
(801, 3826, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-158x88.jpg', '', 'No savings', 3123, 3123, '', NULL, 0, 1, '2017-05-19 11:19:56', NULL),
(802, 3826, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-400x400.jpg', '', 'No savings', 18951, 18951, '', NULL, 0, 1, '2017-05-19 11:19:56', NULL),
(803, 3826, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-650x490.jpg', '', 'No savings', 30152, 30152, '', NULL, 0, 1, '2017-05-19 11:19:56', NULL),
(804, 3826, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-418x279.jpg', '', 'No savings', 13771, 13771, '', NULL, 0, 1, '2017-05-19 11:19:56', NULL),
(805, 3826, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-886x668.jpg', '', 'No savings', 49657, 49657, '', NULL, 0, 1, '2017-05-19 11:19:56', NULL),
(806, 3826, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-886x315.jpg', '', 'No savings', 29341, 29341, '', NULL, 0, 1, '2017-05-19 11:19:57', NULL),
(807, 3826, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-1920x1080.jpg', '', 'No savings', 138493, 138493, '', NULL, 0, 1, '2017-05-19 11:19:57', NULL),
(808, 3826, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-1920x820.jpg', '', 'No savings', 118996, 118996, '', NULL, 0, 1, '2017-05-19 11:19:57', NULL),
(809, 3826, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-512x512.jpg', '', 'No savings', 28205, 28205, '', NULL, 0, 1, '2017-05-19 11:19:57', NULL),
(810, 3826, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-141x188.jpg', '', 'No savings', 5437, 5437, '', NULL, 0, 1, '2017-05-19 11:19:57', NULL),
(811, 3826, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-418x560.jpg', '', 'No savings', 29518, 29518, '', NULL, 0, 1, '2017-05-19 11:19:57', NULL),
(812, 3826, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-301x226.jpg', '', 'No savings', 9451, 9451, '', NULL, 0, 1, '2017-05-19 11:19:57', NULL),
(813, 3826, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-480x362.jpg', '', 'No savings', 18880, 18880, '', NULL, 0, 1, '2017-05-19 11:19:58', NULL),
(814, 3826, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_316295534-1355x1020.jpg', '', 'No savings', 97096, 97096, '', NULL, 0, 1, '2017-05-19 11:19:58', NULL),
(1615, 3846, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-418x560.jpg', '', 'Reduced by 3.8% (1.0 KB)', 26460, 27514, '', NULL, 0, 1, '2017-05-19 09:14:12', NULL),
(1614, 3846, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-141x188.jpg', '', 'Reduced by 8.4% (403 B)', 4381, 4784, '', NULL, 0, 1, '2017-05-19 09:14:12', NULL),
(1613, 3846, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-512x512.jpg', '', 'Reduced by 5.2% (1.3 KB)', 23496, 24789, '', NULL, 0, 1, '2017-05-19 09:14:11', NULL),
(1605, 3846, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-158x88.jpg', '', 'Reduced by 13.6% (397 B)', 2518, 2915, '', NULL, 0, 1, '2017-05-19 09:14:10', NULL),
(1604, 3846, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-150x150.jpg', '', 'Reduced by 12.5% (428 B)', 3000, 3428, '', NULL, 0, 1, '2017-05-19 09:14:10', NULL),
(1603, 3846, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-418x315.jpg', '', 'Reduced by 6.0% (826 B)', 13048, 13874, '', NULL, 0, 1, '2017-05-19 09:14:10', NULL),
(1602, 3846, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-769x431.jpg', '', 'Reduced by 3.7% (1.3 KB)', 35485, 36854, '', NULL, 0, 1, '2017-05-19 09:14:10', NULL),
(1601, 3846, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1024x880.jpg', '', 'Reduced by 6.2% (3.9 KB)', 60657, 64685, '', NULL, 0, 1, '2017-05-19 09:14:10', NULL),
(1600, 3846, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-768x660.jpg', '', 'Reduced by 6.0% (2.4 KB)', 37848, 40257, '', NULL, 0, 1, '2017-05-19 09:14:10', NULL),
(1599, 3846, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-300x258.jpg', '', 'Reduced by 7.6% (623 B)', 7551, 8174, '', NULL, 0, 1, '2017-05-19 09:14:09', NULL),
(1598, 3846, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-295x222.jpg', '', 'Reduced by 7.1% (557 B)', 7298, 7855, '', NULL, 0, 1, '2017-05-19 09:14:09', NULL),
(1597, 3846, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3.jpg', '', 'Reduced by 22.0% (193.7 KB)', 701685, 900084, '', NULL, 0, 1, '2017-05-19 09:14:09', NULL),
(1596, 3845, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1355x1020.jpg', '', 'Reduced by 11.5% (13.9 KB)', 109780, 124015, '', NULL, 0, 1, '2017-05-19 09:14:05', NULL),
(837, 3824, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890.jpg', '', 'No savings', 416672, 416672, '', NULL, 0, 1, '2017-05-19 11:20:04', NULL),
(838, 3824, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-295x222.jpg', '', 'No savings', 10780, 10780, '', NULL, 0, 1, '2017-05-19 11:20:04', NULL),
(839, 3824, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-300x200.jpg', '', 'No savings', 9691, 9691, '', NULL, 0, 1, '2017-05-19 11:20:04', NULL),
(840, 3824, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-768x513.jpg', '', 'No savings', 41603, 41603, '', NULL, 0, 1, '2017-05-19 11:20:04', NULL),
(841, 3824, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-1024x684.jpg', '', 'No savings', 66730, 66730, '', NULL, 0, 1, '2017-05-19 11:20:04', NULL);
INSERT INTO `wp_ewwwio_images` (`id`, `attachment_id`, `gallery`, `resize`, `path`, `converted`, `results`, `image_size`, `orig_size`, `backup`, `level`, `pending`, `updates`, `updated`, `trace`) VALUES
(842, 3824, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-769x431.jpg', '', 'No savings', 36227, 36227, '', NULL, 0, 1, '2017-05-19 11:20:04', NULL),
(843, 3824, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-418x315.jpg', '', 'No savings', 18341, 18341, '', NULL, 0, 1, '2017-05-19 11:20:04', NULL),
(844, 3824, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-150x150.jpg', '', 'No savings', 5372, 5372, '', NULL, 0, 1, '2017-05-19 11:20:05', NULL),
(845, 3824, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-158x88.jpg', '', 'No savings', 3267, 3267, '', NULL, 0, 1, '2017-05-19 11:20:05', NULL),
(846, 3824, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-400x400.jpg', '', 'No savings', 23481, 23481, '', NULL, 0, 1, '2017-05-19 11:20:05', NULL),
(847, 3824, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-650x490.jpg', '', 'No savings', 36955, 36955, '', NULL, 0, 1, '2017-05-19 11:20:05', NULL),
(848, 3824, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-418x279.jpg', '', 'No savings', 15953, 15953, '', NULL, 0, 1, '2017-05-19 11:20:05', NULL),
(849, 3824, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-886x668.jpg', '', 'No savings', 61096, 61096, '', NULL, 0, 1, '2017-05-19 11:20:05', NULL),
(850, 3824, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-886x315.jpg', '', 'No savings', 30347, 30347, '', NULL, 0, 1, '2017-05-19 11:20:05', NULL),
(851, 3824, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-1920x1080.jpg', '', 'No savings', 166275, 166275, '', NULL, 0, 1, '2017-05-19 11:20:06', NULL),
(852, 3824, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-1920x820.jpg', '', 'No savings', 129447, 129447, '', NULL, 0, 1, '2017-05-19 11:20:06', NULL),
(853, 3824, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-512x512.jpg', '', 'No savings', 35212, 35212, '', NULL, 0, 1, '2017-05-19 11:20:06', NULL),
(854, 3824, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-141x188.jpg', '', 'No savings', 6270, 6270, '', NULL, 0, 1, '2017-05-19 11:20:06', NULL),
(855, 3824, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-418x560.jpg', '', 'No savings', 35374, 35374, '', NULL, 0, 1, '2017-05-19 11:20:06', NULL),
(856, 3824, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-301x226.jpg', '', 'No savings', 11065, 11065, '', NULL, 0, 1, '2017-05-19 11:20:06', NULL),
(857, 3824, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-480x362.jpg', '', 'No savings', 22715, 22715, '', NULL, 0, 1, '2017-05-19 11:20:06', NULL),
(858, 3824, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562454890-1355x1020.jpg', '', 'No savings', 122974, 122974, '', NULL, 0, 1, '2017-05-19 11:20:07', NULL),
(859, 3823, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770.jpg', '', 'No savings', 420908, 420908, '', NULL, 0, 1, '2017-05-19 11:20:07', NULL),
(860, 3823, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-295x222.jpg', '', 'No savings', 13677, 13677, '', NULL, 0, 1, '2017-05-19 11:20:07', NULL),
(861, 3823, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-300x200.jpg', '', 'No savings', 12848, 12848, '', NULL, 0, 1, '2017-05-19 11:20:07', NULL),
(862, 3823, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-768x513.jpg', '', 'No savings', 53646, 53646, '', NULL, 0, 1, '2017-05-19 11:20:07', NULL),
(863, 3823, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-1024x684.jpg', '', 'No savings', 82578, 82578, '', NULL, 0, 1, '2017-05-19 11:20:07', NULL),
(864, 3823, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-769x431.jpg', '', 'No savings', 46026, 46026, '', NULL, 0, 1, '2017-05-19 11:20:08', NULL),
(865, 3823, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-418x315.jpg', '', 'No savings', 23443, 23443, '', NULL, 0, 1, '2017-05-19 11:20:08', NULL),
(866, 3823, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-150x150.jpg', '', 'No savings', 6049, 6049, '', NULL, 0, 1, '2017-05-19 11:20:08', NULL),
(867, 3823, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-158x88.jpg', '', 'No savings', 4318, 4318, '', NULL, 0, 1, '2017-05-19 11:20:08', NULL),
(868, 3823, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-400x400.jpg', '', 'No savings', 26120, 26120, '', NULL, 0, 1, '2017-05-19 11:20:08', NULL),
(869, 3823, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-650x490.jpg', '', 'No savings', 45936, 45936, '', NULL, 0, 1, '2017-05-19 11:20:08', NULL),
(870, 3823, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-418x279.jpg', '', 'No savings', 21447, 21447, '', NULL, 0, 1, '2017-05-19 11:20:08', NULL),
(871, 3823, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-886x668.jpg', '', 'No savings', 72787, 72787, '', NULL, 0, 1, '2017-05-19 11:20:08', NULL),
(872, 3823, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-886x315.jpg', '', 'No savings', 40244, 40244, '', NULL, 0, 1, '2017-05-19 11:20:09', NULL),
(873, 3823, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-1920x1080.jpg', '', 'No savings', 178358, 178358, '', NULL, 0, 1, '2017-05-19 11:20:09', NULL),
(874, 3823, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-1920x820.jpg', '', 'No savings', 141298, 141298, '', NULL, 0, 1, '2017-05-19 11:20:09', NULL),
(875, 3823, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-512x512.jpg', '', 'No savings', 38222, 38222, '', NULL, 0, 1, '2017-05-19 11:20:09', NULL),
(876, 3823, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-141x188.jpg', '', 'No savings', 6521, 6521, '', NULL, 0, 1, '2017-05-19 11:20:09', NULL),
(877, 3823, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-418x560.jpg', '', 'No savings', 33736, 33736, '', NULL, 0, 1, '2017-05-19 11:20:09', NULL),
(878, 3823, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-301x226.jpg', '', 'No savings', 14205, 14205, '', NULL, 0, 1, '2017-05-19 11:20:10', NULL),
(879, 3823, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-480x362.jpg', '', 'No savings', 28874, 28874, '', NULL, 0, 1, '2017-05-19 11:20:10', NULL),
(880, 3823, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_447365770-1355x1020.jpg', '', 'No savings', 136159, 136159, '', NULL, 0, 1, '2017-05-19 11:20:10', NULL),
(881, 3822, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279.jpg', '', 'No savings', 414255, 414255, '', NULL, 0, 1, '2017-05-19 11:20:10', NULL),
(882, 3822, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-295x222.jpg', '', 'No savings', 8557, 8557, '', NULL, 0, 1, '2017-05-19 11:20:10', NULL),
(883, 3822, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-300x214.jpg', '', 'No savings', 8183, 8183, '', NULL, 0, 1, '2017-05-19 11:20:10', NULL),
(884, 3822, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-768x548.jpg', '', 'No savings', 50855, 50855, '', NULL, 0, 1, '2017-05-19 11:20:11', NULL),
(885, 3822, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-1024x731.jpg', '', 'No savings', 89001, 89001, '', NULL, 0, 1, '2017-05-19 11:20:11', NULL),
(886, 3822, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-769x431.jpg', '', 'No savings', 48874, 48874, '', NULL, 0, 1, '2017-05-19 11:20:11', NULL),
(887, 3822, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-418x315.jpg', '', 'No savings', 16748, 16748, '', NULL, 0, 1, '2017-05-19 11:20:11', NULL),
(888, 3822, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-150x150.jpg', '', 'No savings', 3999, 3999, '', NULL, 0, 1, '2017-05-19 11:20:11', NULL),
(889, 3822, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-158x88.jpg', '', 'No savings', 2518, 2518, '', NULL, 0, 1, '2017-05-19 11:20:11', NULL),
(890, 3822, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-400x400.jpg', '', 'No savings', 25871, 25871, '', NULL, 0, 1, '2017-05-19 11:20:11', NULL),
(891, 3822, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-650x490.jpg', '', 'No savings', 39922, 39922, '', NULL, 0, 1, '2017-05-19 11:20:11', NULL),
(892, 3822, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-418x298.jpg', '', 'No savings', 15287, 15287, '', NULL, 0, 1, '2017-05-19 11:20:11', NULL),
(893, 3822, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-886x668.jpg', '', 'No savings', 73781, 73781, '', NULL, 0, 1, '2017-05-19 11:20:12', NULL),
(894, 3822, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-886x315.jpg', '', 'No savings', 46691, 46691, '', NULL, 0, 1, '2017-05-19 11:20:12', NULL),
(895, 3822, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-1920x1080.jpg', '', 'No savings', 240947, 240947, '', NULL, 0, 1, '2017-05-19 11:20:12', NULL),
(896, 3822, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-1920x820.jpg', '', 'No savings', 204165, 204165, '', NULL, 0, 1, '2017-05-19 11:20:12', NULL),
(897, 3822, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-512x512.jpg', '', 'No savings', 42385, 42385, '', NULL, 0, 1, '2017-05-19 11:20:12', NULL),
(898, 3822, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-141x188.jpg', '', 'No savings', 5521, 5521, '', NULL, 0, 1, '2017-05-19 11:20:12', NULL),
(899, 3822, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-418x560.jpg', '', 'No savings', 46725, 46725, '', NULL, 0, 1, '2017-05-19 11:20:13', NULL),
(900, 3822, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-301x226.jpg', '', 'No savings', 8803, 8803, '', NULL, 0, 1, '2017-05-19 11:20:13', NULL),
(901, 3822, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-480x362.jpg', '', 'No savings', 21853, 21853, '', NULL, 0, 1, '2017-05-19 11:20:13', NULL),
(902, 3822, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_556612279-1355x1020.jpg', '', 'No savings', 150347, 150347, '', NULL, 0, 1, '2017-05-19 11:20:13', NULL),
(903, 3821, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479.jpg', '', 'No savings', 456986, 456986, '', NULL, 0, 1, '2017-05-19 11:20:13', NULL),
(904, 3821, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-295x222.jpg', '', 'No savings', 12851, 12851, '', NULL, 0, 1, '2017-05-19 11:20:14', NULL),
(905, 3821, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-300x200.jpg', '', 'No savings', 11919, 11919, '', NULL, 0, 1, '2017-05-19 11:20:14', NULL),
(906, 3821, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-768x513.jpg', '', 'No savings', 49783, 49783, '', NULL, 0, 1, '2017-05-19 11:20:14', NULL),
(907, 3821, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-1024x684.jpg', '', 'No savings', 77612, 77612, '', NULL, 0, 1, '2017-05-19 11:20:14', NULL),
(908, 3821, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-769x431.jpg', '', 'No savings', 44277, 44277, '', NULL, 0, 1, '2017-05-19 11:20:14', NULL),
(909, 3821, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-418x315.jpg', '', 'No savings', 22131, 22131, '', NULL, 0, 1, '2017-05-19 11:20:14', NULL),
(910, 3821, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-150x150.jpg', '', 'No savings', 6091, 6091, '', NULL, 0, 1, '2017-05-19 11:20:14', NULL),
(911, 3821, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-158x88.jpg', '', 'No savings', 4050, 4050, '', NULL, 0, 1, '2017-05-19 11:20:14', NULL),
(912, 3821, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-400x400.jpg', '', 'No savings', 26375, 26375, '', NULL, 0, 1, '2017-05-19 11:20:15', NULL),
(913, 3821, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-650x490.jpg', '', 'No savings', 43315, 43315, '', NULL, 0, 1, '2017-05-19 11:20:15', NULL),
(914, 3821, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-418x279.jpg', '', 'No savings', 19668, 19668, '', NULL, 0, 1, '2017-05-19 11:20:15', NULL),
(915, 3821, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-886x668.jpg', '', 'No savings', 69958, 69958, '', NULL, 0, 1, '2017-05-19 11:20:15', NULL),
(916, 3821, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-886x315.jpg', '', 'No savings', 38087, 38087, '', NULL, 0, 1, '2017-05-19 11:20:15', NULL),
(917, 3821, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-1920x1080.jpg', '', 'No savings', 184328, 184328, '', NULL, 0, 1, '2017-05-19 11:20:15', NULL),
(918, 3821, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-1920x820.jpg', '', 'No savings', 149734, 149734, '', NULL, 0, 1, '2017-05-19 11:20:16', NULL),
(919, 3821, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-512x512.jpg', '', 'No savings', 38883, 38883, '', NULL, 0, 1, '2017-05-19 11:20:16', NULL),
(920, 3821, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-141x188.jpg', '', 'No savings', 6762, 6762, '', NULL, 0, 1, '2017-05-19 11:20:16', NULL),
(921, 3821, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-418x560.jpg', '', 'No savings', 36232, 36232, '', NULL, 0, 1, '2017-05-19 11:20:16', NULL),
(922, 3821, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-301x226.jpg', '', 'No savings', 13469, 13469, '', NULL, 0, 1, '2017-05-19 11:20:16', NULL),
(923, 3821, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-480x362.jpg', '', 'No savings', 27111, 27111, '', NULL, 0, 1, '2017-05-19 11:20:16', NULL),
(924, 3821, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_562748479-1355x1020.jpg', '', 'No savings', 134991, 134991, '', NULL, 0, 1, '2017-05-19 11:20:16', NULL),
(925, 3820, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746.jpg', '', 'No savings', 492446, 492446, '', NULL, 0, 1, '2017-05-19 11:20:19', NULL),
(926, 3820, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-295x222.jpg', '', 'No savings', 15601, 15601, '', NULL, 0, 1, '2017-05-19 11:20:19', NULL),
(927, 3820, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-300x200.jpg', '', 'No savings', 14681, 14681, '', NULL, 0, 1, '2017-05-19 11:20:19', NULL),
(928, 3820, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-768x512.jpg', '', 'No savings', 61162, 61162, '', NULL, 0, 1, '2017-05-19 11:20:19', NULL),
(929, 3820, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-1024x683.jpg', '', 'No savings', 93860, 93860, '', NULL, 0, 1, '2017-05-19 11:20:19', NULL),
(930, 3820, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-769x431.jpg', '', 'No savings', 55953, 55953, '', NULL, 0, 1, '2017-05-19 11:20:20', NULL),
(931, 3820, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-418x315.jpg', '', 'No savings', 27047, 27047, '', NULL, 0, 1, '2017-05-19 11:20:20', NULL),
(932, 3820, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-150x150.jpg', '', 'No savings', 6752, 6752, '', NULL, 0, 1, '2017-05-19 11:20:20', NULL),
(933, 3820, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-158x88.jpg', '', 'No savings', 4996, 4996, '', NULL, 0, 1, '2017-05-19 11:20:20', NULL),
(934, 3820, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-400x400.jpg', '', 'No savings', 29714, 29714, '', NULL, 0, 1, '2017-05-19 11:20:20', NULL),
(935, 3820, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-650x490.jpg', '', 'No savings', 52303, 52303, '', NULL, 0, 1, '2017-05-19 11:20:20', NULL),
(936, 3820, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-418x279.jpg', '', 'No savings', 24579, 24579, '', NULL, 0, 1, '2017-05-19 11:20:20', NULL),
(937, 3820, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-886x668.jpg', '', 'No savings', 82176, 82176, '', NULL, 0, 1, '2017-05-19 11:20:20', NULL),
(938, 3820, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-886x315.jpg', '', 'No savings', 50008, 50008, '', NULL, 0, 1, '2017-05-19 11:20:21', NULL),
(939, 3820, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-1920x1080.jpg', '', 'No savings', 211730, 211730, '', NULL, 0, 1, '2017-05-19 11:20:21', NULL),
(940, 3820, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-1920x820.jpg', '', 'No savings', 179012, 179012, '', NULL, 0, 1, '2017-05-19 11:20:21', NULL),
(941, 3820, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-512x512.jpg', '', 'No savings', 43247, 43247, '', NULL, 0, 1, '2017-05-19 11:20:21', NULL),
(942, 3820, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-141x188.jpg', '', 'No savings', 7285, 7285, '', NULL, 0, 1, '2017-05-19 11:20:21', NULL),
(943, 3820, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-418x560.jpg', '', 'No savings', 37756, 37756, '', NULL, 0, 1, '2017-05-19 11:20:21', NULL),
(944, 3820, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-301x226.jpg', '', 'No savings', 16258, 16258, '', NULL, 0, 1, '2017-05-19 11:20:21', NULL),
(945, 3820, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-480x362.jpg', '', 'No savings', 33046, 33046, '', NULL, 0, 1, '2017-05-19 11:20:22', NULL),
(946, 3820, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_508010746-1355x1020.jpg', '', 'No savings', 151762, 151762, '', NULL, 0, 1, '2017-05-19 11:20:22', NULL),
(1572, 3844, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-301x226.jpg', '', 'Reduced by 7.7% (617 B)', 7402, 8019, '', NULL, 0, 1, '2017-05-19 09:13:57', NULL),
(1571, 3844, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-418x560.jpg', '', 'Reduced by 4.5% (1.2 KB)', 25828, 27045, '', NULL, 0, 1, '2017-05-19 09:13:57', NULL),
(1570, 3844, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-141x188.jpg', '', 'Reduced by 8.9% (430 B)', 4399, 4829, '', NULL, 0, 1, '2017-05-19 09:13:56', NULL),
(1569, 3844, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-512x512.jpg', '', 'Reduced by 5.8% (1.4 KB)', 22857, 24255, '', NULL, 0, 1, '2017-05-19 09:13:56', NULL),
(969, 3818, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036.jpg', '', 'No savings', 541772, 541772, '', NULL, 0, 1, '2017-05-19 11:20:25', NULL),
(970, 3818, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-295x222.jpg', '', 'No savings', 18022, 18022, '', NULL, 0, 1, '2017-05-19 11:20:26', NULL),
(971, 3818, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-300x200.jpg', '', 'No savings', 15303, 15303, '', NULL, 0, 1, '2017-05-19 11:20:26', NULL),
(972, 3818, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-768x512.jpg', '', 'No savings', 74987, 74987, '', NULL, 0, 1, '2017-05-19 11:20:26', NULL),
(973, 3818, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-1024x682.jpg', '', 'No savings', 115586, 115586, '', NULL, 0, 1, '2017-05-19 11:20:26', NULL),
(974, 3818, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-769x431.jpg', '', 'No savings', 64747, 64747, '', NULL, 0, 1, '2017-05-19 11:20:26', NULL),
(975, 3818, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-418x315.jpg', '', 'No savings', 32385, 32385, '', NULL, 0, 1, '2017-05-19 11:20:26', NULL),
(976, 3818, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-150x150.jpg', '', 'No savings', 8440, 8440, '', NULL, 0, 1, '2017-05-19 11:20:26', NULL),
(977, 3818, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-158x88.jpg', '', 'No savings', 4546, 4546, '', NULL, 0, 1, '2017-05-19 11:20:27', NULL),
(978, 3818, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-400x400.jpg', '', 'No savings', 43732, 43732, '', NULL, 0, 1, '2017-05-19 11:20:27', NULL),
(979, 3818, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-650x490.jpg', '', 'No savings', 68787, 68787, '', NULL, 0, 1, '2017-05-19 11:20:27', NULL),
(980, 3818, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-418x279.jpg', '', 'No savings', 26895, 26895, '', NULL, 0, 1, '2017-05-19 11:20:27', NULL),
(981, 3818, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-886x668.jpg', '', 'No savings', 109755, 109755, '', NULL, 0, 1, '2017-05-19 11:20:27', NULL),
(982, 3818, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-886x315.jpg', '', 'No savings', 54786, 54786, '', NULL, 0, 1, '2017-05-19 11:20:27', NULL),
(983, 3818, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-1920x1080.jpg', '', 'No savings', 283006, 283006, '', NULL, 0, 1, '2017-05-19 11:20:27', NULL),
(984, 3818, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-1920x820.jpg', '', 'No savings', 226865, 226865, '', NULL, 0, 1, '2017-05-19 11:20:28', NULL),
(985, 3818, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-512x512.jpg', '', 'No savings', 67142, 67142, '', NULL, 0, 1, '2017-05-19 11:20:28', NULL),
(986, 3818, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-141x188.jpg', '', 'No savings', 10319, 10319, '', NULL, 0, 1, '2017-05-19 11:20:28', NULL),
(987, 3818, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-418x560.jpg', '', 'No savings', 66812, 66812, '', NULL, 0, 1, '2017-05-19 11:20:28', NULL),
(988, 3818, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-301x226.jpg', '', 'No savings', 18681, 18681, '', NULL, 0, 1, '2017-05-19 11:20:28', NULL),
(989, 3818, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-480x362.jpg', '', 'No savings', 40974, 40974, '', NULL, 0, 1, '2017-05-19 11:20:28', NULL),
(990, 3818, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_302390036-1355x1020.jpg', '', 'No savings', 222825, 222825, '', NULL, 0, 1, '2017-05-19 11:20:29', NULL),
(991, 3817, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653.jpg', '', 'No savings', 571069, 571069, '', NULL, 0, 1, '2017-05-19 11:20:29', NULL),
(992, 3817, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-295x222.jpg', '', 'No savings', 13443, 13443, '', NULL, 0, 1, '2017-05-19 11:20:29', NULL),
(993, 3817, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-300x200.jpg', '', 'No savings', 12061, 12061, '', NULL, 0, 1, '2017-05-19 11:20:29', NULL),
(994, 3817, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-768x512.jpg', '', 'No savings', 58338, 58338, '', NULL, 0, 1, '2017-05-19 11:20:29', NULL),
(995, 3817, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-1024x682.jpg', '', 'No savings', 97746, 97746, '', NULL, 0, 1, '2017-05-19 11:20:29', NULL),
(996, 3817, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-769x431.jpg', '', 'No savings', 49637, 49637, '', NULL, 0, 1, '2017-05-19 11:20:30', NULL),
(997, 3817, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-418x315.jpg', '', 'No savings', 24567, 24567, '', NULL, 0, 1, '2017-05-19 11:20:30', NULL),
(998, 3817, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-150x150.jpg', '', 'No savings', 6552, 6552, '', NULL, 0, 1, '2017-05-19 11:20:30', NULL),
(999, 3817, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-158x88.jpg', '', 'No savings', 3832, 3832, '', NULL, 0, 1, '2017-05-19 11:20:30', NULL),
(1000, 3817, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-400x400.jpg', '', 'No savings', 32804, 32804, '', NULL, 0, 1, '2017-05-19 11:20:30', NULL),
(1001, 3817, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-650x490.jpg', '', 'No savings', 51737, 51737, '', NULL, 0, 1, '2017-05-19 11:20:30', NULL),
(1002, 3817, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-418x279.jpg', '', 'No savings', 21080, 21080, '', NULL, 0, 1, '2017-05-19 11:20:30', NULL),
(1003, 3817, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-886x668.jpg', '', 'No savings', 89926, 89926, '', NULL, 0, 1, '2017-05-19 11:20:30', NULL),
(1004, 3817, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-886x315.jpg', '', 'No savings', 38731, 38731, '', NULL, 0, 1, '2017-05-19 11:20:31', NULL),
(1005, 3817, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-1920x1080.jpg', '', 'No savings', 238680, 238680, '', NULL, 0, 1, '2017-05-19 11:20:31', NULL),
(1006, 3817, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-1920x820.jpg', '', 'No savings', 175587, 175587, '', NULL, 0, 1, '2017-05-19 11:20:31', NULL),
(1007, 3817, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-512x512.jpg', '', 'No savings', 51187, 51187, '', NULL, 0, 1, '2017-05-19 11:20:31', NULL),
(1008, 3817, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-141x188.jpg', '', 'No savings', 7979, 7979, '', NULL, 0, 1, '2017-05-19 11:20:31', NULL),
(1009, 3817, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-418x560.jpg', '', 'No savings', 52959, 52959, '', NULL, 0, 1, '2017-05-19 11:20:31', NULL),
(1010, 3817, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-301x226.jpg', '', 'No savings', 14176, 14176, '', NULL, 0, 1, '2017-05-19 11:20:32', NULL),
(1011, 3817, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-480x362.jpg', '', 'No savings', 30707, 30707, '', NULL, 0, 1, '2017-05-19 11:20:32', NULL),
(1012, 3817, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_156723653-1355x1020.jpg', '', 'No savings', 185032, 185032, '', NULL, 0, 1, '2017-05-19 11:20:32', NULL),
(1013, 3816, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334.jpg', '', 'No savings', 560539, 560539, '', NULL, 0, 1, '2017-05-19 11:20:32', NULL),
(1014, 3816, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-295x222.jpg', '', 'No savings', 10109, 10109, '', NULL, 0, 1, '2017-05-19 11:20:32', NULL),
(1015, 3816, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-300x167.jpg', '', 'No savings', 7278, 7278, '', NULL, 0, 1, '2017-05-19 11:20:35', NULL),
(1016, 3816, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-768x427.jpg', '', 'No savings', 44958, 44958, '', NULL, 0, 1, '2017-05-19 11:20:35', NULL),
(1017, 3816, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-1024x570.jpg', '', 'No savings', 79294, 79294, '', NULL, 0, 1, '2017-05-19 11:20:35', NULL),
(1018, 3816, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-769x431.jpg', '', 'No savings', 45917, 45917, '', NULL, 0, 1, '2017-05-19 11:20:35', NULL),
(1019, 3816, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-418x315.jpg', '', 'No savings', 20054, 20054, '', NULL, 0, 1, '2017-05-19 11:20:35', NULL),
(1020, 3816, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-150x150.jpg', '', 'No savings', 3926, 3926, '', NULL, 0, 1, '2017-05-19 11:20:35', NULL),
(1021, 3816, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-158x88.jpg', '', 'No savings', 2453, 2453, '', NULL, 0, 1, '2017-05-19 11:20:35', NULL),
(1022, 3816, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-400x400.jpg', '', 'No savings', 24527, 24527, '', NULL, 0, 1, '2017-05-19 11:20:36', NULL),
(1023, 3816, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-650x490.jpg', '', 'No savings', 47876, 47876, '', NULL, 0, 1, '2017-05-19 11:20:36', NULL),
(1024, 3816, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-418x233.jpg', '', 'No savings', 13754, 13754, '', NULL, 0, 1, '2017-05-19 11:20:36', NULL),
(1025, 3816, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-886x668.jpg', '', 'No savings', 86562, 86562, '', NULL, 0, 1, '2017-05-19 11:20:36', NULL),
(1026, 3816, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-886x315.jpg', '', 'No savings', 55478, 55478, '', NULL, 0, 1, '2017-05-19 11:20:36', NULL),
(1027, 3816, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-1920x1080.jpg', '', 'No savings', 234937, 234937, '', NULL, 0, 1, '2017-05-19 11:20:36', NULL),
(1028, 3816, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-1920x820.jpg', '', 'No savings', 224921, 224921, '', NULL, 0, 1, '2017-05-19 11:20:37', NULL),
(1029, 3816, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-512x512.jpg', '', 'No savings', 40236, 40236, '', NULL, 0, 1, '2017-05-19 11:20:37', NULL),
(1030, 3816, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-141x188.jpg', '', 'No savings', 4351, 4351, '', NULL, 0, 1, '2017-05-19 11:20:37', NULL),
(1031, 3816, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-418x560.jpg', '', 'No savings', 36271, 36271, '', NULL, 0, 1, '2017-05-19 11:20:37', NULL),
(1032, 3816, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-301x226.jpg', '', 'No savings', 10509, 10509, '', NULL, 0, 1, '2017-05-19 11:20:37', NULL),
(1033, 3816, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-480x362.jpg', '', 'No savings', 26019, 26019, '', NULL, 0, 1, '2017-05-19 11:20:37', NULL),
(1034, 3816, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_533331334-1355x1020.jpg', '', 'No savings', 175520, 175520, '', NULL, 0, 1, '2017-05-19 11:20:37', NULL),
(1035, 3815, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070.jpg', '', 'No savings', 624138, 624138, '', NULL, 0, 1, '2017-05-19 11:20:38', NULL),
(1036, 3815, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-295x222.jpg', '', 'No savings', 10444, 10444, '', NULL, 0, 1, '2017-05-19 11:20:38', NULL),
(1037, 3815, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-293x300.jpg', '', 'No savings', 11980, 11980, '', NULL, 0, 1, '2017-05-19 11:20:38', NULL),
(1038, 3815, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-768x788.jpg', '', 'No savings', 64755, 64755, '', NULL, 0, 1, '2017-05-19 11:20:38', NULL),
(1039, 3815, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-999x1024.jpg', '', 'No savings', 97852, 97852, '', NULL, 0, 1, '2017-05-19 11:20:39', NULL),
(1040, 3815, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-769x431.jpg', '', 'No savings', 42810, 42810, '', NULL, 0, 1, '2017-05-19 11:20:39', NULL),
(1041, 3815, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-418x315.jpg', '', 'No savings', 19338, 19338, '', NULL, 0, 1, '2017-05-19 11:20:39', NULL),
(1042, 3815, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-150x150.jpg', '', 'No savings', 4098, 4098, '', NULL, 0, 1, '2017-05-19 11:20:39', NULL),
(1043, 3815, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-158x88.jpg', '', 'No savings', 2889, 2889, '', NULL, 0, 1, '2017-05-19 11:20:39', NULL),
(1044, 3815, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-400x400.jpg', '', 'No savings', 20442, 20442, '', NULL, 0, 1, '2017-05-19 11:20:39', NULL),
(1045, 3815, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-650x490.jpg', '', 'No savings', 42030, 42030, '', NULL, 0, 1, '2017-05-19 11:20:39', NULL),
(1046, 3815, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-418x429.jpg', '', 'No savings', 22057, 22057, '', NULL, 0, 1, '2017-05-19 11:20:39', NULL),
(1047, 3815, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-886x668.jpg', '', 'No savings', 73358, 73358, '', NULL, 0, 1, '2017-05-19 11:20:40', NULL),
(1048, 3815, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-886x315.jpg', '', 'No savings', 36863, 36863, '', NULL, 0, 1, '2017-05-19 11:20:40', NULL),
(1049, 3815, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-1920x1080.jpg', '', 'No savings', 213798, 213798, '', NULL, 0, 1, '2017-05-19 11:20:40', NULL),
(1050, 3815, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-1920x820.jpg', '', 'No savings', 168051, 168051, '', NULL, 0, 1, '2017-05-19 11:20:40', NULL),
(1051, 3815, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-512x512.jpg', '', 'No savings', 31101, 31101, '', NULL, 0, 1, '2017-05-19 11:20:40', NULL),
(1052, 3815, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-141x188.jpg', '', 'No savings', 5350, 5350, '', NULL, 0, 1, '2017-05-19 11:20:40', NULL),
(1053, 3815, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-418x560.jpg', '', 'No savings', 33898, 33898, '', NULL, 0, 1, '2017-05-19 11:20:40', NULL),
(1054, 3815, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-301x226.jpg', '', 'No savings', 10907, 10907, '', NULL, 0, 1, '2017-05-19 11:20:41', NULL),
(1055, 3815, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-480x362.jpg', '', 'No savings', 24445, 24445, '', NULL, 0, 1, '2017-05-19 11:20:41', NULL),
(1056, 3815, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_208656070-1355x1020.jpg', '', 'No savings', 149794, 149794, '', NULL, 0, 1, '2017-05-19 11:20:41', NULL),
(1057, 3814, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597.jpg', '', 'No savings', 789581, 789581, '', NULL, 0, 1, '2017-05-19 11:20:41', NULL),
(1058, 3814, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-295x222.jpg', '', 'No savings', 27203, 27203, '', NULL, 0, 1, '2017-05-19 11:20:42', NULL),
(1059, 3814, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-300x169.jpg', '', 'No savings', 18113, 18113, '', NULL, 0, 1, '2017-05-19 11:20:42', NULL),
(1060, 3814, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-768x432.jpg', '', 'No savings', 93745, 93745, '', NULL, 0, 1, '2017-05-19 11:20:42', NULL),
(1061, 3814, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-1024x576.jpg', '', 'No savings', 138920, 138920, '', NULL, 0, 1, '2017-05-19 11:20:42', NULL),
(1062, 3814, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-769x431.jpg', '', 'No savings', 93701, 93701, '', NULL, 0, 1, '2017-05-19 11:20:42', NULL),
(1063, 3814, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-418x315.jpg', '', 'No savings', 51295, 51295, '', NULL, 0, 1, '2017-05-19 11:20:42', NULL),
(1064, 3814, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-150x150.jpg', '', 'No savings', 11132, 11132, '', NULL, 0, 1, '2017-05-19 11:20:42', NULL),
(1065, 3814, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-158x88.jpg', '', 'No savings', 5280, 5280, '', NULL, 0, 1, '2017-05-19 11:20:42', NULL),
(1066, 3814, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-400x400.jpg', '', 'No savings', 63645, 63645, '', NULL, 0, 1, '2017-05-19 11:20:43', NULL),
(1067, 3814, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-650x490.jpg', '', 'No savings', 99973, 99973, '', NULL, 0, 1, '2017-05-19 11:20:43', NULL),
(1068, 3814, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-418x235.jpg', '', 'No savings', 33095, 33095, '', NULL, 0, 1, '2017-05-19 11:20:43', NULL),
(1069, 3814, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-886x668.jpg', '', 'No savings', 161772, 161772, '', NULL, 0, 1, '2017-05-19 11:20:43', NULL),
(1070, 3814, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-886x315.jpg', '', 'No savings', 75355, 75355, '', NULL, 0, 1, '2017-05-19 11:20:43', NULL),
(1071, 3814, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-1920x1080.jpg', '', 'No savings', 344878, 344878, '', NULL, 0, 1, '2017-05-19 11:20:43', NULL),
(1072, 3814, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-1920x820.jpg', '', 'No savings', 261812, 261812, '', NULL, 0, 1, '2017-05-19 11:20:44', NULL),
(1073, 3814, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-512x512.jpg', '', 'No savings', 95749, 95749, '', NULL, 0, 1, '2017-05-19 11:20:44', NULL),
(1074, 3814, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-141x188.jpg', '', 'No savings', 13579, 13579, '', NULL, 0, 1, '2017-05-19 11:20:44', NULL),
(1075, 3814, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-418x560.jpg', '', 'No savings', 85027, 85027, '', NULL, 0, 1, '2017-05-19 11:20:44', NULL),
(1076, 3814, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-301x226.jpg', '', 'No savings', 28460, 28460, '', NULL, 0, 1, '2017-05-19 11:20:44', NULL),
(1077, 3814, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-480x362.jpg', '', 'No savings', 64661, 64661, '', NULL, 0, 1, '2017-05-19 11:20:44', NULL),
(1078, 3814, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_180932597-1355x1020.jpg', '', 'No savings', 296254, 296254, '', NULL, 0, 1, '2017-05-19 11:20:45', NULL),
(1079, 3813, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060.jpg', '', 'No savings', 916317, 916317, '', NULL, 0, 1, '2017-05-19 11:20:45', NULL),
(1080, 3813, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-295x222.jpg', '', 'No savings', 16961, 16961, '', NULL, 0, 1, '2017-05-19 11:20:45', NULL),
(1081, 3813, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-300x199.jpg', '', 'No savings', 14908, 14908, '', NULL, 0, 1, '2017-05-19 11:20:45', NULL),
(1082, 3813, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-768x509.jpg', '', 'No savings', 92263, 92263, '', NULL, 0, 1, '2017-05-19 11:20:45', NULL),
(1083, 3813, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-1024x678.jpg', '', 'No savings', 152110, 152110, '', NULL, 0, 1, '2017-05-19 11:20:46', NULL),
(1084, 3813, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-769x431.jpg', '', 'No savings', 78200, 78200, '', NULL, 0, 1, '2017-05-19 11:20:46', NULL),
(1085, 3813, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-418x315.jpg', '', 'No savings', 33634, 33634, '', NULL, 0, 1, '2017-05-19 11:20:46', NULL);
INSERT INTO `wp_ewwwio_images` (`id`, `attachment_id`, `gallery`, `resize`, `path`, `converted`, `results`, `image_size`, `orig_size`, `backup`, `level`, `pending`, `updates`, `updated`, `trace`) VALUES
(1086, 3813, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-150x150.jpg', '', 'No savings', 6515, 6515, '', NULL, 0, 1, '2017-05-19 11:20:46', NULL),
(1087, 3813, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-158x88.jpg', '', 'No savings', 4095, 4095, '', NULL, 0, 1, '2017-05-19 11:20:46', NULL),
(1088, 3813, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-400x400.jpg', '', 'No savings', 39921, 39921, '', NULL, 0, 1, '2017-05-19 11:20:46', NULL),
(1089, 3813, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-650x490.jpg', '', 'No savings', 79908, 79908, '', NULL, 0, 1, '2017-05-19 11:20:46', NULL),
(1090, 3813, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-418x277.jpg', '', 'No savings', 28263, 28263, '', NULL, 0, 1, '2017-05-19 11:20:46', NULL),
(1091, 3813, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-886x668.jpg', '', 'No savings', 136846, 136846, '', NULL, 0, 1, '2017-05-19 11:20:47', NULL),
(1092, 3813, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-886x315.jpg', '', 'No savings', 61427, 61427, '', NULL, 0, 1, '2017-05-19 11:20:47', NULL),
(1093, 3813, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-1920x1080.jpg', '', 'No savings', 397976, 397976, '', NULL, 0, 1, '2017-05-19 11:20:47', NULL),
(1094, 3813, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-1920x820.jpg', '', 'No savings', 285789, 285789, '', NULL, 0, 1, '2017-05-19 11:20:47', NULL),
(1095, 3813, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-512x512.jpg', '', 'No savings', 64869, 64869, '', NULL, 0, 1, '2017-05-19 11:20:47', NULL),
(1096, 3813, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-141x188.jpg', '', 'No savings', 7194, 7194, '', NULL, 0, 1, '2017-05-19 11:20:48', NULL),
(1097, 3813, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-418x560.jpg', '', 'No savings', 55816, 55816, '', NULL, 0, 1, '2017-05-19 11:20:48', NULL),
(1098, 3813, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-301x226.jpg', '', 'No savings', 17877, 17877, '', NULL, 0, 1, '2017-05-19 11:20:48', NULL),
(1099, 3813, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-480x362.jpg', '', 'No savings', 43797, 43797, '', NULL, 0, 1, '2017-05-19 11:20:48', NULL),
(1100, 3813, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_567559060-1355x1020.jpg', '', 'No savings', 300565, 300565, '', NULL, 0, 1, '2017-05-19 11:20:48', NULL),
(1101, 3812, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941.jpg', '', 'No savings', 950056, 950056, '', NULL, 0, 1, '2017-05-19 11:20:49', NULL),
(1102, 3812, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-295x222.jpg', '', 'No savings', 9086, 9086, '', NULL, 0, 1, '2017-05-19 11:20:51', NULL),
(1103, 3812, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-300x300.jpg', '', 'No savings', 11951, 11951, '', NULL, 0, 1, '2017-05-19 11:20:51', NULL),
(1104, 3812, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-768x768.jpg', '', 'No savings', 72405, 72405, '', NULL, 0, 1, '2017-05-19 11:20:51', NULL),
(1105, 3812, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-1024x1024.jpg', '', 'No savings', 121415, 121415, '', NULL, 0, 1, '2017-05-19 11:20:52', NULL),
(1106, 3812, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-769x431.jpg', '', 'No savings', 43225, 43225, '', NULL, 0, 1, '2017-05-19 11:20:52', NULL),
(1107, 3812, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-418x315.jpg', '', 'No savings', 17489, 17489, '', NULL, 0, 1, '2017-05-19 11:20:52', NULL),
(1108, 3812, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-150x150.jpg', '', 'No savings', 3868, 3868, '', NULL, 0, 1, '2017-05-19 11:20:52', NULL),
(1109, 3812, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-158x88.jpg', '', 'No savings', 2543, 2543, '', NULL, 0, 1, '2017-05-19 11:20:52', NULL),
(1110, 3812, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-400x400.jpg', '', 'No savings', 20356, 20356, '', NULL, 0, 1, '2017-05-19 11:20:52', NULL),
(1111, 3812, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-650x490.jpg', '', 'No savings', 41074, 41074, '', NULL, 0, 1, '2017-05-19 11:20:52', NULL),
(1112, 3812, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-418x418.jpg', '', 'No savings', 22235, 22235, '', NULL, 0, 1, '2017-05-19 11:20:53', NULL),
(1113, 3812, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-886x668.jpg', '', 'No savings', 75762, 75762, '', NULL, 0, 1, '2017-05-19 11:20:53', NULL),
(1114, 3812, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-886x315.jpg', '', 'No savings', 36579, 36579, '', NULL, 0, 1, '2017-05-19 11:20:53', NULL),
(1115, 3812, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-1920x1080.jpg', '', 'No savings', 231726, 231726, '', NULL, 0, 1, '2017-05-19 11:20:53', NULL),
(1116, 3812, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-1920x820.jpg', '', 'No savings', 174338, 174338, '', NULL, 0, 1, '2017-05-19 11:20:53', NULL),
(1117, 3812, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-512x512.jpg', '', 'No savings', 32084, 32084, '', NULL, 0, 1, '2017-05-19 11:20:53', NULL),
(1118, 3812, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-141x188.jpg', '', 'No savings', 4938, 4938, '', NULL, 0, 1, '2017-05-19 11:20:54', NULL),
(1119, 3812, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-418x560.jpg', '', 'No savings', 35939, 35939, '', NULL, 0, 1, '2017-05-19 11:20:54', NULL),
(1120, 3812, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-301x226.jpg', '', 'No savings', 9564, 9564, '', NULL, 0, 1, '2017-05-19 11:20:54', NULL),
(1121, 3812, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-480x362.jpg', '', 'No savings', 22544, 22544, '', NULL, 0, 1, '2017-05-19 11:20:54', NULL),
(1122, 3812, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_222371941-1355x1020.jpg', '', 'No savings', 162656, 162656, '', NULL, 0, 1, '2017-05-19 11:20:54', NULL),
(1123, 3811, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772.jpg', '', 'No savings', 905453, 905453, '', NULL, 0, 1, '2017-05-19 11:20:55', NULL),
(1124, 3811, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-295x222.jpg', '', 'No savings', 13729, 13729, '', NULL, 0, 1, '2017-05-19 11:20:55', NULL),
(1125, 3811, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-300x221.jpg', '', 'No savings', 13538, 13538, '', NULL, 0, 1, '2017-05-19 11:20:55', NULL),
(1126, 3811, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-768x566.jpg', '', 'No savings', 91556, 91556, '', NULL, 0, 1, '2017-05-19 11:20:55', NULL),
(1127, 3811, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-1024x754.jpg', '', 'No savings', 149959, 149959, '', NULL, 0, 1, '2017-05-19 11:20:55', NULL),
(1128, 3811, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-769x431.jpg', '', 'No savings', 88350, 88350, '', NULL, 0, 1, '2017-05-19 11:20:55', NULL),
(1129, 3811, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-418x315.jpg', '', 'No savings', 27692, 27692, '', NULL, 0, 1, '2017-05-19 11:20:55', NULL),
(1130, 3811, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-150x150.jpg', '', 'No savings', 6209, 6209, '', NULL, 0, 1, '2017-05-19 11:20:56', NULL),
(1131, 3811, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-158x88.jpg', '', 'No savings', 3769, 3769, '', NULL, 0, 1, '2017-05-19 11:20:56', NULL),
(1132, 3811, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-400x400.jpg', '', 'No savings', 43560, 43560, '', NULL, 0, 1, '2017-05-19 11:20:56', NULL),
(1133, 3811, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-650x490.jpg', '', 'No savings', 67947, 67947, '', NULL, 0, 1, '2017-05-19 11:20:56', NULL),
(1134, 3811, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-418x308.jpg', '', 'No savings', 26540, 26540, '', NULL, 0, 1, '2017-05-19 11:20:56', NULL),
(1135, 3811, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-886x668.jpg', '', 'No savings', 118332, 118332, '', NULL, 0, 1, '2017-05-19 11:20:56', NULL),
(1136, 3811, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-886x315.jpg', '', 'No savings', 85552, 85552, '', NULL, 0, 1, '2017-05-19 11:20:56', NULL),
(1137, 3811, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-1920x1080.jpg', '', 'No savings', 443375, 443375, '', NULL, 0, 1, '2017-05-19 11:20:57', NULL),
(1138, 3811, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-1920x820.jpg', '', 'No savings', 381012, 381012, '', NULL, 0, 1, '2017-05-19 11:20:57', NULL),
(1139, 3811, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-512x512.jpg', '', 'No savings', 72227, 72227, '', NULL, 0, 1, '2017-05-19 11:20:57', NULL),
(1140, 3811, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-141x188.jpg', '', 'No savings', 8323, 8323, '', NULL, 0, 1, '2017-05-19 11:20:57', NULL),
(1141, 3811, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-418x560.jpg', '', 'No savings', 76525, 76525, '', NULL, 0, 1, '2017-05-19 11:20:57', NULL),
(1142, 3811, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-301x226.jpg', '', 'No savings', 14033, 14033, '', NULL, 0, 1, '2017-05-19 11:20:57', NULL),
(1143, 3811, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-480x362.jpg', '', 'No savings', 36608, 36608, '', NULL, 0, 1, '2017-05-19 11:20:58', NULL),
(1144, 3811, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_328648772-1355x1020.jpg', '', 'No savings', 262395, 262395, '', NULL, 0, 1, '2017-05-19 11:20:58', NULL),
(1145, 3810, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174.jpg', '', 'No savings', 1092993, 1092993, '', NULL, 0, 1, '2017-05-19 11:20:59', NULL),
(1146, 3810, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-295x222.jpg', '', 'No savings', 13001, 13001, '', NULL, 0, 1, '2017-05-19 11:20:59', NULL),
(1147, 3810, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-300x294.jpg', '', 'No savings', 16170, 16170, '', NULL, 0, 1, '2017-05-19 11:20:59', NULL),
(1148, 3810, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-768x754.jpg', '', 'No savings', 90596, 90596, '', NULL, 0, 1, '2017-05-19 11:20:59', NULL),
(1149, 3810, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-1024x1005.jpg', '', 'No savings', 152592, 152592, '', NULL, 0, 1, '2017-05-19 11:20:59', NULL),
(1150, 3810, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-769x431.jpg', '', 'No savings', 62258, 62258, '', NULL, 0, 1, '2017-05-19 11:20:59', NULL),
(1151, 3810, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-418x315.jpg', '', 'No savings', 24645, 24645, '', NULL, 0, 1, '2017-05-19 11:20:59', NULL),
(1152, 3810, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-150x150.jpg', '', 'No savings', 5085, 5085, '', NULL, 0, 1, '2017-05-19 11:20:59', NULL),
(1153, 3810, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-158x88.jpg', '', 'No savings', 3714, 3714, '', NULL, 0, 1, '2017-05-19 11:21:00', NULL),
(1154, 3810, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-400x400.jpg', '', 'No savings', 27231, 27231, '', NULL, 0, 1, '2017-05-19 11:21:00', NULL),
(1155, 3810, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-650x490.jpg', '', 'No savings', 56032, 56032, '', NULL, 0, 1, '2017-05-19 11:21:00', NULL),
(1156, 3810, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-418x410.jpg', '', 'No savings', 29489, 29489, '', NULL, 0, 1, '2017-05-19 11:21:00', NULL),
(1157, 3810, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-886x668.jpg', '', 'No savings', 101064, 101064, '', NULL, 0, 1, '2017-05-19 11:21:00', NULL),
(1158, 3810, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-886x315.jpg', '', 'No savings', 57055, 57055, '', NULL, 0, 1, '2017-05-19 11:21:00', NULL),
(1159, 3810, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-1920x1080.jpg', '', 'No savings', 331368, 331368, '', NULL, 0, 1, '2017-05-19 11:21:00', NULL),
(1160, 3810, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-1920x820.jpg', '', 'No savings', 270335, 270335, '', NULL, 0, 1, '2017-05-19 11:21:01', NULL),
(1161, 3810, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-512x512.jpg', '', 'No savings', 42944, 42944, '', NULL, 0, 1, '2017-05-19 11:21:01', NULL),
(1162, 3810, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-141x188.jpg', '', 'No savings', 5892, 5892, '', NULL, 0, 1, '2017-05-19 11:21:01', NULL),
(1163, 3810, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-418x560.jpg', '', 'No savings', 41492, 41492, '', NULL, 0, 1, '2017-05-19 11:21:01', NULL),
(1164, 3810, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-301x226.jpg', '', 'No savings', 13710, 13710, '', NULL, 0, 1, '2017-05-19 11:21:01', NULL),
(1165, 3810, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-480x362.jpg', '', 'No savings', 31653, 31653, '', NULL, 0, 1, '2017-05-19 11:21:01', NULL),
(1166, 3810, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_221359174-1355x1020.jpg', '', 'No savings', 218573, 218573, '', NULL, 0, 1, '2017-05-19 11:21:02', NULL),
(1167, 3809, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621.jpg', '', 'No savings', 870581, 870581, '', NULL, 0, 1, '2017-05-19 11:21:02', NULL),
(1168, 3809, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-295x222.jpg', '', 'No savings', 16003, 16003, '', NULL, 0, 1, '2017-05-19 11:21:02', NULL),
(1169, 3809, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-300x200.jpg', '', 'No savings', 15271, 15271, '', NULL, 0, 1, '2017-05-19 11:21:02', NULL),
(1170, 3809, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-768x512.jpg', '', 'No savings', 82651, 82651, '', NULL, 0, 1, '2017-05-19 11:21:03', NULL),
(1171, 3809, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-1024x682.jpg', '', 'No savings', 126352, 126352, '', NULL, 0, 1, '2017-05-19 11:21:03', NULL),
(1172, 3809, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-769x431.jpg', '', 'No savings', 82181, 82181, '', NULL, 0, 1, '2017-05-19 11:21:03', NULL),
(1173, 3809, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-418x315.jpg', '', 'No savings', 31016, 31016, '', NULL, 0, 1, '2017-05-19 11:21:03', NULL),
(1174, 3809, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-150x150.jpg', '', 'No savings', 5826, 5826, '', NULL, 0, 1, '2017-05-19 11:21:03', NULL),
(1175, 3809, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-158x88.jpg', '', 'No savings', 4329, 4329, '', NULL, 0, 1, '2017-05-19 11:21:03', NULL),
(1176, 3809, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-400x400.jpg', '', 'No savings', 35199, 35199, '', NULL, 0, 1, '2017-05-19 11:21:03', NULL),
(1177, 3809, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-650x490.jpg', '', 'No savings', 67290, 67290, '', NULL, 0, 1, '2017-05-19 11:21:04', NULL),
(1178, 3809, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-418x279.jpg', '', 'No savings', 28590, 28590, '', NULL, 0, 1, '2017-05-19 11:21:04', NULL),
(1179, 3809, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-886x668.jpg', '', 'No savings', 106739, 106739, '', NULL, 0, 1, '2017-05-19 11:21:04', NULL),
(1180, 3809, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-886x315.jpg', '', 'No savings', 91170, 91170, '', NULL, 0, 1, '2017-05-19 11:21:04', NULL),
(1181, 3809, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-1920x1080.jpg', '', 'No savings', 304133, 304133, '', NULL, 0, 1, '2017-05-19 11:21:04', NULL),
(1182, 3809, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-1920x820.jpg', '', 'No savings', 292329, 292329, '', NULL, 0, 1, '2017-05-19 11:21:04', NULL),
(1183, 3809, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-512x512.jpg', '', 'No savings', 53758, 53758, '', NULL, 0, 1, '2017-05-19 11:21:05', NULL),
(1184, 3809, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-141x188.jpg', '', 'No savings', 7007, 7007, '', NULL, 0, 1, '2017-05-19 11:21:05', NULL),
(1185, 3809, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-418x560.jpg', '', 'No savings', 49088, 49088, '', NULL, 0, 1, '2017-05-19 11:21:05', NULL),
(1186, 3809, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-301x226.jpg', '', 'No savings', 16950, 16950, '', NULL, 0, 1, '2017-05-19 11:21:05', NULL),
(1187, 3809, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-480x362.jpg', '', 'No savings', 39823, 39823, '', NULL, 0, 1, '2017-05-19 11:21:05', NULL),
(1188, 3809, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_554230621-1355x1020.jpg', '', 'No savings', 200414, 200414, '', NULL, 0, 1, '2017-05-19 11:21:08', NULL),
(1189, 3808, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402.jpg', '', 'No savings', 840957, 840957, '', NULL, 0, 1, '2017-05-19 11:21:08', NULL),
(1190, 3808, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-295x222.jpg', '', 'No savings', 13431, 13431, '', NULL, 0, 1, '2017-05-19 11:21:08', NULL),
(1191, 3808, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-300x233.jpg', '', 'No savings', 13973, 13973, '', NULL, 0, 1, '2017-05-19 11:21:08', NULL),
(1192, 3808, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-768x598.jpg', '', 'No savings', 75231, 75231, '', NULL, 0, 1, '2017-05-19 11:21:09', NULL),
(1193, 3808, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-1024x797.jpg', '', 'No savings', 113152, 113152, '', NULL, 0, 1, '2017-05-19 11:21:09', NULL),
(1194, 3808, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-769x431.jpg', '', 'No savings', 67875, 67875, '', NULL, 0, 1, '2017-05-19 11:21:09', NULL),
(1195, 3808, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-418x315.jpg', '', 'No savings', 25647, 25647, '', NULL, 0, 1, '2017-05-19 11:21:09', NULL),
(1196, 3808, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-150x150.jpg', '', 'No savings', 5748, 5748, '', NULL, 0, 1, '2017-05-19 11:21:09', NULL),
(1197, 3808, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-158x88.jpg', '', 'No savings', 3651, 3651, '', NULL, 0, 1, '2017-05-19 11:21:09', NULL),
(1198, 3808, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-400x400.jpg', '', 'No savings', 35737, 35737, '', NULL, 0, 1, '2017-05-19 11:21:09', NULL),
(1199, 3808, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-650x490.jpg', '', 'No savings', 56308, 56308, '', NULL, 0, 1, '2017-05-19 11:21:09', NULL),
(1200, 3808, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-418x325.jpg', '', 'No savings', 25867, 25867, '', NULL, 0, 1, '2017-05-19 11:21:10', NULL),
(1201, 3808, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-886x668.jpg', '', 'No savings', 94660, 94660, '', NULL, 0, 1, '2017-05-19 11:21:10', NULL),
(1202, 3808, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-886x315.jpg', '', 'No savings', 58372, 58372, '', NULL, 0, 1, '2017-05-19 11:21:10', NULL),
(1203, 3808, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-1920x1080.jpg', '', 'No savings', 249427, 249427, '', NULL, 0, 1, '2017-05-19 11:21:10', NULL),
(1204, 3808, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-1920x820.jpg', '', 'No savings', 200837, 200837, '', NULL, 0, 1, '2017-05-19 11:21:10', NULL),
(1205, 3808, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-512x512.jpg', '', 'No savings', 55380, 55380, '', NULL, 0, 1, '2017-05-19 11:21:10', NULL),
(1206, 3808, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-141x188.jpg', '', 'No savings', 7408, 7408, '', NULL, 0, 1, '2017-05-19 11:21:11', NULL),
(1207, 3808, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-418x560.jpg', '', 'No savings', 54184, 54184, '', NULL, 0, 1, '2017-05-19 11:21:11', NULL),
(1208, 3808, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-301x226.jpg', '', 'No savings', 13888, 13888, '', NULL, 0, 1, '2017-05-19 11:21:11', NULL),
(1209, 3808, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-480x362.jpg', '', 'No savings', 33011, 33011, '', NULL, 0, 1, '2017-05-19 11:21:11', NULL),
(1210, 3808, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_557818402-1355x1020.jpg', '', 'No savings', 169803, 169803, '', NULL, 0, 1, '2017-05-19 11:21:11', NULL),
(1211, 3807, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700.jpg', '', 'No savings', 1234368, 1234368, '', NULL, 0, 1, '2017-05-19 11:21:12', NULL),
(1212, 3807, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-295x222.jpg', '', 'No savings', 14885, 14885, '', NULL, 0, 1, '2017-05-19 11:21:12', NULL),
(1213, 3807, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-300x300.jpg', '', 'No savings', 15891, 15891, '', NULL, 0, 1, '2017-05-19 11:21:12', NULL),
(1214, 3807, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-768x768.jpg', '', 'No savings', 92509, 92509, '', NULL, 0, 1, '2017-05-19 11:21:12', NULL),
(1215, 3807, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-1024x1024.jpg', '', 'No savings', 152534, 152534, '', NULL, 0, 1, '2017-05-19 11:21:13', NULL),
(1216, 3807, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-769x431.jpg', '', 'No savings', 98292, 98292, '', NULL, 0, 1, '2017-05-19 11:21:13', NULL),
(1217, 3807, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-418x315.jpg', '', 'No savings', 30818, 30818, '', NULL, 0, 1, '2017-05-19 11:21:13', NULL),
(1218, 3807, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-150x150.jpg', '', 'No savings', 3928, 3928, '', NULL, 0, 1, '2017-05-19 11:21:13', NULL),
(1219, 3807, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-158x88.jpg', '', 'No savings', 4191, 4191, '', NULL, 0, 1, '2017-05-19 11:21:13', NULL),
(1220, 3807, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-400x400.jpg', '', 'No savings', 28281, 28281, '', NULL, 0, 1, '2017-05-19 11:21:13', NULL),
(1221, 3807, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-650x490.jpg', '', 'No savings', 73665, 73665, '', NULL, 0, 1, '2017-05-19 11:21:13', NULL),
(1222, 3807, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-418x418.jpg', '', 'No savings', 31665, 31665, '', NULL, 0, 1, '2017-05-19 11:21:13', NULL),
(1223, 3807, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-886x668.jpg', '', 'No savings', 117219, 117219, '', NULL, 0, 1, '2017-05-19 11:21:14', NULL),
(1224, 3807, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-886x315.jpg', '', 'No savings', 107814, 107814, '', NULL, 0, 1, '2017-05-19 11:21:14', NULL),
(1225, 3807, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-1920x1080.jpg', '', 'No savings', 376095, 376095, '', NULL, 0, 1, '2017-05-19 11:21:14', NULL),
(1226, 3807, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-1920x820.jpg', '', 'No savings', 372587, 372587, '', NULL, 0, 1, '2017-05-19 11:21:14', NULL),
(1227, 3807, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-512x512.jpg', '', 'No savings', 46580, 46580, '', NULL, 0, 1, '2017-05-19 11:21:14', NULL),
(1228, 3807, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-141x188.jpg', '', 'No savings', 4853, 4853, '', NULL, 0, 1, '2017-05-19 11:21:15', NULL),
(1229, 3807, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-418x560.jpg', '', 'No savings', 44605, 44605, '', NULL, 0, 1, '2017-05-19 11:21:15', NULL),
(1230, 3807, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-301x226.jpg', '', 'No savings', 15678, 15678, '', NULL, 0, 1, '2017-05-19 11:21:15', NULL),
(1231, 3807, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-480x362.jpg', '', 'No savings', 40298, 40298, '', NULL, 0, 1, '2017-05-19 11:21:15', NULL),
(1232, 3807, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\shutterstock_436473700-1355x1020.jpg', '', 'No savings', 231592, 231592, '', NULL, 0, 1, '2017-05-19 11:21:15', NULL),
(1233, 3732, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4.jpg', '', 'No savings', 129296, 129296, '', NULL, 0, 1, '2017-05-19 11:21:16', NULL),
(1234, 3732, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-295x222.jpg', '', 'Reduced by 17.5% (824 B)', 3882, 4706, '', NULL, 0, 1, '2017-05-19 11:21:16', NULL),
(1235, 3732, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-300x154.jpg', '', 'Reduced by 19.4% (693 B)', 2870, 3563, '', NULL, 0, 1, '2017-05-19 11:21:16', NULL),
(1236, 3732, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-768x394.jpg', '', 'Reduced by 15.6% (2.5 KB)', 14047, 16639, '', NULL, 0, 1, '2017-05-19 11:21:16', NULL),
(1237, 3732, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-1024x526.jpg', '', 'Reduced by 15.4% (4.2 KB)', 23590, 27877, '', NULL, 0, 1, '2017-05-19 11:21:16', NULL),
(1238, 3732, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-769x431.jpg', '', 'Reduced by 15.6% (2.8 KB)', 15306, 18143, '', NULL, 0, 1, '2017-05-19 11:21:16', NULL),
(1239, 3732, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-418x315.jpg', '', 'Reduced by 15.4% (1.3 KB)', 7248, 8565, '', NULL, 0, 1, '2017-05-19 11:21:16', NULL),
(1240, 3732, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-150x150.jpg', '', 'Reduced by 22.9% (530 B)', 1780, 2310, '', NULL, 0, 1, '2017-05-19 11:21:16', NULL),
(1241, 3732, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-158x88.jpg', '', 'Reduced by 27.3% (460 B)', 1222, 1682, '', NULL, 0, 1, '2017-05-19 11:21:17', NULL),
(1242, 3732, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-400x400.jpg', '', 'Reduced by 14.4% (1.5 KB)', 8832, 10317, '', NULL, 0, 1, '2017-05-19 11:21:17', NULL),
(1243, 3732, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-650x490.jpg', '', 'Reduced by 14.6% (2.7 KB)', 15913, 18634, '', NULL, 0, 1, '2017-05-19 11:21:17', NULL),
(1244, 3732, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-418x215.jpg', '', 'Reduced by 17.6% (1.0 KB)', 4855, 5890, '', NULL, 0, 1, '2017-05-19 11:21:17', NULL),
(1245, 3732, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-886x668.jpg', '', 'Reduced by 14.1% (4.5 KB)', 28188, 32821, '', NULL, 0, 1, '2017-05-19 11:21:17', NULL),
(1246, 3732, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-886x315.jpg', '', 'Reduced by 15.8% (2.4 KB)', 13211, 15681, '', NULL, 0, 1, '2017-05-19 11:21:17', NULL),
(1247, 3732, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-1920x986.jpg', '', 'Reduced by 13.8% (15.1 KB)', 96477, 111895, '', NULL, 0, 1, '2017-05-19 11:21:17', NULL),
(1248, 3732, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-1920x820.jpg', '', 'Reduced by 14.6% (12.2 KB)', 72758, 85237, '', NULL, 0, 1, '2017-05-19 11:21:18', NULL),
(1249, 3732, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-512x512.jpg', '', 'Reduced by 13.4% (2.1 KB)', 14051, 16231, '', NULL, 0, 1, '2017-05-19 11:21:18', NULL),
(1250, 3732, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-141x188.jpg', '', 'Reduced by 20.6% (537 B)', 2065, 2602, '', NULL, 0, 1, '2017-05-19 11:21:18', NULL),
(1251, 3732, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-418x560.jpg', '', 'Reduced by 13.1% (2.0 KB)', 13469, 15495, '', NULL, 0, 1, '2017-05-19 11:21:18', NULL),
(1252, 3732, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-301x226.jpg', '', 'Reduced by 17.1% (849 B)', 4103, 4952, '', NULL, 0, 1, '2017-05-19 11:21:18', NULL),
(1253, 3732, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-480x362.jpg', '', 'Reduced by 15.2% (1.6 KB)', 9075, 10697, '', NULL, 0, 1, '2017-05-19 11:21:18', NULL),
(1254, 3732, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-4-1355x986.jpg', '', 'Reduced by 13.2% (10.0 KB)', 67467, 77744, '', NULL, 0, 1, '2017-05-19 11:21:18', NULL),
(1255, 3712, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3.jpg', '', 'No savings', 113090, 113090, '', NULL, 0, 1, '2017-05-19 11:21:19', NULL),
(1256, 3712, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-295x222.jpg', '', 'Reduced by 9.2% (622 B)', 6143, 6765, '', NULL, 0, 1, '2017-05-19 11:21:19', NULL),
(1257, 3712, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-300x187.jpg', '', 'Reduced by 9.7% (597 B)', 5572, 6169, '', NULL, 0, 1, '2017-05-19 11:21:19', NULL),
(1258, 3712, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-768x479.jpg', '', 'Reduced by 9.0% (2.1 KB)', 21874, 24040, '', NULL, 0, 1, '2017-05-19 11:21:19', NULL),
(1259, 3712, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-1024x639.jpg', '', 'Reduced by 10.5% (3.7 KB)', 32452, 36258, '', NULL, 0, 1, '2017-05-19 11:21:19', NULL),
(1260, 3712, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-769x431.jpg', '', 'Reduced by 8.6% (1.9 KB)', 20772, 22737, '', NULL, 0, 1, '2017-05-19 11:21:19', NULL),
(1261, 3712, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-418x315.jpg', '', 'Reduced by 8.5% (954 B)', 10297, 11251, '', NULL, 0, 1, '2017-05-19 11:21:20', NULL),
(1262, 3712, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-150x150.jpg', '', 'Reduced by 14.1% (450 B)', 2746, 3196, '', NULL, 0, 1, '2017-05-19 11:21:20', NULL),
(1263, 3712, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-158x88.jpg', '', 'Reduced by 16.8% (409 B)', 2026, 2435, '', NULL, 0, 1, '2017-05-19 11:21:20', NULL),
(1264, 3712, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-400x400.jpg', '', 'Reduced by 9.0% (1.1 KB)', 11013, 12101, '', NULL, 0, 1, '2017-05-19 11:21:20', NULL),
(1265, 3712, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-650x490.jpg', '', 'Reduced by 9.9% (2.0 KB)', 18775, 20832, '', NULL, 0, 1, '2017-05-19 11:21:20', NULL),
(1266, 3712, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-418x261.jpg', '', 'Reduced by 8.1% (808 B)', 9152, 9960, '', NULL, 0, 1, '2017-05-19 11:21:20', NULL),
(1267, 3712, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-886x668.jpg', '', 'Reduced by 11.1% (3.6 KB)', 29384, 33036, '', NULL, 0, 1, '2017-05-19 11:21:20', NULL),
(1268, 3712, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-886x315.jpg', '', 'Reduced by 8.7% (1.7 KB)', 18328, 20069, '', NULL, 0, 1, '2017-05-19 11:21:20', NULL),
(1269, 3712, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-1920x1080.jpg', '', 'Reduced by 14.1% (12.3 KB)', 76778, 89334, '', NULL, 0, 1, '2017-05-19 11:21:21', NULL),
(1270, 3712, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-1920x820.jpg', '', 'Reduced by 12.4% (9.0 KB)', 65031, 74268, '', NULL, 0, 1, '2017-05-19 11:21:21', NULL),
(1271, 3712, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-512x512.jpg', '', 'Reduced by 9.7% (1.6 KB)', 15416, 17068, '', NULL, 0, 1, '2017-05-19 11:21:21', NULL),
(1272, 3712, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-141x188.jpg', '', 'Reduced by 13.9% (465 B)', 2887, 3352, '', NULL, 0, 1, '2017-05-19 11:21:21', NULL),
(1273, 3712, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-418x560.jpg', '', 'Reduced by 10.7% (1.6 KB)', 13326, 14926, '', NULL, 0, 1, '2017-05-19 11:21:21', NULL),
(1274, 3712, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-301x226.jpg', '', 'Reduced by 9.4% (649 B)', 6253, 6902, '', NULL, 0, 1, '2017-05-19 11:21:21', NULL),
(1275, 3712, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-480x362.jpg', '', 'Reduced by 8.6% (1.1 KB)', 12357, 13515, '', NULL, 0, 1, '2017-05-19 11:21:24', NULL),
(1276, 3712, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-3-1355x1020.jpg', '', 'Reduced by 13.4% (8.1 KB)', 53805, 62137, '', NULL, 0, 1, '2017-05-19 11:21:24', NULL),
(1277, 3707, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2.jpg', '', 'Reduced by 2.0% (838 B)', 41530, 42368, '', NULL, 0, 1, '2017-05-19 11:21:24', NULL),
(1278, 3707, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-295x222.jpg', '', 'Reduced by 51.8% (1,023 B)', 950, 1973, '', NULL, 0, 1, '2017-05-19 11:21:24', NULL),
(1279, 3707, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-300x120.jpg', '', 'Reduced by 31.3% (673 B)', 1476, 2149, '', NULL, 0, 1, '2017-05-19 11:21:24', NULL),
(1280, 3707, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-768x307.jpg', '', 'Reduced by 26.1% (2.1 KB)', 6142, 8308, '', NULL, 0, 1, '2017-05-19 11:21:24', NULL),
(1281, 3707, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-1024x410.jpg', '', 'Reduced by 27.5% (3.5 KB)', 9453, 13041, '', NULL, 0, 1, '2017-05-19 11:21:25', NULL),
(1282, 3707, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-769x431.jpg', '', 'Reduced by 46.3% (3.4 KB)', 3995, 7437, '', NULL, 0, 1, '2017-05-19 11:21:25', NULL),
(1283, 3707, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-418x315.jpg', '', 'Reduced by 52.6% (1.6 KB)', 1509, 3182, '', NULL, 0, 1, '2017-05-19 11:21:25', NULL),
(1284, 3707, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-150x150.jpg', '', 'Reduced by 56.4% (641 B)', 496, 1137, '', NULL, 0, 1, '2017-05-19 11:21:25', NULL),
(1285, 3707, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-158x88.jpg', '', 'Reduced by 48.9% (530 B)', 554, 1084, '', NULL, 0, 1, '2017-05-19 11:21:25', NULL),
(1286, 3707, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-400x400.jpg', '', 'Reduced by 55.3% (1.9 KB)', 1550, 3471, '', NULL, 0, 1, '2017-05-19 11:21:25', NULL),
(1287, 3707, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-650x490.jpg', '', 'Reduced by 54.2% (3.4 KB)', 2918, 6374, '', NULL, 0, 1, '2017-05-19 11:21:25', NULL),
(1288, 3707, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-418x167.jpg', '', 'Reduced by 27.3% (916 B)', 2445, 3361, '', NULL, 0, 1, '2017-05-19 11:21:25', NULL),
(1289, 3707, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-886x668.jpg', '', 'Reduced by 56.3% (6.0 KB)', 4749, 10876, '', NULL, 0, 1, '2017-05-19 11:21:26', NULL),
(1290, 3707, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-886x315.jpg', '', 'Reduced by 26.3% (2.4 KB)', 6882, 9340, '', NULL, 0, 1, '2017-05-19 11:21:26', NULL),
(1291, 3707, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-1920x768.jpg', '', 'Reduced by 33.2% (12.3 KB)', 25327, 37894, '', NULL, 0, 1, '2017-05-19 11:21:26', NULL),
(1292, 3707, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-512x512.jpg', '', 'Reduced by 58.2% (2.8 KB)', 2085, 4989, '', NULL, 0, 1, '2017-05-19 11:21:26', NULL),
(1293, 3707, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-141x188.jpg', '', 'Reduced by 59.0% (670 B)', 465, 1135, '', NULL, 0, 1, '2017-05-19 11:21:26', NULL),
(1294, 3707, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-418x560.jpg', '', 'Reduced by 61.1% (2.7 KB)', 1760, 4528, '', NULL, 0, 1, '2017-05-19 11:21:26', NULL),
(1295, 3707, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-301x226.jpg', '', 'Reduced by 52.3% (1.0 KB)', 967, 2029, '', NULL, 0, 1, '2017-05-19 11:21:26', NULL),
(1296, 3707, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-480x362.jpg', '', 'Reduced by 53.3% (2.0 KB)', 1786, 3822, '', NULL, 0, 1, '2017-05-19 11:21:27', NULL),
(1297, 3707, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\home-bg-2-1355x768.jpg', '', 'Reduced by 49.7% (9.8 KB)', 10172, 20220, '', NULL, 0, 1, '2017-05-19 11:21:27', NULL),
(1298, 3679, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3.jpg', '', 'Reduced by 4.8% (20.4 KB)', 418089, 438956, '', NULL, 0, 1, '2017-05-19 11:21:27', NULL),
(1299, 3679, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-295x222.jpg', '', 'Reduced by 4.4% (520 B)', 11192, 11712, '', NULL, 0, 1, '2017-05-19 11:21:27', NULL),
(1300, 3679, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-300x169.jpg', '', 'Reduced by 5.3% (491 B)', 8779, 9270, '', NULL, 0, 1, '2017-05-19 11:21:27', NULL),
(1301, 3679, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-768x432.jpg', '', 'Reduced by 2.2% (1.1 KB)', 50948, 52119, '', NULL, 0, 1, '2017-05-19 11:21:28', NULL),
(1302, 3679, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-1024x576.jpg', '', 'Reduced by 1.9% (1.7 KB)', 86834, 88545, '', NULL, 0, 1, '2017-05-19 11:21:28', NULL),
(1303, 3679, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-769x431.jpg', '', 'Reduced by 2.2% (1.1 KB)', 50814, 51981, '', NULL, 0, 1, '2017-05-19 11:21:28', NULL),
(1304, 3679, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-418x315.jpg', '', 'Reduced by 3.0% (666 B)', 21729, 22395, '', NULL, 0, 1, '2017-05-19 11:21:28', NULL),
(1305, 3679, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-150x150.jpg', '', 'Reduced by 9.1% (416 B)', 4132, 4548, '', NULL, 0, 1, '2017-05-19 11:21:28', NULL),
(1306, 3679, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-158x88.jpg', '', 'Reduced by 11.8% (390 B)', 2914, 3304, '', NULL, 0, 1, '2017-05-19 11:21:28', NULL),
(1307, 3679, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-400x400.jpg', '', 'Reduced by 2.9% (714 B)', 23596, 24310, '', NULL, 0, 1, '2017-05-19 11:21:28', NULL),
(1308, 3679, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-650x490.jpg', '', 'Reduced by 2.2% (1.1 KB)', 49610, 50750, '', NULL, 0, 1, '2017-05-19 11:21:28', NULL),
(1309, 3679, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-418x235.jpg', '', 'Reduced by 3.4% (577 B)', 16187, 16764, '', NULL, 0, 1, '2017-05-19 11:21:29', NULL),
(1310, 3679, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-886x668.jpg', '', 'Reduced by 1.8% (1.6 KB)', 87950, 89567, '', NULL, 0, 1, '2017-05-19 11:21:29', NULL),
(1311, 3679, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-886x315.jpg', '', 'Reduced by 2.5% (973 B)', 38700, 39673, '', NULL, 0, 1, '2017-05-19 11:21:29', NULL);
INSERT INTO `wp_ewwwio_images` (`id`, `attachment_id`, `gallery`, `resize`, `path`, `converted`, `results`, `image_size`, `orig_size`, `backup`, `level`, `pending`, `updates`, `updated`, `trace`) VALUES
(1312, 3679, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-1920x820.jpg', '', 'Reduced by 6.2% (13.6 KB)', 212569, 226504, '', NULL, 0, 1, '2017-05-19 11:21:29', NULL),
(1313, 3679, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-512x512.jpg', '', 'Reduced by 2.5% (951 B)', 37455, 38406, '', NULL, 0, 1, '2017-05-19 11:21:29', NULL),
(1314, 3679, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-141x188.jpg', '', 'Reduced by 8.5% (429 B)', 4607, 5036, '', NULL, 0, 1, '2017-05-19 11:21:29', NULL),
(1315, 3679, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-418x560.jpg', '', 'Reduced by 2.6% (867 B)', 31951, 32818, '', NULL, 0, 1, '2017-05-19 11:21:30', NULL),
(1316, 3679, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-301x226.jpg', '', 'Reduced by 4.3% (525 B)', 11802, 12327, '', NULL, 0, 1, '2017-05-19 11:21:30', NULL),
(1317, 3679, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-480x362.jpg', '', 'Reduced by 2.6% (758 B)', 27905, 28663, '', NULL, 0, 1, '2017-05-19 11:21:30', NULL),
(1318, 3679, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-3-1355x1020.jpg', '', 'Reduced by 6.0% (11.1 KB)', 177575, 188903, '', NULL, 0, 1, '2017-05-19 11:21:30', NULL),
(1319, 3678, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2.jpg', '', 'Reduced by 4.5% (19.8 KB)', 429527, 449813, '', NULL, 0, 1, '2017-05-19 11:21:30', NULL),
(1320, 3678, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-295x222.jpg', '', 'Reduced by 4.1% (427 B)', 10056, 10483, '', NULL, 0, 1, '2017-05-19 11:21:31', NULL),
(1321, 3678, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-300x169.jpg', '', 'Reduced by 5.1% (417 B)', 7839, 8256, '', NULL, 0, 1, '2017-05-19 11:21:31', NULL),
(1322, 3678, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-768x432.jpg', '', 'Reduced by 1.5% (760 B)', 48755, 49515, '', NULL, 0, 1, '2017-05-19 11:21:31', NULL),
(1323, 3678, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-1024x576.jpg', '', 'Reduced by 1.2% (991 B)', 82875, 83866, '', NULL, 0, 1, '2017-05-19 11:21:31', NULL),
(1324, 3678, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-769x431.jpg', '', 'Reduced by 1.6% (817 B)', 48722, 49539, '', NULL, 0, 1, '2017-05-19 11:21:31', NULL),
(1325, 3678, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-418x315.jpg', '', 'Reduced by 2.6% (544 B)', 20090, 20634, '', NULL, 0, 1, '2017-05-19 11:21:31', NULL),
(1326, 3678, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-150x150.jpg', '', 'Reduced by 9.4% (387 B)', 3745, 4132, '', NULL, 0, 1, '2017-05-19 11:21:31', NULL),
(1327, 3678, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-158x88.jpg', '', 'Reduced by 12.6% (363 B)', 2510, 2873, '', NULL, 0, 1, '2017-05-19 11:21:32', NULL),
(1328, 3678, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-400x400.jpg', '', 'Reduced by 2.3% (558 B)', 24071, 24629, '', NULL, 0, 1, '2017-05-19 11:21:32', NULL),
(1329, 3678, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-650x490.jpg', '', 'Reduced by 1.5% (724 B)', 47029, 47753, '', NULL, 0, 1, '2017-05-19 11:21:32', NULL),
(1330, 3678, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-418x235.jpg', '', 'Reduced by 3.4% (523 B)', 14875, 15398, '', NULL, 0, 1, '2017-05-19 11:21:32', NULL),
(1331, 3678, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-886x668.jpg', '', 'Reduced by 1.2% (1.0 KB)', 82875, 83918, '', NULL, 0, 1, '2017-05-19 11:21:32', NULL),
(1332, 3678, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-886x315.jpg', '', 'Reduced by 1.1% (630 B)', 54488, 55118, '', NULL, 0, 1, '2017-05-19 11:21:32', NULL),
(1333, 3678, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-1920x820.jpg', '', 'Reduced by 4.5% (11.1 KB)', 243148, 254504, '', NULL, 0, 1, '2017-05-19 11:21:33', NULL),
(1334, 3678, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-512x512.jpg', '', 'Reduced by 1.6% (631 B)', 38515, 39146, '', NULL, 0, 1, '2017-05-19 11:21:33', NULL),
(1335, 3678, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-141x188.jpg', '', 'Reduced by 8.5% (388 B)', 4198, 4586, '', NULL, 0, 1, '2017-05-19 11:21:33', NULL),
(1336, 3678, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-418x560.jpg', '', 'Reduced by 1.7% (600 B)', 33965, 34565, '', NULL, 0, 1, '2017-05-19 11:21:33', NULL),
(1337, 3678, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-301x226.jpg', '', 'Reduced by 4.0% (443 B)', 10520, 10963, '', NULL, 0, 1, '2017-05-19 11:21:33', NULL),
(1338, 3678, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-480x362.jpg', '', 'Reduced by 2.2% (581 B)', 26106, 26687, '', NULL, 0, 1, '2017-05-19 11:21:33', NULL),
(1339, 3678, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-2-1355x1020.jpg', '', 'Reduced by 5.0% (8.3 KB)', 162372, 170863, '', NULL, 0, 1, '2017-05-19 11:21:33', NULL),
(1340, 3677, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1.jpg', '', 'Reduced by 6.2% (36.2 KB)', 559090, 596119, '', NULL, 0, 1, '2017-05-19 11:21:34', NULL),
(1341, 3677, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-295x222.jpg', '', 'Reduced by 3.1% (425 B)', 13178, 13603, '', NULL, 0, 1, '2017-05-19 11:21:34', NULL),
(1342, 3677, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-300x169.jpg', '', 'Reduced by 3.1% (469 B)', 14620, 15089, '', NULL, 0, 1, '2017-05-19 11:21:34', NULL),
(1343, 3677, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-768x432.jpg', '', 'Reduced by 1.7% (1.2 KB)', 74744, 76000, '', NULL, 0, 1, '2017-05-19 11:21:34', NULL),
(1344, 3677, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-1024x576.jpg', '', 'Reduced by 8.7% (10.1 KB)', 109130, 119509, '', NULL, 0, 1, '2017-05-19 11:21:34', NULL),
(1345, 3677, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-769x431.jpg', '', 'Reduced by 1.5% (1.1 KB)', 75259, 76427, '', NULL, 0, 1, '2017-05-19 11:21:35', NULL),
(1346, 3677, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-418x315.jpg', '', 'Reduced by 2.1% (524 B)', 24732, 25256, '', NULL, 0, 1, '2017-05-19 11:21:35', NULL),
(1347, 3677, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-150x150.jpg', '', 'Reduced by 9.4% (396 B)', 3805, 4201, '', NULL, 0, 1, '2017-05-19 11:21:35', NULL),
(1348, 3677, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-158x88.jpg', '', 'Reduced by 7.8% (367 B)', 4352, 4719, '', NULL, 0, 1, '2017-05-19 11:21:35', NULL),
(1349, 3677, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-400x400.jpg', '', 'Reduced by 2.9% (633 B)', 21178, 21811, '', NULL, 0, 1, '2017-05-19 11:21:35', NULL),
(1350, 3677, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-650x490.jpg', '', 'Reduced by 1.9% (995 B)', 51595, 52590, '', NULL, 0, 1, '2017-05-19 11:21:35', NULL),
(1351, 3677, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-418x235.jpg', '', 'Reduced by 1.9% (529 B)', 26823, 27352, '', NULL, 0, 1, '2017-05-19 11:21:35', NULL),
(1352, 3677, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-886x668.jpg', '', 'Reduced by 2.1% (1.8 KB)', 84129, 85938, '', NULL, 0, 1, '2017-05-19 11:21:36', NULL),
(1353, 3677, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-886x315.jpg', '', 'Reduced by 1.8% (1.0 KB)', 57682, 58717, '', NULL, 0, 1, '2017-05-19 11:21:36', NULL),
(1354, 3677, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-1920x820.jpg', '', 'Reduced by 8.6% (21.6 KB)', 236495, 258615, '', NULL, 0, 1, '2017-05-19 11:21:36', NULL),
(1355, 3677, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-512x512.jpg', '', 'Reduced by 3.2% (1.0 KB)', 32110, 33157, '', NULL, 0, 1, '2017-05-19 11:21:36', NULL),
(1356, 3677, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-141x188.jpg', '', 'Reduced by 11.6% (425 B)', 3242, 3667, '', NULL, 0, 1, '2017-05-19 11:21:36', NULL),
(1357, 3677, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-418x560.jpg', '', 'Reduced by 5.0% (1.1 KB)', 21487, 22628, '', NULL, 0, 1, '2017-05-19 11:21:36', NULL),
(1358, 3677, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-301x226.jpg', '', 'Reduced by 3.1% (443 B)', 13833, 14276, '', NULL, 0, 1, '2017-05-19 11:21:36', NULL),
(1359, 3677, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-480x362.jpg', '', 'Reduced by 2.0% (619 B)', 30739, 31358, '', NULL, 0, 1, '2017-05-19 11:21:37', NULL),
(1360, 3677, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\slide-1-1355x1020.jpg', '', 'Reduced by 9.2% (14.7 KB)', 149076, 164119, '', NULL, 0, 1, '2017-05-19 11:21:37', NULL),
(1361, 3669, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1.jpg', '', 'Reduced by 1.5% (850 B)', 56010, 56860, '', NULL, 0, 1, '2017-05-19 11:21:37', NULL),
(1362, 3669, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-295x222.jpg', '', 'Reduced by 3.5% (404 B)', 11156, 11560, '', NULL, 0, 1, '2017-05-19 11:21:37', NULL),
(1363, 3669, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-300x168.jpg', '', 'Reduced by 4.4% (402 B)', 8715, 9117, '', NULL, 0, 1, '2017-05-19 11:21:37', NULL),
(1364, 3669, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-768x430.jpg', '', 'Reduced by 2.2% (759 B)', 34384, 35143, '', NULL, 0, 1, '2017-05-19 11:21:37', NULL),
(1365, 3669, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-418x315.jpg', '', 'Reduced by 2.3% (451 B)', 18991, 19442, '', NULL, 0, 1, '2017-05-19 11:21:38', NULL),
(1366, 3669, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-150x150.jpg', '', 'Reduced by 6.6% (388 B)', 5515, 5903, '', NULL, 0, 1, '2017-05-19 11:21:41', NULL),
(1367, 3669, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-158x88.jpg', '', 'Reduced by 9.9% (376 B)', 3429, 3805, '', NULL, 0, 1, '2017-05-19 11:21:41', NULL),
(1368, 3669, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-400x400.jpg', '', 'Reduced by 1.8% (430 B)', 24037, 24467, '', NULL, 0, 1, '2017-05-19 11:21:41', NULL),
(1369, 3669, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-650x431.jpg', '', 'Reduced by 1.7% (622 B)', 35671, 36293, '', NULL, 0, 1, '2017-05-19 11:21:41', NULL),
(1370, 3669, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-418x234.jpg', '', 'Reduced by 3.1% (456 B)', 14292, 14748, '', NULL, 0, 1, '2017-05-19 11:21:41', NULL),
(1371, 3669, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-769x315.jpg', '', 'Reduced by 1.9% (583 B)', 29926, 30509, '', NULL, 0, 1, '2017-05-19 11:21:42', NULL),
(1372, 3669, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-512x431.jpg', '', 'Reduced by 1.7% (559 B)', 32429, 32988, '', NULL, 0, 1, '2017-05-19 11:21:42', NULL),
(1373, 3669, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-141x188.jpg', '', 'Reduced by 5.8% (420 B)', 6804, 7224, '', NULL, 0, 1, '2017-05-19 11:21:42', NULL),
(1374, 3669, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-418x431.jpg', '', 'Reduced by 1.6% (498 B)', 30002, 30500, '', NULL, 0, 1, '2017-05-19 11:21:42', NULL),
(1375, 3669, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-301x226.jpg', '', 'Reduced by 3.2% (386 B)', 11589, 11975, '', NULL, 0, 1, '2017-05-19 11:21:42', NULL),
(1376, 3669, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-1-480x362.jpg', '', 'Reduced by 1.9% (442 B)', 23364, 23806, '', NULL, 0, 1, '2017-05-19 11:21:42', NULL),
(1377, 3668, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1.jpg', '', 'Reduced by 1.6% (826 B)', 50488, 51314, '', NULL, 0, 1, '2017-05-19 11:21:42', NULL),
(1378, 3668, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-295x222.jpg', '', 'Reduced by 30.8% (920 B)', 2066, 2986, '', NULL, 0, 1, '2017-05-19 11:21:43', NULL),
(1379, 3668, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-300x105.jpg', '', 'Reduced by 34.4% (682 B)', 1301, 1983, '', NULL, 0, 1, '2017-05-19 11:21:43', NULL),
(1380, 3668, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-768x269.jpg', '', 'Reduced by 22.9% (2.0 KB)', 6717, 8715, '', NULL, 0, 1, '2017-05-19 11:21:43', NULL),
(1381, 3668, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-1024x359.jpg', '', 'Reduced by 22.5% (3.1 KB)', 10882, 14045, '', NULL, 0, 1, '2017-05-19 11:21:43', NULL),
(1382, 3668, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-769x431.jpg', '', 'Reduced by 26.9% (2.9 KB)', 8164, 11175, '', NULL, 0, 1, '2017-05-19 11:21:43', NULL),
(1383, 3668, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-418x315.jpg', '', 'Reduced by 28.1% (1.4 KB)', 3766, 5239, '', NULL, 0, 1, '2017-05-19 11:21:43', NULL),
(1384, 3668, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-150x150.jpg', '', 'Reduced by 40.9% (613 B)', 884, 1497, '', NULL, 0, 1, '2017-05-19 11:21:43', NULL),
(1385, 3668, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-158x88.jpg', '', 'Reduced by 45.8% (529 B)', 625, 1154, '', NULL, 0, 1, '2017-05-19 11:21:44', NULL),
(1386, 3668, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-400x400.jpg', '', 'Reduced by 28.9% (1.6 KB)', 4031, 5667, '', NULL, 0, 1, '2017-05-19 11:21:44', NULL),
(1387, 3668, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-650x490.jpg', '', 'Reduced by 27.2% (2.8 KB)', 7752, 10645, '', NULL, 0, 1, '2017-05-19 11:21:44', NULL),
(1388, 3668, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-418x147.jpg', '', 'Reduced by 29.4% (956 B)', 2299, 3255, '', NULL, 0, 1, '2017-05-19 11:21:44', NULL),
(1389, 3668, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-886x668.jpg', '', 'Reduced by 28.9% (5.0 KB)', 12568, 17679, '', NULL, 0, 1, '2017-05-19 11:21:44', NULL),
(1390, 3668, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-886x315.jpg', '', 'Reduced by 22.6% (2.5 KB)', 8733, 11279, '', NULL, 0, 1, '2017-05-19 11:21:44', NULL),
(1391, 3668, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-1920x673.jpg', '', 'Reduced by 23.6% (9.9 KB)', 32952, 43137, '', NULL, 0, 1, '2017-05-19 11:21:44', NULL),
(1392, 3668, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-512x512.jpg', '', 'Reduced by 29.4% (2.4 KB)', 5921, 8385, '', NULL, 0, 1, '2017-05-19 11:21:45', NULL),
(1393, 3668, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-141x188.jpg', '', 'Reduced by 39.5% (630 B)', 965, 1595, '', NULL, 0, 1, '2017-05-19 11:21:45', NULL),
(1394, 3668, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-418x560.jpg', '', 'Reduced by 31.6% (2.3 KB)', 5123, 7486, '', NULL, 0, 1, '2017-05-19 11:21:45', NULL),
(1395, 3668, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-301x226.jpg', '', 'Reduced by 30.5% (971 B)', 2212, 3183, '', NULL, 0, 1, '2017-05-19 11:21:45', NULL),
(1396, 3668, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-480x362.jpg', '', 'Reduced by 26.4% (1.7 KB)', 4797, 6519, '', NULL, 0, 1, '2017-05-19 11:21:45', NULL),
(1397, 3668, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2016\\09\\home-bg-1-1355x673.jpg', '', 'Reduced by 28.2% (7.8 KB)', 20264, 28223, '', NULL, 0, 1, '2017-05-19 11:21:45', NULL),
(1398, 3579, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav.png', '', 'Reduced by 30.3% (3.8 KB)', 9020, 12944, '', NULL, 0, 1, '2017-05-19 11:21:46', NULL),
(1399, 3579, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-295x222.png', '', 'Reduced by 30.0% (13.2 KB)', 31506, 45026, '', NULL, 0, 1, '2017-05-19 11:21:48', NULL),
(1400, 3579, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-300x300.png', '', 'Reduced by 29.1% (12.3 KB)', 30838, 43484, '', NULL, 0, 1, '2017-05-19 11:21:50', NULL),
(1401, 3579, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-512x431.png', '', 'Reduced by 31.3% (3.9 KB)', 8728, 12703, '', NULL, 0, 1, '2017-05-19 11:21:51', NULL),
(1402, 3579, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-418x315.png', '', 'Reduced by 32.6% (26.0 KB)', 55050, 81711, '', NULL, 0, 1, '2017-05-19 11:21:54', NULL),
(1403, 3579, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-150x150.png', '', 'Reduced by 27.7% (3.6 KB)', 9628, 13317, '', NULL, 0, 1, '2017-05-19 11:21:55', NULL),
(1404, 3579, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-158x88.png', '', 'Reduced by 28.2% (3.0 KB)', 7846, 10922, '', NULL, 0, 1, '2017-05-19 11:22:00', NULL),
(1405, 3579, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-400x400.png', '', 'Reduced by 23.5% (9.1 KB)', 30274, 39549, '', NULL, 0, 1, '2017-05-19 11:22:01', NULL),
(1406, 3579, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-512x490.png', '', 'Reduced by 30.5% (3.8 KB)', 8955, 12879, '', NULL, 0, 1, '2017-05-19 11:22:02', NULL),
(1407, 3579, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-418x418.png', '', 'Reduced by 31.0% (26.8 KB)', 61196, 88629, '', NULL, 0, 1, '2017-05-19 11:22:06', NULL),
(1408, 3579, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-512x315.png', '', 'Reduced by 33.8% (3.1 KB)', 6235, 9414, '', NULL, 0, 1, '2017-05-19 11:22:07', NULL),
(1409, 3579, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-141x188.png', '', 'Reduced by 31.8% (5.2 KB)', 11395, 16705, '', NULL, 0, 1, '2017-05-19 11:22:08', NULL),
(1410, 3579, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-418x512.png', '', 'Reduced by 27.6% (2.7 KB)', 7151, 9881, '', NULL, 0, 1, '2017-05-19 11:22:08', NULL),
(1411, 3579, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-301x226.png', '', 'Reduced by 31.4% (13.9 KB)', 31022, 45248, '', NULL, 0, 1, '2017-05-19 11:22:11', NULL),
(1412, 3579, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\cropped-Fav-480x362.png', '', 'Reduced by 21.8% (8.1 KB)', 29696, 37975, '', NULL, 0, 1, '2017-05-19 11:22:12', NULL),
(1413, 3578, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav.png', '', 'Reduced by 68.1% (19.6 KB)', 9378, 29425, '', NULL, 0, 1, '2017-05-19 11:22:13', NULL),
(1414, 3578, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-295x222.png', '', 'Reduced by 30.0% (13.2 KB)', 31506, 45026, '', NULL, 0, 1, '2017-05-19 11:22:15', NULL),
(1415, 3578, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-300x300.png', '', 'Reduced by 29.1% (12.3 KB)', 30838, 43484, '', NULL, 0, 1, '2017-05-19 11:22:20', NULL),
(1416, 3578, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-512x431.png', '', 'Reduced by 31.3% (3.9 KB)', 8728, 12703, '', NULL, 0, 1, '2017-05-19 11:22:21', NULL),
(1417, 3578, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-418x315.png', '', 'Reduced by 32.6% (26.0 KB)', 55050, 81711, '', NULL, 0, 1, '2017-05-19 11:22:24', NULL),
(1418, 3578, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-150x150.png', '', 'Reduced by 27.7% (3.6 KB)', 9628, 13317, '', NULL, 0, 1, '2017-05-19 11:22:25', NULL),
(1419, 3578, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-158x88.png', '', 'Reduced by 28.2% (3.0 KB)', 7846, 10922, '', NULL, 0, 1, '2017-05-19 11:22:25', NULL),
(1420, 3578, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-400x400.png', '', 'Reduced by 23.5% (9.1 KB)', 30274, 39549, '', NULL, 0, 1, '2017-05-19 11:22:27', NULL),
(1421, 3578, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-512x490.png', '', 'Reduced by 30.5% (3.8 KB)', 8955, 12879, '', NULL, 0, 1, '2017-05-19 11:22:27', NULL),
(1422, 3578, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-418x418.png', '', 'Reduced by 31.0% (26.8 KB)', 61196, 88629, '', NULL, 0, 1, '2017-05-19 11:22:31', NULL),
(1423, 3578, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-512x315.png', '', 'Reduced by 33.8% (3.1 KB)', 6235, 9414, '', NULL, 0, 1, '2017-05-19 11:22:32', NULL),
(1424, 3578, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-141x188.png', '', 'Reduced by 31.8% (5.2 KB)', 11395, 16705, '', NULL, 0, 1, '2017-05-19 11:22:32', NULL),
(1425, 3578, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-418x512.png', '', 'Reduced by 27.6% (2.7 KB)', 7151, 9881, '', NULL, 0, 1, '2017-05-19 11:22:36', NULL),
(1426, 3578, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-301x226.png', '', 'Reduced by 31.4% (13.9 KB)', 31022, 45248, '', NULL, 0, 1, '2017-05-19 11:22:38', NULL),
(1427, 3578, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax\\wp-content\\uploads\\2017\\05\\Fav-480x362.png', '', 'Reduced by 21.8% (8.1 KB)', 29696, 37975, '', NULL, 0, 1, '2017-05-19 11:22:40', NULL),
(1428, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\default\\default-thumb.png', '', 'Reduced by 2.1% (1.2 KB)', 56880, 58088, '', NULL, 0, 1, '2017-05-19 11:22:40', NULL),
(1429, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-1\\skin-1-thumb.png', '', 'Reduced by 2.9% (4.1 KB)', 139511, 143744, '', NULL, 0, 1, '2017-05-19 11:22:41', NULL),
(1430, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-10\\skin-10-thumb.png', '', 'Reduced by 2.7% (2.7 KB)', 97303, 100019, '', NULL, 0, 1, '2017-05-19 11:22:42', NULL),
(1431, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-11\\skin-11-thumb.png', '', 'Reduced by 19.1% (17.3 KB)', 74965, 92642, '', NULL, 0, 1, '2017-05-19 11:22:42', NULL),
(1432, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-12\\skin-12-thumb.png', '', 'Reduced by 1.8% (3.3 KB)', 181247, 184609, '', NULL, 0, 1, '2017-05-19 11:22:43', NULL),
(1433, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-13\\skin-13-thumb.png', '', 'Reduced by 1.4% (2.7 KB)', 189160, 191876, '', NULL, 0, 1, '2017-05-19 11:22:44', NULL),
(1434, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-2\\skin-2-thumb.png', '', 'Reduced by 3.9% (3.7 KB)', 93481, 97297, '', NULL, 0, 1, '2017-05-19 11:22:45', NULL),
(1435, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-3\\skin-3-thumb.png', '', 'Reduced by 10.3% (5.7 KB)', 50493, 56320, '', NULL, 0, 1, '2017-05-19 11:22:45', NULL),
(1436, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-4\\skin-4-thumb.png', '', 'Reduced by 8.1% (6.0 KB)', 69758, 75901, '', NULL, 0, 1, '2017-05-19 11:22:46', NULL),
(1437, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-5\\skin-5-thumb.png', '', 'Reduced by 2.3% (2.8 KB)', 122218, 125089, '', NULL, 0, 1, '2017-05-19 11:22:48', NULL),
(1438, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-6\\skin-6-thumb.png', '', 'Reduced by 3.3% (2.9 KB)', 87991, 91011, '', NULL, 0, 1, '2017-05-19 11:22:49', NULL),
(1439, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-7\\skin-7-thumb.png', '', 'Reduced by 2.4% (3.1 KB)', 129110, 132243, '', NULL, 0, 1, '2017-05-19 11:22:54', NULL),
(1440, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-8\\skin-8-thumb.png', '', 'Reduced by 2.0% (2.8 KB)', 139231, 142079, '', NULL, 0, 1, '2017-05-19 11:22:55', NULL),
(1441, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\demo-content\\skin-9\\skin-9-thumb.png', '', 'Reduced by 4.2% (8.7 KB)', 200724, 209590, '', NULL, 0, 1, '2017-05-19 11:22:56', NULL),
(1442, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\images\\bg_404.jpg', '', 'No savings', 43426, 43426, '', NULL, 0, 1, '2017-05-19 11:22:56', NULL),
(1443, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\images\\blank.gif', '', 'No savings', 43, 43, '', NULL, 0, 1, '2017-05-19 11:22:56', NULL),
(1444, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\images\\down-2.png', '', 'No savings', 204, 204, '', NULL, 0, 1, '2017-05-19 11:22:56', NULL),
(1445, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\images\\footer-logo.png', '', 'No savings', 1156, 1156, '', NULL, 0, 1, '2017-05-19 11:22:57', NULL),
(1446, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\images\\invert-logo.png', '', 'No savings', 1149, 1149, '', NULL, 0, 1, '2017-05-19 11:22:57', NULL),
(1447, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\images\\logo.png', '', 'No savings', 1156, 1156, '', NULL, 0, 1, '2017-05-19 11:22:57', NULL),
(1448, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\assets\\images\\shadow.png', '', 'No savings', 5245, 5245, '', NULL, 0, 1, '2017-05-19 11:22:58', NULL),
(1449, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\screenshot.png', '', 'No savings', 253231, 253231, '', NULL, 0, 1, '2017-05-19 11:22:59', NULL),
(1450, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin1\\assets\\images\\bg_404.jpg', '', 'No savings', 191387, 191387, '', NULL, 0, 1, '2017-05-19 11:23:00', NULL),
(1451, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin1\\assets\\images\\footer-logo.png', '', 'No savings', 1271, 1271, '', NULL, 0, 1, '2017-05-19 11:23:00', NULL),
(1452, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin1\\assets\\images\\invert-logo.png', '', 'No savings', 1490, 1490, '', NULL, 0, 1, '2017-05-19 11:23:00', NULL),
(1453, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin1\\assets\\images\\logo.png', '', 'No savings', 868, 868, '', NULL, 0, 1, '2017-05-19 11:23:00', NULL),
(1454, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin10\\assets\\images\\footer-logo.png', '', 'No savings', 1075, 1075, '', NULL, 0, 1, '2017-05-19 11:23:01', NULL),
(1455, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin10\\assets\\images\\invert-logo.png', '', 'No savings', 1063, 1063, '', NULL, 0, 1, '2017-05-19 11:23:01', NULL),
(1456, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin10\\assets\\images\\logo.png', '', 'No savings', 1075, 1075, '', NULL, 0, 1, '2017-05-19 11:23:01', NULL),
(1457, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin11\\assets\\images\\bg_404.jpg', '', 'Reduced by 10.5% (10.8 KB)', 94461, 105556, '', NULL, 0, 1, '2017-05-19 11:23:02', NULL),
(1458, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin11\\assets\\images\\footer-logo.png', '', 'Reduced by 81.9% (14.7 KB)', 3315, 18365, '', NULL, 0, 1, '2017-05-19 11:23:02', NULL),
(1459, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin11\\assets\\images\\invert-logo.png', '', 'Reduced by 81.9% (14.7 KB)', 3315, 18365, '', NULL, 0, 1, '2017-05-19 11:23:02', NULL),
(1460, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin11\\assets\\images\\logo.png', '', 'Reduced by 82.5% (14.6 KB)', 3172, 18122, '', NULL, 0, 1, '2017-05-19 11:23:03', NULL),
(1461, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin12\\assets\\images\\footer-logo.png', '', 'Reduced by 33.6% (1.3 KB)', 2661, 4007, '', NULL, 0, 1, '2017-05-19 11:23:03', NULL),
(1462, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin12\\assets\\images\\invert-logo.png', '', 'Reduced by 33.6% (1.3 KB)', 2661, 4007, '', NULL, 0, 1, '2017-05-19 11:23:03', NULL),
(1463, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin12\\assets\\images\\logo.png', '', 'Reduced by 34.9% (1.4 KB)', 2697, 4140, '', NULL, 0, 1, '2017-05-19 11:23:03', NULL),
(1464, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin13\\assets\\images\\bg_404.jpg', '', 'No savings', 63330, 63330, '', NULL, 0, 1, '2017-05-19 11:23:04', NULL),
(1465, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin13\\assets\\images\\footer-logo.png', '', 'No savings', 539, 539, '', NULL, 0, 1, '2017-05-19 11:23:04', NULL),
(1466, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin13\\assets\\images\\invert-logo.png', '', 'No savings', 539, 539, '', NULL, 0, 1, '2017-05-19 11:23:04', NULL),
(1467, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin13\\assets\\images\\logo.png', '', 'No savings', 539, 539, '', NULL, 0, 1, '2017-05-19 11:23:04', NULL),
(1468, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin16\\assets\\images\\footer-logo.png', '', 'Reduced by 42.0% (923 B)', 1273, 2196, '', NULL, 0, 1, '2017-05-19 11:23:05', NULL),
(1469, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin16\\assets\\images\\invert-logo.png', '', 'Reduced by 43.1% (951 B)', 1258, 2209, '', NULL, 0, 1, '2017-05-19 11:23:05', NULL),
(1470, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin16\\assets\\images\\logo.png', '', 'Reduced by 43.7% (987 B)', 1274, 2261, '', NULL, 0, 1, '2017-05-19 11:23:05', NULL),
(1471, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin2\\assets\\images\\bg_404.jpg', '', 'No savings', 63330, 63330, '', NULL, 0, 1, '2017-05-19 11:23:05', NULL),
(1472, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin2\\assets\\images\\footer-logo.png', '', 'No savings', 617, 617, '', NULL, 0, 1, '2017-05-19 11:23:06', NULL),
(1473, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin2\\assets\\images\\invert-logo.png', '', 'No savings', 617, 617, '', NULL, 0, 1, '2017-05-19 11:23:06', NULL),
(1474, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin2\\assets\\images\\logo.png', '', 'No savings', 617, 617, '', NULL, 0, 1, '2017-05-19 11:23:06', NULL),
(1475, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin3\\assets\\images\\footer-logo.png', '', 'No savings', 356, 356, '', NULL, 0, 1, '2017-05-19 11:23:07', NULL),
(1476, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin3\\assets\\images\\invert-logo.png', '', 'No savings', 356, 356, '', NULL, 0, 1, '2017-05-19 11:23:07', NULL),
(1477, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin3\\assets\\images\\logo.png', '', 'No savings', 356, 356, '', NULL, 0, 1, '2017-05-19 11:23:07', NULL),
(1478, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin4\\assets\\images\\footer-logo.png', '', 'No savings', 1771, 1771, '', NULL, 0, 1, '2017-05-19 11:23:11', NULL),
(1479, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin4\\assets\\images\\invert-logo.png', '', 'No savings', 1771, 1771, '', NULL, 0, 1, '2017-05-19 11:23:11', NULL),
(1480, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin4\\assets\\images\\logo.png', '', 'No savings', 1819, 1819, '', NULL, 0, 1, '2017-05-19 11:23:12', NULL),
(1481, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin5\\assets\\images\\footer-logo.png', '', 'No savings', 1715, 1715, '', NULL, 0, 1, '2017-05-19 11:23:12', NULL),
(1482, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin5\\assets\\images\\invert-logo.png', '', 'No savings', 1715, 1715, '', NULL, 0, 1, '2017-05-19 11:23:12', NULL),
(1483, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin5\\assets\\images\\logo.png', '', 'No savings', 1681, 1681, '', NULL, 0, 1, '2017-05-19 11:23:13', NULL),
(1484, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin6\\assets\\images\\bg_404.jpg', '', 'Reduced by 1.0% (976 B)', 96771, 97747, '', NULL, 0, 1, '2017-05-19 11:23:13', NULL),
(1485, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin6\\assets\\images\\footer-logo.png', '', 'No savings', 1357, 1357, '', NULL, 0, 1, '2017-05-19 11:23:13', NULL),
(1486, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin6\\assets\\images\\invert-logo.png', '', 'No savings', 1357, 1357, '', NULL, 0, 1, '2017-05-19 11:23:14', NULL),
(1487, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin6\\assets\\images\\logo.png', '', 'No savings', 1357, 1357, '', NULL, 0, 1, '2017-05-19 11:23:14', NULL),
(1488, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin7\\assets\\images\\footer-logo.png', '', 'No savings', 2282, 2282, '', NULL, 0, 1, '2017-05-19 11:23:14', NULL),
(1489, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin7\\assets\\images\\invert-logo.png', '', 'No savings', 2362, 2362, '', NULL, 0, 1, '2017-05-19 11:23:15', NULL),
(1490, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin7\\assets\\images\\logo.png', '', 'No savings', 2282, 2282, '', NULL, 0, 1, '2017-05-19 11:23:15', NULL),
(1491, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin8\\assets\\images\\bg_404.jpg', '', 'No savings', 71601, 71601, '', NULL, 0, 1, '2017-05-19 11:23:15', NULL),
(1492, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin8\\assets\\images\\footer-logo.png', '', 'No savings', 931, 931, '', NULL, 0, 1, '2017-05-19 11:23:16', NULL),
(1493, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin8\\assets\\images\\invert-logo.png', '', 'No savings', 931, 931, '', NULL, 0, 1, '2017-05-19 11:23:16', NULL),
(1494, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin8\\assets\\images\\logo.png', '', 'No savings', 916, 916, '', NULL, 0, 1, '2017-05-19 11:23:16', NULL),
(1495, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin9\\assets\\images\\bg_404.jpg', '', 'No savings', 27067, 27067, '', NULL, 0, 1, '2017-05-19 11:23:16', NULL),
(1496, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin9\\assets\\images\\footer-logo.png', '', 'No savings', 1399, 1399, '', NULL, 0, 1, '2017-05-19 11:23:17', NULL),
(1497, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin9\\assets\\images\\invert-logo.png', '', 'No savings', 1399, 1399, '', NULL, 0, 1, '2017-05-19 11:23:17', NULL),
(1498, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\skins\\skin9\\assets\\images\\logo.png', '', 'No savings', 1399, 1399, '', NULL, 0, 1, '2017-05-19 11:23:18', NULL),
(1499, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\default.png', '', 'Reduced by 46.8% (3.5 KB)', 4014, 7549, '', NULL, 0, 1, '2017-05-19 11:23:18', NULL),
(1500, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin1.png', '', 'No savings', 1640, 1640, '', NULL, 0, 1, '2017-05-19 11:23:19', NULL),
(1501, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin10.png', '', 'Reduced by 40.9% (2.7 KB)', 3930, 6647, '', NULL, 0, 1, '2017-05-19 11:23:19', NULL),
(1502, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin11.png', '', 'No savings', 2125, 2125, '', NULL, 0, 1, '2017-05-19 11:23:19', NULL),
(1503, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin12.png', '', 'Reduced by 47.5% (1.7 KB)', 1877, 3573, '', NULL, 0, 1, '2017-05-19 11:23:20', NULL),
(1504, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin13.png', '', 'Reduced by 62.9% (2.7 KB)', 1604, 4320, '', NULL, 0, 1, '2017-05-19 11:23:20', NULL),
(1505, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin2.png', '', 'Reduced by 92.7% (2.8 KB)', 230, 3143, '', NULL, 0, 1, '2017-05-19 11:23:20', NULL),
(1506, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin3.png', '', 'Reduced by 83.8% (2.9 KB)', 570, 3520, '', NULL, 0, 1, '2017-05-19 11:23:21', NULL),
(1507, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin4.png', '', 'Reduced by 49.0% (1.7 KB)', 1784, 3497, '', NULL, 0, 1, '2017-05-19 11:23:21', NULL),
(1508, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin5.png', '', 'Reduced by 69.9% (1.8 KB)', 782, 2600, '', NULL, 0, 1, '2017-05-19 11:23:21', NULL),
(1509, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin6.png', '', 'Reduced by 64.3% (2.4 KB)', 1369, 3830, '', NULL, 0, 1, '2017-05-19 11:23:22', NULL),
(1510, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin7.png', '', 'Reduced by 54.5% (3.0 KB)', 2573, 5655, '', NULL, 0, 1, '2017-05-19 11:23:22', NULL),
(1511, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin8.png', '', 'No savings', 2086, 2086, '', NULL, 0, 1, '2017-05-19 11:23:22', NULL),
(1512, NULL, NULL, NULL, 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/themes/swanxy\\tm-style-switcher-pressets\\skin9.png', '', 'No savings', 1934, 1934, '', NULL, 0, 1, '2017-05-19 11:23:23', NULL),
(1811, 3882, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-141x188.jpg', '', 'Reduced by 9.4% (402 B)', 3879, 4281, '', NULL, 0, 1, '2017-05-19 10:18:54', NULL),
(1804, 3882, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-150x150.jpg', '', 'Reduced by 11.7% (406 B)', 3070, 3476, '', NULL, 0, 1, '2017-05-19 10:18:53', NULL),
(1803, 3882, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-1-418x315.jpg', '', 'Reduced by 5.1% (663 B)', 12325, 12988, '', NULL, 0, 1, '2017-05-19 10:18:53', NULL),
(1795, 3881, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-141x188.jpg', '', 'Reduced by 8.2% (403 B)', 4486, 4889, '', NULL, 0, 1, '2017-05-19 10:18:48', NULL),
(1794, 3881, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-512x512.jpg', '', 'Reduced by 5.4% (1.2 KB)', 20739, 21924, '', NULL, 0, 1, '2017-05-19 10:18:48', NULL),
(1786, 3881, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-663x431.jpg', '', 'Reduced by 5.5% (1.2 KB)', 21657, 22929, '', NULL, 0, 1, '2017-05-19 10:18:47', NULL),
(1785, 3881, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-300x300.jpg', '', 'Reduced by 5.7% (590 B)', 9742, 10332, '', NULL, 0, 1, '2017-05-19 10:18:46', NULL),
(1784, 3881, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2-295x222.jpg', '', 'Reduced by 6.5% (508 B)', 7311, 7819, '', NULL, 0, 1, '2017-05-19 10:18:46', NULL),
(1783, 3881, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-2.jpg', '', 'Reduced by 1.6% (843 B)', 51872, 52715, '', NULL, 0, 1, '2017-05-19 10:18:46', NULL),
(1778, 3880, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-512x512.jpg', '', 'Reduced by 2.9% (917 B)', 30222, 31139, '', NULL, 0, 1, '2017-05-19 10:18:41', NULL),
(1777, 3880, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-663x315.jpg', '', 'Reduced by 3.9% (856 B)', 21309, 22165, '', NULL, 0, 1, '2017-05-19 10:18:41', NULL),
(1776, 3880, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-418x418.jpg', '', 'Reduced by 2.9% (673 B)', 22278, 22951, '', NULL, 0, 1, '2017-05-19 10:18:41', NULL),
(1775, 3880, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-650x490.jpg', '', 'Reduced by 2.7% (920 B)', 33245, 34165, '', NULL, 0, 1, '2017-05-19 10:18:41', NULL),
(1774, 3880, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-400x400.jpg', '', 'Reduced by 2.8% (582 B)', 20494, 21076, '', NULL, 0, 1, '2017-05-19 10:18:41', NULL),
(1773, 3880, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-158x88.jpg', '', 'Reduced by 12.2% (378 B)', 2713, 3091, '', NULL, 0, 1, '2017-05-19 10:18:41', NULL),
(1772, 3880, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2016/09/team-3-150x150.jpg', '', 'Reduced by 8.0% (379 B)', 4376, 4755, '', NULL, 0, 1, '2017-05-19 10:18:41', NULL),
(1696, 3851, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-418x359.jpg', '', 'Reduced by 16.4% (1.2 KB)', 6255, 7481, '', NULL, 0, 1, '2017-05-19 09:14:51', NULL),
(1695, 3851, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-650x490.jpg', '', 'Reduced by 16.7% (2.1 KB)', 10922, 13107, '', NULL, 0, 1, '2017-05-19 09:14:51', NULL),
(1694, 3851, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-400x400.jpg', '', 'Reduced by 14.7% (1.1 KB)', 6818, 7989, '', NULL, 0, 1, '2017-05-19 09:14:51', NULL),
(1693, 3851, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-158x88.jpg', '', 'Reduced by 23.9% (434 B)', 1381, 1815, '', NULL, 0, 1, '2017-05-19 09:14:51', NULL),
(1692, 3851, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-150x150.jpg', '', 'Reduced by 20.2% (454 B)', 1788, 2242, '', NULL, 0, 1, '2017-05-19 09:14:50', NULL),
(1691, 3851, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-2-418x315.jpg', '', 'Reduced by 15.5% (1.0 KB)', 5750, 6805, '', NULL, 0, 1, '2017-05-19 09:14:50', NULL),
(1652, 3848, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-418x359.jpg', '', 'Reduced by 9.3% (1.1 KB)', 10552, 11632, '', NULL, 0, 1, '2017-05-19 09:14:33', NULL),
(1651, 3848, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-650x490.jpg', '', 'Reduced by 8.1% (1.8 KB)', 20562, 22373, '', NULL, 0, 1, '2017-05-19 09:14:33', NULL),
(1650, 3848, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-400x400.jpg', '', 'Reduced by 7.9% (1.0 KB)', 12071, 13103, '', NULL, 0, 1, '2017-05-19 09:14:33', NULL),
(1649, 3848, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-158x88.jpg', '', 'Reduced by 13.5% (406 B)', 2611, 3017, '', NULL, 0, 1, '2017-05-19 09:14:33', NULL),
(1648, 3848, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-150x150.jpg', '', 'Reduced by 12.4% (429 B)', 3037, 3466, '', NULL, 0, 1, '2017-05-19 09:14:33', NULL),
(1647, 3848, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/2-1-418x315.jpg', '', 'Reduced by 8.5% (953 B)', 10320, 11273, '', NULL, 0, 1, '2017-05-19 09:14:33', NULL),
(1612, 3846, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1920x820.jpg', '', 'Reduced by 11.1% (18.6 KB)', 153244, 172333, '', NULL, 0, 1, '2017-05-19 09:14:11', NULL),
(1611, 3846, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-1920x1080.jpg', '', 'Reduced by 12.0% (21.7 KB)', 163214, 185397, '', NULL, 0, 1, '2017-05-19 09:14:11', NULL),
(1610, 3846, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-886x315.jpg', '', 'Reduced by 2.7% (1.0 KB)', 38643, 39697, '', NULL, 0, 1, '2017-05-19 09:14:11', NULL);
INSERT INTO `wp_ewwwio_images` (`id`, `attachment_id`, `gallery`, `resize`, `path`, `converted`, `results`, `image_size`, `orig_size`, `backup`, `level`, `pending`, `updates`, `updated`, `trace`) VALUES
(1609, 3846, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-886x668.jpg', '', 'Reduced by 5.3% (2.6 KB)', 47502, 50154, '', NULL, 0, 1, '2017-05-19 09:14:11', NULL),
(1608, 3846, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-418x359.jpg', '', 'Reduced by 6.4% (930 B)', 13542, 14472, '', NULL, 0, 1, '2017-05-19 09:14:11', NULL),
(1607, 3846, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-650x490.jpg', '', 'Reduced by 5.1% (1.5 KB)', 28201, 29709, '', NULL, 0, 1, '2017-05-19 09:14:10', NULL),
(1606, 3846, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/3-400x400.jpg', '', 'Reduced by 5.7% (929 B)', 15330, 16259, '', NULL, 0, 1, '2017-05-19 09:14:10', NULL),
(1573, 3844, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-480x362.jpg', '', 'Reduced by 6.2% (1.0 KB)', 16170, 17233, '', NULL, 0, 1, '2017-05-19 09:13:57', NULL),
(1568, 3844, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1920x820.jpg', '', 'Reduced by 10.2% (15.2 KB)', 137187, 152732, '', NULL, 0, 1, '2017-05-19 09:13:56', NULL),
(1567, 3844, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1920x1080.jpg', '', 'Reduced by 11.0% (19.2 KB)', 158456, 178119, '', NULL, 0, 1, '2017-05-19 09:13:56', NULL),
(1566, 3844, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-886x315.jpg', '', 'Reduced by 3.6% (1.2 KB)', 33259, 34512, '', NULL, 0, 1, '2017-05-19 09:13:56', NULL),
(1565, 3844, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-886x668.jpg', '', 'Reduced by 5.8% (2.7 KB)', 45476, 48279, '', NULL, 0, 1, '2017-05-19 09:13:56', NULL),
(1564, 3844, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-418x359.jpg', '', 'Reduced by 7.2% (1,012 B)', 13059, 14071, '', NULL, 0, 1, '2017-05-19 09:13:55', NULL),
(1563, 3844, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-650x490.jpg', '', 'Reduced by 5.9% (1.7 KB)', 27006, 28696, '', NULL, 0, 1, '2017-05-19 09:13:55', NULL),
(1562, 3844, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-400x400.jpg', '', 'Reduced by 6.2% (987 B)', 14942, 15929, '', NULL, 0, 1, '2017-05-19 09:13:55', NULL),
(1561, 3844, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-158x88.jpg', '', 'Reduced by 14.1% (430 B)', 2623, 3053, '', NULL, 0, 1, '2017-05-19 09:13:55', NULL),
(1560, 3844, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-150x150.jpg', '', 'Reduced by 12.7% (445 B)', 3049, 3494, '', NULL, 0, 1, '2017-05-19 09:13:55', NULL),
(1559, 3844, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-418x315.jpg', '', 'Reduced by 6.7% (911 B)', 12695, 13606, '', NULL, 0, 1, '2017-05-19 09:13:55', NULL),
(1558, 3844, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-769x431.jpg', '', 'Reduced by 4.2% (1.5 KB)', 34643, 36174, '', NULL, 0, 1, '2017-05-19 09:13:55', NULL),
(1557, 3844, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-1024x880.jpg', '', 'Reduced by 6.9% (4.2 KB)', 58517, 62839, '', NULL, 0, 1, '2017-05-19 09:13:54', NULL),
(1556, 3844, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-768x660.jpg', '', 'Reduced by 6.5% (2.5 KB)', 36553, 39076, '', NULL, 0, 1, '2017-05-19 09:13:54', NULL),
(1555, 3844, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-300x258.jpg', '', 'Reduced by 8.2% (684 B)', 7633, 8317, '', NULL, 0, 1, '2017-05-19 09:13:54', NULL),
(1554, 3844, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1-295x222.jpg', '', 'Reduced by 7.7% (608 B)', 7272, 7880, '', NULL, 0, 1, '2017-05-19 09:13:54', NULL),
(1553, 3844, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/1.jpg', '', 'Reduced by 22.0% (191.0 KB)', 693149, 888732, '', NULL, 0, 1, '2017-05-19 09:13:54', NULL),
(1513, 3840, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1.jpg', '', 'Reduced by 6.4% (6.8 KB)', 102025, 108970, '', NULL, 0, 1, '2017-05-19 08:50:07', NULL),
(1514, 3840, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-295x222.jpg', '', 'Reduced by 3.7% (709 B)', 18648, 19357, '', NULL, 0, 1, '2017-05-19 08:50:07', NULL),
(1515, 3840, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-300x169.jpg', '', 'Reduced by 4.6% (628 B)', 12968, 13596, '', NULL, 0, 1, '2017-05-19 08:50:07', NULL),
(1516, 3840, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-768x432.jpg', '', 'Reduced by 2.2% (1.2 KB)', 57115, 58391, '', NULL, 0, 1, '2017-05-19 08:50:08', NULL),
(1517, 3840, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-769x431.jpg', '', 'Reduced by 2.1% (1.2 KB)', 57185, 58408, '', NULL, 0, 1, '2017-05-19 08:50:08', NULL),
(1518, 3840, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-418x315.jpg', '', 'Reduced by 2.7% (906 B)', 32978, 33884, '', NULL, 0, 1, '2017-05-19 08:50:08', NULL),
(1519, 3840, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-150x150.jpg', '', 'Reduced by 6.1% (543 B)', 8379, 8922, '', NULL, 0, 1, '2017-05-19 08:50:08', NULL),
(1520, 3840, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-158x88.jpg', '', 'Reduced by 8.8% (439 B)', 4526, 4965, '', NULL, 0, 1, '2017-05-19 08:50:08', NULL),
(1521, 3840, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-400x400.jpg', '', 'Reduced by 2.4% (1,010 B)', 40319, 41329, '', NULL, 0, 1, '2017-05-19 08:50:08', NULL),
(1522, 3840, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-650x490.jpg', '', 'Reduced by 2.0% (1.3 KB)', 65285, 66636, '', NULL, 0, 1, '2017-05-19 08:50:08', NULL),
(1523, 3840, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-418x235.jpg', '', 'Reduced by 3.4% (789 B)', 22119, 22908, '', NULL, 0, 1, '2017-05-19 08:50:08', NULL),
(1524, 3840, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-886x498.jpg', '', 'Reduced by 2.2% (1.8 KB)', 81140, 82933, '', NULL, 0, 1, '2017-05-19 08:50:09', NULL),
(1525, 3840, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-886x315.jpg', '', 'Reduced by 2.1% (1.1 KB)', 51273, 52396, '', NULL, 0, 1, '2017-05-19 08:50:09', NULL),
(1526, 3840, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-512x498.jpg', '', 'Reduced by 2.0% (1.3 KB)', 65807, 67173, '', NULL, 0, 1, '2017-05-19 08:50:09', NULL),
(1527, 3840, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-141x188.jpg', '', 'Reduced by 5.5% (574 B)', 9839, 10413, '', NULL, 0, 1, '2017-05-19 08:50:09', NULL),
(1528, 3840, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-418x498.jpg', '', 'Reduced by 2.1% (1.2 KB)', 58008, 59258, '', NULL, 0, 1, '2017-05-19 08:50:09', NULL),
(1529, 3840, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-301x226.jpg', '', 'Reduced by 3.7% (745 B)', 19432, 20177, '', NULL, 0, 1, '2017-05-19 08:50:09', NULL),
(1530, 3840, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/post-1-480x362.jpg', '', 'Reduced by 2.5% (1,023 B)', 40541, 41564, '', NULL, 0, 1, '2017-05-19 08:50:09', NULL),
(1531, 3841, 'media', 'full', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384.jpg', '', 'Reduced by 26.4% (1.0 MB)', 3038110, 4128857, '', NULL, 0, 1, '2017-05-19 08:51:53', NULL),
(1532, 3841, 'media', 'thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-295x222.jpg', '', 'Reduced by 2.7% (700 B)', 24912, 25612, '', NULL, 0, 1, '2017-05-19 08:51:53', NULL),
(1533, 3841, 'media', 'medium', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-300x300.jpg', '', 'Reduced by 2.4% (794 B)', 32831, 33625, '', NULL, 0, 1, '2017-05-19 08:51:53', NULL),
(1534, 3841, 'media', 'medium_large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-768x768.jpg', '', 'Reduced by 11.1% (25.0 KB)', 203990, 229585, '', NULL, 0, 1, '2017-05-19 08:51:53', NULL),
(1535, 3841, 'media', 'large', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-1024x1024.jpg', '', 'Reduced by 12.3% (46.3 KB)', 339437, 386837, '', NULL, 0, 1, '2017-05-19 08:51:53', NULL),
(1536, 3841, 'media', 'swanxy-skin16-769-431', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-769x431.jpg', '', 'Reduced by 10.2% (14.9 KB)', 134792, 150088, '', NULL, 0, 1, '2017-05-19 08:51:53', NULL),
(1537, 3841, 'media', 'post-thumbnail', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-418x315.jpg', '', 'Reduced by 2.5% (1.4 KB)', 54186, 55571, '', NULL, 0, 1, '2017-05-19 08:51:54', NULL),
(1538, 3841, 'media', 'swanxy-thumb-s', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-150x150.jpg', '', 'Reduced by 5.0% (383 B)', 7314, 7697, '', NULL, 0, 1, '2017-05-19 08:51:54', NULL),
(1539, 3841, 'media', 'swanxy-slider-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-158x88.jpg', '', 'Reduced by 6.7% (382 B)', 5303, 5685, '', NULL, 0, 1, '2017-05-19 08:51:54', NULL),
(1540, 3841, 'media', 'swanxy-thumb-m', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-400x400.jpg', '', 'Reduced by 2.5% (1.5 KB)', 60160, 61730, '', NULL, 0, 1, '2017-05-19 08:51:54', NULL),
(1541, 3841, 'media', 'swanxy-thumb-m-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-650x490.jpg', '', 'Reduced by 9.3% (12.4 KB)', 122848, 135499, '', NULL, 0, 1, '2017-05-19 08:51:54', NULL),
(1542, 3841, 'media', 'swanxy-thumb-masonry', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-418x418.jpg', '', 'Reduced by 2.4% (1.6 KB)', 67703, 69386, '', NULL, 0, 1, '2017-05-19 08:51:54', NULL),
(1543, 3841, 'media', 'swanxy-thumb-l', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-886x668.jpg', '', 'Reduced by 11.5% (27.3 KB)', 216307, 244312, '', NULL, 0, 1, '2017-05-19 08:51:54', NULL),
(1544, 3841, 'media', 'swanxy-thumb-l-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-886x315.jpg', '', 'Reduced by 10.7% (15.2 KB)', 129701, 145240, '', NULL, 0, 1, '2017-05-19 08:51:55', NULL),
(1545, 3841, 'media', 'swanxy-thumb-xl', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-1920x1080.jpg', '', 'Reduced by 12.0% (80.1 KB)', 603999, 685983, '', NULL, 0, 1, '2017-05-19 08:51:55', NULL),
(1546, 3841, 'media', 'swanxy-thumb-xl-2', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-1920x820.jpg', '', 'Reduced by 11.8% (66.6 KB)', 509619, 577788, '', NULL, 0, 1, '2017-05-19 08:51:55', NULL),
(1547, 3841, 'media', 'swanxy-author-avatar', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-512x512.jpg', '', 'Reduced by 8.4% (8.4 KB)', 94007, 102592, '', NULL, 0, 1, '2017-05-19 08:51:55', NULL),
(1548, 3841, 'media', 'swanxy-woo-cart-product-thumb', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-141x188.jpg', '', 'Reduced by 4.6% (434 B)', 8993, 9427, '', NULL, 0, 1, '2017-05-19 08:51:55', NULL),
(1549, 3841, 'media', 'swanxy-thumb-listing-line-product', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-418x560.jpg', '', 'Reduced by 2.6% (2.4 KB)', 92350, 94806, '', NULL, 0, 1, '2017-05-19 08:51:56', NULL),
(1550, 3841, 'media', 'swanxy-thumb-301-226', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-301x226.jpg', '', 'Reduced by 2.5% (695 B)', 26581, 27276, '', NULL, 0, 1, '2017-05-19 08:51:56', NULL),
(1551, 3841, 'media', 'swanxy-thumb-480-362', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-480x362.jpg', '', 'Reduced by 2.5% (1.8 KB)', 71762, 73589, '', NULL, 0, 1, '2017-05-19 08:51:56', NULL),
(1552, 3841, 'media', 'swanxy-thumb-1355-1020', 'E:\\Wamp\\www\\tm\\2017\\reflax/wp-content/uploads/2017/05/shutterstock_527830384-1355x1020.jpg', '', 'Reduced by 12.4% (61.0 KB)', 440369, 502840, '', NULL, 0, 1, '2017-05-19 08:51:56', NULL);

DROP TABLE IF EXISTS `wp_links`;
CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) UNSIGNED NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `wp_mprm_customer`;
CREATE TABLE IF NOT EXISTS `wp_mprm_customer` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(11) NOT NULL,
  `email` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `telephone` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `purchase_value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `purchase_count` bigint(11) NOT NULL,
  `payment_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `user` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

DROP TABLE IF EXISTS `wp_mp_timetable_data`;
CREATE TABLE IF NOT EXISTS `wp_mp_timetable_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `column_id` int(11) NOT NULL,
  `event_id` int(11) NOT NULL,
  `event_start` time NOT NULL,
  `event_end` time NOT NULL,
  `user_id` int(11) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_mp_timetable_data` (`id`, `column_id`, `event_id`, `event_start`, `event_end`, `user_id`, `description`) VALUES
(29, 245, 1761, '10:00:00', '11:30:00', -1, ''),
(31, 664, 1761, '09:30:00', '11:00:00', -1, ''),
(32, 665, 1761, '10:30:00', '11:30:00', -1, ''),
(33, 1481, 1761, '10:30:00', '12:00:00', -1, ''),
(34, 667, 1761, '10:00:00', '11:30:00', -1, ''),
(35, 668, 1761, '09:30:00', '10:30:00', -1, ''),
(36, 669, 1761, '09:00:00', '10:00:00', -1, ''),
(37, 1481, 1761, '08:00:00', '09:00:00', -1, ''),
(38, 667, 1761, '12:30:00', '13:30:00', -1, '');

DROP TABLE IF EXISTS `wp_options`;
CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=2706 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1, 'siteurl', 'your_website_url_here', 'yes'),
(2, 'home', 'your_website_url_here', 'yes'),
(3, 'blogname', 'Swanxy', 'yes'),
(4, 'blogdescription', '', 'yes'),
(5, 'users_can_register', '0', 'yes'),
(6, 'admin_email', 'm@m.com', 'yes'),
(7, 'start_of_week', '1', 'yes'),
(8, 'use_balanceTags', '0', 'yes'),
(9, 'use_smilies', '1', 'yes'),
(10, 'require_name_email', '1', 'yes'),
(11, 'comments_notify', '1', 'yes'),
(12, 'posts_per_rss', '10', 'yes'),
(13, 'rss_use_excerpt', '0', 'yes'),
(14, 'mailserver_url', 'mail.example.com', 'yes'),
(15, 'mailserver_login', 'login@example.com', 'yes'),
(16, 'mailserver_pass', 'password', 'yes'),
(17, 'mailserver_port', '110', 'yes'),
(18, 'default_category', '1', 'yes'),
(19, 'default_comment_status', 'open', 'yes'),
(20, 'default_ping_status', 'open', 'yes'),
(21, 'default_pingback_flag', '1', 'yes'),
(22, 'posts_per_page', '6', 'yes'),
(23, 'date_format', 'M. j, Y', 'yes'),
(24, 'time_format', 'g:i a', 'yes'),
(25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
(26, 'comment_moderation', '0', 'yes'),
(27, 'moderation_notify', '1', 'yes'),
(28, 'permalink_structure', '/%category%/%postname%/', 'yes'),
(30, 'hack_file', '0', 'yes'),
(31, 'blog_charset', 'UTF-8', 'yes'),
(32, 'moderation_keys', '', 'no'),
(33, 'active_plugins', 'a:12:{i:0;s:19:\"akismet/akismet.php\";i:1;s:45:\"cherry-data-importer/cherry-data-importer.php\";i:2;s:35:\"cherry-projects/cherry-projects.php\";i:3;s:45:\"cherry-services-list/cherry-services-list.php\";i:4;s:35:\"cherry-sidebars/cherry-sidebars.php\";i:5;s:37:\"cherry-socialize/cherry-socialize.php\";i:6;s:43:\"cherry-team-members/cherry-team-members.php\";i:7;s:29:\"cherry-testi/testimonials.php\";i:8;s:9:\"hello.php\";i:9;s:53:\"power-builder-integrator/power-builder-integrator.php\";i:10;s:35:\"power-builder/power-builder-upd.php\";i:12;s:29:\"tm-mega-menu/tm-mega-menu.php\";}', 'yes'),
(34, 'category_base', '', 'yes'),
(35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
(36, 'comment_max_links', '2', 'yes'),
(37, 'gmt_offset', '0', 'yes'),
(38, 'default_email_category', '1', 'yes'),
(39, 'recently_edited', 'a:2:{i:0;s:126:\"F:\\OpenServer\\domains\\localhost\\2017\\may\\swanxy/wp-content/plugins/force-regenerate-thumbnails/force-regenerate-thumbnails.php\";i:1;s:0:\"\";}', 'no'),
(40, 'template', 'swanxy', 'yes'),
(41, 'stylesheet', 'swanxy', 'yes'),
(42, 'comment_whitelist', '1', 'yes'),
(43, 'blacklist_keys', '', 'no'),
(44, 'comment_registration', '0', 'yes'),
(45, 'html_type', 'text/html', 'yes'),
(46, 'use_trackback', '0', 'yes'),
(47, 'default_role', 'subscriber', 'yes'),
(48, 'db_version', '38590', 'yes'),
(49, 'uploads_use_yearmonth_folders', '1', 'yes'),
(50, 'upload_path', '', 'yes'),
(51, 'blog_public', '1', 'yes'),
(52, 'default_link_category', '2', 'yes'),
(53, 'show_on_front', 'page', 'yes'),
(54, 'tag_base', '', 'yes'),
(55, 'show_avatars', '1', 'yes'),
(56, 'avatar_rating', 'G', 'yes'),
(57, 'upload_url_path', '', 'yes'),
(58, 'thumbnail_size_w', '295', 'yes'),
(59, 'thumbnail_size_h', '222', 'yes'),
(60, 'thumbnail_crop', '1', 'yes'),
(61, 'medium_size_w', '300', 'yes'),
(62, 'medium_size_h', '300', 'yes'),
(63, 'avatar_default', 'mystery', 'yes'),
(64, 'large_size_w', '1024', 'yes'),
(65, 'large_size_h', '1024', 'yes'),
(66, 'image_default_link_type', 'none', 'yes'),
(67, 'image_default_size', '', 'yes'),
(68, 'image_default_align', '', 'yes'),
(69, 'close_comments_for_old_posts', '0', 'yes'),
(70, 'close_comments_days_old', '14', 'yes'),
(71, 'thread_comments', '1', 'yes'),
(72, 'thread_comments_depth', '5', 'yes'),
(73, 'page_comments', '0', 'yes'),
(74, 'comments_per_page', '50', 'yes'),
(75, 'default_comments_page', 'newest', 'yes'),
(76, 'comment_order', 'asc', 'yes'),
(77, 'sticky_posts', 'a:0:{}', 'yes'),
(78, 'widget_categories', 'a:3:{i:2;a:4:{s:5:\"title\";s:10:\"Categories\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:3;a:4:{s:5:\"title\";s:10:\"Categories\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(79, 'widget_text', 'a:4:{i:1;a:0:{}i:2;a:3:{s:5:\"title\";s:5:\"About\";s:4:\"text\";s:404:\"The advertising industry is one of the most volatile fields of work there are. With so many new mediums, it’s constantly evolving.\r\n\r\nWith so many new ways to advertise and market your products and services these days, digitally and elsewhere and the old conventional ways getting a revamp - your business surely needs professional help. With years of experience, we are the best fit for your projects!\";s:6:\"filter\";b:1;}i:3;a:3:{s:5:\"title\";s:5:\"About\";s:4:\"text\";s:404:\"The advertising industry is one of the most volatile fields of work there are. With so many new mediums, it’s constantly evolving.\r\n\r\nWith so many new ways to advertise and market your products and services these days, digitally and elsewhere and the old conventional ways getting a revamp - your business surely needs professional help. With years of experience, we are the best fit for your projects!\";s:6:\"filter\";b:1;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(80, 'widget_rss', 'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}', 'yes'),
(81, 'uninstall_plugins', 'a:5:{s:38:\"mp-restaurant-menu/restaurant-menu.php\";a:2:{i:0;s:31:\"MP_Restaurant_Menu_Setup_Plugin\";i:1;s:12:\"on_uninstall\";}s:29:\"mp-timetable/mp-timetable.php\";a:2:{i:0;s:13:\"Mp_Time_Table\";i:1;s:12:\"on_uninstall\";}s:37:\"cherry-socialize/cherry-socialize.php\";a:2:{i:0;s:16:\"Cherry_Socialize\";i:1;s:9:\"uninstall\";}s:45:\"ewww-image-optimizer/ewww-image-optimizer.php\";s:30:\"ewww_image_optimizer_uninstall\";s:47:\"rvg-optimize-database/rvg-optimize-database.php\";a:2:{i:0;s:16:\"OptimizeDatabase\";i:1;s:26:\"odb_uninstallation_handler\";}}', 'no'),
(82, 'timezone_string', '', 'yes'),
(83, 'page_for_posts', '812', 'yes'),
(84, 'page_on_front', '814', 'yes'),
(85, 'default_post_format', '0', 'yes'),
(86, 'link_manager_enabled', '0', 'yes'),
(87, 'finished_splitting_shared_terms', '1', 'yes'),
(88, 'site_icon', '3579', 'yes'),
(89, 'medium_large_size_w', '768', 'yes'),
(90, 'medium_large_size_h', '0', 'yes'),
(91, 'initial_db_version', '38590', 'yes'),
(92, 'wp_user_roles', 'a:15:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:182:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:24:\"edit_booked_appointments\";b:1;s:21:\"manage_booked_options\";b:1;s:26:\"manage_restaurant_settings\";b:1;s:23:\"manage_restaurant_terms\";b:1;s:22:\"manage_restaurant_menu\";b:1;s:17:\"edit_mp_menu_item\";b:1;s:17:\"read_mp_menu_item\";b:1;s:19:\"delete_mp_menu_item\";b:1;s:18:\"edit_mp_menu_items\";b:1;s:25:\"edit_others_mp_menu_items\";b:1;s:21:\"publish_mp_menu_items\";b:1;s:26:\"read_private_mp_menu_items\";b:1;s:20:\"delete_mp_menu_items\";b:1;s:28:\"delete_private_mp_menu_items\";b:1;s:30:\"delete_published_mp_menu_items\";b:1;s:27:\"delete_others_mp_menu_items\";b:1;s:26:\"edit_private_mp_menu_items\";b:1;s:28:\"edit_published_mp_menu_items\";b:1;s:25:\"manage_mp_menu_item_terms\";b:1;s:23:\"edit_mp_menu_item_terms\";b:1;s:25:\"delete_mp_menu_item_terms\";b:1;s:25:\"assign_mp_menu_item_terms\";b:1;s:23:\"view_mp_menu_item_stats\";b:1;s:15:\"edit_mprm_order\";b:1;s:15:\"read_mprm_order\";b:1;s:17:\"delete_mprm_order\";b:1;s:16:\"edit_mprm_orders\";b:1;s:23:\"edit_others_mprm_orders\";b:1;s:19:\"publish_mprm_orders\";b:1;s:24:\"read_private_mprm_orders\";b:1;s:18:\"delete_mprm_orders\";b:1;s:26:\"delete_private_mprm_orders\";b:1;s:28:\"delete_published_mprm_orders\";b:1;s:25:\"delete_others_mprm_orders\";b:1;s:24:\"edit_private_mprm_orders\";b:1;s:26:\"edit_published_mprm_orders\";b:1;s:23:\"manage_mprm_order_terms\";b:1;s:21:\"edit_mprm_order_terms\";b:1;s:23:\"delete_mprm_order_terms\";b:1;s:23:\"assign_mprm_order_terms\";b:1;s:21:\"view_mprm_order_stats\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:44:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:15:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:7:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:23:\"edit_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:0:{}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:0:{}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:0:{}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:0:{}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:0:{}}s:20:\"booked_booking_agent\";a:2:{s:4:\"name\";s:13:\"Booking Agent\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:24:\"edit_booked_appointments\";b:1;}}s:12:\"mprm_manager\";a:2:{s:4:\"name\";s:18:\"Restaurant Manager\";s:12:\"capabilities\";a:68:{s:4:\"read\";b:1;s:10:\"edit_posts\";b:1;s:12:\"delete_posts\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:19:\"delete_others_pages\";b:1;s:19:\"delete_others_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:17:\"edit_others_posts\";b:1;s:10:\"edit_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:13:\"publish_pages\";b:1;s:13:\"publish_posts\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:26:\"manage_restaurant_settings\";b:1;s:23:\"manage_restaurant_terms\";b:1;s:22:\"manage_restaurant_menu\";b:1;s:14:\"manage_options\";b:1;s:17:\"edit_mp_menu_item\";b:1;s:17:\"read_mp_menu_item\";b:1;s:19:\"delete_mp_menu_item\";b:1;s:18:\"edit_mp_menu_items\";b:1;s:25:\"edit_others_mp_menu_items\";b:1;s:21:\"publish_mp_menu_items\";b:1;s:26:\"read_private_mp_menu_items\";b:1;s:20:\"delete_mp_menu_items\";b:1;s:28:\"delete_private_mp_menu_items\";b:1;s:30:\"delete_published_mp_menu_items\";b:1;s:27:\"delete_others_mp_menu_items\";b:1;s:26:\"edit_private_mp_menu_items\";b:1;s:28:\"edit_published_mp_menu_items\";b:1;s:25:\"manage_mp_menu_item_terms\";b:1;s:23:\"edit_mp_menu_item_terms\";b:1;s:25:\"delete_mp_menu_item_terms\";b:1;s:25:\"assign_mp_menu_item_terms\";b:1;s:23:\"view_mp_menu_item_stats\";b:1;s:15:\"edit_mprm_order\";b:1;s:15:\"read_mprm_order\";b:1;s:17:\"delete_mprm_order\";b:1;s:16:\"edit_mprm_orders\";b:1;s:23:\"edit_others_mprm_orders\";b:1;s:19:\"publish_mprm_orders\";b:1;s:24:\"read_private_mprm_orders\";b:1;s:18:\"delete_mprm_orders\";b:1;s:26:\"delete_private_mprm_orders\";b:1;s:28:\"delete_published_mprm_orders\";b:1;s:25:\"delete_others_mprm_orders\";b:1;s:24:\"edit_private_mprm_orders\";b:1;s:26:\"edit_published_mprm_orders\";b:1;s:23:\"manage_mprm_order_terms\";b:1;s:21:\"edit_mprm_order_terms\";b:1;s:23:\"delete_mprm_order_terms\";b:1;s:23:\"assign_mprm_order_terms\";b:1;s:21:\"view_mprm_order_stats\";b:1;}}s:13:\"mprm_customer\";a:2:{s:4:\"name\";s:19:\"Restaurant Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:110:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;}}}', 'yes'),
(93, 'fresh_site', '0', 'yes'),
(94, 'widget_search', 'a:3:{i:3;a:1:{s:5:\"title\";s:6:\"Search\";}i:4;a:1:{s:5:\"title\";s:6:\"Search\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(95, 'widget_recent-posts', 'a:4:{i:4;a:3:{s:5:\"title\";s:12:\"Recent Posts\";s:6:\"number\";i:3;s:9:\"show_date\";b:1;}i:5;a:3:{s:5:\"title\";s:12:\"Latest Posts\";s:6:\"number\";i:3;s:9:\"show_date\";b:1;}i:6;a:3:{s:5:\"title\";s:12:\"Recent Posts\";s:6:\"number\";i:3;s:9:\"show_date\";b:1;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(96, 'widget_recent-comments', 'a:3:{i:3;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;}i:4;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:3;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(97, 'widget_archives', 'a:3:{i:2;a:3:{s:5:\"title\";s:7:\"Archive\";s:5:\"count\";i:0;s:8:\"dropdown\";i:1;}i:3;a:3:{s:5:\"title\";s:7:\"Archive\";s:5:\"count\";i:0;s:8:\"dropdown\";i:1;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(98, 'widget_meta', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(99, 'sidebars_widgets', 'a:12:{s:19:\"wp_inactive_widgets\";a:8:{i:0;s:10:\"archives-2\";i:1;s:8:\"search-3\";i:2;s:6:\"text-2\";i:3;s:12:\"categories-2\";i:4;s:14:\"recent-posts-4\";i:5;s:17:\"recent-comments-3\";i:6;s:10:\"nav_menu-2\";i:7;s:35:\"cherry_socialize_widget_instagram-2\";}s:7:\"sidebar\";a:6:{i:0;s:12:\"categories-3\";i:1;s:14:\"recent-posts-5\";i:2;s:17:\"recent-comments-4\";i:3;s:8:\"search-4\";i:4;s:10:\"archives-3\";i:5;s:11:\"tag_cloud-2\";}s:22:\"full-width-header-area\";a:0:{}s:19:\"before-content-area\";a:0:{}s:16:\"before-loop-area\";a:0:{}s:15:\"after-loop-area\";a:0:{}s:18:\"after-content-area\";a:0:{}s:29:\"after-content-full-width-area\";a:0:{}s:11:\"footer-area\";a:6:{i:0;s:6:\"text-3\";i:1;s:14:\"recent-posts-6\";i:2;s:35:\"cherry_socialize_widget_instagram-3\";i:3;s:35:\"swanxy_contact_information_widget-2\";i:4;s:10:\"nav_menu-3\";i:5;s:32:\"swanxy_widget_subscribe_follow-2\";}s:12:\"tm-mega-menu\";a:0:{}s:18:\"cherry-sidebars-32\";a:1:{i:0;s:32:\"swanxy_widget_subscribe_follow-3\";}s:13:\"array_version\";i:3;}', 'yes'),
(440, 'swanxy_sidebars', 'a:1:{s:14:\"custom_sidebar\";a:2:{s:23:\"cherry-sidebars-counter\";i:32;s:18:\"cherry-sidebars-32\";a:9:{s:4:\"name\";s:15:\"Home newsletter\";s:2:\"id\";s:18:\"cherry-sidebars-32\";s:11:\"description\";s:15:\"Home newsletter\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:37:\"<aside id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:8:\"</aside>\";s:12:\"before_title\";s:25:\"<h3 class=\"widget-title\">\";s:11:\"after_title\";s:5:\"</h3>\";s:15:\"dynamic-sidebar\";b:1;}}}', 'yes'),
(441, 'swanxy_sidbars', '', 'yes'),
(100, 'widget_pages', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(101, 'widget_calendar', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(102, 'widget_tag_cloud', 'a:3:{i:1;a:2:{s:5:\"title\";s:4:\"Tags\";s:8:\"taxonomy\";s:8:\"category\";}i:2;a:2:{s:5:\"title\";s:4:\"Tags\";s:8:\"taxonomy\";s:8:\"category\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(103, 'widget_nav_menu', 'a:3:{i:2;a:2:{s:5:\"title\";s:13:\"Special Pages\";s:8:\"nav_menu\";i:92;}i:3;a:2:{s:5:\"title\";s:13:\"Special Pages\";s:8:\"nav_menu\";i:92;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(104, 'cron', 'a:5:{i:1499305098;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1499323992;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1499348307;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1499349301;a:1:{s:24:\"tribe_common_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}', 'yes'),
(135, 'theme_mods_twentyseventeen', 'a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1494424016;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}', 'yes'),
(136, 'current_theme', 'Monstroid2', 'yes'),
(137, 'theme_mods_swanxy', 'a:244:{i:0;b:0;s:12:\"show_tagline\";b:0;s:16:\"totop_visibility\";b:1;s:14:\"page_preloader\";b:1;s:16:\"header_logo_type\";s:5:\"image\";s:15:\"header_logo_url\";s:25:\"%s/assets/images/logo.png\";s:22:\"retina_header_logo_url\";N;s:23:\"header_logo_font_family\";s:22:\"Montserrat, sans-serif\";s:22:\"header_logo_font_style\";s:6:\"normal\";s:23:\"header_logo_font_weight\";s:3:\"900\";s:21:\"header_logo_font_size\";i:20;s:25:\"header_logo_character_set\";s:5:\"latin\";s:23:\"breadcrumbs_visibillity\";b:0;s:29:\"breadcrumbs_front_visibillity\";b:0;s:22:\"breadcrumbs_page_title\";b:1;s:21:\"breadcrumbs_path_type\";s:8:\"minified\";s:19:\"header_social_links\";b:0;s:19:\"footer_social_links\";b:1;s:23:\"blog_post_share_buttons\";b:0;s:25:\"single_post_share_buttons\";b:1;s:16:\"page_layout_type\";s:9:\"fullwidth\";s:15:\"container_width\";i:1404;s:13:\"sidebar_width\";s:3:\"1/4\";s:22:\"regular_accent_color_1\";s:7:\"#0bd9fe\";s:22:\"regular_accent_color_2\";s:7:\"#0bb8fd\";s:22:\"regular_accent_color_3\";s:7:\"#5a8eee\";s:18:\"regular_text_color\";s:7:\"#8b8d9e\";s:18:\"regular_link_color\";s:7:\"#0bd9fe\";s:24:\"regular_link_hover_color\";s:7:\"#1a1b29\";s:16:\"regular_h1_color\";s:7:\"#1a1b29\";s:16:\"regular_h2_color\";s:7:\"#1a1b29\";s:16:\"regular_h3_color\";s:7:\"#1a1b29\";s:16:\"regular_h4_color\";s:7:\"#1a1b29\";s:16:\"regular_h5_color\";s:7:\"#1a1b29\";s:16:\"regular_h6_color\";s:7:\"#0bd9fe\";s:21:\"invert_accent_color_1\";s:7:\"#ffffff\";s:21:\"invert_accent_color_2\";s:7:\"#1a1b29\";s:21:\"invert_accent_color_3\";s:7:\"#ffffff\";s:17:\"invert_text_color\";s:7:\"#8b8d9e\";s:17:\"invert_link_color\";s:7:\"#5a8eee\";s:23:\"invert_link_hover_color\";s:7:\"#0bd9fe\";s:15:\"invert_h1_color\";s:7:\"#ffffff\";s:15:\"invert_h2_color\";s:7:\"#ffffff\";s:15:\"invert_h3_color\";s:7:\"#ffffff\";s:15:\"invert_h4_color\";s:7:\"#ffffff\";s:15:\"invert_h5_color\";s:7:\"#ffffff\";s:15:\"invert_h6_color\";s:7:\"#ffffff\";s:16:\"body_font_family\";s:21:\"Open Sans, sans-serif\";s:15:\"body_font_style\";s:6:\"normal\";s:16:\"body_font_weight\";s:3:\"400\";s:14:\"body_font_size\";i:16;s:16:\"body_line_height\";d:1.6875;s:19:\"body_letter_spacing\";s:1:\"0\";s:18:\"body_character_set\";s:5:\"latin\";s:15:\"body_text_align\";s:4:\"left\";s:14:\"h1_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h1_font_style\";s:6:\"normal\";s:14:\"h1_font_weight\";s:3:\"900\";s:12:\"h1_font_size\";i:144;s:14:\"h1_line_height\";s:3:\"1.1\";s:17:\"h1_letter_spacing\";d:-0.02;s:16:\"h1_character_set\";s:5:\"latin\";s:13:\"h1_text_align\";s:7:\"inherit\";s:14:\"h2_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h2_font_style\";s:6:\"normal\";s:14:\"h2_font_weight\";s:3:\"900\";s:12:\"h2_font_size\";i:40;s:14:\"h2_line_height\";d:1.1000000000000001;s:17:\"h2_letter_spacing\";s:1:\"0\";s:16:\"h2_character_set\";s:5:\"latin\";s:13:\"h2_text_align\";s:7:\"inherit\";s:14:\"h3_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h3_font_style\";s:6:\"normal\";s:14:\"h3_font_weight\";s:3:\"300\";s:12:\"h3_font_size\";i:40;s:14:\"h3_line_height\";d:1.1000000000000001;s:17:\"h3_letter_spacing\";s:1:\"0\";s:16:\"h3_character_set\";s:5:\"latin\";s:13:\"h3_text_align\";s:7:\"inherit\";s:14:\"h4_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h4_font_style\";s:6:\"normal\";s:14:\"h4_font_weight\";s:3:\"800\";s:12:\"h4_font_size\";i:24;s:14:\"h4_line_height\";d:1.4199999999999999;s:17:\"h4_letter_spacing\";s:1:\"0\";s:16:\"h4_character_set\";s:5:\"latin\";s:13:\"h4_text_align\";s:7:\"inherit\";s:14:\"h5_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h5_font_style\";s:6:\"normal\";s:14:\"h5_font_weight\";s:3:\"500\";s:12:\"h5_font_size\";i:16;s:14:\"h5_line_height\";d:1.875;s:17:\"h5_letter_spacing\";d:0.02;s:16:\"h5_character_set\";s:5:\"latin\";s:13:\"h5_text_align\";s:7:\"inherit\";s:14:\"h6_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h6_font_style\";s:6:\"normal\";s:14:\"h6_font_weight\";s:3:\"900\";s:12:\"h6_font_size\";i:14;s:14:\"h6_line_height\";d:1.9299999999999999;s:17:\"h6_letter_spacing\";d:0.80000000000000004;s:16:\"h6_character_set\";s:5:\"latin\";s:13:\"h6_text_align\";s:7:\"inherit\";s:23:\"breadcrumbs_font_family\";s:21:\"Open Sans, sans-serif\";s:22:\"breadcrumbs_font_style\";s:6:\"normal\";s:23:\"breadcrumbs_font_weight\";s:3:\"400\";s:21:\"breadcrumbs_font_size\";i:14;s:23:\"breadcrumbs_line_height\";s:3:\"1.5\";s:26:\"breadcrumbs_letter_spacing\";s:1:\"0\";s:25:\"breadcrumbs_character_set\";s:5:\"latin\";s:15:\"header_bg_color\";s:7:\"#0e0e16\";s:15:\"header_bg_image\";N;s:16:\"header_bg_repeat\";s:9:\"no-repeat\";s:20:\"header_bg_position_x\";s:6:\"center\";s:20:\"header_bg_attachment\";s:6:\"scroll\";s:18:\"header_layout_type\";s:7:\"style-3\";s:14:\"top_panel_text\";s:23:\"Premium WordPress Theme\";s:16:\"top_panel_search\";b:0;s:12:\"top_panel_bg\";s:7:\"#ffffff\";s:18:\"header_menu_sticky\";b:1;s:22:\"header_menu_attributes\";b:0;s:23:\"hidden_menu_items_title\";s:4:\"More\";s:16:\"sidebar_position\";s:9:\"fullwidth\";s:17:\"mailchimp_api_key\";s:37:\"0fabd7822dcc3cb8547dcf9109750d92-us10\";s:17:\"mailchimp_list_id\";s:10:\"2a6603b219\";s:10:\"ads_header\";s:0:\"\";s:20:\"ads_home_before_loop\";s:0:\"\";s:23:\"ads_post_before_content\";s:0:\"\";s:24:\"ads_post_before_comments\";s:0:\"\";s:15:\"footer_logo_url\";s:32:\"%s/assets/images/footer-logo.png\";s:16:\"footer_copyright\";s:32:\"%%site-name%% Theme © %%year%%.\";s:21:\"footer_widget_columns\";s:1:\"3\";s:18:\"footer_layout_type\";s:7:\"default\";s:17:\"footer_widgets_bg\";s:7:\"#171825\";s:9:\"footer_bg\";s:7:\"#0e0e16\";s:16:\"blog_layout_type\";s:7:\"default\";s:17:\"blog_sticky_label\";s:8:\"Featured\";s:18:\"blog_posts_content\";s:7:\"excerpt\";s:19:\"blog_featured_image\";s:5:\"small\";s:19:\"blog_read_more_text\";s:9:\"Read More\";s:16:\"blog_post_author\";b:1;s:22:\"blog_post_publish_date\";b:1;s:20:\"blog_post_categories\";b:1;s:14:\"blog_post_tags\";b:0;s:18:\"blog_post_comments\";b:0;s:18:\"single_post_author\";b:1;s:24:\"single_post_publish_date\";b:1;s:22:\"single_post_categories\";b:1;s:16:\"single_post_tags\";b:0;s:20:\"single_post_comments\";b:0;s:19:\"single_author_block\";b:1;s:16:\"background_color\";s:6:\"ffffff\";s:18:\"body_font_weight_2\";s:3:\"600\";s:22:\"single_post_navigation\";b:1;s:25:\"related_posts_block_title\";s:12:\"Latest Posts\";s:21:\"related_posts_visible\";b:0;s:19:\"related_posts_count\";s:1:\"2\";s:18:\"related_posts_grid\";s:1:\"2\";s:19:\"related_posts_title\";b:1;s:21:\"related_posts_content\";s:4:\"hide\";s:26:\"related_posts_title_length\";s:2:\"10\";s:28:\"related_posts_content_length\";s:2:\"25\";s:16:\"single_post_type\";s:7:\"default\";s:18:\"nav_menu_locations\";a:4:{s:6:\"social\";i:90;s:6:\"footer\";i:88;s:4:\"main\";i:89;s:3:\"top\";i:91;}s:22:\"content_container_type\";s:9:\"fullwidth\";s:21:\"header_container_type\";s:9:\"fullwidth\";s:21:\"footer_container_type\";s:9:\"fullwidth\";s:29:\"footer_widget_area_visibility\";b:1;s:19:\"footer_contact_info\";s:273:\"<div class=\\\"info-block\\\">Address: 4578 Marmora Road, Glasgow, D04 89GR</div><div class=\\\"info-block\\\">Phones: <a href=\\\"tel:#\\\">(800) 123-0045</a>; <a href=\\\"tel:#\\\">(800) 123-0046</a></div><div class=\\\"info-block\\\">E-mail: <a href=\\\"mailto:#\\\">info@demolink.org</a></div>\";s:22:\"footer_logo_visibility\";b:1;s:30:\"footer_contact_info_visibility\";b:1;s:22:\"footer_menu_visibility\";b:1;s:19:\"top_menu_visibility\";b:1;s:20:\"top_panel_visibility\";b:0;s:21:\"footer_contact_text_1\";s:36:\"4578 Marmora Road, Glasgow, D04 89GR\";s:21:\"footer_contact_text_2\";s:96:\"<a href=\"tel:(800) 123-0045\">(800) 123-0045</a>; <a href=\"tel:(800) 123-0046\">(800) 123-0046</a>\";s:21:\"footer_contact_text_3\";s:56:\"<a href=\"mailto:info@demolink.org\">info@demolink.org</a>\";s:21:\"footer_contact_icon_1\";s:0:\"\";s:21:\"footer_contact_icon_2\";s:0:\"\";s:21:\"header_contact_text_1\";s:36:\"4578 Marmora Road, Glasgow, D04 89GR\";s:21:\"header_contact_text_2\";s:96:\"<a href=\"tel:(800) 123-0045\">(800) 123-0045</a>; <a href=\"tel:(800) 123-0046\">(800) 123-0046</a>\";s:21:\"header_contact_text_3\";s:17:\"Mn-Fr: 10 am-8 pm\";s:31:\"header_contact_block_visibility\";b:0;s:15:\"header_btn_text\";s:10:\"Buy theme!\";s:13:\"header_search\";b:0;s:22:\"header_invert_logo_url\";s:32:\"%s/assets/images/invert-logo.png\";s:22:\"invert_header_logo_url\";s:32:\"%s/assets/images/invert-logo.png\";s:16:\"meta_font_family\";s:21:\"Open Sans, sans-serif\";s:15:\"meta_font_style\";s:6:\"normal\";s:16:\"meta_font_weight\";s:3:\"400\";s:14:\"meta_font_size\";i:14;s:16:\"meta_line_height\";d:1.5;s:19:\"meta_letter_spacing\";s:1:\"0\";s:18:\"meta_character_set\";s:5:\"latin\";s:16:\"blog_sticky_icon\";s:15:\"linearicon-star\";s:16:\"blog_sticky_type\";s:4:\"icon\";s:21:\"tm_pb_layouts_updated\";s:3:\"yes\";s:39:\"tm_updated_layouts_built_for_post_types\";s:3:\"yes\";s:30:\"tm_pb_predefined_layouts_added\";s:2:\"on\";s:34:\"tm_pb_predefined_layouts_version_2\";s:2:\"on\";s:18:\"header_transparent\";b:0;s:26:\"header_invert_color_scheme\";b:1;s:25:\"header_transparent_layout\";b:0;s:16:\"more_button_type\";s:4:\"text\";s:16:\"more_button_icon\";s:13:\"fa-arrow-down\";s:21:\"more_button_image_url\";s:0:\"\";s:31:\"footer_contact_block_visibility\";b:0;s:17:\"page_404_bg_color\";s:7:\"#5a8eee\";s:18:\"page_404_bg_repeat\";s:9:\"no-repeat\";s:22:\"page_404_bg_attachment\";s:6:\"scroll\";s:22:\"page_404_bg_position_x\";s:6:\"center\";s:17:\"page_404_bg_image\";s:27:\"%s/assets/images/bg_404.jpg\";s:22:\"header_contact_label_2\";s:7:\"Phones:\";s:22:\"header_contact_label_1\";s:8:\"Address:\";s:22:\"header_contact_label_3\";s:12:\"We are open:\";s:15:\"onsale_badge_bg\";s:7:\"#ff596d\";s:17:\"featured_badge_bg\";s:7:\"#ffc045\";s:12:\"new_badge_bg\";s:7:\"#000000\";s:24:\"related_posts_categories\";b:1;s:18:\"related_posts_tags\";b:1;s:27:\"related_posts_comment_count\";b:1;s:15:\"include_css_url\";s:0:\"\";s:12:\"skin_css_url\";s:0:\"\";s:10:\"skin_style\";s:6:\"skin16\";s:19:\"header_woo_elements\";b:1;s:14:\"header_btn_url\";s:1:\"#\";s:21:\"header_btn_visibility\";b:0;s:21:\"header_contact_icon_1\";s:21:\"linearicon-map-marker\";s:21:\"header_contact_icon_2\";s:20:\"linearicon-telephone\";s:21:\"header_contact_icon_3\";s:17:\"linearicon-clock3\";s:16:\"more_button_text\";s:4:\"More\";s:28:\"retina_more_button_image_url\";N;s:22:\"footer_contact_label_1\";s:8:\"Address:\";s:22:\"footer_contact_label_2\";s:7:\"Phones:\";s:21:\"footer_contact_icon_3\";s:0:\"\";s:22:\"footer_contact_label_3\";s:7:\"E-mail:\";s:19:\"related_posts_image\";b:1;s:20:\"related_posts_author\";b:1;s:26:\"related_posts_publish_date\";b:1;s:18:\"woo_column_numbers\";s:1:\"4\";s:29:\"invert_retina_header_logo_url\";b:0;s:16:\"gradient_color_1\";b:0;s:16:\"gradient_color_2\";b:0;s:18:\"custom_css_post_id\";i:-1;}', 'yes'),
(138, 'theme_switched', '', 'yes'),
(139, 'widget_swanxy_widget_about', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(140, 'widget_swanxy_widget_about_author', 'a:2:{i:1;a:6:{s:5:\"title\";s:5:\"About\";s:7:\"user_id\";s:1:\"1\";s:11:\"avatar_size\";s:1:\"0\";s:10:\"avatar_img\";s:0:\"\";s:4:\"link\";s:1:\"#\";s:9:\"link_text\";s:9:\"Read More\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(141, 'widget_swanxy_widget_banner', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(142, 'widget_swanxy_widget_carousel', 'a:2:{i:1;a:17:{s:5:\"title\";s:0:\"\";s:10:\"terms_type\";s:8:\"category\";s:14:\"posts_per_page\";s:2:\"10\";s:10:\"post_title\";s:4:\"true\";s:7:\"content\";s:4:\"true\";s:11:\"more_button\";s:4:\"true\";s:16:\"more_button_text\";s:9:\"Read more\";s:10:\"trim_words\";s:2:\"10\";s:15:\"slides_per_view\";s:1:\"3\";s:16:\"slides_per_group\";s:1:\"3\";s:17:\"slides_per_column\";s:1:\"1\";s:20:\"space_between_slides\";s:2:\"50\";s:14:\"duration_speed\";s:3:\"500\";s:10:\"navigation\";s:4:\"true\";s:10:\"pagination\";s:4:\"true\";s:10:\"categories\";a:1:{i:0;s:17:\"shortcode-central\";}s:10:\"trim_title\";s:2:\"30\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(197, 'bp-deactivated-components', 'a:0:{}', 'yes'),
(198, 'bb-config-location', 'E:\\Wamp\\www\\tm\\2017\\reflax/bb-config.php', 'yes'),
(133, 'auto_core_update_notified', 'a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:7:\"m@m.com\";s:7:\"version\";s:5:\"4.7.5\";s:9:\"timestamp\";i:1495015419;}', 'no'),
(115, 'can_compress_scripts', '1', 'no'),
(874, 'WPLANG', '', 'yes'),
(1130, '_site_transient_update_core', 'O:8:\"stdClass\":4:{s:7:\"updates\";a:2:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.8.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.8.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-4.8-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.8-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"4.8\";s:7:\"version\";s:3:\"4.8\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.8.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:57:\"https://downloads.wordpress.org/release/wordpress-4.8.zip\";s:10:\"no_content\";s:68:\"https://downloads.wordpress.org/release/wordpress-4.8-no-content.zip\";s:11:\"new_bundled\";s:69:\"https://downloads.wordpress.org/release/wordpress-4.8-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:3:\"4.8\";s:7:\"version\";s:3:\"4.8\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1499263984;s:15:\"version_checked\";s:5:\"4.7.5\";s:12:\"translations\";a:0:{}}', 'no'),
(1318, 'ewww_image_optimizer_bulk_attachments', '', 'no'),
(1319, 'ewww_image_optimizer_flag_attachments', '', 'no'),
(1320, 'ewww_image_optimizer_ngg_attachments', '', 'no'),
(1321, 'ewww_image_optimizer_disable_pngout', '1', 'no'),
(1322, 'ewww_image_optimizer_optipng_level', '2', 'no'),
(1323, 'ewww_image_optimizer_pngout_level', '2', 'no'),
(1324, 'ewww_image_optimizer_jpegtran_copy', '1', 'no'),
(1325, 'ewww_image_optimizer_jpg_level', '10', 'no'),
(1326, 'ewww_image_optimizer_png_level', '10', 'no'),
(1327, 'ewww_image_optimizer_gif_level', '10', 'no'),
(1328, 'ewww_image_optimizer_pdf_level', '0', 'no'),
(1329, 'ewww_image_optimizer_version', '331.0', 'yes'),
(1339, 'wp_ewwwio_media_optimize_batch_b', '', 'no'),
(1597, 'tm_builder_settings', 'a:2:{s:7:\"api_key\";s:39:\"AIzaSyC7bPvtKHcYRjpG5h34SalSbpMrAV64pFA\";s:18:\"allowed_post_types\";a:6:{s:4:\"post\";s:4:\"true\";s:4:\"page\";s:4:\"true\";s:8:\"projects\";s:5:\"false\";s:4:\"team\";s:5:\"false\";s:15:\"cherry-services\";s:5:\"false\";s:15:\"tm-testimonials\";s:5:\"false\";}}', 'yes'),
(1413, 'ewww_image_optimizer_bulk_resume', '', 'yes'),
(1416, 'ewww_image_optimizer_aux_resume', '', 'yes'),
(1417, 'ewww_image_optimizer_aux_folders_completed', 'a:0:{}', 'no'),
(788, 'cherry_socialize_instagram_widget_cache_keys', 'a:3:{s:35:\"cherry_socialize_widget_instagram-2\";s:37:\"tlc__e41030a185223ba1692ede96a4ccb9be\";s:35:\"cherry_socialize_widget_instagram-3\";s:37:\"tlc__e41030a185223ba1692ede96a4ccb9be\";s:35:\"cherry_socialize_widget_instagram-5\";s:37:\"tlc__135d0095bf57197e937e46da3e6edfff\";}', 'yes'),
(1648, '_transient_timeout_tlc__e41030a185223ba1692ede96a4ccb9be', '1530801424', 'no'),
(1649, '_transient_tlc__e41030a185223ba1692ede96a4ccb9be', 'a:2:{i:0;i:1499265424;i:1;a:2:{s:9:\"widget_id\";s:35:\"cherry_socialize_widget_instagram-3\";s:6:\"photos\";a:6:{i:0;a:4:{s:4:\"link\";s:11:\"BUY4g21FZy5\";s:5:\"image\";s:122:\"https://instagram.fhen1-1.fna.fbcdn.net/t51.2885-15/s640x640/sh0.08/e35/18581348_210327562812998_3307108565763751936_n.jpg\";s:4:\"date\";s:10:\"1495443583\";s:7:\"caption\";s:18:\"#62222_ref&hellip;\";}i:1;a:4:{s:4:\"link\";s:11:\"BUY4e1XFwRP\";s:5:\"image\";s:123:\"https://instagram.fhen1-1.fna.fbcdn.net/t51.2885-15/s640x640/sh0.08/e35/18645893_1521596341245157_4492352864663896064_n.jpg\";s:4:\"date\";s:10:\"1495443567\";s:7:\"caption\";s:18:\"#62222_ref&hellip;\";}i:2;a:4:{s:4:\"link\";s:11:\"BUY4cPGFlC3\";s:5:\"image\";s:122:\"https://instagram.fhen1-1.fna.fbcdn.net/t51.2885-15/s640x640/sh0.08/e35/18580308_216469738870121_3086780840877752320_n.jpg\";s:4:\"date\";s:10:\"1495443545\";s:7:\"caption\";s:18:\"#62222_ref&hellip;\";}i:3;a:4:{s:4:\"link\";s:11:\"BUY4aBAl1KS\";s:5:\"image\";s:122:\"https://instagram.fhen1-1.fna.fbcdn.net/t51.2885-15/s640x640/sh0.08/e35/18645105_280880559040339_3555810631313522688_n.jpg\";s:4:\"date\";s:10:\"1495443527\";s:7:\"caption\";s:18:\"#62222_ref&hellip;\";}i:4;a:4:{s:4:\"link\";s:11:\"BUY4XfflyMm\";s:5:\"image\";s:122:\"https://instagram.fhen1-1.fna.fbcdn.net/t51.2885-15/s640x640/sh0.08/e35/18580227_223716604798598_6564665221955190784_n.jpg\";s:4:\"date\";s:10:\"1495443507\";s:7:\"caption\";s:18:\"#62222_ref&hellip;\";}i:5;a:4:{s:4:\"link\";s:11:\"BUY4VHfFyIy\";s:5:\"image\";s:123:\"https://instagram.fhen1-1.fna.fbcdn.net/t51.2885-15/s640x640/sh0.08/e35/18645686_1399748713444788_6691222854307938304_n.jpg\";s:4:\"date\";s:10:\"1495443487\";s:7:\"caption\";s:18:\"#62222_ref&hellip;\";}}}}', 'no'),
(2667, '_transient_timeout_plugin_slugs', '1499350527', 'no'),
(2668, '_transient_plugin_slugs', 'a:13:{i:0;s:19:\"akismet/akismet.php\";i:1;s:45:\"cherry-data-importer/cherry-data-importer.php\";i:2;s:35:\"cherry-projects/cherry-projects.php\";i:3;s:45:\"cherry-services-list/cherry-services-list.php\";i:4;s:35:\"cherry-sidebars/cherry-sidebars.php\";i:5;s:37:\"cherry-socialize/cherry-socialize.php\";i:6;s:43:\"cherry-team-members/cherry-team-members.php\";i:7;s:29:\"cherry-testi/testimonials.php\";i:8;s:9:\"hello.php\";i:9;s:47:\"rvg-optimize-database/rvg-optimize-database.php\";i:10;s:53:\"power-builder-integrator/power-builder-integrator.php\";i:11;s:35:\"power-builder/power-builder-upd.php\";i:12;s:29:\"tm-mega-menu/tm-mega-menu.php\";}', 'no'),
(2665, '_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109', '1499299625', 'no'),
(2666, '_transient_feed_mod_b9388c83948825c1edaef0d856b7b109', '1499256425', 'no'),
(2669, '_transient_timeout_dash_88ae138922fe95674369b1cb3d215a2b', '1499299625', 'no'),
(2670, '_transient_dash_88ae138922fe95674369b1cb3d215a2b', '<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2017/07/the-month-in-wordpress-june-2017/\'>The Month in WordPress: June 2017</a> <span class=\"rss-date\">Jul. 3, 2017</span><div class=\"rssSummary\">We’re starting a new regular feature on this blog today. We’d like to keep everyone up-to-date about the happenings all across the WordPress open source project and highlight how you can get involved, so we’ll be posting a roundup of all the major WordPress news at the end of every month. Aside from other general [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/wordcamp-europe-2017-posts-24-no-show-rate-cites-early-ticket-sales-and-expensive-location\'>WPTavern: WordCamp Europe 2017 Posts 24% No-Show Rate, Cites Early Ticket Sales and Expensive Location</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2017/07/the-month-in-wordpress-june-2017/\'>Dev Blog: The Month in WordPress: June 2017</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/gutenberg-contributors-explore-adding-drag-and-drop-and-multi-column-support-for-blocks\'>WPTavern: Gutenberg Contributors Explore Adding Drag-and-Drop and Multi-Column Support for Blocks</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\"dashboard-news-plugin\"><span>Popular Plugin:</span> WooCommerce&nbsp;<a href=\"plugin-install.php?tab=plugin-information&amp;plugin=woocommerce&amp;_wpnonce=e825cb4705&amp;TB_iframe=true&amp;width=600&amp;height=800\" class=\"thickbox open-plugin-details-modal\" aria-label=\"Install WooCommerce\">(Install)</a></li></ul></div>', 'no'),
(2699, '_transient_is_multi_author', '0', 'yes'),
(2663, '_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109', '1499299625', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(2664, '_transient_feed_b9388c83948825c1edaef0d856b7b109', 'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Popular — WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wordpress.org/plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Plugins extend and expand the functionality of WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Jul 2017 11:59:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.9-alpha-40964\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/contact-form-7/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:43:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins-wp/contact-form-7/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5025:\"<p><!--section=description--></p>\n<p>Contact Form 7 can manage multiple contact forms, plus you can customize the form and the mail contents flexibly with simple markup. The form supports Ajax-powered submitting, CAPTCHA, Akismet spam filtering and so on.</p>\n<h4>Docs &amp; Support</h4>\n<p>You can find <a href=\"https://contactform7.com/docs/\" rel=\"nofollow\">docs</a>, <a href=\"https://contactform7.com/faq/\" rel=\"nofollow\">FAQ</a> and more detailed information about Contact Form 7 on <a href=\"https://contactform7.com/\" rel=\"nofollow\">contactform7.com</a>. If you were unable to find the answer to your question on the FAQ or in any of the documentation, you should check the <a href=\"https://wordpress.org/support/plugin/contact-form-7/\" rel=\"nofollow\">support forum</a> on WordPress.org. If you can&#8217;t locate any topics that pertain to your particular issue, post a new topic for it.</p>\n<h4>Contact Form 7 Needs Your Support</h4>\n<p>It is hard to continue development and support for this free plugin without contributions from users like you. If you enjoy using Contact Form 7 and find it useful, please consider <a href=\"https://contactform7.com/donate/\" rel=\"nofollow\"><strong>making a donation</strong></a>. Your donation will help encourage and support the plugin&#8217;s continued development and better user support.</p>\n<h4>Recommended Plugins</h4>\n<p>The following plugins are recommended for Contact Form 7 users:</p>\n<ul>\n<li><a href=\"https://wordpress.org/plugins/flamingo/\">Flamingo</a> by Takayuki Miyoshi &#8211; With Flamingo, you can save submitted messages via contact forms in the database.</li>\n<li><a href=\"https://wordpress.org/plugins/postman-smtp/\">Postman</a> by<br />\nJason Hendriks &#8211; Postman is a next-generation SMTP Mailer, software that assists in the delivery of email generated by your WordPress site.</li>\n<li><a href=\"https://wordpress.org/plugins/bogo/\">Bogo</a> by Takayuki Miyoshi &#8211; Bogo is a straight-forward multilingual plugin that doesn&#8217;t cause headaches.</li>\n</ul>\n<h4>Translations</h4>\n<p>You can <a href=\"https://contactform7.com/translating-contact-form-7/\" rel=\"nofollow\">translate Contact Form 7</a> on <a href=\"https://translate.wordpress.org/projects/wp-plugins/contact-form-7\" rel=\"nofollow\"><strong>translate.wordpress.org</strong></a>.</p>\n<p><!--section=installation--></p>\n<ol>\n<li>Upload the entire <code>contact-form-7</code> folder to the <code>/wp-content/plugins/</code> directory.</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress.</li>\n</ol>\n<p>You will find &#8216;Contact&#8217; menu in your WordPress admin panel.</p>\n<p>For basic usage, you can also have a look at the <a href=\"https://contactform7.com/\" rel=\"nofollow\">plugin web site</a>.</p>\n<p><!--section=faq--></p>\n<p>Do you have questions or issues with Contact Form 7? Use these support channels appropriately.</p>\n<ol>\n<li><a href=\"https://contactform7.com/docs/\" rel=\"nofollow\">Docs</a></li>\n<li><a href=\"https://contactform7.com/faq/\" rel=\"nofollow\">FAQ</a></li>\n<li><a href=\"https://wordpress.org/support/plugin/contact-form-7/\" rel=\"nofollow\">Support Forum</a></li>\n</ol>\n<p><a href=\"https://contactform7.com/support/\" rel=\"nofollow\">Support</a></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<ol>\n<li>Upload the entire <code>contact-form-7</code> folder to the <code>/wp-content/plugins/</code> directory.</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress.</li>\n</ol>\n<p>You will find &#8216;Contact&#8217; menu in your WordPress admin panel.</p>\n<p>For basic usage, you can also have a look at the <a href=\"https://contactform7.com/\" rel=\"nofollow\">plugin web site</a>.</p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<p>For more information, see <a href=\"https://contactform7.com/category/releases/\" rel=\"nofollow\">Releases</a>.</p>\n<h4>4.8</h4>\n<ul>\n<li>Stopped using jquery.form.js.</li>\n<li>Added custom REST API endpoints for Ajax form submissions.</li>\n<li>WPCF7_FormTag class implements ArrayAccess interface.</li>\n<li>WPCF7_FormTagsManager::filter() filters form-tags based on features they support.</li>\n<li>New form-tag features: do-not-store, display-block, and display-hidden</li>\n<li>Removed inappropriate content from h1 headings.</li>\n<li>Added the support of size:invisible option to the reCAPTCHA form-tag.</li>\n</ul>\n<h4>4.7</h4>\n<ul>\n<li>Added REST API custom endpoints to manipulate contact form data.</li>\n<li>Config Validator: Added test items for field names and attachment file paths.</li>\n<li>Added custom DOM events: <code>wpcf7invalid</code>, <code>wpcf7spam</code>, <code>wpcf7mailsent</code>, <code>wpcf7mailfailed</code> and <code>wpcf7submit</code>.</li>\n<li>New action hook: <code>wpcf7_after_flamingo</code>.</li>\n<li>Added <code>size</code> option to <code>select</code> and <code>select*</code> form-tag types.</li>\n<li>Made it possible to use the 3rd parameter of <code>wpcf7_add_form_tag()</code> to specify &#8220;features&#8221; of the form-tag type.</li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/plugins/contact-form-7/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/plugins/akismet/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Oct 2005 08:57:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/plugins-wp/akismet/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Akismet checks your comments and contact form submissions against our global database of spam to&#8230;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:18320:\"<p><!--section=description--></p>\n<p>Akismet checks your comments and contact form submissions against our global database of spam to prevent your site from publishing malicious content. You can review the comment spam it catches on your blog&#8217;s &#8220;Comments&#8221; admin screen.</p>\n<p>Major features in Akismet include:</p>\n<ul>\n<li>Automatically checks all comments and filters out the ones that look like spam.</li>\n<li>Each comment has a status history, so you can easily see which comments were caught or cleared by Akismet and which were spammed or unspammed by a moderator.</li>\n<li>URLs are shown in the comment body to reveal hidden or misleading links.</li>\n<li>Moderators can see the number of approved comments for each user.</li>\n<li>A discard feature that outright blocks the worst spam, saving you disk space and speeding up your site.</li>\n</ul>\n<p>PS: You&#8217;ll need an <a href=\"https://akismet.com/get/\" rel=\"nofollow\">Akismet.com API key</a> to use it.  Keys are free for personal blogs; paid subscriptions are available for businesses and commercial sites.</p>\n<p><!--section=installation--></p>\n<p>Upload the Akismet plugin to your blog, Activate it, then enter your <a href=\"https://akismet.com/get/\" rel=\"nofollow\">Akismet.com API key</a>.</p>\n<p>1, 2, 3: You&#8217;re done!</p>\n<p><!--section=changelog--></p>\n<h4>3.3.2</h4>\n<p><em>Release Date &#8211; 10 May 2017</em></p>\n<ul>\n<li>Fixed a bug causing JavaScript errors in some browsers.</li>\n</ul>\n<h4>3.3.1</h4>\n<p><em>Release Date &#8211; 2 May 2017</em></p>\n<ul>\n<li>Improve performance by only requesting the akismet_comment_nonce option when absolutely necessary.</li>\n<li>Fixed two bugs that could cause PHP warnings.</li>\n<li>Fixed a bug that was preventing the &#8220;Remove author URL&#8221; feature from working after a comment was edited using &#8220;Quick Edit.&#8221;</li>\n<li>Fixed a bug that was preventing the URL preview feature from working after a comment was edited using &#8220;Quick Edit.&#8221;</li>\n</ul>\n<h4>3.3</h4>\n<p><em>Release Date &#8211; 23 February 2017</em></p>\n<ul>\n<li>Updated the Akismet admin pages with a new clean design.</li>\n<li>Fixed bugs preventing the <code>akismet_add_comment_nonce</code> and <code>akismet_update_alert</code> wrapper functions from working properly.</li>\n<li>Fixed bug preventing the loading indicator from appearing when re-checking all comments for spam.</li>\n<li>Added a progress indicator to the &#8220;Check for Spam&#8221; button.</li>\n<li>Added a success message after manually rechecking the Pending queue for spam.</li>\n</ul>\n<h4>3.2</h4>\n<p><em>Release Date &#8211; 6 September 2016</em></p>\n<ul>\n<li>Added a WP-CLI module. You can now check comments and recheck the moderation queue from the command line.</li>\n<li>Stopped using the deprecated jQuery function <code>.live()</code>.</li>\n<li>Fixed a bug in <code>remove_comment_author_url()</code> and <code>add_comment_author_url()</code> that could generate PHP notices.</li>\n<li>Fixed a bug that could cause an infinite loop for sites with very very very large comment IDs.</li>\n<li>Fixed a bug that could cause the Akismet widget title to be blank.</li>\n</ul>\n<h4>3.1.11</h4>\n<p><em>Release Date &#8211; 12 May 2016</em></p>\n<ul>\n<li>Fixed a bug that could cause the &#8220;Check for Spam&#8221; button to skip some comments.</li>\n<li>Fixed a bug that could prevent some spam submissions from being sent to Akismet.</li>\n<li>Updated all links to use https:// when possible.</li>\n<li>Disabled Akismet debug logging unless WP_DEBUG and WP_DEBUG_LOG are both enabled.</li>\n</ul>\n<h4>3.1.10</h4>\n<p><em>Release Date &#8211; 1 April 2016</em></p>\n<ul>\n<li>Fixed a bug that could cause comments caught as spam to be placed in the Pending queue.</li>\n<li>Fixed a bug that could have resulted in comments that were caught by the core WordPress comment blacklist not to have a corresponding History entry.</li>\n<li>Fixed a bug that could have caused avoidable PHP warnings in the error log.</li>\n</ul>\n<h4>3.1.9</h4>\n<p><em>Release Date &#8211; 28 March 2016</em></p>\n<ul>\n<li>Add compatibility with Jetpack so that Jetpack can automatically configure Akismet settings when appropriate.</li>\n<li>Fixed a bug preventing some comment data from being sent to Akismet.</li>\n</ul>\n<h4>3.1.8</h4>\n<p><em>Release Date &#8211; 4 March 2016</em></p>\n<ul>\n<li>Fixed a bug preventing Akismet from being used with some plugins that rewrite admin URLs.</li>\n<li>Reduced the amount of bandwidth used on Akismet API calls</li>\n<li>Reduced the amount of space Akismet uses in the database</li>\n<li>Fixed a bug that could cause comments caught as spam to be placed in the Pending queue.</li>\n</ul>\n<h4>3.1.7</h4>\n<p><em>Release Date &#8211; 4 January 2016</em></p>\n<ul>\n<li>Added documentation for the &#8216;akismet_comment_nonce&#8217; filter.</li>\n<li>The post-install activation button is now accessible to screen readers and keyboard-only users.</li>\n<li>Fixed a bug that was preventing the &#8220;Remove author URL&#8221; feature from working in WordPress 4.4</li>\n</ul>\n<h4>3.1.6</h4>\n<p><em>Release Date &#8211; 14 December 2015</em></p>\n<ul>\n<li>Improve the notices shown after activating Akismet.</li>\n<li>Update some strings to allow for the proper plural forms in all languages.</li>\n</ul>\n<h4>3.1.5</h4>\n<p><em>Release Date &#8211; 13 October 2015</em></p>\n<ul>\n<li>Closes a potential XSS vulnerability.</li>\n</ul>\n<h4>3.1.4</h4>\n<p><em>Release Date &#8211; 24 September 2015</em></p>\n<ul>\n<li>Fixed a bug that was preventing some users from automatically connecting using Jetpack if they didn&#8217;t have a current Akismet subscription.</li>\n<li>Fixed a bug that could cause comments caught as spam to be placed in the Pending queue.</li>\n<li>Error messages and instructions have been simplified to be more understandable.</li>\n<li>Link previews are enabled for all links inside comments, not just the author&#8217;s website link.</li>\n</ul>\n<h4>3.1.3</h4>\n<p><em>Release Date &#8211; 6 July 2015</em></p>\n<ul>\n<li>Notify users when their account status changes after previously being successfully set up. This should help any users who are seeing blank Akismet settings screens.</li>\n</ul>\n<h4>3.1.2</h4>\n<p><em>Release Date &#8211; 7 June 2015</em></p>\n<ul>\n<li>Reduced the amount of space Akismet uses in the commentmeta table.</li>\n<li>Fixed a bug where some comments with quotes in the author name weren&#8217;t getting history entries</li>\n<li>Pre-emptive security improvements to ensure that the Akismet plugin can&#8217;t be used by attackers to compromise a WordPress installation.</li>\n<li>Better UI for the key entry field: allow whitespace to be included at the beginning or end of the key and strip it out automatically when the form is submitted.</li>\n<li>When deactivating the plugin, notify the Akismet API so the site can be marked as inactive.</li>\n<li>Clearer error messages.</li>\n</ul>\n<h4>3.1.1</h4>\n<p><em>Release Date &#8211; 17th March, 2015</em></p>\n<ul>\n<li>Improvements to the &#8220;Remove comment author URL&#8221; JavaScript</li>\n<li>Include the pingback pre-check from the 2.6 branch.</li>\n</ul>\n<h4>3.1</h4>\n<p><em>Release Date &#8211; 11th March, 2015</em></p>\n<ul>\n<li>Use HTTPS by default for all requests to Akismet.</li>\n<li>Fix for a situation where Akismet might strip HTML from a comment.</li>\n</ul>\n<h4>3.0.4</h4>\n<p><em>Release Date &#8211; 11th December, 2014</em></p>\n<ul>\n<li>Fix to make .htaccess compatible with Apache 2.4.</li>\n<li>Fix to allow removal of https author URLs.</li>\n<li>Fix to avoid stripping part of the author URL when removing and re-adding.</li>\n<li>Removed the &#8220;Check for Spam&#8221; button from the &#8220;Trash&#8221; and &#8220;Approved&#8221; queues, where it would have no effect.</li>\n<li>Allow automatic API key configuration when Jetpack is installed and connected to a WordPress.com account</li>\n</ul>\n<h4>3.0.3</h4>\n<p><em>Release Date &#8211; 3rd November, 2014</em></p>\n<ul>\n<li>Fix for sending the wrong data to delete_comment action that could have prevented old spam comments from being deleted.</li>\n<li>Added a filter to disable logging of Akismet debugging information.</li>\n<li>Added a filter for the maximum comment age when deleting old spam comments.</li>\n<li>Added a filter for the number per batch when deleting old spam comments.</li>\n<li>Removed the &#8220;Check for Spam&#8221; button from the Spam folder.</li>\n</ul>\n<h4>3.0.2</h4>\n<p><em>Release Date &#8211; 18th August, 2014</em></p>\n<ul>\n<li>Performance improvements.</li>\n<li>Fixed a bug that could truncate the comment data being sent to Akismet for checking.</li>\n</ul>\n<h4>3.0.1</h4>\n<p><em>Release Date &#8211; 9th July, 2014</em></p>\n<ul>\n<li>Removed dependency on PHP&#8217;s fsockopen function</li>\n<li>Fix spam/ham reports to work when reported outside of the WP dashboard, e.g., from Notifications or the WP app</li>\n<li>Remove jQuery dependency for comment form JavaScript</li>\n<li>Remove unnecessary data from some Akismet comment meta</li>\n<li>Suspended keys will now result in all comments being put in moderation, not spam.</li>\n</ul>\n<h4>3.0.0</h4>\n<p><em>Release Date &#8211; 15th April, 2014</em></p>\n<ul>\n<li>Move Akismet to Settings menu</li>\n<li>Drop Akismet Stats menu</li>\n<li>Add stats snapshot to Akismet settings</li>\n<li>Add Akismet subscription details and status to Akismet settings</li>\n<li>Add contextual help for each page</li>\n<li>Improve Akismet setup to use Jetpack to automate plugin setup</li>\n<li>Fix &#8220;Check for Spam&#8221; to use AJAX to avoid page timing out</li>\n<li>Fix Akismet settings page to be responsive</li>\n<li>Drop legacy code</li>\n<li>Tidy up CSS and Javascript</li>\n<li>Replace the old discard setting with a new &#8220;discard pervasive spam&#8221; feature.</li>\n</ul>\n<h4>2.6.0</h4>\n<p><em>Release Date &#8211; 18th March, 2014</em></p>\n<ul>\n<li>Add ajax paging to the check for spam button to handle large volumes of comments</li>\n<li>Optimize javascript and add localization support </li>\n<li>Fix bug in link to spam comments from right now dashboard widget</li>\n<li>Fix bug with deleting old comments to avoid timeouts dealing with large volumes of comments</li>\n<li>Include X-Pingback-Forwarded-For header in outbound WordPress pingback verifications</li>\n<li>Add pre-check for pingbacks, to stop spam before an outbound verification request is made</li>\n</ul>\n<h4>2.5.9</h4>\n<p><em>Release Date &#8211; 1st August, 2013</em></p>\n<ul>\n<li>Update &#8216;Already have a key&#8217; link to redirect page rather than depend on javascript</li>\n<li>Fix some non-translatable strings to be translatable</li>\n<li>Update Activation banner in plugins page to redirect user to Akismet config page</li>\n</ul>\n<h4>2.5.8</h4>\n<p><em>Release Date &#8211; 20th January, 2013</em></p>\n<ul>\n<li>Simplify the activation process for new users</li>\n<li>Remove the reporter_ip parameter</li>\n<li>Minor preventative security improvements</li>\n</ul>\n<h4>2.5.7</h4>\n<p><em>Release Date &#8211; 13th December, 2012</em></p>\n<ul>\n<li>FireFox Stats iframe preview bug</li>\n<li>Fix mshots preview when using https</li>\n<li>Add .htaccess to block direct access to files</li>\n<li>Prevent some PHP notices</li>\n<li>Fix Check For Spam return location when referrer is empty</li>\n<li>Fix Settings links for network admins</li>\n<li>Fix prepare() warnings in WP 3.5</li>\n</ul>\n<h4>2.5.6</h4>\n<p><em>Release Date &#8211; 26th April, 2012</em></p>\n<ul>\n<li>Prevent retry scheduling problems on sites where wp_cron is misbehaving</li>\n<li>Preload mshot previews</li>\n<li>Modernize the widget code</li>\n<li>Fix a bug where comments were not held for moderation during an error condition</li>\n<li>Improve the UX and display when comments are temporarily held due to an error</li>\n<li>Make the Check For Spam button force a retry when comments are held due to an error</li>\n<li>Handle errors caused by an invalid key</li>\n<li>Don&#8217;t retry comments that are too old</li>\n<li>Improve error messages when verifying an API key</li>\n</ul>\n<h4>2.5.5</h4>\n<p><em>Release Date &#8211; 11th January, 2012</em></p>\n<ul>\n<li>Add nonce check for comment author URL remove action</li>\n<li>Fix the settings link</li>\n</ul>\n<h4>2.5.4</h4>\n<p><em>Release Date &#8211; 5th January, 2012</em></p>\n<ul>\n<li>Limit Akismet CSS and Javascript loading in wp-admin to just the pages that need it</li>\n<li>Added author URL quick removal functionality</li>\n<li>Added mShot preview on Author URL hover</li>\n<li>Added empty index.php to prevent directory listing</li>\n<li>Move wp-admin menu items under Jetpack, if it is installed</li>\n<li>Purge old Akismet comment meta data, default of 15 days</li>\n</ul>\n<h4>2.5.3</h4>\n<p><em>Release Date &#8211; 8th Febuary, 2011</em></p>\n<ul>\n<li>Specify the license is GPL v2 or later</li>\n<li>Fix a bug that could result in orphaned commentmeta entries</li>\n<li>Include hotfix for WordPress 3.0.5 filter issue</li>\n</ul>\n<h4>2.5.2</h4>\n<p><em>Release Date &#8211; 14th January, 2011</em></p>\n<ul>\n<li>Properly format the comment count for author counts</li>\n<li>Look for super admins on multisite installs when looking up user roles</li>\n<li>Increase the HTTP request timeout</li>\n<li>Removed padding for author approved count</li>\n<li>Fix typo in function name</li>\n<li>Set Akismet stats iframe height to fixed 2500px.  Better to have one tall scroll bar than two side by side.</li>\n</ul>\n<h4>2.5.1</h4>\n<p><em>Release Date &#8211; 17th December, 2010</em></p>\n<ul>\n<li>Fix a bug that caused the &#8220;Auto delete&#8221; option to fail to discard comments correctly</li>\n<li>Remove the comment nonce form field from the &#8216;Akismet Configuration&#8217; page in favor of using a filter, akismet_comment_nonce</li>\n<li>Fixed padding bug in &#8220;author&#8221; column of posts screen</li>\n<li>Added margin-top to &#8220;cleared by &#8230;&#8221; badges on dashboard</li>\n<li>Fix possible error when calling akismet_cron_recheck()</li>\n<li>Fix more PHP warnings</li>\n<li>Clean up XHTML warnings for comment nonce</li>\n<li>Fix for possible condition where scheduled comment re-checks could get stuck</li>\n<li>Clean up the comment meta details after deleting a comment</li>\n<li>Only show the status badge if the comment status has been changed by someone/something other than Akismet</li>\n<li>Show a &#8216;History&#8217; link in the row-actions</li>\n<li>Translation fixes</li>\n<li>Reduced font-size on author name</li>\n<li>Moved &#8220;flagged by&#8230;&#8221; notification to top right corner of comment container and removed heavy styling</li>\n<li>Hid &#8220;flagged by&#8230;&#8221; notification while on dashboard</li>\n</ul>\n<h4>2.5.0</h4>\n<p><em>Release Date &#8211; 7th December, 2010</em></p>\n<ul>\n<li>Track comment actions under &#8216;Akismet Status&#8217; on the edit comment screen</li>\n<li>Fix a few remaining deprecated function calls ( props Mike Glendinning ) </li>\n<li>Use HTTPS for the stats IFRAME when wp-admin is using HTTPS</li>\n<li>Use the WordPress HTTP class if available</li>\n<li>Move the admin UI code to a separate file, only loaded when needed</li>\n<li>Add cron retry feature, to replace the old connectivity check</li>\n<li>Display Akismet status badge beside each comment</li>\n<li>Record history for each comment, and display it on the edit page</li>\n<li>Record the complete comment as originally submitted in comment_meta, to use when reporting spam and ham</li>\n<li>Highlight links in comment content</li>\n<li>New option, &#8220;Show the number of comments you&#8217;ve approved beside each comment author.&#8221;</li>\n<li>New option, &#8220;Use a nonce on the comment form.&#8221;</li>\n</ul>\n<h4>2.4.0</h4>\n<p><em>Release Date &#8211; 23rd August, 2010</em></p>\n<ul>\n<li>Spell out that the license is GPLv2</li>\n<li>Fix PHP warnings</li>\n<li>Fix WordPress deprecated function calls</li>\n<li>Fire the delete_comment action when deleting comments</li>\n<li>Move code specific for older WP versions to legacy.php</li>\n<li>General code clean up</li>\n</ul>\n<h4>2.3.0</h4>\n<p><em>Release Date &#8211; 5th June, 2010</em></p>\n<ul>\n<li>Fix &#8220;Are you sure&#8221; nonce message on config screen in WPMU</li>\n<li>Fix XHTML compliance issue in sidebar widget</li>\n<li>Change author link; remove some old references to WordPress.com accounts</li>\n<li>Localize the widget title (core ticket #13879)</li>\n</ul>\n<h4>2.2.9</h4>\n<p><em>Release Date &#8211; 2nd June, 2010</em></p>\n<ul>\n<li>Eliminate a potential conflict with some plugins that may cause spurious reports</li>\n</ul>\n<h4>2.2.8</h4>\n<p><em>Release Date &#8211; 27th May, 2010</em></p>\n<ul>\n<li>Fix bug in initial comment check for ipv6 addresses</li>\n<li>Report comments as ham when they are moved from spam to moderation</li>\n<li>Report comments as ham when clicking undo after spam</li>\n<li>Use transition_comment_status action when available instead of older actions for spam/ham submissions</li>\n<li>Better diagnostic messages when PHP network functions are unavailable</li>\n<li>Better handling of comments by logged-in users</li>\n</ul>\n<h4>2.2.7</h4>\n<p><em>Release Date &#8211; 17th December, 2009</em></p>\n<ul>\n<li>Add a new AKISMET_VERSION constant</li>\n<li>Reduce the possibility of over-counting spam when another spam filter plugin is in use</li>\n<li>Disable the connectivity check when the API key is hard-coded for WPMU</li>\n</ul>\n<h4>2.2.6</h4>\n<p><em>Release Date &#8211; 20th July, 2009</em></p>\n<ul>\n<li>Fix a global warning introduced in 2.2.5</li>\n<li>Add changelog and additional readme.txt tags</li>\n<li>Fix an array conversion warning in some versions of PHP</li>\n<li>Support a new WPCOM_API_KEY constant for easier use with WordPress MU</li>\n</ul>\n<h4>2.2.5</h4>\n<p><em>Release Date &#8211; 13th July, 2009</em></p>\n<ul>\n<li>Include a new Server Connectivity diagnostic check, to detect problems caused by firewalls</li>\n</ul>\n<h4>2.2.4</h4>\n<p><em>Release Date &#8211; 3rd June, 2009</em></p>\n<ul>\n<li>Fixed a key problem affecting the stats feature in WordPress MU</li>\n<li>Provide additional blog information in Akismet API calls</li>\n</ul>\n<p><!--section=faq--></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<p>Upload the Akismet plugin to your blog, Activate it, then enter your <a href=\"https://akismet.com/get/\" rel=\"nofollow\">Akismet.com API key</a>.</p>\n<p>1, 2, 3: You&#8217;re done!</p>\n</dd>\n</dl>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/plugins/akismet/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n		\n		\n		\n		\n		\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 11 Oct 2010 20:55:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/plugins-wp/wordpress-seo/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using&#8230;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:12921:\"<p><!--section=description--></p>\n<p>WordPress out of the box is already technically quite a good platform for SEO. This was true when Joost wrote his original <a href=\"https://yoast.com/articles/wordpress-seo/\" rel=\"nofollow\">WordPress SEO</a> article in 2008 (updated every few months) and it&#8217;s still true today, but that doesn&#8217;t mean you can&#8217;t improve it further! This plugin is written from the ground up by Joost de Valk and his team at <a href=\"https://yoast.com/\" rel=\"nofollow\">Yoast</a> to improve your site&#8217;s SEO on <em>all</em> needed aspects. While this <a href=\"https://yoast.com/wordpress/plugins/seo/\" rel=\"nofollow\">Yoast SEO plugin</a> goes the extra mile to take care of all the technical optimization, more on that below, it first and foremost helps you write better content.  Yoast SEO forces you to choose a focus keyword when you&#8217;re writing your articles, and then makes sure you use that focus keyword everywhere.</p>\n<blockquote>\n<p><strong>Premium Support</strong><br />\n  The Yoast team does not always provide active support for the Yoast SEO plugin on the WordPress.org forums. One-on-one email support is available to people who bought the <a href=\"https://yoast.com/wordpress/plugins/seo-premium/\" rel=\"nofollow\">Premium Yoast SEO plugin</a> only.<br />\n  Note that the Premium SEO plugin has several extra features too, including the option to have multiple focus keywords and a redirect manager, so it might be well worth your investment!</p>\n<p>You should also check out the <a href=\"https://yoast.com/wordpress/plugins/local-seo/\" rel=\"nofollow\">Yoast Local SEO</a>, <a href=\"https://yoast.com/wordpress/plugins/news-seo/\" rel=\"nofollow\">Yoast News SEO</a> and <a href=\"https://yoast.com/wordpress/plugins/video-seo/\" rel=\"nofollow\">Yoast Video SEO</a> extensions to Yoast SEO. These of course come with support too.</p>\n<p><strong>Bug Reports</strong><br />\n  Bug reports for Yoast SEO are <a href=\"https://github.com/Yoast/wordpress-seo\" rel=\"nofollow\">welcomed on GitHub</a>. Please note GitHub is <em>not</em> a support forum, and issues that aren&#8217;t properly qualified as bugs will be closed.</p>\n</blockquote>\n<h4>Write better content with Yoast SEO</h4>\n<p>Using the snippet preview, you can see a rendering of what your post or page will look like in the search results, whether your title is too long or too short, and whether your meta description makes sense in the context of a search result. This way the plugin will help you not only increase rankings but also increase the click through rate for organic search results.</p>\n<h4>Page Analysis</h4>\n<p>The Yoast SEO plugins <a href=\"https://yoast.com/content-seo-wordpress-linkdex/\" rel=\"nofollow\">Page Analysis</a> functionality checks simple things you&#8217;re bound to forget. It checks, for instance, if you have images in your post and whether they have an alt tag containing the focus keyword for that post. It also checks whether your posts are long enough, whether you&#8217;ve written a meta description and if that meta description contains your focus keyword, if you&#8217;ve used any subheadings within your post, etc. etc.</p>\n<p>The plugin alsgruo allows you to write meta titles and descriptions for all your category, tag and custom taxonomy archives, giving you the option to further optimize those pages.</p>\n<p>Combined, this plugin makes sure that your content is the type of content search engines will love!</p>\n<h4>Technical WordPress Search Engine Optimization</h4>\n<p>While out of the box WordPress is pretty good for SEO, it needs some tweaks here and there. This Yoast SEO plugin guides you through some of the settings needed, for instance by reminding you to enable pretty permalinks. But it also goes beyond that, by automatically optimizing and inserting the meta tags and link elements that Google and other search engines like so much:</p>\n<h4>Meta &amp; Link Elements</h4>\n<p>With the Yoast SEO plugin you can control which pages Google shows in its search results and which pages it doesn&#8217;t show. By default, it will tell search engines to index all of your pages, including category and tag archives, but to only show the first pages in the search results. It&#8217;s not very useful for a user to end up on the third page of your &#8220;personal&#8221; category, right?</p>\n<p>WordPress itself only shows canonical link elements on single pages, but Yoast SEO makes it output canonical link elements everywhere. Google has recently announced they would also use <code>rel=\"next\"</code> and <code>rel=\"prev\"</code> link elements in the <code>head</code> section of your paginated archives. This plugin adds those automatically. See <a href=\"https://yoast.com/rel-next-prev-paginated-archives/\" rel=\"nofollow\">this post</a> for more info.</p>\n<h4>XML Sitemaps</h4>\n<p>The Yoast SEO plugin has the most advanced XML Sitemaps functionality in any WordPress plugin. Once you check the box, it automatically creates XML sitemaps and notifies Google &amp; Bing of the sitemaps&#8217; existence. These XML sitemaps include the images in your posts &amp; pages too, so that your images may be found better in the search engines too.</p>\n<p>These XML Sitemaps will even work on large sites, because of how they&#8217;re created, using one index sitemap that links to sub-sitemaps for each 1,000 posts. They will also work with custom post types and custom taxonomies automatically, while giving you the option to remove those from the XML sitemap should you wish to.</p>\n<p>Because of using <a href=\"https://yoast.com/xsl-stylesheet-xml-sitemap/\" rel=\"nofollow\">XSL stylesheets for these XML Sitemaps</a>, the XML sitemaps are easily readable for the human eye too, so you can spot things that shouldn&#8217;t be in there.</p>\n<h4>RSS Optimization</h4>\n<p>Are you being outranked by scrapers? Instead of cursing at them, use them to your advantage! By automatically adding a link to your RSS feed pointing back to the original article, you&#8217;re telling the search engine where they should be looking for the original. This way, the Yoast SEO plugin increases your own chance of ranking for your chosen keywords and gets rid of scrapers in one go!</p>\n<h4>Breadcrumbs</h4>\n<p>If your theme is compatible, and themes based on for instance Genesis or by WooThemes often are, you can use the built-in Breadcrumbs functionality. This allows you to create an easy navigation that is great for both users and search engines, and will support the search engines in understanding the structure of your site.</p>\n<p>Making your theme compatible isn&#8217;t hard either, check <a href=\"https://kb.yoast.com/kb/implement-wordpress-seo-breadcrumbs/\" rel=\"nofollow\">these instructions</a>.</p>\n<h4>Edit your .htaccess and robots.txt file</h4>\n<p>Using the built-in file editor, you can edit your WordPress blog&#8217;s <code>.htaccess</code> and <code>robots.txt</code> file, giving you direct access to the two most powerful files, from an SEO perspective, in your WordPress install.</p>\n<h4>Social Integration</h4>\n<p>SEO and Social Media are heavily intertwined. That&#8217;s why this plugin also comes with a Facebook OpenGraph implementation and will soon also support Google+ sharing tags.</p>\n<h4>Multi-Site Compatible</h4>\n<p>The Yoast SEO plugin, unlike some others, is fully Multi-Site compatible. The XML Sitemaps work fine in all setups and you even have the option, in the Network settings, to copy the settings from one blog to another, or make blogs default to the settings for a specific blog.</p>\n<h4>Import &amp; Export functionality</h4>\n<p>If you have multiple blogs, setting up plugins like this one on all of them might seem like a daunting task. Except that it&#8217;s not, because what you can do is simple: you set up the plugin once. You then export your settings and simply import them on all your other sites. It&#8217;s that simple!</p>\n<h4>Import functionality for other WordPress SEO plugins</h4>\n<p>If you&#8217;ve used All In One SEO Pack or HeadSpace2 before using this plugin, you might want to import all your old titles and descriptions. You can do that easily using the built-in import functionality. There&#8217;s also import functionality for some of the older Yoast plugins, like Robots Meta and RSS footer.</p>\n<p>Should you have a need to import from another SEO plugin to Yoast SEO, or from a theme like Genesis or Thesis, you can use the <a href=\"https://wordpress.org/extend/plugins/seo-data-transporter/\" rel=\"nofollow\">SEO Data Transporter</a> plugin, which will easily convert your SEO meta data from and to a whole set of plugins like Platinum SEO, SEO Ultimate, Greg&#8217;s High Performance SEO, and themes like Headway, Hybrid, WooFramework, Catalyst etc.</p>\n<p>Read <a href=\"https://yoast.com/all-in-one-seo-pack-migration/\" rel=\"nofollow\">this migration guide</a> if you still have questions about migrating from another SEO plugin to Yoast SEO.</p>\n<h4>Yoast SEO Plugin in your Language!</h4>\n<p>Currently a huge translation project is underway, translating Yoast SEO in as much as 24 languages. So far, the translations for French and Dutch are complete, but we still need help on a lot of other languages, so if you&#8217;re good at translating, please join us at <a href=\"http://translate.yoast.com\" rel=\"nofollow\">translate.yoast.com</a>.</p>\n<h4>News SEO</h4>\n<p>Be sure to also check out the premium <a href=\"https://yoast.com/wordpress/plugins/news-seo/\" rel=\"nofollow\">News SEO module</a> if you need Google News Sitemaps. It tightly integrates with Yoast SEO to give you the combined power of News Sitemaps and full Search Engine Optimization.</p>\n<h4>Further Reading</h4>\n<p>For more info, check out the following articles:</p>\n<ul>\n<li>The <a href=\"https://kb.yoast.com/kb/category/yoast-seo/\" rel=\"nofollow\">Yoast SEO Knowledgebase</a>.</li>\n<li><a href=\"https://yoast.com/articles/wordpress-seo/\" rel=\"nofollow\">WordPress SEO &#8211; The definitive Guide by Yoast</a>.</li>\n<li>Once you have great SEO, you&#8217;ll need the <a href=\"https://yoast.com/articles/wordpress-hosting/\" rel=\"nofollow\">best WordPress Hosting</a>.</li>\n<li>The <a href=\"https://yoast.com/wordpress/plugins/seo/\" rel=\"nofollow\">Yoast SEO Plugin</a> official homepage.</li>\n<li>Other <a href=\"https://yoast.com/wordpress/plugins/\" rel=\"nofollow\">WordPress Plugins</a> by the same team.</li>\n<li>Follow Yoast on <a href=\"https://facebook.com/yoast\" rel=\"nofollow\">Facebook</a> &amp; <a href=\"http://twitter.com/yoast\" rel=\"nofollow\">Twitter</a>.</li>\n</ul>\n<h3>From within WordPress</h3>\n<ol>\n<li>Visit &#8216;Plugins &gt; Add New&#8217;</li>\n<li>Search for &#8216;Yoast SEO&#8217;</li>\n<li>Activate Yoast SEO from your Plugins page.</li>\n<li>Go to &#8220;after activation&#8221; below.</li>\n</ol>\n<h3>Manually</h3>\n<ol>\n<li>Upload the <code>wordpress-seo</code> folder to the <code>/wp-content/plugins/</code> directory</li>\n<li>Activate the Yoast SEO plugin through the &#8216;Plugins&#8217; menu in WordPress</li>\n<li>Go to &#8220;after activation&#8221; below.</li>\n</ol>\n<h3>After activation</h3>\n<ol>\n<li>You should see (a notice to start) the Yoast SEO configuration wizard.</li>\n<li>Go through the configuration wizard and set up the plugin for your site.</li>\n<li>You&#8217;re done!</li>\n</ol>\n<p><!--section=faq--></p>\n<p>You&#8217;ll find answers to many of your questions on <a href=\"https://kb.yoast.com/kb/category/yoast-seo/\" rel=\"nofollow\">kb.yoast.com</a>.</p>\n<p><!--section=changelog--></p>\n<h4>4.9.0</h4>\n<p>Release Date: June 7th, 2017</p>\n<ul>\n<li>\n<p>Bugfixes</p>\n<ul>\n<li>Fixes a bug where there were certain assessments missing when switching to cornerstone content.</li>\n<li>Fixes a bug where the configuration wizard button was visible for users who didn&#8217;t have enough rights to access the configuration wizard.</li>\n<li>Fixes a bug where the column <code>ID</code> was ambiguous, causing an SQL error.</li>\n<li>Fixes a bug where the category URL in the sitemap was encoded twice.</li>\n<li>Fixes a bug where an old upgrade notice is not removed.</li>\n</ul>\n</li>\n<li>\n<p>Enhancements</p>\n<ul>\n<li>Removes the noodp advanced robots meta value as it is no longer used.</li>\n<li>Loads the translations only when the configuration wizard endpoint is called, instead of every time <code>rest_api_init</code> is called.</li>\n</ul>\n</li>\n</ul>\n<h4>4.8.0</h4>\n<p>Release Date: May 23rd, 2017</p>\n<ul>\n<li>\n<p>Bugfixes</p>\n<ul>\n<li>Fixes a bug where the tabs in the social and advanced metabox section are gone when keyword analysis has been disabled.</li>\n</ul>\n</li>\n<li>\n<p>Enhancements</p>\n<ul>\n<li>Optimizes the way the cornerstone flag is saved.</li>\n<li>Analyzes the content using cornerstone assessors when a post or page is cornerstone content.</li>\n</ul>\n</li>\n</ul>\n<h4>Earlier versions</h4>\n<p>For the changelog of earlier versions, please refer to the separate changelog.txt file.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/plugins/jetpack/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/plugins-wp/jetpack/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"The one plugin you need for stats, related posts, search engine optimization, social sharing, protection,&#8230;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13334:\"<p><!--section=description--></p>\n<p>Keep any WordPress site secure, increase traffic, and engage your readers.</p>\n<h4>Traffic and SEO Tools</h4>\n<p>Traffic is the lifeblood of any website. Jetpack includes:</p>\n<ul>\n<li>[free] Site stats and analytics</li>\n<li>[free] Automatic sharing on Facebook, Twitter, LinkedIn, Tumblr, Reddit, and WhatsApp</li>\n<li>[free] Related posts</li>\n<li>[paid] Search engine optimization tools for Google, Bing, Twitter, Facebook, and WordPress.com</li>\n<li>[paid] Advertising program that includes the best of AdSense, Facebook Ads, AOL, Amazon, Google AdX, and Yahoo</li>\n</ul>\n<h4>Security and Backup Services</h4>\n<p>Stop worrying about data loss, downtime, and hacking. Jetpack provides:</p>\n<ul>\n<li>[free] Brute force attack protection</li>\n<li>[free] Downtime and uptime monitoring</li>\n<li>[free] Secured logins and two-factor authentication</li>\n<li>[paid] Malware scanning, code scanning, and threat resolution</li>\n<li>[paid] Site backups, restores, and migrations</li>\n</ul>\n<h4>Content Creation</h4>\n<p>Add rich, beautifully-presented media &#8212; no graphic design expertise necessary:</p>\n<ul>\n<li>[free] A high-speed CDN for your images</li>\n<li>[free] Carousels, slideshows, and tiled galleries</li>\n<li>[free] Simple embeds from YouTube, Google Documents, Spotify and more</li>\n<li>[free] Sidebar customization including Facebook, Twitter, and RSS feeds</li>\n<li>[free] Extra sidebar widgets including blog stats, calendar, and author widgets</li>\n<li>[paid] High-speed, ad-free, and high-definition video hosting</li>\n</ul>\n<h4>Discussion and Community</h4>\n<p>Create a connection with your readers and keep them coming back to your site with:</p>\n<ul>\n<li>[free] Email subscriptions</li>\n<li>[free] Comment login with Facebook, Twitter, and Google</li>\n<li>[free] Fully-customizable contact forms</li>\n<li>[free] Infinite scroll for your posts</li>\n</ul>\n<h4>Expert Support</h4>\n<p>We have an entire team of Happiness Engineers ready to help you. Ask your questions in the support forum, or <a href=\"https://jetpack.com/contact-support\" rel=\"nofollow\">contact us directly</a>.</p>\n<h4>Paid Services</h4>\n<p>Most of Jetpack&#8217;s features and services are free. Jetpack also provides advanced security and backup services, video hosting, site monetization, priority support, and more SEO tools in three <a href=\"https://jetpack.com/pricing?from=wporg\" rel=\"nofollow\">simple and affordable plans</a>.</p>\n<h4>Get Started</h4>\n<p>Installation is free, quick, and easy. Set up <a href=\"https://jetpack.com/install?from=wporg\" rel=\"nofollow\">the free plan</a> in minutes.</p>\n<p><!--section=installation--></p>\n<h4>Automated Installation</h4>\n<p>Installation is free, quick, and easy. <a href=\"https://jetpack.com/install?from=wporg\" rel=\"nofollow\">Install Jetpack from our site</a> in minutes.</p>\n<h4>Manual Alternatives</h4>\n<p>Alternatively, install Jetpack via the plugin directory, or upload the files manually to your server and follow the on-screen instructions. If you need additional help <a href=\"http://jetpack.com/support/installing-jetpack/\" rel=\"nofollow\">read our detailed instructions</a>.</p>\n<p><!--section=faq--></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<h4>Automated Installation</h4>\n<p>Installation is free, quick, and easy. <a href=\"https://jetpack.com/install?from=wporg\" rel=\"nofollow\">Install Jetpack from our site</a> in minutes.</p>\n<h4>Manual Alternatives</h4>\n<p>Alternatively, install Jetpack via the plugin directory, or upload the files manually to your server and follow the on-screen instructions. If you need additional help <a href=\"http://jetpack.com/support/installing-jetpack/\" rel=\"nofollow\">read our detailed instructions</a>.</p>\n</dd>\n<dt>Is Jetpack Free?</dt>\n<dd>\n<p>Yes! Jetpack&#8217;s core features are and always will be free.</p>\n<p>These include: <a href=\"https://jetpack.com/features/traffic/site-stats\" rel=\"nofollow\">site stats</a>, a <a href=\"https://jetpack.com/features/writing/content-delivery-network/\" rel=\"nofollow\">high-speed CDN</a> for images, <a href=\"https://jetpack.com/features/traffic/related-posts\" rel=\"nofollow\">related posts</a>, <a href=\"https://jetpack.com/features/security/downtime-monitoring\" rel=\"nofollow\">downtime monitoring</a>, brute force <a href=\"https://jetpack.com/features/security/brute-force-attack-protection\" rel=\"nofollow\">attack protection</a>, <a href=\"https://jetpack.com/features/traffic/automatic-publishing/\" rel=\"nofollow\">automated sharing</a> to social networks, <a href=\"https://jetpack.com/features/writing/sidebar-customization/\" rel=\"nofollow\">sidebar customization</a>, and many more.</p>\n</dd>\n<dt>Should I purchase a paid plan?</dt>\n<dd>\n<p>Jetpack&#8217;s paid services include automated backups, security scanning, spam filtering, video hosting, site monetization, SEO tools, and priority support.</p>\n<p>If you&#8217;re interested in learning more about the extra layers of protection and advanced tools available, learn more about our <a href=\"https://jetpack.com/pricing?from=wporg\" rel=\"nofollow\">paid plans</a>.</p>\n</dd>\n<dt>Why do I need a WordPress.com account?</dt>\n<dd>\n<p>Since Jetpack and its services are provided and hosted by WordPress.com, a WordPress.com account is required for Jetpack to function.</p>\n</dd>\n<dt>I already have a WordPress account, but Jetpack isn&#8217;t working. What&#8217;s going on?</dt>\n<dd>\n<p>A WordPress.com account is different from the account you use to log into your self-hosted WordPress. If you can log into <a href=\"https://wordpress.com\" rel=\"nofollow\">WordPress.com</a>, then you already have a WordPress.com account. If you can&#8217;t, you can easily create one <a href=\"https://jetpack.com/install?from=wporg\" rel=\"nofollow\">during installation</a>.</p>\n</dd>\n<dt>How do I view my stats?</dt>\n<dd>\n<p>Once you&#8217;ve installed Jetpack your stats will be available on <a href=\"https://wordpress.com/stats\" rel=\"nofollow\">WordPress.com/Stats</a>, on the official <a href=\"https://apps.wordpress.com/mobile/\" rel=\"nofollow\">WordPress mobile apps</a>, and on your Jetpack dashboard.</p>\n</dd>\n<dt>How do I contribute to Jetpack?</dt>\n<dd>\n<p>There are opportunities for developers at all levels to contribute. <a href=\"https://jetpack.com/contribute\" rel=\"nofollow\">Learn more about contributing to Jetpack</a> or consider <a href=\"https://jetpack.com/beta\" rel=\"nofollow\">joining our beta program</a>.</p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<h4>5.0</h4>\n<ul>\n<li>Release date: June 6th, 2017</li>\n<li>Release post: http://wp.me/p1moTy-5hK</li>\n</ul>\n<p><strong>Enhancements</strong></p>\n<ul>\n<li>Several changes to the Jetpack dashboard and notices: alignment tweaks, code refactor, text simplification, and more.</li>\n<li>Changes to the communication layer between your site and WordPress.com, to improve performance and allow you to do more to manage your site from WordPress.com.</li>\n<li>Social menu gets icons for Etsy, Meetup, 500px, and Goodreads.</li>\n<li>Jetpack data sync now better supports WordPress updates, themes changes, widgets, and multisite networks.</li>\n<li>Video is updated to be fully compatible with the upcoming Media Widget.</li>\n<li>Force secure WordPress.com API requests for request body, remove deprecated stats methods, and add new endpoints for post listing and user invitations.</li>\n<li>Jetpack&#8217;s Command Line tools can now output information about the primary Jetpack site owner. Try <code>wp jetpack status</code>!</li>\n<li>Custom CSS now supports the <code>animation-fill-mode</code>, <code>fill</code>, and <code>stroke</code> properties.</li>\n<li>Remove the &#8220;Menus&#8221; item from the WordPress.com toolbar for parity with the toolbar on WordPress.com.</li>\n<li>Improve the display of the Omnisearch results page on sites using an RTL language.</li>\n<li>Trim any white space when adding new email address in the Contact Info Widget.</li>\n<li>Improve the look of your recipes in search engine result pages, when you use the Recipe shortcode.</li>\n</ul>\n<p><strong>Compatibility Improvements</strong></p>\n<ul>\n<li>Improve the connection process for end users and hosts.</li>\n<li>Improve compatibility of Jetpack data sync with WooCommerce and Pet Manager plugins.</li>\n<li>Make sure Jetpack&#8217;s SEO Tools don&#8217;t conflict with other SEO plugins that may already be active on the site, like Yoast SEO or All In One SEO Pack.</li>\n</ul>\n<p><strong>Bug Fixes</strong></p>\n<ul>\n<li>Add a &#8220;Set Up&#8221; button when a Personal plan is purchased, but VaultPress isn&#8217;t active yet.</li>\n<li>When the Ads feature is active, do not display Ads in RSS feeds.</li>\n<li>Comments do not use Photon for Facebook and Twitter avatars and now avoid non-secure warnings when submitting comments on a HTTP site in Safari.</li>\n<li>Contact form emails are now sent in a way that ensures they are correctly rendered as HTML.</li>\n<li>Properly print the full list of modules when using the sync command in Jetpack&#8217;s Command Line Interface (CLI).</li>\n<li>Avoid errors when reordering a lot of Restaurant menu items at once.</li>\n<li>Add a mechanism to detect broken connection states and resolve them.</li>\n<li>Autosaves can now be restored as Markdown.</li>\n<li>Photon no longer conflicts with Facebook&#8217;s CDN, local images, and plugins that customize reponsive images.</li>\n<li>Avoid potential PHP notice in Publicize.</li>\n<li>Fix bad jQuery selector in Presentations shortcode.</li>\n<li>Avoid fatal errors for Social Links on sites running PHP 7.1.</li>\n<li>Properly escape button attribute in spellchecker.</li>\n<li>Avoid PHP notices for stats on some sites when user roles are not attributed properly.</li>\n<li>No longer attempt to sync options that do not exist and avoid fatal errors when de/activating plugins.</li>\n<li>Avoid errors when Social Menu functions have already been defined in the theme or in another plugin.</li>\n<li>VideoPress media items now always return their unique ID, and do not trigger any PHP notice.</li>\n<li>Fix style of the EU Cookie Law Widget on themes with specific positioning.</li>\n<li>Use correct time constant to define an hour in Upcoming Events Widget.</li>\n<li>Avoid HTML encoding issues in sitemaps.</li>\n</ul>\n<h4>4.9</h4>\n<ul>\n<li>Release date: May 2nd, 2017</li>\n<li>Release post: http://wp.me/p1moTy-4Rl</li>\n</ul>\n<p><strong>Major Enhancements</strong></p>\n<ul>\n<li>New &#8220;EU Cookie Law Banner&#8221;, Flickr, and &#8220;Internet Defense League&#8221; widgets.</li>\n</ul>\n<p><strong>Slightly Less Exciting Enhancements</strong></p>\n<ul>\n<li>Success notices are automatically dismissed after a short period.</li>\n<li>Removed unused code from &#8220;My Jetpack&#8221; interface and deprecated an XML-RPC method.</li>\n<li>Contact Form now adds display names to email addresses in the <code>To</code> header.</li>\n<li>Updated multiple unit tests to increase code coverage.</li>\n<li>Development mode now also shows module list.</li>\n<li>Updated the list of locales available in Jetpack.</li>\n<li>Plugin auto-updates only triggered from WordPress.com and now trigger WordPress&#8217; maintenance mode.</li>\n</ul>\n<p><strong>Performance Improvements</strong></p>\n<ul>\n<li>Record comment content modifications and moderation events to make sure comments are always up to date on WordPress.com.</li>\n<li>Sync post deletions, changes to sidebar, user events (addition, removal, and update) and theme installation.</li>\n<li>We now distinguish between a new and an updated attachment.</li>\n<li>Sync plugin and theme names when a related event is triggered including theme updates.</li>\n</ul>\n<p><strong>Compatibility Improvements</strong></p>\n<ul>\n<li>Protect avoid conflicts with other plugins hooking into the log in form.</li>\n<li>Contact Form not auto-activated when Ninja Forms is active.</li>\n<li>WordPess.com REST API now allows <code>HTTP PUT</code> requests.</li>\n<li>Ensure that Jetpack&#8217;s Image Widget is fully compatible with the Media Widget soon to be available in WordPress 4.8.</li>\n</ul>\n<p><strong>Bug Fixes</strong></p>\n<ul>\n<li>Fixed wording in Post By Email button when no email address has been generated.</li>\n<li>Fixed a notice in the subscription widget in PHP 7.1</li>\n<li>Properly display VaultPress notices in the Jetpack dashboard.</li>\n<li>VideoPress now included in search results for &#8220;video&#8221; and fixed positioning of search icon on mobile screens.</li>\n<li>Protect supports IPv6 addresses properly.</li>\n<li>Dashboard avoids API requests being cached on some hosts and avoids errors when Spellchecker is inactive.</li>\n<li>Contact Form message content type is now set properly to restore compatibility with email plugins.</li>\n<li>Ads not displayed in the portfolio projects custom content type.</li>\n<li>Display all sites available in a network, even on large multisite installations.</li>\n<li>Featured Image is always used in tweets posted via Publicize.</li>\n<li>Avoid fatal errors when the exclusion parameter in Related Posts is not a string.</li>\n<li>Allow the removal of all custom title settings in the SEO feature.</li>\n<li>Make sure images are not distorted when Tiled Galleries uses Photon.</li>\n<li>Avoid PHP warnings and errors in the Stats dashboard on Multisite.</li>\n<li>Avoid errors when the Jetpack plugin is deleted.</li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/plugins/jetpack/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 18:48:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins-wp/wordpress-importer/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4618:\"<p><!--section=description--></p>\n<p>The WordPress Importer will import the following content from a WordPress export file:</p>\n<ul>\n<li>Posts, pages and other custom post types</li>\n<li>Comments</li>\n<li>Custom fields and post meta</li>\n<li>Categories, tags and terms from custom taxonomies</li>\n<li>Authors</li>\n</ul>\n<p>For further information and instructions please see the <a href=\"https://codex.wordpress.org/Importing_Content#WordPress\" rel=\"nofollow\">Codex page on Importing Content</a></p>\n<h3>Filters</h3>\n<p>The importer has a couple of filters to allow you to completely enable/block certain features:</p>\n<ul>\n<li><code>import_allow_create_users</code>: return false if you only want to allow mapping to existing users</li>\n<li><code>import_allow_fetch_attachments</code>: return false if you do not wish to allow importing and downloading of attachments</li>\n<li><code>import_attachment_size_limit</code>: return an integer value for the maximum file size in bytes to save (default is 0, which is unlimited)</li>\n</ul>\n<p>There are also a few actions available to hook into:</p>\n<ul>\n<li><code>import_start</code>: occurs after the export file has been uploaded and author import settings have been chosen</li>\n<li><code>import_end</code>: called after the last output from the importer</li>\n</ul>\n<p><!--section=faq--></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<p>The quickest method for installing the importer is:</p>\n<ol>\n<li>Visit Tools -&gt; Import in the WordPress dashboard</li>\n<li>Click on the WordPress link in the list of importers</li>\n<li>Click &#8220;Install Now&#8221;</li>\n<li>Finally click &#8220;Activate Plugin &amp; Run Importer&#8221;</li>\n</ol>\n<p>If you would prefer to do things manually then follow these instructions:</p>\n<ol>\n<li>Upload the <code>wordpress-importer</code> folder to the <code>/wp-content/plugins/</code> directory</li>\n<li>Activate the plugin through the &#8216;Plugins&#8217; menu in WordPress</li>\n<li>Go to the Tools -&gt; Import screen, click on WordPress</li>\n</ol>\n</dd>\n<dt>Help! I&#8217;m getting out of memory errors or a blank screen.</dt>\n<dd>\n<p>If your exported file is very large, the import script may run into your host&#8217;s configured memory limit for PHP.</p>\n<p>A message like &#8220;Fatal error: Allowed memory size of 8388608 bytes exhausted&#8221; indicates that the script can&#8217;t successfully import your XML file under the current PHP memory limit. If you have access to the php.ini file, you can manually increase the limit; if you do not (your WordPress installation is hosted on a shared server, for instance), you might have to break your exported XML file into several smaller pieces and run the import script one at a time.</p>\n<p>For those with shared hosting, the best alternative may be to consult hosting support to determine the safest approach for running the import. A host may be willing to temporarily lift the memory limit and/or run the process directly from their end.</p>\n<p>&#8212; <a href=\"https://codex.wordpress.org/Importing_Content#Before_Importing\" rel=\"nofollow\">WordPress Codex: Importing Content</a></p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<h4>0.6.3</h4>\n<ul>\n<li>Add support for import term metadata.</li>\n<li>Fix bug that caused slashes to be stripped from imported content.</li>\n<li>Fix bug that caused characters to be stripped inside of CDATA in some cases.</li>\n<li>Fix PHP notices.</li>\n</ul>\n<h4>0.6.2</h4>\n<ul>\n<li>Add wp_import_existing_post filter. See: https://core.trac.wordpress.org/ticket/33721</li>\n</ul>\n<h4>0.6</h4>\n<ul>\n<li>Support for WXR 1.2 and multiple CDATA sections</li>\n<li>Post aren&#8217;t duplicates if their post_type&#8217;s are different</li>\n</ul>\n<h4>0.5.2</h4>\n<ul>\n<li>Double check that the uploaded export file exists before processing it. This prevents incorrect error messages when<br />\nan export file is uploaded to a server with bad permissions and WordPress 3.3 or 3.3.1 is being used.</li>\n</ul>\n<h4>0.5</h4>\n<ul>\n<li>Import comment meta (requires export from WordPress 3.2)</li>\n<li>Minor bugfixes and enhancements</li>\n</ul>\n<h4>0.4</h4>\n<ul>\n<li>Map comment user_id where possible</li>\n<li>Import attachments from <code>wp:attachment_url</code></li>\n<li>Upload attachments to correct directory</li>\n<li>Remap resized image URLs correctly</li>\n</ul>\n<h4>0.3</h4>\n<ul>\n<li>Use an XML Parser if possible</li>\n<li>Proper import support for nav menus</li>\n<li>&#8230; and much more, see <a href=\"https://core.trac.wordpress.org/ticket/15197\" rel=\"nofollow\">Trac ticket #15197</a></li>\n</ul>\n<h4>0.1</h4>\n<ul>\n<li>Initial release</li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wordpress.org/plugins/woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/plugins/woocommerce/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Sep 2011 15:32:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins-wp/woocommerce/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:20075:\"<p><!--section=description--></p>\n<p>WooCommerce is a free eCommerce plugin that allows you to sell anything, beautifully. Built to integrate seamlessly with WordPress, WooCommerce is the world’s favorite eCommerce solution that gives both store owners and developers complete control.</p>\n<p>With endless flexibility and access to hundreds of free and premium WordPress extensions, WooCommerce now powers 30% of all online stores &#8212; more than any other platform.</p>\n<iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/1KahlicghaE?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe>\n<h4>Sell anything, anywhere</h4>\n<p>With WooCommerce, you can sell both physical and digital goods in all shapes and sizes, offer product variations, multiple configurations, and instant downloads to shoppers, and even sell affiliate goods from online marketplaces.</p>\n<p>With premium extensions, you can offer bookings, memberships, and recurring subscriptions. Perhaps you’d like to sell monthly subscriptions for physical goods, or offer your members a discount on digital downloads? It’s all possible.</p>\n<h4>Ship wherever you like</h4>\n<p>Offer free shipping, flat rate shipping, or make real-time calculations. Limit your shipments to specific countries, or open your store up to the world. Shipping is highly configurable, and WooCommerce even supports drop shipping.</p>\n<h4>Extensive payment options</h4>\n<p>WooCommerce comes bundled with the ability to accept major credit cards, PayPal, BACS (bank transfers), and cash on delivery. Need additional options? More than 140 region-specific gateways integrate with WooCommerce, including popular choices like Stripe, Authorize.Net, and Amazon Payments.</p>\n<h4>You control it all &#8212; forever</h4>\n<p>WooCommerce gives you complete control of your store, from taxes to stock levels to customer accounts. Add and remove extensions, change your design, and switch settings as you please. It’s all under your control.</p>\n<p>One of the biggest risks of using a hosted eCommerce platform is what happens to your store if the provider closes up shop. With WooCommerce, you have complete control, so there’s never any reason to worry. Your data belongs to you &#8212; and it’s kept secure, thanks to regular audits by industry leaders.</p>\n<h4>Define your style with Storefront</h4>\n<p><a href=\"https://wordpress.org/themes/storefront/\" rel=\"nofollow\">Storefront</a> is a free WordPress theme available to any WooCommerce store. Along with deep WooCommerce integration, Storefront prioritizes speed and uptime while eliminating theme and plugin conflicts during major updates.</p>\n<p>Define your style even further by customizing Storefront to your liking or choosing from one of our several <a href=\"https://woocommerce.com/product-category/themes/storefront-child-theme-themes/\" rel=\"nofollow\">Storefront child themes</a>. It’s all up to you, and all open source.</p>\n<h4>Built with developers in mind</h4>\n<p>Extendable, adaptable, and open source &#8212; WooCommerce was created with developers in mind. With its strong, robust framework, you can scale your client’s store all the way from basic to high-end (infinity and beyond).</p>\n<p>Built with a REST API, WooCommerce can integrate with virtually any service. Your store’s data can be accessed anywhere, anytime, 100% securely. WooCommerce allows developers to easily create, modify, and grow a store that meets their specifications.</p>\n<p>No matter the size of the store you want to build, WooCommerce will scale to meet your requirements. With a growing collection of more than 300 extensions, you can enhance each store’s features to meet your client’s unique needs &#8212; or even create your own solution.</p>\n<p>If security is a concern, rest easy. WooCommerce is audited by a dedicated team of developers working around the clock to identify and patch any and all discovered bugs.</p>\n<p>We also support WooCommerce and all its extensions with comprehensive, easily-accessible documentation. With our docs, you’ll learn how to create the exact site your client needs.</p>\n<h4>Extensions galore</h4>\n<p>WordPress.org is home to some amazing extensions for WooCommerce, including:</p>\n<ul>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-google-analytics-integration/\">Google Analytics</a></li>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-delivery-notes/\">Delivery Notes</a></li>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-pdf-invoices-packing-slips/\">PDF Invoices and Packing Slips</a></li>\n<li><a href=\"https://wordpress.org/plugins/affiliates-woocommerce-light/\">Affiliates Integration Light</a></li>\n<li><a href=\"https://wordpress.org/plugins/woocommerce-new-product-badge/\">New Product Badges</a></li>\n</ul>\n<p>Keen to see them all? Search WordPress.org for ‘WooCommerce’ to dive in.</p>\n<p>If you’re looking for something endorsed and maintained by the developers who built WooCommerce, there are a plethora of premium eCommerce extensions, the most popular of which include:</p>\n<ul>\n<li><a href=\"https://woocommerce.com/products/woocommerce-subscriptions/\" rel=\"nofollow\">WooCommerce Subscriptions</a></li>\n<li><a href=\"https://woocommerce.com/products/woocommerce-memberships/\" rel=\"nofollow\">WooCommerce Memberships</a></li>\n<li><a href=\"https://woocommerce.com/products/woocommerce-bookings/\" rel=\"nofollow\">WooCommerce Bookings</a></li>\n<li><a href=\"https://woocommerce.com/products/dynamic-pricing/\" rel=\"nofollow\">Dynamic Pricing</a></li>\n<li><a href=\"https://woocommerce.com/products/table-rate-shipping/\" rel=\"nofollow\">Table Rate Shipping</a></li>\n<li><a href=\"https://woocommerce.com/products/product-csv-import-suite/\" rel=\"nofollow\">Product CSV Import Suite</a></li>\n</ul>\n<p>And there’s plenty more where they came from. Visit our <a href=\"https://woocommerce.com/product-category/woocommerce-extensions/\" rel=\"nofollow\">extensions page</a> to find out everything you’re capable of and all that&#8217;s possible with premium WooCommerce extensions.</p>\n<h4>Join our growing community</h4>\n<p>When you download WooCommerce, you join a community of more than a million store owners, developers, and WordPress enthusiasts. We’re one of the fastest-growing open source communities online, and whether you’re a n00b or a Ninja, we’d love to have you!</p>\n<p>If you’re interested in contributing to WooCommerce we’ve got more than 350 contributors, and there’s always room for more. Head over to the <a href=\"https://github.com/woocommerce/woocommerce\" rel=\"nofollow\">WooCommerce GitHub Repository</a> to find out how you can pitch in.</p>\n<p>Want to add a new language to WooCommerce? Swell! You can contribute via <a href=\"https://translate.wordpress.org/projects/wp-plugins/woocommerce\" rel=\"nofollow\">translate.wordpress.org</a>.</p>\n<p>And, finally, consider joining or spearheading a WooCommerce Meetup locally, more about those <a href=\"https://woocommerce.com/woocommerce/meetups/\" rel=\"nofollow\">here</a>.</p>\n<p><!--section=installation--></p>\n<h4>Minimum Requirements</h4>\n<ul>\n<li>PHP version 5.2.4 or greater (PHP 5.6 or greater is recommended)</li>\n<li>MySQL version 5.0 or greater (MySQL 5.6 or greater is recommended)</li>\n<li>Some payment gateways require fsockopen support (for IPN access)</li>\n<li>WooCommerce 2.5 requires WordPress 4.1+</li>\n<li>WooCommerce 2.6 requires WordPress 4.4+</li>\n</ul>\n<p>Visit the <a href=\"https://docs.woocommerce.com/document/server-requirements/\" rel=\"nofollow\">WooCommerce server requirements documentation</a> for a detailed list of server requirements.</p>\n<h4>Automatic installation</h4>\n<p>Automatic installation is the easiest option as WordPress handles the file transfers itself and you don’t need to leave your web browser. To do an automatic install of WooCommerce, log in to your WordPress dashboard, navigate to the Plugins menu and click Add New.</p>\n<p>In the search field type “WooCommerce” and click Search Plugins. Once you’ve found our eCommerce plugin you can view details about it such as the point release, rating and description. Most importantly of course, you can install it by simply clicking “Install Now”.</p>\n<h4>Manual installation</h4>\n<p>The manual installation method involves downloading our eCommerce plugin and uploading it to your webserver via your favourite FTP application. The WordPress codex contains <a href=\"https://codex.wordpress.org/Managing_Plugins#Manual_Plugin_Installation\" rel=\"nofollow\">instructions on how to do this here</a>.</p>\n<h4>Updating</h4>\n<p>Automatic updates should work like a charm; as always though, ensure you backup your site just in case.</p>\n<p>If on the off-chance you do encounter issues with the shop/category pages after an update you simply need to flush the permalinks by going to WordPress &gt; Settings &gt; Permalinks and hitting &#8216;save&#8217;. That should return things to normal.</p>\n<h4>Dummy data</h4>\n<p>WooCommerce comes with some dummy data you can use to see how products look; either import dummy_data.xml via the <a href=\"https://wordpress.org/plugins/wordpress-importer/\">WordPress importer</a> or use our <a href=\"https://woocommerce.com/products/product-csv-import-suite/\" rel=\"nofollow\">CSV Import Suite plugin</a> to import dummy_data.csv and dummy_data_variations.csv.</p>\n<p><!--section=faq--></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<h4>Minimum Requirements</h4>\n<ul>\n<li>PHP version 5.2.4 or greater (PHP 5.6 or greater is recommended)</li>\n<li>MySQL version 5.0 or greater (MySQL 5.6 or greater is recommended)</li>\n<li>Some payment gateways require fsockopen support (for IPN access)</li>\n<li>WooCommerce 2.5 requires WordPress 4.1+</li>\n<li>WooCommerce 2.6 requires WordPress 4.4+</li>\n</ul>\n<p>Visit the <a href=\"https://docs.woocommerce.com/document/server-requirements/\" rel=\"nofollow\">WooCommerce server requirements documentation</a> for a detailed list of server requirements.</p>\n<h4>Automatic installation</h4>\n<p>Automatic installation is the easiest option as WordPress handles the file transfers itself and you don’t need to leave your web browser. To do an automatic install of WooCommerce, log in to your WordPress dashboard, navigate to the Plugins menu and click Add New.</p>\n<p>In the search field type “WooCommerce” and click Search Plugins. Once you’ve found our eCommerce plugin you can view details about it such as the point release, rating and description. Most importantly of course, you can install it by simply clicking “Install Now”.</p>\n<h4>Manual installation</h4>\n<p>The manual installation method involves downloading our eCommerce plugin and uploading it to your webserver via your favourite FTP application. The WordPress codex contains <a href=\"https://codex.wordpress.org/Managing_Plugins#Manual_Plugin_Installation\" rel=\"nofollow\">instructions on how to do this here</a>.</p>\n<h4>Updating</h4>\n<p>Automatic updates should work like a charm; as always though, ensure you backup your site just in case.</p>\n<p>If on the off-chance you do encounter issues with the shop/category pages after an update you simply need to flush the permalinks by going to WordPress &gt; Settings &gt; Permalinks and hitting &#8216;save&#8217;. That should return things to normal.</p>\n<h4>Dummy data</h4>\n<p>WooCommerce comes with some dummy data you can use to see how products look; either import dummy_data.xml via the <a href=\"https://wordpress.org/plugins/wordpress-importer/\">WordPress importer</a> or use our <a href=\"https://woocommerce.com/products/product-csv-import-suite/\" rel=\"nofollow\">CSV Import Suite plugin</a> to import dummy_data.csv and dummy_data_variations.csv.</p>\n</dd>\n<dt>Where can I find WooCommerce documentation and user guides?</dt>\n<dd>\n<p>For help setting up and configuring WooCommerce please refer to our <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/getting-started/\" rel=\"nofollow\">user guide</a></p>\n<p>For extending or theming WooCommerce, see our <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/woocommerce-codex/\" rel=\"nofollow\">codex</a>.</p>\n</dd>\n<dt>Where can I get support or talk to other users?</dt>\n<dd>\n<p>If you get stuck, you can ask for help in the <a href=\"https://wordpress.org/support/plugin/woocommerce\" rel=\"nofollow\">WooCommerce Plugin Forum</a>.</p>\n<p>For help with premium extensions from WooThemes, use <a href=\"https://support.woothemes.com/\" rel=\"nofollow\">our helpdesk</a>.</p>\n</dd>\n<dt>Will WooCommerce work with my theme?</dt>\n<dd>\n<p>Yes; WooCommerce will work with any theme, but may require some styling to make it match nicely. Please see our <a href=\"https://docs.woocommerce.com/documentation/plugins/woocommerce/woocommerce-codex/\" rel=\"nofollow\">codex</a> for help. If you&#8217;re looking for a theme with built in WooCommerce integration we recommend <a href=\"https://woocommerce.com/storefront/\" rel=\"nofollow\">Storefront</a>.</p>\n</dd>\n<dt>Where can I request new features, eCommerce themes and extensions?</dt>\n<dd>\n<p>You can vote on and request new features and extensions in our <a href=\"http://ideas.woothemes.com/forums/133476-woocommerce\" rel=\"nofollow\">WooIdeas board</a></p>\n</dd>\n<dt>Where can I report bugs or contribute to the project?</dt>\n<dd>\n<p>Bugs can be reported either in our support forum or preferably on the <a href=\"https://github.com/woocommerce/woocommerce/issues\" rel=\"nofollow\">WooCommerce GitHub repository</a>.</p>\n</dd>\n<dt>Where can I find the REST API documentation?</dt>\n<dd>\n<p>You can find the documentation of our REST API on the <a href=\"https://woocommerce.github.io/woocommerce-rest-api-docs/\" rel=\"nofollow\">WooCommerce REST API Docs</a>.</p>\n</dd>\n<dt>WooCommerce is awesome! Can I contribute?</dt>\n<dd>\n<p>Yes you can! Join in on our <a href=\"http://github.com/woocommerce/woocommerce/\" rel=\"nofollow\">GitHub repository</a> <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<h4>3.1.0 &#8211; 2017-06-28</h4>\n<ul>\n<li>Feature &#8211; Built-in product CSV importer and exporter for products.</li>\n<li>Feature &#8211; Display (toggle-able) terms inline on the checkout rather than showing a link.</li>\n<li>Feature &#8211; On the &#8220;pay for order&#8221; page, if logged out show a login form rather than an error message.</li>\n<li>Feature &#8211; Enabled oembed support for product short descriptions.</li>\n<li>Feature &#8211; Added bulk variation update for stock status.</li>\n<li>Feature &#8211; On customer profiles: added a button to copy billing address to shipping address.</li>\n<li>Feature &#8211; Setup Wizard &#8211; Automatic Shipping Zone Creation In Setup Wizard for the base location.</li>\n<li>Feature &#8211; Setup Wizard &#8211; Added a new optional Storefront Theme step if you&#8217;re using a non-WooCommerce compatible theme.</li>\n<li>Feature &#8211; Made it possible to manage extension licenses purchased from WooCommerce.com on the extensions screen.</li>\n<li>Tweak &#8211; Gallery &#8211; Added a data-caption for captions to support both captions and titles for SEO.</li>\n<li>Tweak &#8211; Gallery &#8211; Used smoothHeight setting to better support images of different heights.</li>\n<li>Tweak &#8211; UI &#8211; Added blank states for API keys &amp; webhooks.</li>\n<li>Tweak &#8211; UI &#8211; Made Product submenu labels consistent in admin.</li>\n<li>Tweak &#8211; UI &#8211; Changed street address field label and placeholder to minimize user error on checkout.</li>\n<li>Tweak &#8211; UI &#8211; Added a confirmation before deleting log files.</li>\n<li>Tweak &#8211; If prices are the same for all variations, use price not priceSpecification in structured data.</li>\n<li>Tweak &#8211; Added variable so shipping calculator is shown on first row only when showing multiple shipping packages.</li>\n<li>Tweak &#8211; Updated mini-cart HTML to use a list.</li>\n<li>Tweak &#8211; Allow linking to single product additional_information tab from url hash.</li>\n<li>Tweak &#8211; Re-included WooCommerce endpoints on the appearance &gt; menus screens.</li>\n<li>Tweak &#8211; Always sync incorrect titles on variation read regardless of version.</li>\n<li>Tweak &#8211; Standardize rating HTML in all templates.</li>\n<li>Tweak &#8211; When searching, disable WC sort order so results are sorted by relevance.</li>\n<li>Tweak &#8211; Update price sorting code to use min or max for variable products depending on sorting direction.</li>\n<li>Tweak &#8211; Utilize $product method to get thumbnail in loops.</li>\n<li>Tweak &#8211; Check for an existing display name before updating a user on checkout. Adds display_name prop to the CRUD.</li>\n<li>Tweak &#8211; Adapt variable product price used in sorting based on direction of sort.</li>\n<li>Tweak &#8211; Made state validation less strict for keys.</li>\n<li>Tweak &#8211; For COD orders, force payment complete status to be completed.</li>\n<li>Fix &#8211; Use get_max_purchase_quantity in cart template and fix logic when stock management is off.</li>\n<li>Fix &#8211; Added log_id as the secondary sorting column to log list so log entries sort correctly.</li>\n<li>Fix &#8211; Fix shop page when using shop base and UTF8 shop page slug.</li>\n<li>Fix &#8211; Added handles so drag and drop does not break edit on mobile when sorting categories.</li>\n<li>Fix &#8211; Added ABSPATH checks to all files.</li>\n<li>Fix &#8211; Fixed how to flush rewrite rules after saving the shop main page.</li>\n<li>Fix &#8211; Emails sent via admin should switch to global locale.</li>\n<li>Fix &#8211; Set and restore wp_query so product page functions think it&#8217;s a real product page.</li>\n<li>Fix &#8211; Variation default value of &#8216;0&#8217; fails to save on product.</li>\n<li>Fix &#8211; Prevent locations being added to the &#8220;Rest Of The World&#8221; shipping zone via the API.</li>\n<li>Dev &#8211; Allow date created to be set in wc_create_refund.</li>\n<li>Dev &#8211; Introduced a <a href=\"https://github.com/woocommerce/woocommerce/wiki/wc_get_orders-and-WC_Order_Query\" rel=\"nofollow\">WC_Order_Query class</a> for finding/searching orders.</li>\n<li>Dev &#8211; Added &#8220;restored&#8221; webhook.</li>\n<li>Dev &#8211; Support floats for the custom attribute name sorting function.</li>\n<li>Dev &#8211; Updated Emogrifier to version 1.2.</li>\n<li>Dev &#8211; Sort product data tabs by priority in admin screen.</li>\n<li>Dev &#8211; Added new hooks for: dashboard reviews widget, product and category sorting events, woocommerce_add_to_cart_sold_individually_found_in_cart, cart empty messages.</li>\n<li>Dev &#8211; Added filters for zoom / flexslider / photoswipe enabling.</li>\n<li>Dev &#8211; Added filter for cookie name.</li>\n<li>Dev &#8211; Added ability to filter Photoswipe lightbox options.</li>\n<li>Dev &#8211; Added new filter for product thumbnail size.</li>\n<li>Dev &#8211; Added action for displaying custom data for fees in admin.</li>\n<li>Dev &#8211; Changed build_payload from private to public in webhook system.</li>\n<li>Dev &#8211; Added deprecated notice to WC_Order_Item_Meta (deprecated in 3.0).</li>\n<li>Dev &#8211; Added namespace to jQuery events that are removed in VariationForm.</li>\n<li>Dev &#8211; Made WC_Checkout::get_posted_data() public.</li>\n<li>Dev &#8211; Add custom message for custom system status tools.</li>\n<li>Dev &#8211; Added filters to change which order items are created and loaded to support custom item types.</li>\n<li>Dev &#8211; Updated jQuery payment and serializejson libraries.</li>\n<li>Localization &#8211; Added Bolivian states.</li>\n<li>Localization &#8211; Use VAT for Norway instead of Tax.</li>\n</ul>\n<p><a href=\"https://raw.githubusercontent.com/woocommerce/woocommerce/master/CHANGELOG.txt\" rel=\"nofollow\">See changelog for all versions</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/plugins/woocommerce/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/plugins/all-in-one-seo-pack/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/all-in-one-seo-pack/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 19:30:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins-wp/all-in-one-seo-pack/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"The original SEO plugin for WordPress, downloaded over 30,000,000 times since 2007.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4934:\"<p><!--section=description--></p>\n<p>Use <strong>All in One SEO Pack</strong> to optimize your WordPress site for SEO. It&#8217;s easy and works out of the box for beginners, and has advanced features and an API for developers.</p>\n<p><strong><a href=\"http://semperplugins.com/plugins/all-in-one-seo-pack-pro-version/?loc=readme_utpv\" rel=\"nofollow\">Upgrade to Pro Version</a></strong></p>\n<p><a href=\"http://semperplugins.com/support/?loc=readme_ps\" rel=\"nofollow\">Premium Support</a></p>\n<p>First created in 2007, see why AIOSEO is one of the all time most downloaded plugins for WordPress.</p>\n<ul>\n<li>XML Sitemap support &#8211; submit your sitemap to Google and Bing and improve your SEO</li>\n<li>Google AMP support (Accelerated Mobile Pages)</li>\n<li>Google Analytics support</li>\n<li>Support for SEO on Custom Post Types</li>\n<li>Advanced Canonical URLs</li>\n<li>Redirect attachment pages to parent post</li>\n<li>Automatically notifies search engines like Google and Bing about changes to your site</li>\n<li>Built-in API so other plugins/themes can access and extend functionality</li>\n<li>ONLY free plugin to provide SEO Integration for e-Commerce sites, including WooCommerce</li>\n<li>Nonce Security built into All in One SEO Pack</li>\n<li>Automatically optimizes your <strong>titles</strong> for Google and other search engines</li>\n<li>Generates <strong>META tags automatically</strong></li>\n<li>Avoids the typical duplicate content found on WordPress blogs</li>\n<li>For beginners, you don&#8217;t even have to look at the options, it works out-of-the-box. Just install.</li>\n<li>For advanced users, you can fine-tune everything to optimize your SEO</li>\n<li>You can override any title and set any META description and any META keywords you want.</li>\n<li>Compatibility with many other plugins</li>\n<li>Translated into 57 languages</li>\n<li>PHP 7 100% Compatible</li>\n</ul>\n<p>Follow me on Twitter to keep up with the latest updates <a href=\"http://twitter.com/michaeltorbert/\" rel=\"nofollow\">Michael<br />\nTorbert</a></p>\n<p><iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/46MR4FboMaA?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe></p>\n<h4>Tags</h4>\n<p>seo, SEO, All in One, google, meta, meta description, search engine optimization, xml sitemap, xml sitemaps, google sitemap, sitemap, sitemaps, robots meta, rss, rss footer, yahoo, bing, widget, Post, plugin, admin, posts, shortcode, sidebar, twitter, page, images, comments, image, news sitemaps, XML News Sitemaps, WordPress SEO, multisite, canonical, nofollow, noindex, keywords, meta keywords, description, webmaster tools, google webmaster tools, seo pack, schema.org, search engines, custom post types, custom taxonomies, canonical</p>\n<p><!--section=faq--></p>\n<p>Please visit our complete <strong><a href=\"http://semperplugins.com/documentation/\" rel=\"nofollow\">Documentation</a></strong> before requesting support for SEO from the<br />\n<strong><a href=\"http://semperplugins.com/support/\" rel=\"nofollow\">All in One SEO Pack Support Forum</a></strong></p>\n<p><a href=\"http://semperfiwebdesign.com/documentation/all-in-one-seo-pack/translations-for-all-in-one-seo-pack/\" rel=\"nofollow\">Translations</a></p>\n<dl>\n<dt>General Settings</dt>\n<dd>\n<p><iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/uGt6CVbA5bI?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe></p>\n</dd>\n<dt>XML Sitemaps</dt>\n<dd>\n<p><iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/zvNU92Low8A?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe></p>\n</dd>\n<dt>Social Meta</dt>\n<dd>\n<p><iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/Dfe49FiiAog?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe></p>\n</dd>\n<dt>Performance</dt>\n<dd>\n<p><iframe class=\'youtube-player\' type=\'text/html\' width=\'640\' height=\'390\' src=\'https://www.youtube.com/embed/A0VKinM5s00?version=3&#038;rel=1&#038;fs=1&#038;autohide=2&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;wmode=transparent\' allowfullscreen=\'true\' style=\'border:0;\'></iframe></p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<p>All in One SEO Pack <a href=\"http://semperfiwebdesign.com/documentation/all-in-one-seo-pack/all-in-one-seo-pack-release-history/\" rel=\"nofollow\">Changelog</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/all-in-one-seo-pack/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/google-sitemap-generator/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wordpress.org/plugins/google-sitemap-generator/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Jun 2005 09:33:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins-wp/google-sitemap-generator/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"This plugin will generate a special XML sitemap which will help search engines to better&#8230;\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7635:\"<p><!--section=description--></p>\n<p>This plugin will generate a special XML sitemap which will help search engines like Google, Bing, Yahoo and Ask.com to better index your blog. With such a sitemap, it&#8217;s much easier for the crawlers to see the complete structure of your site and retrieve it more efficiently. The plugin supports all kinds of WordPress generated pages as well as custom URLs. Additionally it notifies all major search engines every time you create a post about the new content.</p>\n<p>Supported since <em>over 9 years</em> and rated as the <a href=\"https://wordpress.org/plugins/browse/top-rated/\">best WordPress plugin</a>, it will do exactly what it&#8217;s supposed to do &#8211; providing a complete XML sitemap for search engines. It will not break your site, slow it down or annoy you. Guaranteed!</p>\n<blockquote>\n<p>If you like the plugin, feel free to rate it (on the right side of this page) or <a href=\"http://www.arnebrachhold.de/redir/sitemap-paypal/\" rel=\"nofollow\">donate via PayPal</a>. I&#8217;m gladly supporting this plugin since over 9 years! Thanks a lot! <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</blockquote>\n<p>Related Links:</p>\n<ul>\n<li><a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/\" title=\"Google XML Sitemaps Plugin for WordPress\" rel=\"nofollow\">Plugin Homepage</a></li>\n<li><a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/changelog/\" title=\"Changelog of the Google XML Sitemaps Plugin for WordPress\" rel=\"nofollow\">Changelog</a></li>\n<li><a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/help/\" title=\"Google Sitemaps FAQ\" rel=\"nofollow\">Plugin help and sitemaps FAQ</a></li>\n<li><a href=\"https://wordpress.org/support/topic/read-before-opening-a-new-support-topic\" rel=\"nofollow\">Support Forum</a></li>\n</ul>\n<h3>License</h3>\n<p>Good news, this plugin is free for everyone! Since it&#8217;s released under the GPL, you can use it free of charge on your personal or commercial blog. But if you enjoy this plugin, you can thank me and leave a <a href=\"http://www.arnebrachhold.de/redir/sitemap-paypal\" title=\"Donate with PayPal\" rel=\"nofollow\">small donation</a> for the time I&#8217;ve spent writing and supporting this plugin. And I really don&#8217;t want to know how many hours of my life this plugin has already eaten <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n<h3>Translations</h3>\n<p>The plugin comes with various translations, please refer to the <a href=\"https://codex.wordpress.org/Installing_WordPress_in_Your_Language\" title=\"Installing WordPress in Your Language\" rel=\"nofollow\">WordPress Codex</a> for more information about activating the translation. If you want to help to translate the plugin to your language, please have a look at the sitemap.pot file which contains all definitions and may be used with a <a href=\"http://www.gnu.org/software/gettext/\" rel=\"nofollow\">gettext</a> editor like <a href=\"http://www.poedit.net/\" rel=\"nofollow\">Poedit</a> (Windows).</p>\n<p><!--section=installation--></p>\n<ol>\n<li>Install the plugin like you always install plugins, either by uploading it via FTP or by using the &#8220;Add Plugin&#8221; function of WordPress.</li>\n<li>Activate the plugin at the plugin administration page</li>\n<li>If you want: Open the plugin configuration page, which is located under Settings -&gt; XML-Sitemap and customize settings like priorities and change frequencies.</li>\n<li>The plugin will automatically update your sitemap of you publish a post, so there is nothing more to do <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></li>\n</ol>\n<p><!--section=faq--></p>\n<dl>\n<dt>Where can I find the options page of the plugin?</dt>\n<dd>\n<p>It is under Settings &gt; XML Sitemap. I know nowadays many plugins add top-level menu items, but in most of the cases it is just not necessary. I&#8217;ve seen WP installations which looked like an Internet Explorer ten years ago with 20 toolbars installed. <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</dd>\n<dt>Do I have to create a sitemap.xml and sitemap.xml.gz by myself?</dt>\n<dd>\n<p>Not anymore. Since version 4, these files are dynamically generated. <em>There must be no sitemap.xml or sitemap.xml.gz in your blog directory anymore!</em> The plugin will try to rename them to sitemap.xml.bak if they still exists.</p>\n</dd>\n<dt>Does this plugin use static files or &#8220;I can&#8217;t find the sitemap.xml file!&#8221;</dt>\n<dd>\n<p>Not anymore. Since version 4, these files are dynamically generated just like any other WordPress content.</p>\n</dd>\n<dt>There are no comments yet (or I&#8217;ve disabled them) and all my postings have a priority of zero!</dt>\n<dd>\n<p>Please disable automatic priority calculation and define a static priority for posts.</p>\n</dd>\n<dt>So many configuration options&#8230; Do I need to change them?</dt>\n<dd>\n<p>No, only if you want to. Default values are ok for most sites.</p>\n</dd>\n<dt>Does this plugin work with all WordPress versions?</dt>\n<dd>\n<p>This version works with WordPress 3.3 and better. If you&#8217;re using an older version, please check the <a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/\" title=\"Google (XML) Sitemap Generator Plugin Homepage\" rel=\"nofollow\">Google Sitemaps Plugin Homepage</a> for the legacy releases. There is a working release for every WordPress version since 1.5, but you really should consider updating your WordPress installation!</p>\n</dd>\n<dt>My question isn&#8217;t answered here</dt>\n<dd>\n<p>Most of the plugin options are described at the <a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/\" rel=\"nofollow\">plugin homepage</a> as well as the dedicated <a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/help/\" title=\"List of common questions / problems regarding Google (XML) Sitemaps\" rel=\"nofollow\">Google Sitemaps FAQ</a>.</p>\n</dd>\n<dt>My question isn&#8217;t even answered there</dt>\n<dd>\n<p>Please post your question at the <a href=\"https://wordpress.org/support/topic/read-before-opening-a-new-support-topic\" rel=\"nofollow\">WordPress support forum</a> and tag your post with &#8220;google-sitemap-generator&#8221;.</p>\n</dd>\n<dt>What&#8217;s new in the latest version?</dt>\n<dd>\n<p>The changelog is maintained <a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/changelog/\" title=\"Google (XML) Sitemap Generator Plugin Changelog\" rel=\"nofollow\">here</a></p>\n</dd>\n<dt>Why is the changelog on a separate page and not here?</dt>\n<dd>\n<p>The WordPress.org repository is just another place to download this plugin. I don&#8217;t want to maintain too many pages with the same content. Thank you for your understanding!</p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<p>You can always find the changelog on <a href=\"http://www.arnebrachhold.de/projects/wordpress-plugins/google-xml-sitemaps-generator/changelog/\" title=\"Google (XML) Sitemap Generator Plugin Changelog\" rel=\"nofollow\">the plugin website</a>, since I don&#8217;t like to maintain the same content on different pages. Thank you for your understanding!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/google-sitemap-generator/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Limit Login Attempts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/limit-login-attempts/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/limit-login-attempts/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Jan 2009 14:20:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins-wp/limit-login-attempts/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"Limit rate of login attempts, including by way of cookies, for each IP. Fully customizable.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11759:\"<p><!--section=description--></p>\n<p>Limit the number of login attempts possible both through normal login as well as using auth cookies.</p>\n<p>By default WordPress allows unlimited login attempts either through the login page or by sending special cookies. This allows passwords (or hashes) to be brute-force cracked with relative ease.</p>\n<p>Limit Login Attempts blocks an Internet address from making further attempts after a specified limit on retries is reached, making a brute-force attack difficult or impossible.</p>\n<p>Features</p>\n<ul>\n<li>Limit the number of retry attempts when logging in (for each IP). Fully customizable</li>\n<li>Limit the number of attempts to log in using auth cookies in same way</li>\n<li>Informs user about remaining retries or lockout time on login page</li>\n<li>Optional logging, optional email notification</li>\n<li>Handles server behind reverse proxy</li>\n<li>It is possible to whitelist IPs using a filter. But you probably shouldn&#8217;t. <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></li>\n</ul>\n<p>Translations: Bulgarian, Brazilian Portuguese, Catalan, Chinese (Traditional), Czech, Dutch, Finnish, French, German, Hungarian, Norwegian, Persian, Romanian, Russian, Spanish, Swedish, Turkish</p>\n<p>Plugin uses standard actions and filters only.</p>\n<p><!--section=installation--></p>\n<ol>\n<li>Download and extract plugin files to a wp-content/plugin directory.</li>\n<li>Activate the plugin through the WordPress admin interface.</li>\n<li>Customize the settings on the options page, if desired. If your server is located behind a reverse proxy make sure to change this setting.</li>\n</ol>\n<p>If you have any questions or problems please make a post here: https://wordpress.org/tags/limit-login-attempts</p>\n<p><!--section=faq--></p>\n<dl>\n<dt>Why not reset failed attempts on a successful login?</dt>\n<dd>\n<p>This is very much by design. Otherwise you could brute force the &#8220;admin&#8221; password by logging in as your own user every 4th attempt.</p>\n</dd>\n<dt>What is this option about site connection and reverse proxy?</dt>\n<dd>\n<p>A reverse proxy is a server in between the site and the Internet (perhaps handling caching or load-balancing). This makes getting the correct client IP to block slightly more complicated.</p>\n<p>The option default to NOT being behind a proxy &#8212; which should be by far the common case.</p>\n</dd>\n<dt>How do I know if my site is behind a reverse proxy?</dt>\n<dd>\n<p>You probably are not or you would know. We show a pretty good guess on the option page. Set the option using this unless you are sure you know better.</p>\n</dd>\n<dt>Can I whitelist my IP so I don&#8217;t get locked out?</dt>\n<dd>\n<p>First please consider if you really need this. Generally speaking it is not a good idea to have exceptions to your security policies.</p>\n<p>That said, there is now a filter which allows you to do it: &#8220;limit_login_whitelist_ip&#8221;.</p>\n<p>Example:<br />\nfunction my_ip_whitelist($allow, $ip) {<br />\n     return ($ip == &#8216;my-ip&#8217;) ? true : $allow;<br />\n}<br />\nadd_filter(&#8216;limit_login_whitelist_ip&#8217;, &#8216;my_ip_whitelist&#8217;, 10, 2);</p>\n<p>Note that we still do notification and logging as usual. This is meant to allow you to be aware of any suspicious activity from whitelisted IPs.</p>\n</dd>\n<dt>I locked myself out testing this thing, what do I do?</dt>\n<dd>\n<p>Either wait, or:</p>\n<p>If you know how to edit / add to PHP files you can use the IP whitelist functionality described above. You should then use the &#8220;Restore Lockouts&#8221; button on the plugin settings page and remove the whitelist function again.</p>\n<p>If you have ftp / ssh access to the site rename the file &#8220;wp-content/plugins/limit-login-attempts/limit-login-attempts.php&#8221; to deactivate the plugin.</p>\n<p>If you have access to the database (for example through phpMyAdmin) you can clear the limit_login_lockouts option in the wordpress options table. In a default setup this would work: &#8220;UPDATE wp_options SET option_value = &#8221; WHERE option_name = &#8216;limit_login_lockouts\'&#8221;</p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<h4>1.7.1</h4>\n<p>This version fixes a security bug in version 1.6.2 and 1.7.0. Please upgrade immediately.</p>\n<p>&#8220;Auth cookies&#8221; are special cookies set at login that authenticating you to the system. It is how WordPress &#8220;remembers&#8221; that you are logged in between page loads.</p>\n<p>During lockout these are supposed to be cleared, but a change in 1.6.2 broke this. It allowed an attacker to keep trying to break these cookies during a lockout.</p>\n<p>Lockout of normal password login attempts still worked as it should, and it appears that all &#8220;auth cookie&#8221; attempts would keep getting logged.</p>\n<p>In theory the &#8220;auth cookie&#8221; is quite resistant to brute force attack. It contains a cryptographic hash of the user password, and the difficulty to break it is not based on the password strength but instead on the cryptographic operations used and the length of the hash value. In theory it should take many many years to break this hash. As theory and practice does not always agree it is still a good idea to have working lockouts of any such attempts.</p>\n<h4>1.7.0</h4>\n<ul>\n<li>Added filter that allows whitelisting IP. Please use with care!!</li>\n<li>Update to Spanish translation, thanks to Marcelo Pedra</li>\n<li>Updated Swedish translation</li>\n<li>Tested against WordPress 3.3.2</li>\n</ul>\n<h4>1.6.2</h4>\n<ul>\n<li>Fix bug where log would not get updated after it had been cleared</li>\n<li>Do plugin setup in &#8216;init&#8217; action</li>\n<li>Small update to Spanish translation file, thanks to Marcelo Pedra</li>\n<li>Tested against WordPress 3.2.1</li>\n</ul>\n<h4>1.6.1</h4>\n<ul>\n<li>(WordPress 3.0+) An invalid cookie can sometimes get sent multiple times before it gets cleared, resulting in multiple failed attempts or even a lockout from a single invalid cookie. Store the latest failed cookie to make sure we only count it as one failed attempt</li>\n<li>Define &#8220;Text Domain&#8221; correctly</li>\n<li>Include correct Dutch tranlation file. Thanks to Martin1 for noticing. Thanks again to Bjorn Wijers for the translation</li>\n<li>Updated POT file for this version</li>\n<li>Tested against WordPress 3.1-RC4</li>\n</ul>\n<h4>1.6.0</h4>\n<ul>\n<li>Happy New Year</li>\n<li>Tested against WordPress 3.1-RC1</li>\n<li>Plugin now requires WordPress version 2.8+. Of course you should never ever use anything but the latest version</li>\n<li>Fixed deprecation warnings that had been piling up with the old version requirement. Thanks to Johannes Ruthenberg for the report that prompted this</li>\n<li>Removed auth cookie admin check for version 2.7.</li>\n<li>Make sure relevant values in $_COOKIE get cleared right away on auth cookie validation failure. There are still some problems with cookie auth handling. The lockout can trigger prematurely in rare cases, but fixing it is plugin version 2 stuff unfortunately.</li>\n<li>Changed default time for retries to reset from 24 hours to 12 hours. The security impact is very minor and it means the warning will disappear &#8220;overnight&#8221;</li>\n<li>Added question to FAQ (&#8220;Why not reset failed attempts on a successful login?&#8221;)</li>\n<li>Updated screenshots</li>\n</ul>\n<h4>1.5.2</h4>\n<ul>\n<li>Reverted minor cookie-handling cleanup which might somehow be responsible for recently reported cookie related lockouts</li>\n<li>Added version 1.x Brazilian Portuguese translation, thanks to Luciano Passuello</li>\n<li>Added Finnish translation, thanks to Ari Kontiainen</li>\n</ul>\n<h4>1.5.1</h4>\n<ul>\n<li>Further multisite &amp; WPMU support (again thanks to <a href=\"mailto:&#101;&#114;&#105;&#x6b;&#x40;&#101;&#114;&#105;&#x6b;&#x73;&#x68;&#111;&#115;t&#x69;&#x6e;&#103;&#046;c&#x6f;&#x6d;\" rel=\"nofollow\">&#101;&#114;&#105;&#x6b;&#x40;&#101;&#114;&#105;&#x6b;&#x73;&#x68;&#111;&#115;t&#x69;&#x6e;&#103;&#046;c&#x6f;&#x6d;</a>)</li>\n<li>Better error handling if option variables are damaged</li>\n<li>Added Traditional Chinese translation, thanks to Denny Huang <a href=\"mailto:&#x62;&#105;&#x67;&#101;&#x78;&#112;&#x6c;&#111;&#114;&#x61;&#116;&#x69;&#111;&#x6e;&#115;&#064;&#x62;&#105;&#x67;&#101;&#x78;&#112;&#108;&#x6f;&#114;&#x61;&#116;&#x69;&#111;n&#x73;&#046;&#x63;&#111;&#x6d;&#046;t&#x77;\" rel=\"nofollow\">&#x62;&#105;&#x67;&#101;&#x78;&#112;&#x6c;&#111;&#114;&#x61;&#116;&#x69;&#111;&#x6e;&#115;&#064;&#x62;&#105;&#x67;&#101;&#x78;&#112;&#108;&#x6f;&#114;&#x61;&#116;&#x69;&#111;n&#x73;&#046;&#x63;&#111;&#x6d;&#046;t&#x77;</a></li>\n</ul>\n<h4>1.5</h4>\n<ul>\n<li>Tested against WordPress 3.0</li>\n<li>Handle 3.0 login page failure &#8220;shake&#8221;</li>\n<li>Basic multisite support (parts thanks to <a href=\"mailto:&#101;&#114;&#105;&#x6b;&#x40;&#101;&#114;&#105;&#x6b;&#x73;&#x68;&#111;&#115;t&#x69;&#x6e;&#103;&#046;c&#x6f;&#x6d;\" rel=\"nofollow\">&#101;&#114;&#105;&#x6b;&#x40;&#101;&#114;&#105;&#x6b;&#x73;&#x68;&#111;&#115;t&#x69;&#x6e;&#103;&#046;c&#x6f;&#x6d;</a>)</li>\n<li>Added Dutch translation, thanks to Bjorn Wijers <a href=\"mailto:b&#117;&#x72;&#111;&#x62;&#x6a;&#111;&#x72;n&#064;&#x62;&#117;&#x72;&#x6f;&#098;&#x6a;&#111;&#114;&#x6e;&#046;&#x6e;l\" rel=\"nofollow\">b&#117;&#x72;&#111;&#x62;&#x6a;&#111;&#x72;n&#064;&#x62;&#117;&#x72;&#x6f;&#098;&#x6a;&#111;&#114;&#x6e;&#046;&#x6e;l</a></li>\n<li>Added Hungarian translation, thanks to B?lint Vereskuti <a href=\"mailto:&#098;&#097;&#x6c;&#x69;&#110;&#116;&#x40;v&#101;&#x72;&#x65;&#115;&#107;&#x75;&#x74;&#105;&#046;&#x69;n&#102;&#x6f;\" rel=\"nofollow\">&#098;&#097;&#x6c;&#x69;&#110;&#116;&#x40;v&#101;&#x72;&#x65;&#115;&#107;&#x75;&#x74;&#105;&#046;&#x69;n&#102;&#x6f;</a></li>\n<li>Added French translation, thanks to oVa <a href=\"mailto:&#111;&#118;&#x61;&#x31;&#x33;l&#097;&#115;&#x74;&#x61;&#x72;&#064;&#103;&#109;&#097;&#x69;&#x6c;&#x2e;&#099;&#111;&#109;\" rel=\"nofollow\">&#111;&#118;&#x61;&#x31;&#x33;l&#097;&#115;&#x74;&#x61;&#x72;&#064;&#103;&#109;&#097;&#x69;&#x6c;&#x2e;&#099;&#111;&#109;</a></li>\n</ul>\n<h4>1.4.1</h4>\n<ul>\n<li>Added Turkish translation, thanks to Yazan Canarkadas</li>\n</ul>\n<h4>1.4</h4>\n<ul>\n<li>Protect admin page update using wp_nonce</li>\n<li>Added Czech translation, thanks to Jakub Jedelsky</li>\n</ul>\n<h4>1.3.2</h4>\n<ul>\n<li>Added Bulgarian translation, thanks to Hristo Chakarov</li>\n<li>Added Norwegian translation, thanks to Rune Gulbrands?y</li>\n<li>Added Spanish translation, thanks to Marcelo Pedra</li>\n<li>Added Persian translation, thanks to Mostafa Soufi</li>\n<li>Added Russian translation, thanks to Jack Leonid (http://studio-xl.com)</li>\n</ul>\n<h4>1.3.1</h4>\n<ul>\n<li>Added Catalan translation, thanks to Robert Buj</li>\n<li>Added Romanian translation, thanks to Robert Tudor</li>\n</ul>\n<h4>1.3</h4>\n<ul>\n<li>Support for getting the correct IP for clients while server is behind reverse proxy, thanks to Michael Skerwiderski</li>\n<li>Added German translation, thanks to Michael Skerwiderski</li>\n</ul>\n<h4>1.2</h4>\n<ul>\n<li>No longer replaces pluggable function when cookie handling active. Re-implemented using available actions and filters</li>\n<li>Filter error messages during login to avoid information leak regarding available usernames</li>\n<li>Do not show retries or lockout messages except for login (registration, lost password pages). No change in actual enforcement</li>\n<li>Slightly more aggressive in trimming old retries data</li>\n</ul>\n<h4>1.1</h4>\n<ul>\n<li>Added translation support</li>\n<li>Added Swedish translation</li>\n<li>During lockout, filter out all other login errors</li>\n<li>Minor cleanups</li>\n</ul>\n<h4>1.0</h4>\n<ul>\n<li>Initial version</li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/limit-login-attempts/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n		\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wordpress.org/plugins/tinymce-advanced/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/tinymce-advanced/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Jun 2007 06:02:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wordpress.org/plugins-wp/tinymce-advanced/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Extends and enhances TinyMCE, the WordPress Visual Editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10701:\"<p><!--section=description--></p>\n<p>This plugin will let you add, remove and arrange the buttons that are shown on the Visual Editor toolbar. You can configure up to four rows of buttons including Font Sizes, Font Family, text and background colors, tables, etc. It will also let you enable the editor menu, see the <a href=\"screenshots\" rel=\"nofollow\">screenshots</a>.</p>\n<p>It includes 15 plugins for <a href=\"http://tinymce.com/\" rel=\"nofollow\">TinyMCE</a> that are automatically enabled or disabled depending on the buttons you have chosen. In addition this plugin adds some commonly used options as keeping the paragraph tags in the Text editor and importing the CSS classes from the theme&#8217;s editor-style.css.</p>\n<h4>Some of the features added by this plugin</h4>\n<ul>\n<li>Support for creating and editing tables.</li>\n<li>More options when inserting lists.</li>\n<li>Search and Replace in the editor.</li>\n<li>Ability to set Font Family and Font Sizes.</li>\n<li>And many others.</li>\n</ul>\n<p>With this plugin you can also enable the TinyMCE menu above the toolbars. This will make the editor even more powerful and convenient.</p>\n<p><!--section=installation--></p>\n<p>Best is to install directly from WordPress. If manual installation is required, please make sure that the plugin files are in a folder named &#8220;tinymce-advanced&#8221; (not two nested folders) in the WordPress plugins folder, usually &#8220;wp-content/plugins&#8221;.</p>\n<p><!--section=faq--></p>\n<dl>\n<dt>Installation Instructions</dt>\n<dd>\n<p>Best is to install directly from WordPress. If manual installation is required, please make sure that the plugin files are in a folder named &#8220;tinymce-advanced&#8221; (not two nested folders) in the WordPress plugins folder, usually &#8220;wp-content/plugins&#8221;.</p>\n</dd>\n<dt>No styles are imported in the Formats sub-menu.</dt>\n<dd>\n<p>These styles are imported from your current theme editor-style.css file. However some themes do not have this functionality. For these themes TinyMCE Advanced has the option to let you add a customized editor-style.css and import it into the editor.</p>\n</dd>\n<dt>I have just installed this plugin, but it does not do anything.</dt>\n<dd>\n<p>Change some buttons on one of the toolbars, save your changes, clear your browser cache, and try again. If that does not work try reloding the Edit page several times while holding down Shift or Ctrl. There may also be a network cache somewhere between you and your host. You may need to wait for a few hours until this cache expires.</p>\n</dd>\n<dt>When I add &#8220;Smilies&#8221;, they do not show in the editor.</dt>\n<dd>\n<p>The &#8220;Emoticons&#8221; button in TinyMCE adds the codes for the smilies. The actual images are added by WordPress when viewing the Post. Make sure the checkbox &#8220;Convert emoticons to graphics on display&#8221; in &#8220;Options &#8211; Writing&#8221; is checked.</p>\n</dd>\n<dt>The plugin does not add any buttons.</dt>\n<dd>\n<p>Make sure the &#8220;Disable the visual editor when writing&#8221; checkbox under &#8220;Users &#8211; Your Profile&#8221; is <strong>not</strong> checked.</p>\n</dd>\n<dt>I still see the &#8220;old&#8221; buttons in the editor</dt>\n<dd>\n<p>Click the &#8220;Restore Default Settings&#8221; button on the plugin settings page and then set the buttons again and save.</p>\n</dd>\n<dt>Other questions? More screenshots?</dt>\n<dd>\n<p>Please post on the support forum or visit the homepage for <a href=\"http://www.laptoptips.ca/projects/tinymce-advanced/\" rel=\"nofollow\">TinyMCE Advanced</a>.</p>\n</dd>\n</dl>\n<p><!--section=changelog--></p>\n<h4>4.6.3</h4>\n<ul>\n<li>Updated for WordPress 4.8 and TinyMCE 4.6.3.</li>\n</ul>\n<h4>4.5.6</h4>\n<ul>\n<li>Updated for WordPress 4.7.4 and TinyMCE 4.5.6.</li>\n<li>Fixed PHP notice after importing settings.</li>\n</ul>\n<h4>4.4.3</h4>\n<ul>\n<li>Updated for WordPress 4.7 and TinyMCE 4.4.3.</li>\n<li>Fixed missing &#8220;Source code&#8221; button bug.</li>\n</ul>\n<h4>4.4.1</h4>\n<ul>\n<li>Updated for WordPress 4.6 and TinyMCE 4.4.1.</li>\n<li>Fixed multisite saving bug.</li>\n<li>Added new button in the Text editor to add or reset the line breaks. Adds line breaks only between tags. Works only when it detects that line breaks are missing so it doesn&#8217;t reformat posts with removed paragraphs.</li>\n</ul>\n<h4>4.3.10.1</h4>\n<ul>\n<li>Fixed adding paragraph tags when loading posts that were saved before turning autop off.</li>\n<li>Disabled the (new) inline toolbar for tables as it was overlapping the table in some cases.</li>\n</ul>\n<h4>4.3.10</h4>\n<ul>\n<li>Updated for WordPress 4.5.1 and TinyMCE 4.3.10.</li>\n<li>Fixed support for adding editor-style.css to themes that don&#8217;t have it.</li>\n</ul>\n<h4>4.3.8</h4>\n<ul>\n<li>Updated for WordPress 4.5 and TinyMCE 4.3.8.</li>\n<li>Separated standard options and admin options.</li>\n<li>Added settings that can disable the plugin for the main editor, other editors in wp-admin or editors on the front-end.</li>\n<li>Korean translation by Josh Kim and Greek translation by Stathis Mellios.</li>\n</ul>\n<h4>4.2.8</h4>\n<ul>\n<li>Updated for WordPress 4.4 and TinyMCE 4.2.8.</li>\n<li>Japanese translation by Manabu Miwa.</li>\n</ul>\n<h4>4.2.5</h4>\n<ul>\n<li>Updated for WordPress 4.3.1 and TinyMCE 4.2.5.</li>\n<li>Fixed text domain and plugin headers.</li>\n</ul>\n<h4>4.2.3.1</h4>\n<ul>\n<li>Fix error with removing the &#8216;textpattern&#8217; plugin.</li>\n</ul>\n<h4>4.2.3</h4>\n<ul>\n<li>Updated for WordPress 4.3 and TinyMCE 4.2.3.</li>\n<li>Removed the &#8216;textpattern&#8217; plugin as WordPress 4.3 includes similar functionality by default.</li>\n<li>French translation by Nicolas Schneider.</li>\n</ul>\n<h4>4.1.9</h4>\n<ul>\n<li>Updated for WordPress 4.2 and TinyMCE 4.1.9.</li>\n<li>Fixed bugs with showing oEmbed previews when pasting an URL.</li>\n<li>Fixed bugs with getting the content from TinyMCE with line breaks.</li>\n</ul>\n<h4>4.1.7</h4>\n<ul>\n<li>Updated for WordPress 4.1 and TinyMCE 4.1.7.</li>\n<li>Fixed bug where consecutive caption shortcodes may be split with an empty paragraph tag.</li>\n</ul>\n<h4>4.1.1</h4>\n<ul>\n<li>Fix bug with image captions when wpautop is disabled.</li>\n<li>Add translation support to the settings page. Button names/descriptions are translated from JS using the existing WordPress translation, so this part of the settings page will be translated by default. The other text still needs separate translation.</li>\n</ul>\n<h4>4.1</h4>\n<ul>\n<li>Updated for WordPress 4.0 and TinyMCE 4.1.</li>\n<li>Add the &#8216;textpattern&#8217; plugin that supports some of the markdown syntax while typing, <a href=\"http://www.tinymce.com/wiki.php/Configuration:textpattern_patterns\" rel=\"nofollow\">(more info)</a>.</li>\n<li>Add the updated &#8216;table&#8217; plugin that supports background and border color.</li>\n</ul>\n<h4>4.0.2</h4>\n<ul>\n<li>Fix showing of the second, third and forth button rows when the Toolbar Toggle button is not used.</li>\n<li>Fix adding the &#8221;directionality&#8221; plugin when RTL or LTR button is selected.</li>\n<li>Show the &#8221;Advanced Options&#8221; to super admins on multisite installs.</li>\n<li>Add the &#8221;link&#8221; plugin including link rel setting. Replaces the Insert/Edit Link dialog when enabled.</li>\n<li>Include updated &#8221;table&#8221; plugin that has support for vertical align for cells.</li>\n</ul>\n<h4>4.0.1</h4>\n<p>Fix warnings on pages other than Edit Post. Update the description.</p>\n<h4>4.0</h4>\n<p>Updated for WordPress 3.9 and TinyMCE 4.0. Refreshed the settings screen. Added support for exporting and importing of the settings.</p>\n<h4>3.5.9.1</h4>\n<p>Updated for WordPress 3.8, fixed auto-embedding of single line URLs when not removing paragraph tags.</p>\n<h4>3.5.9</h4>\n<p>Updated for WordPress 3.7 and TinyMCE 3.5.9.</p>\n<h4>3.5.8</h4>\n<p>Updated for WordPress 3.5 and TinyMCE 3.5.8.</p>\n<h4>3.4.9</h4>\n<p>Updated for WordPress 3.4 and TinyMCE 3.4.9.</p>\n<h4>3.4.5.1</h4>\n<p>Fixed a bug preventing TinyMCE from importing CSS classes from editor-style.css.</p>\n<h4>3.4.5</h4>\n<p>Updated for WordPress 3.3 or later and TinyMCE 3.4.5.</p>\n<h4>3.4.2.1</h4>\n<p>Fix the removal of the <em>media</em> plugin so it does not require re-saving the settings.</p>\n<h4>3.4.2</h4>\n<p>Compatibility with WordPress 3.2 and TinyMCE 3.4.2, removed the options for support for iframe and HTML 5.0 elements as they are supported by default in WordPress 3.2, removed the <em>media</em> plugin as it is included by default.</p>\n<h4>3.3.9.1</h4>\n<p>Added advanced options: stop removing iframes, stop removing HTML 5.0 elements, moved the support for custom editor styles to editor-style.css in the current theme.</p>\n<p>Attention: if you have a customized tadv-mce.css file and your theme doesn&#8217;t have editor-style.css, please download tadv-mce.css, rename it to editor-style.css and upload it to your current theme directory. Alternatively you can add there the editor-style.css from the Twenty Ten theme. If your theme has editor-style.css you can add any custom styles there.</p>\n<h4>3.3.9</h4>\n<p>Compatibility with WordPress 3.1 and TinyMCE 3.3.9, improved P and BR tags option.</p>\n<h4>3.2.7</h4>\n<p>Compatibility with WordPress 2.9 and TinyMCE 3.2.7, several minor bug fixes.</p>\n<h4>3.2.4</h4>\n<p>Compatibility with WordPress 2.8 and TinyMCE 3.2.4, minor bug fixes.</p>\n<h4>3.2</h4>\n<p>Compatibility with WordPress 2.7 and TinyMCE 3.2, minor bug fixes.</p>\n<h4>3.1</h4>\n<p>Compatibility with WordPress 2.6 and TinyMCE 3.1, keeps empty paragraphs when disabling the removal of P and BR tags, the buttons for MCImageManager and MCFileManager can be arranged (if installed).</p>\n<h4>3.0.1</h4>\n<p>Compatibility with WordPress 2.5.1 and TinyMCE 3.0.7, added option to disable the removal of P and BR tags when saving and in the HTML editor (autop), added two more buttons to the HTML editor: autop and undo, fixed the removal of non-default TinyMCE buttons.</p>\n<h4>3.0</h4>\n<p>Support for WordPress 2.5 and TinyMCE 3.0.</p>\n<h4>2.2</h4>\n<p>Deactivate/Uninstall option page, font size drop-down menu and other small changes.</p>\n<h4>2.1</h4>\n<p>Improved language selection, improved compatibility with WordPress 2.3 and TinyMCE 2.1.1.1, option to override some of the imported css classes and other small improvements and bugfixes.</p>\n<h4>2.0</h4>\n<p>Includes an admin page for arranging the TinyMCE toolbar buttons, easy installation, a lot of bugfixes, customized &#8220;Smilies&#8221; plugin that uses the built-in WordPress smilies, etc. The admin page uses jQuery and jQuery UI that lets you &#8220;drag and drop&#8221; the TinyMCE buttons to arrange your own toolbars and enables/disables the corresponding plugins depending on the used buttons.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/tinymce-advanced/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:50:\"https://wordpress.org/plugins/browse/popular/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 05 Jul 2017 12:10:49 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 05 Jul 2017 11:59:42 GMT\";s:4:\"link\";s:66:\"<https://wordpress.org/plugins/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}}s:5:\"build\";s:14:\"20130911010210\";}', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(2659, '_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9', '1499299621', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(2660, '_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9', 'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"WPTavern: WordCamp Europe 2017 Posts 24% No-Show Rate, Cites Early Ticket Sales and Expensive Location\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72644\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://wptavern.com/wordcamp-europe-2017-posts-24-no-show-rate-cites-early-ticket-sales-and-expensive-location\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3872:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/wordcamp-europe-venue.jpg?ssl=1\"><img /></a>photo credit: WP Tavern\n<p>WordCamp Europe 2017 organizers have posted <a href=\"https://2017.europe.wordcamp.org/2017/06/30/wordcamp-europe-2017-in-paris-its-a-wrap/\" target=\"_blank\">attendance and budget data</a> compiled after the conclusion of the event. Despite being <a href=\"https://2017.europe.wordcamp.org/do-not-miss-the-biggest-wordcamp-in-europe/\" target=\"_blank\">promoted</a> as &#8220;the largest WordPress event to this day&#8221; with more than 3,000 expected attendees, WCEU 2017 fell short with 1,900 people on the ground. Attendees were 5% fewer than last year&#8217;s 2,000 in Vienna. Expectations ran high but organizers could not predict the 24% no-show rate once the event got started. This is more than double the 10% no-show rate for the previous four years.</p>\n<p>The camp&#8217;s organizers do not have a simple explanation for the high no-show rate, but cite several factors, including a few dozen participants being <a href=\"https://wptavern.com/wordcamp-europe-attendees-are-being-denied-visas-because-conference-ticket-price-is-too-low\" target=\"_blank\">denied visas</a>, higher local sales, an expensive location, and putting tickets on sale too early. Approximately 60% of attendees were from nearby countries, such as France, Great Britain, Germany, Belgium, and the Netherlands.</p>\n<p>Ticket sales for 2017 were open immediately at the conclusion of the 2016 event in Vienna. Organizers found that tickets sold in the first six months had a 34% no-show rate as compared to 20% for those sold in 2017. As the event has often sold out in the past, prospective attendees may have felt pressure to purchase a ticket in advance without confirming the ability to attend. </p>\n<p>Posting increasingly higher attendance numbers isn&#8217;t one of the goals of the WordCamp, but planning accurately for the number of people who will attend is crucial for resource and budget planning. When one in four attendees is a no-show, the plans for food, swag, venue accommodations, and other aspects of the event are askew.</p>\n<p>Organizers did not mention <a href=\"https://wptavern.com/wordcamp-europe-2017-kicks-off-with-contributor-day-focused-on-growing-wordpress-through-inclusion\" target=\"_blank\">Contributor Day</a> attendance in the wrap-up report, but this may have been one of the most successful aspects of the event. It was held prior to the main conference days, which may explain the event&#8217;s unusually high attendance numbers. Organizers hosted 473 attendees for the 500 available contributors slots. </p>\n<h3>WordCamp Europe 2017 Cost 300€ per Attendee, Sponsors Covered 80%</h3>\n<p>WordCamp Europe&#8217;s wrap-up report also includes a transparent breakdown of the event&#8217;s 700k€ budget. Catering costs for lunches, snacks and drinks, made up 50% of the budget. However, organizers were limited to the venue&#8217;s catering partners, which blurs the line between actual food versus venue costs. </p>\n<p>The team was unable to sell all of the sponsorship packages and was forced to reduce the budget by 149k€ along the way. WordCamp Central subsidized 10€/ticket and covered the final deficit of 28k€. The cost breakdown per attendee was 300€ with sponsors covering 80%, WordCamp Central 7%, and tickets sales 13%. These numbers show that the 40€ ticket price is a small fraction of the total costs required for an event of this size. </p>\n<p>Organizers said they felt it was important to share the data for educational purposes but also to &#8220;demonstrate to everyone who might have a doubt, that maintaining the ticket fee very low is meant to make our events accessible to all, but that the fee is not an indicator of the value of the conference.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Jul 2017 19:06:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Dev Blog: The Month in WordPress: June 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4865\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2017/07/the-month-in-wordpress-june-2017/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9049:\"<p><i>We&#8217;re starting a new regular feature on this blog today. We&#8217;d like to keep everyone up-to-date about the happenings all across the WordPress open source project and highlight how you can get involved, so we&#8217;ll be posting a roundup of all the major WordPress news at the end of every month.</i></p>\n<p>Aside from other general news, the three big events in June were the release of WordPress 4.8, WordCamp Europe 2017, and the WordPress Community Summit. Read on to hear more about these as well as other interesting stories from around the WordPress world.</p>\n<hr />\n<h2>WordPress 4.8</h2>\n<p>On June 8, a week before the Community Summit and WordCamp Europe,<a href=\"https://wordpress.org/news/2017/06/evans/\"> WordPress 4.8 was released</a>.You can read<a href=\"https://make.wordpress.org/core/2017/05/26/wordpress-4-8-field-guide/\"> the Field Guide</a> for a comprehensive overview of all the features of this release (the News and Events widget in the dashboard is one of the major highlights).</p>\n<p>Most people would either have their version auto-updated, or their hosts would have updated it for them. For the rest, the updates have gone smoothly with no major issues reported so far.</p>\n<p>This WordPress release saw contributions from 346 individuals; you can find their names in <a href=\"https://wordpress.org/news/2017/06/evans/\">the announcement post</a>. To get involved in building WordPress core, jump into the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>, and follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>.</p>\n<h2>WordCamp Europe 2017</h2>\n<p><a href=\"https://2017.europe.wordcamp.org/\">WordCamp Europe 2017</a> was held in Paris between June 15-17. The event began with a Contributor Day, followed by two days of talks and community goodness. The talks were live-streamed, but you can still catch all the recordings <a href=\"http://wordpress.tv/event/wordcamp-europe-2017/\">on WordPress.tv</a>. The organisers also published <a href=\"https://2017.europe.wordcamp.org/2017/06/30/wordcamp-europe-2017-in-paris-its-a-wrap/\">a handy wrap-up of the event</a>.</p>\n<p>WordCamp Europe exists to bring together the WordPress community from all over the continent, as well as to inspire local communities everywhere to get their own events going — to that end, the event was a great success, as a host of new meetup groups have popped up in the weeks following WordCamp Europe.</p>\n<p>The work that Contributor Day participants accomplished was both varied and valuable, covering all aspects of the WordPress project — have a look through <a href=\"https://make.wordpress.org/\">the Make blogs</a> for updates from each team.</p>\n<p>Finally, we also learned during the event that <a href=\"https://2017.europe.wordcamp.org/2017/06/17/belgrade-serbia-to-host-wordcamp-europe-2018/\">WordCamp Europe 2018 will be held in Belgrade, Serbia</a>, continuing the tradition of exploring locations and communities across the continent.</p>\n<h2>WordPress Community Summit</h2>\n<p>The fourth WordPress Community Summit took place during the two days leading up to WordCamp Europe 2017. This event is an invite-only unconference where people from all over the WordPress community come together to discuss some of the more difficult issues in the community, as well as to make plans for the year ahead in each of the contribution teams.</p>\n<p>As the Summit is designed to be a safe space for all attendees, the notes from each discussion are in the process of being anonymized before we publish them on <a href=\"https://make.wordpress.org/summit/\">the Summit blog</a> (so stay tuned &#8211; they’ll show up there over the next few weeks).</p>\n<p>You can already see the final list of topics that were proposed for the event <a href=\"https://make.wordpress.org/summit/2017/06/10/community-summit-2017-final-list-of-topic/\">here</a> (although a few more were added during the course of the two day Summit).</p>\n<h2>WordPress marketing push continues apace</h2>\n<p>As part of the push to be more intentional in marketing WordPress (as per Matt Mullenweg&#8217;s <a href=\"http://wordpress.tv/2016/12/07/matt-mullenweg-state-of-the-word-2016/\">2016 State of the Word</a>), the Marketing team has launched two significant drives to obtain more information about who uses WordPress and how that information can shape their outreach and messaging efforts.</p>\n<p><a href=\"https://make.wordpress.org/marketing/2017/06/15/wordpress-case-studies-and-usage-survey/\">The team is looking for WordPress case studies</a> and is asking users, agencies, and freelancers to take a WordPress usage survey. This will go a long way towards establishing a marketing base for WordPress as a platform and as a community — and many people in the community are looking forward to seeing this area develop further.</p>\n<p>To get involved in the WordPress Marketing team, you can visit <a href=\"https://make.wordpress.org/marketing/\">their team blog</a>.</p>\n<h2>New Gutenberg editor available for testing</h2>\n<p>For some time now, the Core team has been hard at work on a brand-new text editor for WordPress — this project has been dubbed “Gutenberg.” The project’s ultimate goal is to replace the existing TinyMCE editor, but for now it is in beta and available for public testing — <a href=\"https://wordpress.org/plugins/gutenberg/\">you can download it here as a plugin</a> and install it on any WordPress site.</p>\n<p>This feature is still in beta, so we don’t recommend using it on a production site. If you test it out, though, you’ll find that it is a wholly different experience to what you are used to in WordPress. It’s a more streamlined, altogether cleaner approach to the text-editing experience than we’ve had before, and something that many people are understandably excited about. Matt Mullenweg discussed the purpose of Gutenberg in more detail during <a href=\"http://wordpress.tv/2017/07/01/interview-and-qanda-with-matt-mullenweg/\">his Q&amp;A at WordCamp Europe</a>.</p>\n<p>There are already a few reviews out from <a href=\"https://kinsta.com/blog/gutenberg-wordpress-editor/\">Brian Jackson at Kinsta</a>, <a href=\"https://daily.jorb.in/2017/06/random-thoughts-on-gutenberg/\">Aaron Jorbin</a>, and <a href=\"https://www.mattcromwell.com/gutenberg-first-impressions/\">Matt Cromwell</a> (among many others). Keep in mind that the project is in constant evolution at this stage; when it eventually lands in WordPress core (probably in v5.0), it could look very different from its current iteration — that’s what makes this beta stage and user testing so important.</p>\n<p>To get involved with shaping the future of Gutenberg, please <a href=\"https://make.wordpress.org/test/handbook/call-for-testing/gutenberg-testing/\">test it out</a>, and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>. You can also visit <a href=\"https://github.com/WordPress/gutenberg\">the project’s GitHub repository</a> to report issues and contribute to the codebase.</p>\n<hr />\n<h2>Further reading:</h2>\n<ul>\n<li>Bridget Willard <a href=\"https://make.wordpress.org/community/2017/06/21/proposed-wordcamp-editorial-calendar/\">has proposed an editorial calendar</a> to assist WordCamp organizers with publishing content for their event.</li>\n<li>A new kind of niche WordCamp, <a href=\"https://2017-denver.journalist.wordcamp.org/\">WordCamp for Publishers in Denver</a>, has opened ticket sales.</li>\n<li>The WordPress iOS app was updated with <a href=\"https://en.blog.wordpress.com/2017/06/21/an-all-new-media-library-for-the-wordpress-ios-app/\">a fresh, new media library</a> this month.</li>\n<li>It looks like <i>Underscores</i>, the popular WordPress starter theme, <a href=\"https://themeshaper.com/2017/06/26/the-future-of-underscores-and-a-new-committer/\">has a bright future ahead of it</a>, with a renewed vision and new committer.</li>\n<li>The always-inspiring Tom McFarlin <a href=\"https://tommcfarlin.com/simple-autoloader-for-wordpress\">has released a simple autoloader for WordPress</a> that looks very useful indeed.</li>\n<li>After a bit of a discussion on Twitter regarding the differences between WordPress.org, WordPress.com, and Jetpack, <a href=\"https://helen.wordpress.com/2017/06/21/restaurant-vs-meal-kit-vs-grocery-shopping-or-wordpress-com-vs-jetpack-vs-wordpress-org/\">Helen Hou-Sandí came up with a great analogy</a> and an interesting post about it all.</li>\n<li>If you’re interested in contributing specifically to the JavaScript or PHP areas of the WordPress core codebase, then the new #core-js and #core-php channels in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a> are perfect for you.</li>\n</ul>\n<p><i>If you have a story we should consider including in the next “Month in WordPress” post, please </i><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><i>submit it here</i></a><i>.</i></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Jul 2017 11:42:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WPTavern: Gutenberg Contributors Explore Adding Drag-and-Drop and Multi-Column Support for Blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72638\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"https://wptavern.com/gutenberg-contributors-explore-adding-drag-and-drop-and-multi-column-support-for-blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6817:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/09/building-blocks.jpg?ssl=1\"><img /></a>photo credit: ruudgreven <a href=\"http://www.flickr.com/photos/40811229@N07/6180817922\">DSC_0012</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc-sa/2.0/\">(license)</a>\n<p>The new Gutenberg editor has an open ticket for <a href=\"https://github.com/WordPress/gutenberg/issues/38#issuecomment-309998712\" target=\"_blank\">allowing users to sort blocks via drag and drop</a>. Blocks can currently be sorted with up and down arrows located to the left of the content but the beta only allows for single-column stacking.</p>\n<p>One of the goals for Gutenberg is to provide &#8220;a page building experience that makes it easy to create rich post layouts.&#8221; As far as layout building goes, the first planned versions of the new editor are very primitive as compared to Wix and Weebly&#8217;s drag and drop website builders where nearly every element on the page can be easily moved to a different position.</p>\n<p>Contributors have been discussing the intricacies of adding this feature to Gutenberg since February. James Nylen <a href=\"https://github.com/WordPress/gutenberg/issues/38#issuecomment-309984280\" target=\"_blank\">summarized some of the challenges</a> that make drag and drop more complicated to implement: </p>\n<blockquote><p>Dragging and dropping a block is not really a one-step operation. It is more like 3:</p>\n<ol>\n<li>Press and hold mouse button or screen</li>\n<li>Move to desired location</li>\n<li>Release</li>\n</ol>\n<p>Step 2 is incredibly difficult to get right, and requires a lot of complicated behaviors like duplicating an item (or at least its general shape and size), scroll handling, and determining the intended new location, especially at the beginning and end of the content. We have all used bad drag-and-drop experiences, and I would argue they are worse than not having it at all.</p>\n<p>That said, for two-dimensional movement with columns, I agree that arrows alone are probably not a good solution. Though mobile support for that is going to be very tricky no matter how it works.</p></blockquote>\n<p>Several commenters on the ticket agree that repeatedly clicking arrows to move blocks is cumbersome and will become untenable in the future when multi-column support is added. This would require up, down, right, and left arrows to rearrange content. Users have come to expect a drag-and-drop interface, because nearly every page builder application offers it.</p>\n<p>&#8220;We are thinking of drag and drop as a progressive enhancement for desktops,&#8221; Joen Asmussen said. &#8220;One that would be great to have, but we should build it after we have explicit button actions in place for doing the same, including splitting into columns in the future. This decision is based on a desire to ensure accessibility as well as mobile devices can play the same game.&#8221;</p>\n<p>Asmussen marked the ticket priority as low in May and removed it from the beta milestone. At this point, users are not likely to see drag and drop in the first release that ships with WordPress core. </p>\n<h3>Multi-Column Layouts Planned for Gutenberg V2</h3>\n<p>The discussion surrounding adding drag-and-drop to the editor naturally leads into <a href=\"https://github.com/WordPress/gutenberg/issues/219\" target=\"_blank\">adding multi-column support</a>. Limiting users to a single column is a one-dimensional approach to designing pages, but contributors don&#8217;t plan to leave Gutenberg without multi-column support for long. </p>\n<p>Geoarge Olaru, a designer at <a href=\"https://pixelgrade.com/\" target=\"_blank\">PixelGrade</a>, shared a <a href=\"https://invis.io/3FAS8VQE8#/222711568_Creating_Columns_-_0\" target=\"_blank\">prototype</a> for adding a simple two or three-grid column layout to Gutenberg. </p>\n<p>&#8220;Extending WordPress further from the default Blog Posts automatically implies the need of multi-column layouts for presentation pages,&#8221; Olaru said. &#8220;I would prefer to tackle this feature upfront, rather than letting every developer do it on his own (see the multitude of page builders plugins).&#8221;</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/06/multi-column-mockup.png?ssl=1\"><img /></a></p>\n<p>&#8220;For the V1 editor, I&#8217;m afraid columns like this is out of scope,&#8221; Asmussen <a href=\"https://github.com/WordPress/gutenberg/issues/219#issuecomment-285330922\" target=\"_blank\">said</a> in reply to a Olaru&#8217;s ticket with mockups and a prototype for multi-column support. &#8220;That&#8217;s not a &#8216;no&#8217; — rather, we need some technical foundations to be solid first, before we commit to the really interesting stuff. But it might be a V1.1, or at the very least something for the customization folks later on in the year. Even before that, it would be good to keep this UI in mind, so that perhaps a plugin can add this even earlier.&#8221; </p>\n<p>Other commenters on the ticket feel more urgency about getting multi-column support into the first version of the editor. One of the concerns is that plugin developers will rush to add columns immediately based on demands from users, who will then have to migrate once core adds support.</p>\n<p>&#8220;Multi column layouts are a must-have,&#8221; Anthony Hortin commented on the ticket. &#8220;At the moment, Gutenberg isn&#8217;t solving any issue. You still end up with one long column of content. The whole reason page builders are so popular, and why hundreds of thousands of people are using them, is because they provide the ability to easily make multi-column layouts. Without this functionality, you&#8217;re not providing any reason to use Gutenberg over a page builder plugin.&#8221;</p>\n<p>One of the main challenges of adding multi-column support is figuring out what type of grid system to use and making sure that it scales from mobile to desktop. Weston Ruter joined the discussion to say that the foundational work for nested block support is being done now in version 1, but the UI for displaying them hasn&#8217;t been implemented yet.</p>\n<p>&#8220;I appreciate the excitement and urgency to wanting columns,&#8221; Asmussen said. &#8220;We feel the same urgency. It&#8217;s not about not wanting columns, it&#8217;s purely about managing resources at this point.&#8221;</p>\n<p>The good news is if you&#8217;ve been testing Gutenberg and wondering where some of these features are on the roadmap, they will be coming in later versions. While there may be disagreements about how much of a priority drag-and-drop and multi-column support should have for version 1, contributors agree that laying a solid technical foundation for these features is crucial for future extensibility.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 01 Jul 2017 19:06:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"WPTavern: Gutenberg 0.3.0 Adds Front-End Styles for Core Blocks, Notices Framework, and Text and Image Quick Inserts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://wptavern.com/gutenberg-0-3-0-adds-front-end-styles-for-core-blocks-notices-framework-and-text-and-image-quick-inserts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4557:\"<p>Gutenberg development is marching ahead with <a href=\"https://make.wordpress.org/core/2017/06/30/whats-new-in-gutenberg-june-30/\" target=\"_blank\">version 0.3.0</a> released today. New releases are shipping out on a weekly basis, so testers will get to discover another round of new additions after updating to the latest. The <a href=\"https://wordpress.org/plugins/gutenberg/#developers\" target=\"_blank\">changelog</a> has a full list of the 50 additions and improvements included in this release, but here&#8217;s a quick visual tour of a few of the most interesting user-facing features added this week.</p>\n<p>Gutenberg developers have <a href=\"https://github.com/WordPress/gutenberg/pull/1418\" target=\"_blank\">added front-end styles for core blocks</a>, which means that content like cover images will now appear the same as they look in the admin in the editor. The demo content in the plugin has also been <a href=\"https://github.com/WordPress/gutenberg/pull/1493\" target=\"_blank\">updated to display a full-width cover image</a>. Below is an example of a standard width cover image on the front-end.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/06/cover-image-frontend.png?ssl=1\"><img /></a></p>\n<p>Version 0.3.0 also includes new <a href=\"https://github.com/WordPress/gutenberg/pull/1553\" target=\"_blank\">text and image quick inserts</a>, which appear when hovering over the blank space beneath the post content. This makes it faster to add the types of content that are used most frequently.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/text-and-image-quick-inserts.png?ssl=1\"><img /></a></p>\n<p>This release adds a <a href=\"https://github.com/WordPress/gutenberg/pull/1437\" target=\"_blank\">framework for notices</a>, which provides developers with reusable notices components, showing how to trigger notices and where they will show up. Gutenberg now displays <a href=\"https://github.com/WordPress/gutenberg/pull/1564\" target=\"_blank\">notices on post save, schedule, and update</a>.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/06/gutenberg-notices.png?ssl=1\"><img /></a></p>\n<p>Version 0.3.0 adds a new <a href=\"https://github.com/WordPress/gutenberg/pull/1555\" target=\"_blank\">block descriptions component</a> to blocks with inspector controls. Several of the core blocks now display descriptions. These will be especially useful when plugin developers begin adding their own custom blocks, offering users a quick way to see the purpose of the block.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/block-description-e1498855903121.png?ssl=1\"><img /></a></p>\n<p>This release adds more placeholder text to various blocks, as &#8220;placeholders are key,&#8221; according to the newly added <a href=\"http://gutenberg-devdoc.surge.sh/?selectedKind=Gutenberg&selectedStory=Design&full=0&down=1&left=1&panelRight=1&downPanel=storybooks%2Fstorybook-addon-knobs\" target=\"_blank\">design blueprints and principles</a> included in Gutenberg&#8217;s documentation:</p>\n<blockquote><p>If your block can have a neutral placeholder state, it should. An image placeholder block shows a button to open the media library, a text placeholder block shows a writing prompt. By embracing placeholders we can predefine editable layouts, so all you have to do is fill out the blanks.</p></blockquote>\n<p>Version 0.3.0 also adds several enhancements that make it easier to edit and customize the image-oriented blocks with more options and settings: </p>\n<ul>\n<li>Added “edit image” button to image and cover image blocks</li>\n<li>Added option to visually crop images in galleries for nicer alignment</li>\n<li>Added option to disable dimming the background in cover images</li>\n<li>Added option to display date and to configure number of posts in LatestPosts block</li>\n<li>Added text formatting to CoverImage block</li>\n<li>Added toggle option for fixed background in CoverImage</li>\n<li>Added placeholder for all text blocks</li>\n<li>Added placeholder text for headings, quotes, etc</li>\n</ul>\n<p>Active installs for the <a href=\"https://wordpress.org/plugins/gutenberg/\" target=\"_blank\">Gutenberg plugin</a> have nearly doubled since last week and are at more than 900 sites. This is roughly 1% of the goal Matt Mullenweg set for testing on 100,000 sites before replacing the edit screen. The plugin may also be advertised in the dashboard in a future release, possibly 4.8.1, which is slated for the end of July.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Jun 2017 22:07:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Popular WordPress Plugins Slow to Add Meta Box Support for Calypso\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71527\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://wptavern.com/popular-wordpress-plugins-slow-to-add-meta-box-support-for-calypso\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3361:\"<p>During the State of the Word at WordCamp US 2016, Matt Mullenweg <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\">announced</a> that Calypso was <a href=\"https://youtu.be/Nl6U7UotA-M?t=37m1s\">plugin aware</a>. Calypso is a REST API and React <a href=\"https://wptavern.com/early-reviews-show-applications-like-calypso-are-the-future-of-wordpress\">powered application</a> for the desktop created by Automattic <a href=\"https://ma.tt/2015/11/dance-to-calypso/\">in 2015</a>.</p>\n<p>Developers with plugins active on 1M sites or more <a href=\"https://github.com/Automattic/wp-calypso/pull/10517\">received an email invitation</a> from Andy Peatling to begin building support for Calypso.</p>\n<p>&#8220;Calypso is now plugin-aware,&#8221; Mullenweg said. &#8220;This pull request was merged today, and as a way to bootstrap this, we’re opening up for what I just described for plugins to create Calypso interfaces for what they’re doing.</p>\n<p>&#8220;Basically saying, if you’re using Calypso on a site that has one of these plugins, let’s say WooCommerce, all of a sudden in the interface, there will be all the WooCommerce stuff. It’ll talk to the API, it will run on the desktop just like the rest of Calypso, and it will only be loaded if the plugin is active.&#8221;</p>\n<p>One of the major differences between <a href=\"https://developer.wordpress.com/calypso/\">Calypso</a> and WP-Admin is that custom meta boxes added by plugins are not accessible in Calypso.</p>\n<p>Nearly seven months since the announcement, popular WordPress plugins have struggled to add meta box support, including those maintained by Automattic. <a href=\"https://wordpress.org/plugins/wordpress-seo/\">WordPress SEO</a>, active on more than 3M sites, is among the plugins that were selected to take part in the experiment.</p>\n<p>When asked about the progress of making WordPress SEO Calypso aware, Joost de Valk, founder of <a href=\"https://yoast.com/\">Yoast.com</a>, declined to comment.</p>\n<p>Automattic has seen little progress on the initiative, &#8220;No news to report at this time, but hope to have some soon,&#8221; Automattic representative Mark Armstrong said. WooCommerce has yet to add meta box support and settings pages in Calypso.</p>\n<p>Gutenberg, WordPress&#8217; new editor, is also built using React. One of the chief concerns expressed by users and developers is how it will <a href=\"https://github.com/WordPress/gutenberg/issues/952\">support custom meta boxes</a> built using the current PHP framework.</p>\n<p>&#8220;I miss a lot of the meta boxes I’m used to seeing on the screen,&#8221; <a href=\"https://daily.jorb.in/2017/06/random-thoughts-on-gutenberg/\">Aaron Jorbin said</a>. &#8220;Things like Yoast SEO (on some sites) and custom taxonomies are just not shown. If every meta box ever made for WordPress needs to be remade, it sure is going to make developers lives a living hell.&#8221;</p>\n<p>I want to use Calypso as a replacement for WP-Admin because it&#8217;s fast and I like the interface. However, I can&#8217;t do that until it supports meta boxes for the plugins I rely on, such as Edit Flow. Is the lack of custom meta box support for Calypso a sign of what&#8217;s to come with Gutenberg?</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Jun 2017 20:05:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: WordCamp Netherlands Reinstated for 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72624\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wptavern.com/wordcamp-netherlands-reinstated-for-2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1924:\"<p>At WordCamp Europe I had the opportunity to speak with WordCamp Netherlands organizers Marcel Bootsman and Luc Princen, along with WordPress Global Community Team members Josepha Haden and Andrea Middleton. The group has had several conversations about the future of WordCamp Netherlands, which was <a href=\"https://wptavern.com/wordpress-community-support-shuts-down-wordcamp-netherlands-in-favor-of-city-based-wordcamps\" target=\"_blank\">shut down earlier this year in favor of city-based WordCamps</a>, and have decided to reinstate the camp with a few conditions.</p>\n<p>WordCamp Netherlands organizers are now allowed to begin planning the event again based on the requirement that the country host three city-based WordCamps first. There are currently two local camps on the schedule and a few others in the pre-planning stage. Lead organizer Marcel Bootsman is aiming to have 500 attendees for the next WordCamp Netherlands in 2018.</p>\n<p>In a recent <a href=\"https://torquemag.io/2017/06/matt-mullenweg-interview/\" target=\"_blank\">interview</a> with Torque, Matt Mullenweg indicated that the outlook is good for future regional WordCamps.</p>\n<p>&#8220;I think we got to the point where we were too rules-based and now we’re starting to open up the process and be more agile in the approach to WordCamps,” Mullenweg said. “We can start to think about regional WordCamps and topic-focused WordCamp&#8230;we want to think about which WordCamps make sense to move the community forward.&#8221;</p>\n<p>In our interview below, WordPress Global Community Team members said they plan to take similar country-based WordCamp proposals on a case-by-case basis. WordCamp Netherlands is pioneering the way for other countries with active local communities to continue to push the boundaries of the previously &#8220;one-size-fits-all&#8221; approach to WordPress events.</p>\n<p></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jun 2017 19:18:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WPWeekly Episode 279 – The Future of Underscores with David A. Kennedy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=72616&preview=true&preview_id=72616\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/wpweekly-episode-279-the-future-of-underscores-with-david-a-kennedy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2442:\"<p>In this episode, <a href=\"http://jjj.me/\">John James Jacoby</a> and I are joined by <a href=\"https://davidakennedy.com/\">David A. Kennedy</a>. Kennedy is a Theminator at Automattic and an accessibility advocate. Kennedy joined us to talk about <a href=\"https://wptavern.com/automattic-to-renew-efforts-on-underscores-retire-components-starter-theme-generator\">the future of Underscores</a>, a starter theme created by Automattic in 2012.</p>\n<p>We discussed how Gutenberg may impact theme development in general and some of the lessons learned from their <a href=\"https://wptavern.com/automattic-launches-components-with-5-new-starter-themes-based-on-underscores\">Components project</a>. Kennedy tells us what trends he&#8217;s noticing with WordPress themes today and what the state of accessibility looks like for the theme landscape.</p>\n<p>After the interview, Jacoby and I have a candid conversation about Gutenberg, what it means for WordPress, our experience with it thus far, and how it&#8217;s being developed.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/wordpress-4-9-to-focus-on-managing-plugins-and-themes-gutenberg-targeted-for-5-0\">WordPress 4.9 to Focus on Managing Plugins and Themes, Gutenberg Targeted for 5.0</a></p>\n<h2>Links Mentioned:</h2>\n<p><a href=\"http://a11yweekly.com/\">Accessibility Weekly</a> &#8211; Kennedy&#8217;s hand-curated newsletter about web-accessibility delivered weekly.<br />\n<a href=\"https://make.wordpress.org/themes/\">WordPress Theme Review Team</a><br />\n<a href=\"https://wptavern.com/wordpress-opens-up-more-channels-for-gutenberg-testing-and-feedback\">Gutenberg</a><br />\n<a href=\"http://underscores.me/\">Underscores</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, July 5th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #279:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jun 2017 01:07:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: WooCommerce 3.1 Adds New CSV Product Importer/Exporter, Improves Extension Management\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72604\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wptavern.com/woocommerce-3-1-adds-new-csv-product-importerexporter-improves-extension-management\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3048:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/07/woocommerce-logo.jpg?ssl=1\"><img /></a></p>\n<p><a href=\"https://woocommerce.com/2017/06/3-1-release-product-importer-shipping-service/\" target=\"_blank\">WooCommerce 3.1</a> was released today after four weeks of beta and RC testing. Although it is just a minor update, the release was a large undertaking with 1,600 commits from 84 contributors. </p>\n<p>The most exciting feature in 3.1 is the new built-in product importer/exporter that supports CSV files, a feature previously offered through extensions. The importer makes it easier to migrate stores from other e-commerce platforms, as well as add and update product information for existing stores. Users can select whether to update existing products or create new products and can map the data against product fields:</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/woo-product-importer.png?ssl=1\"><img /></a></p>\n<p>The tool is also useful for those selling across multiple storefronts or marketplaces and is capable of matching up data based on product ID or SKU. Please note that it only handles products and not customers and orders. Store owners looking to import those additional items will still need to use an extension.</p>\n<p>Version 3.1 also introduces the ability to manage WooCommerce.com extension licenses within WooCommerce core, eliminating the need to install the helper extension and copy subscription keys over. Customers can now connect their WooCommerce.com account to the site and download, manage, and activate extensions in the admin. Developers or agencies that have purchased extensions on behalf of clients will need to contact WooCommerce to transfer the subscriptions to a new owner in order for them to show up within the clients&#8217; admin. </p>\n<p>This release also includes several other improvements, including the following: </p>\n<ul>\n<li>Add oEmbeds to the product short description, more useful error messages</li>\n<li>More useful error messages</li>\n<li>Add oEmbeds to the product short description</li>\n<li>Customers can accept ‘Terms and conditions’ without leaving checkout</li>\n<li>Set stock statuses for variations in bulk from the edit product screen</li>\n<li>Small improvements to the setup wizard</li>\n<li>WooCommerce Services Plugin: Add live shipping rates for USPS and Canada Post and print discounted shipping labels for USPS without leaving the store</li>\n<li>New search helpers for orders to allow developers to query orders by multiple props</li>\n</ul>\n<p>Many WooCommerce store owners experienced considerable difficulties in updating to 3.0 due to extension incompatibilities. This is one of the reasons why WooCommerce recommends making backups of your store and testing the 3.1 update on a staging site to see how it affects themes and extensions. The changes in 3.1 should be backwards compatible with 3.0.x sites, but impact on extensions needs to be tested before pushing the update live.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 Jun 2017 00:30:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: WordPress Opens Up More Channels for Gutenberg Testing and Feedback\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=72583&preview=true&preview_id=72583\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/wordpress-opens-up-more-channels-for-gutenberg-testing-and-feedback\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3501:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/06/testing.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/23YKF6ZUWV\">Vojtech Okenka</a>\n<p>Gutenberg testing is in full swing and the WordPress Testing Handbook has a new page to help users <a href=\"https://make.wordpress.org/test/handbook/call-for-testing/gutenberg-testing/\">get started</a>. It clearly defines the purpose of the new block editor as not just for writing content but also for creating layouts. Users are invited to offer general feedback or engage in specific task-based tests.</p>\n<p>The new testing page erases boundaries for feedback by allowing users to submit their thoughts and suggestions using an <a href=\"https://docs.google.com/forms/d/e/1FAIpQLSdCVZ5ooeVYzjp26LAxKZVgkvcRraSTD6pRM_cjGuJfvLKQKw/viewform\">online form</a>. Previously, the only way to offer feedback was by creating an issue on <a href=\"https://github.com/WordPress/gutenberg\">GitHub</a> or contacting the contributors on WordPress&#x27; #core-editor Slack channel. </p>\n<p>At this stage in Gutenberg development, it may be difficult to discern what is a bug versus what is an unpolished feature. WordPress is using Storybook, an interactive development and testing environment for React and React-Native UI components, to create <a href=\"http://gutenberg-devdoc.surge.sh/\">Gutenberg&#x27;s documentation</a>. However, this collection of documents focuses more on technical details for developers. The plugin&#x27;s <a href=\"https://wordpress.org/plugins/gutenberg/#developers\">changelog</a> may provide some information about which features should be working. Before reporting an issue in the feedback form, it&#x27;s a good idea to review the project&#x27;s <a href=\"https://github.com/WordPress/gutenberg/issues\">GitHub issues</a> to see if it has already been logged.</p>\n<h3>Testing Gutenberg Outside of the WordPress&#x27; Developer Community is Critical to Its Success</h3>\n<p>A few weeks ago I helped one of my friends migrate her personal blog from Blogger to WordPress. She had put off setting up her new site for months after checking out the admin and getting overwhelmed. Getting familiar with the post editor was enough of a hurdle, without piling on the idea of widgets and shortcodes and different screens and methods for inserting different types of content. The new editor can solve this problem with a unified method of creating content and placing it on the page.</p>\n<p>Gutenberg has the potential to make WordPress content editing and layout building more user-friendly but only if it gets into the hands of non-technical users and those who are considering a switch from other platforms. WordPress&#x27; recurring <a href=\"https://wptavern.com/wordpress-editor-experience-survey-shows-75-of-respondents-dont-use-distraction-free-writing-mode\">failure to collect feedback beyond its own development community</a> needs to be addressed if Gutenberg is going to become a product that will attract non-WordPress users.</p>\n<p>As the plugin is still in the very early beta stage, this is a crucial point in time when feedback can have a big impact on shaping Gutenberg&#x27;s development. Including non-technical users as early in the process as possible, as the new <a href=\"https://make.wordpress.org/test/handbook/call-for-testing/gutenberg-testing/\">testing page</a> attempts to do, should provide a better overall picture of Gutenberg&#x27;s usability.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jun 2017 20:30:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"WPTavern: Why Gutenberg?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72563\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wptavern.com/why-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7502:\"<p>At WordCamp Europe 2017, Matt Mullenweg, co-founder of the WordPress open source project, <a href=\"https://wptavern.com/wordpress-new-gutenberg-editor-now-available-as-a-plugin-for-testing\">announced</a> that Gutenberg was available as a plugin for testing. In the past few weeks, members of the community have published their experiences with the new editor. Some of the reviews I&#8217;ve read so far include:</p>\n<ul class=\"wp-block-freeform wp-block-freeform wp-block-freeform wp-block-freeform wp-block-freeform wp-block-freeform wp-block-freeform wp-block-freeform\">\n<li><a href=\"https://daily.jorb.in/2017/06/random-thoughts-on-gutenberg/\"><cite></cite>Random Thoughts on Gutenberg </a></li>\n<li><a href=\"https://joost.blog/gutenberg-and-yoast-seo/\">Gutenberg and Yoast SEO </a></li>\n<li><a href=\"http://gschoppe.com/wordpress/improving-wordpress/improving-wordpress-pt-4-where-project-gutenberg-lost-me-open-letter-to-core/\">Improving WordPress Pt 4 – Where Gutenberg Lost Me (Open Letter to Core) </a></li>\n<li><a href=\"https://wplift.com/gutenberg-editor-first-look\">A First Look at Gutenberg Editor for WordPress: Mixed Opinions </a></li>\n<li><a href=\"https://kinsta.com/blog/gutenberg-wordpress-editor/\">Diving Into the New Gutenberg WordPress Editor (Pros and Cons) </a></li>\n<li><a href=\"https://www.customerservant.com/gutenberg-screen-reader-initial-thoughts-reactions/\">Gutenberg With A Screen Reader: Initial Thoughts And Reactions </a></li>\n<li><a href=\"https://mrwweb.com/first-reactions-gutenberg-future-of-wordpress/\">First Reactions to Gutenberg, the Future of WordPress</a></li>\n</ul>\n<p>There is one review in particular that has piqued my interest. Adrian Roselli not only <a href=\"http://adrianroselli.com/2017/06/first-reactions-to-gutenberg.html\">shares his first impressions</a> of Gutenberg, but also asks a couple of important questions and raises some interesting points:</p>\n<blockquote class=\"blocks-quote-style-1 wp-block-quote\"><p>When I first heard about Gutenberg, I asked some people at WordCamp London and later at WordCamp Europe who had requested it. Remembering that WordCamp is open source, I then re-jiggered my question and asked what problem it was trying to solve.</p>\n<p>Of the people I asked, I do not know who was a contributor. The answer I overwhelmingly got back was that Matt wanted it.</p></blockquote>\n<p>There are two things that concern me about Roselli&#8217;s statement. The first is that I have a few quirks with the current editor but I don&#8217;t often use short codes, custom HTML, or use custom embed codes. Thinking about what <a href=\"https://github.com/WordPress/gutenberg/blob/aae8cdd1349c6af7a74e84174724526386643a6e/docs/design.md\">problems Gutenberg solves</a> is somewhat perplexing if they&#8217;re not problems I encounter on a regular basis.</p>\n<p>The second is that people at WordCamps are answering the question by saying Mullenweg wants it in core. Roselli states that he doesn&#8217;t know if the people answering the question are contributors or not. Because Mullenweg wants something in core should never be the primary reason it&#8217;s added.</p>\n<p>It&#8217;s easy to see how one could come up with this answer. Earlier this year, Mullenweg took over core development as the project lead, and <a href=\"https://wptavern.com/matt-mullenweg-announces-tech-and-design-leads-for-new-focus-based-development-cycle\">assigned</a> Automattic employees Matias Ventura and Joen Asmussen to lead the development of Gutenberg. As project lead, Mullenweg can bypass the <a href=\"https://wptavern.com/matt-mullenweg-discusses-core-focuses-downsides-of-a-consensus-driven-model-and-more-on-apply-filters-podcast\">concensus-driven model</a>, and do what he thinks is best for the project without going through a committee.</p>\n<p>In the <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\">2016 State of the Word</a>, Mullenweg announced that the Editor would be one of three core focuses for 2017. In January of this year, the team published a <a href=\"https://make.wordpress.org/core/2017/01/17/editor-technical-overview/\">technical overview</a> of what the new editor would encompass. A month later, the team <a href=\"https://make.wordpress.org/design/2017/02/09/initial-editor-blocks-prototype-editor-testing/\">published an initial prototype</a> of a block-based editor.</p>\n<p>The team is moving rapidly with <a href=\"https://wptavern.com/wordpress-4-9-to-focus-on-managing-plugins-and-themes-gutenberg-targeted-for-5-0\">plans to ship Gutenberg</a> possibly in time for WordPress 5.0 expected later this year or early next. If all of the work thus far had to go through a committee, it&#8217;s likely Gutenberg development wouldn&#8217;t be where it&#8217;s at.</p>\n<p>Perhaps not enough people <a href=\"http://chrislema.com/misunderstanding-goal-gutenberg-writing-experience/\">understand the &#8216;Why&#8217; behind the project.</a> Who can blame them? Outside of specifying that it will help WordPress <a href=\"https://wptavern.com/wordpress-new-gutenberg-editor-now-available-as-a-plugin-for-testing\">leapfrog its competitors</a>, there&#8217;s not a lot of information on official channels that concretely explains and supports the idea that Gutenberg is necessary for millions of users.</p>\n<p>Mullenweg has a good track record of doing what&#8217;s best for the project. However, in the case of revamping the editor, which will radically change how everyone will create content in WordPress, it&#8217;s concerning that more user research, personas, usage data, etc. is not available to indicate such a major shift was warranted. There was an <a href=\"https://wptavern.com/wordpress-editor-experience-survey-shows-75-of-respondents-dont-use-distraction-free-writing-mode\">Editor survey published</a> earlier this year but the results were not representative of WordPress&#8217; global user base.</p>\n<p>&#8220;A lot of assertions on ease of use are made on the Gutenberg plugin page, with nothing to back them up,&#8221; Roselli said.</p>\n<p>Gutenberg is an exciting, ambitious project, but one that I&#8217;m not entirely sure is necessary. If WordPress core is going to fundamentally change the way I create content without giving me a choice, I want as much information and user research data as possible to convince me that it&#8217;s the better option.</p>\n<p>It may seem odd that these questions and concerns are being raised six months into the project but at the same time, development has moved so fast, it feels like the opportunity to have them addressed at the beginning was missed.</p>\n<p>Revamping the editor experience is a massive undertaking and, six months in, it&#8217;s not better than the editor I use today. I wrote this post in Gutenberg and it was a cumbersome, frustrating experience. It will need to address a lot of issues if it&#8217;s going to beat the current WordPress editor, let alone leapfrog its competitors. However, the team is <a href=\"https://make.wordpress.org/core/tag/gutenberg/\">making good progress</a> on a weekly basis.</p>\n<p>Gutenberg needs as many testers as possible if it&#8217;s going to be the best editor in its class. For instructions on how and what to test, read the <a href=\"https://make.wordpress.org/test/handbook/call-for-testing/gutenberg-testing/\">Gutenberg testing guide</a> on the Make WordPress Testing site.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jun 2017 18:48:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"HeroPress: From Teaching Toddlers to Teaching the World\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1940\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"https://heropress.com/essays/teaching-toddlers-teaching-world/?utm_source=rss&utm_medium=rss&utm_campaign=teaching-toddlers-teaching-world\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9327:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2018/06/062817-min-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: My goal was to learn as much as I could about WordPress so I too, can teach.\" /><p>I did not pick the computer life. It picked me. I can remember the summer between kindergarten and first grade; I had a computer summer class that introduced me to my passion. The first day when my mother picked me up I exclaimed “mommy I want a computer for Christmas!” I was five and had no realization that in 1986 they would cost more than about everything I owned. I remember being upset that Santa did not bring me the computer that I had been wishing for since June. Growing up, any time I got the chance to sit in front of a computer, I took it for as long as I could. In high school, I even designed the website of one of the groups I was in. It was still online up until last year when CCHS did a website redesign. However, I never actively pursued a career with computers or even took a class for them since that summer. It was not until after I got into WordPress that I actually took a computer class, and now I have an associate&#8217;s in Information Technology.</p>\n<p>My first career was as a preschool teacher. I loved teaching, loved the joy that it gave me, but it was a very under-valued career.</p>\n<blockquote><p>Most teachers, who go to college to become teachers, make anywhere between minimum wage to a dollar over that with no insurance and maybe a week’s paid vacation.</p></blockquote>\n<p>While spending 45 plus hours every week, I was dedicated to teaching our future, I was barely getting bills paid. So many times I would have to pay bills late, worry how I was going to make sure the next bill gets paid, and have enough gas in my car to make it to work the rest of the week. I devoted twelve years to teaching colors, shapes, letters, numbers, and how to get along with others. While I loved to teach, I needed more. Plus, if I wanted to be able to take care of my daughter, I needed to make a change or I would never even be able to have a savings.</p>\n<h3>And Then There Was WordPress</h3>\n<p>Around 2011, I got the idea that I wanted to write a blog. I had heard my friend Chris talk about blogging so I knew he would point me in the right direction. At that time he was working on a security plugin to help the sites he managed for work. He told me “if you want me to help you build a blog, I&#8217;m going to teach you so you can do it on your own later.” We bought a domain, set up hosting, and ran the install. I instantly became hooked. The more I built, the more I wanted to learn about WordPress, and the more I wanted to do.</p>\n<blockquote><p>Almost every night, after my daughter would go to bed, I would spend working on my blog, reading about what one can do with WordPress, and trying everything I learned.</p></blockquote>\n<p>Sometimes things would go great, and other times I would accidentally delete out my entire site on FileZilla without a backup and would start from scratch again. Most of my learning came from my failed attempts and what not to do. That is what was my first clue that I would like to be a “fixer” instead of a “builder”.</p>\n<p>The more I learned, the more I wanted to learn. By 2013 I decided that “I could actually do this. I could make money from WordPress” but I still had about zero clue of how to go about it. I decided to leave preschool for good. I took a full time job working for a local IT agency that also built sites on WordPress. I spent a year there but during that time Chris introduced me to Regina at WP Security Lock. We hit it off and I quickly became a part time employee in April of 2014 helping her with the sites she managed and then learning how to clean hacked websites.</p>\n<p>I spent almost two years working for WPSL. The first part of them I was working for the local agency. Regina showed me another option for working in WordPress. It was the idea of working remotely. My daughter was still at the age where she needed after school care, and it is expensive. So with the support of my then fiance, I took the leap to work remotely in September of 2014.</p>\n<p>Fast forward from working in with various plugin support teams and security support roles, to jumping into agency support that I did for almost a year, I am now at home with WP Media on their WP Rocket support team. While most do not feel that it is the most glamorous of career choices, I love fixing problems, finding solutions, and helping people. Most of all, WordPress and working with support, gives me many teaching opportunities to help out every person who asks.</p>\n<h3>The Want to Teach</h3>\n<p>My first ever WordPress Community event was WP Engine’s 10 year birthday party they threw for WordPress in Austin. The feeling the Austin WP community gave me led me to feel like this was really a place I wanted to be. After Chris saw how excited I was about the community, he asked if I would like to go to WordCamp Chicago. Coincidentally, four years ago today, I was attending my first ever WordCamp. How the speakers taught the attendees, my goal was to learn as much as I could about WordPress so I too, can teach.</p>\n<p>Even though I no longer had the official title of a teacher, I still loved to teach. WordCamp Austin 2014 gave me the first opportunity to teach others about Jetpack. I was a nervous wreck! Not only was my best friend there who I looked up to in the WordPress community, but also one of the wonderful Happiness Engineers for the Jetpack team. I had Kraft go over my slides for me to make sure there was not anything I was sticking my foot in my mouth for and away we went. Afterwards I had people coming up and thanking me for explaining Jetpack in a way they could understand.</p>\n<blockquote><p>After that WordCamp, I wanted to speak at all WordCamps.</p></blockquote>\n<p>One of the many advantages of working for companies that have roots in the WordPress Community is that they allow me to attend, speak, and volunteer at WordCamps. I now have over 20 speaking opportunities under my belt, and have no want to stop for the unforeseeable future. I love having any opportunity to teach. I have now grown from only speaking at WordCamps to teaching beginner’s WordPress at our local community college, writing a book on beginner’s WordPress, and starting WP Kids Slack group to be a resource for KidsCamps and teaching our youth on the value and joys of WordPress. Now I am proud to say that I have taught WordPress to all ages from children to the baby boomers and it feels great! I have even had the opportunity to teach my own daughter WordPress and she loves going to the WordCamps. She has even helped others at Camps which for me is what it is all about. It is such a delight teaching Kids Camps and seeing their creativity blossom while building a site of their own. Plus, getting youth and teenagers interested in WordPress, coding, design, and more ensures that what we are building now, will only become better in the future.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: From Teaching Toddlers to Teaching the World\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=From%20Teaching%20Toddlers%20to%20Teaching%20the%20World&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fteaching-toddlers-teaching-world%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: From Teaching Toddlers to Teaching the World\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fteaching-toddlers-teaching-world%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fteaching-toddlers-teaching-world%2F&title=From+Teaching+Toddlers+to+Teaching+the+World\" rel=\"nofollow\" target=\"_blank\" title=\"Share: From Teaching Toddlers to Teaching the World\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/teaching-toddlers-teaching-world/&media=https://heropress.com/wp-content/uploads/2018/06/062817-min-150x150.jpg&description=From Teaching Toddlers to Teaching the World\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: From Teaching Toddlers to Teaching the World\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/teaching-toddlers-teaching-world/\" title=\"From Teaching Toddlers to Teaching the World\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/teaching-toddlers-teaching-world/\">From Teaching Toddlers to Teaching the World</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Jun 2017 14:15:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Michele Butcher-Jones\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: Automattic to Renew Efforts on Underscores, Retire Components Starter-Theme Generator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=70860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/automattic-to-renew-efforts-on-underscores-retire-components-starter-theme-generator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7346:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2014/08/underscores.jpg?ssl=1\"><img /></a></p>\n<p>For the past several months we have received inquiries about Automattic&#8217;s open source <a href=\"http://underscores.me/\" target=\"_blank\">Underscores</a> starter theme. After six months of no commits to the <a href=\"https://github.com/automattic/_s\" target=\"_blank\">GitHub repository</a> and pull requests left unanswered, users and contributors were beginning to wonder whether the project was abandoned.</p>\n<p>After contacting Automattic to get a status update on Underscores, the company confirmed that it is still an active project but would not explain why it had gone dormant for six months.</p>\n<p>For the past couple weeks there have been a sudden flurry of commits to the Underscores repository, the first activity since December 2016. The project has come out of hibernation and Automattic announced its intentions to <a href=\"https://themeshaper.com/2017/06/26/the-future-of-underscores-and-a-new-committer/\" target=\"_blank\">renew its efforts in maintaining it</a>.</p>\n<p>&#8220;As we continue to push for consistency in themes and imagine what they might become with Gutenberg, we’re bringing our attention back to Underscores,&#8221; David Kennedy said. &#8220;In the last year, we’ve gotten a lot of questions from the community about Underscores and whether we had abandoned it. No way! It’s a stable project, and we enjoyed working on something new, away from it. It gave us better perspective and more ideas for the future of Underscores.&#8221;</p>\n<p>Kennedy explained how the project&#8217;s maintainers have spent the past year and a half experimenting with <a href=\"https://wptavern.com/automattic-launches-components-with-5-new-starter-themes-based-on-underscores\" target=\"_blank\">Components</a>, a starter-theme generator that was created to provide a more modular approach to theme development with reusable building blocks. The team has decided to retire Components in favor of refocusing on Underscores and applying what they learned from the experiment.</p>\n<p>&#8220;The generator we built to piece the different components together got complex quickly,&#8221; Kennedy said. &#8220;We created a plugin to test builds locally and struggled with a seamless way to make many starter themes from one code base. The original idea is still solid: make starter themes do more by crafting them out of building blocks. But we didn’t hit the mark, so we’re retiring Components.&#8221;</p>\n<h3>Underscores Adds Ulrich Pogson as New Committer</h3>\n<p>Automattic has named <a href=\"https://profiles.wordpress.org/grapplerulrich/\" target=\"_blank\">Ulrich Pogson</a> as a new committer to Underscores, the second non-Automattic contributor, <a href=\"https://themeshaper.com/2014/04/22/commit-access-underscores/\" target=\"_blank\">following Philip Arthur Moore</a>, to receive commit access. Pogson is a WordPress contributor and meetup organizer, a member of the Theme Review Team, and an independent voice for the Underscores community.</p>\n<p>Philip Arthur Moore <a href=\"https://philip.blog/2017/06/27/wp-underscores-future/\" target=\"_blank\">said</a> he was excited to hear the news and thankful to Automattic for &#8220;not allowing Underscores to rot on the vine any longer.&#8221;</p>\n<p>&#8220;It’s fair to say that my involvement with the starter theme will likely come out of a coma and find new life,&#8221; Moore said. &#8220;This is exactly what the theming community needs right now, and I couldn’t be more excited to see what we come up with and create.&#8221;</p>\n<p>In early January, the Underscores community shared concerns regarding the project&#8217;s general lack of leadership and transparency. Contributor Sami Keijonen wrote an article with constructive ideas for <a href=\"https://foxland.fi/underscores-development/\" target=\"_blank\">how Automattic could improve Underscores development</a>. One of his suggestions for the project was to identify leadership for moving forward, a person or group of people who could be responsible to review and discuss issues and pull requests more frequently. This would encourage more active discussion and testing of pull requests.</p>\n<p>In the comments of this post, <a href=\"https://foxland.fi/underscores-development/#comment-22416\" target=\"_blank\">Pogson expressed similar concerns</a> and said he would potentially be interested in creating a fork of Underscores.</p>\n<p>&#8220;Personally I am also hesitant to contribute as I am not sure when the PR will be merged,&#8221; Pogson said. &#8220;I would like to see regular feedback instead of instead of PR’s being merged in a merging spree. There is also a clash between _s fulfilling Automattic needs and at the same time as the community needs.&#8221;</p>\n<p>Now that Pogson has been named a committer, he may be able to assist the team in maintaining active discussion on issues and keeping pull requests moving.</p>\n<p>&#8220;A large number of people use Underscores as a base for their clients and for themes on w.org,&#8221; Pogson said. &#8220;I would like to bring in things that have made me a better developer and make it easier for others getting started.&#8221;</p>\n<p>Pogson said he is still finding his position in the team and he anticipates he will most likely be merging simple PRs in the beginning. He enjoys working on Underscores and said he regularly likes to go through opened issues and give feedback.</p>\n<p>Sami Keijonen said he thinks the addition of Pogson as a committer is &#8220;very good news.&#8221;</p>\n<p>&#8220;They are bringing the focus back on Underscores, and they can bring the best ideas of Components to Underscores,&#8221; Keijonen said. &#8220;Ulrich is the perfect choice as a new committer. He has been involved in the development for a long time and knows the big picture. It’s also good to see a committer from outside of Automattic. Different kinds of perspectives are always welcome.&#8221;</p>\n<p>Keijonen said he is also optimistic that David Kennedy has taken a more active leadership role and hopes the project will continue to benefit from it.</p>\n<p>&#8220;With all that said <code>_s</code> is still Automattic’s starter theme,&#8221; Keijonen said. &#8220;It can mean more wp.com related decisions in the future. That’s one reason why many have their own fork of <code>_s</code>.&#8221; He cited a few examples of companies that have active forks of Underscores to suit their particular interests, including <a href=\"https://github.com/WebDevStudios/wd_s\" target=\"_blank\">WebDevStudios</a>, <a href=\"https://github.com/ZeelandFamily/zf-theme\" target=\"_blank\">Zeeland Family</a>, and <a href=\"https://github.com/digitoimistodude/air\" target=\"_blank\">Digitoimisto Dude Studio</a>.</p>\n<p>&#8220;It will be an interesting partnership as I am the only committer who has not worked at Automattic,&#8221; Pogson said. &#8220;I think there will always be a certain clash between what Automattic needs and what the community wants, just because of the nature of the project. Many plugin authors have the same problem where they get requests that are not ideal for the other customers. There is still a bit of uncertainty but I am sure these things will be clarified in the future.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Jun 2017 21:01:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"WPTavern: Catalina Alvarez is Conducting the First Occupational Psychology Study on Autonomous Motivation and Burnout in the WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71964\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:155:\"https://wptavern.com/catalina-alvarez-is-conducting-the-first-occupational-psychology-study-on-autonomous-motivation-and-burnout-in-the-wordpress-community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1652:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/computer-paper-coffee.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/JHJH4PS68L\">WDnet Studio</a>\n<p>While attending WordCamp Europe I met Catalina Alvarez, a Master&#8217;s degree student at Paris 8 University, who is studying Occupational Psychology and Human Resources. She is in the process of writing her thesis about WordPress community health, with a focus on &#8220;autonomous motivation as a moderator in the Demands-Burnout relationship.&#8221;</p>\n<p>Alvarez is conducting a <a href=\"http://cataalvarezp.polldaddy.com/s/motivation-burnout-in-wordpress-community\" target=\"_blank\">survey</a> as part of her research and is inviting anyone in the WordPress community who has contributed, whether to code or community projects, to participate. One of the theories she is testing is that burnout is not the consequence of the demands of one&#8217;s work but rather the consequence of long periods of stress. She is also testing to see if autonomous motivation (when you do things because you are passionate about them) can reduce burnout and if external motivation contributes to burnout.</p>\n<p>The <a href=\"http://cataalvarezp.polldaddy.com/s/motivation-burnout-in-wordpress-community\" target=\"_blank\">survey</a> takes approximately 5-10 minutes and will close on July 5, 2017. Alvarez plans to share her results with the community and will need at least 250 respondents to make any meaningful conclusions.</p>\n<p>Check out our video interview below to find out more details and background on the study.</p>\n<p></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Jun 2017 00:06:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"WPTavern: Matt Mullenweg Discusses Core Focuses, Downsides of a Consensus-Driven Model, and More on Apply Filters Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72517\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:130:\"https://wptavern.com/matt-mullenweg-discusses-core-focuses-downsides-of-a-consensus-driven-model-and-more-on-apply-filters-podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6079:\"<p>Matt Mullenweg, co-founder of the WordPress open source project and CEO of Automattic, joined Pippin Williamson and Brad Touesnard on <a href=\"http://applyfilters.fm/podcast/episode-81/\">episode 81</a> of the <a href=\"http://applyfilters.fm/\">Apply Filters</a> podcast. Apply Filters is a podcast dedicated to WordPress development.</p>\n<p>During the interview, Mullenweg touched on a number of topics including, a progress report on the <a href=\"https://wptavern.com/matt-mullenweg-announces-tech-and-design-leads-for-new-focus-based-development-cycle\">three core focus areas</a>, why he stepped back into the project lead role, and what&#8217;s not being talked about enough in the WordPress world.</p>\n<p>There are quite a few things in this episode that piqued my interest. Near the beginning of the interview, Mullenweg is asked if there was a tipping point that made him decide to take on the role of project lead again.</p>\n<p>&#8220;I’ve been personally frustrated by how long it has taken to do some things that I think should be relatively simple,&#8221; Mullenweg said. &#8220;Hearing that from other release leads over the past few years, and seeing some of the frustration because we have this rotating release lead philosophy.</p>\n<p>&#8220;So hearing them voice some of the same frustrations, I was like, okay, maybe this is something more with how the project is organized versus something that I personally am having trouble with.</p>\n<p>&#8220;We had a couple of years of releases that were a little uninspiring from the point of view of moving the needle forward for its adoption, even though they did a lot of great things and people worked really hard on them, and we closed 700 tickets, and had 130 or 150 contributors.</p>\n<p>&#8220;We were beating or we were doing a good job on a lot of metrics that we were tracking, but, on the whole, I think it really started to feel like WordPress was falling behind the state of the art in the world.&#8221;</p>\n<p>It was interesting to hear Mullenweg admit that WordPress releases in the last couple of years have been a bit uninspiring. This is <a href=\"https://wptavern.com/the-wow-factor-in-major-wordpress-releases-is-getting-few-and-far-between\">a sentiment I</a> and <a href=\"https://premium.wpmudev.org/blog/wordpress-4-0-hugely-underwhelming/?utm_expid=3606929-74.aeX0WyvtRVa7qMe8Ph5smw.0&utm_referrer=https%3A%2F%2Fwww.google.com%2F\">others</a> in the community have shared in recent years. Development of Gutenberg, <a href=\"https://wptavern.com/wordpress-new-gutenberg-editor-now-available-as-a-plugin-for-testing\">WordPress&#8217; new editor</a>, has created a buzz around the project that I haven&#8217;t felt in a long time. It&#8217;s not surprising considering it is going to be the largest fundamental change to WordPress since its creation.</p>\n<h2>Disagree and Commit</h2>\n<p>During the discussions on whether or not to merge the REST API into core, Mullenweg argued that it shouldn&#8217;t be integrated until it was 100% complete. The core development team ultimately decided to merge it into core and iterate improvements. In the show, Mullenweg describes the disagree and commit principle.</p>\n<p>&#8220;This idea that even though I disagreed with some of the things going in, the moment it was committed, I was advocating for it as strongly as anything else,&#8221; Mullenweg said.</p>\n<p>&#8220;The historical thoughts or ideas or whatever I had don’t really matter at this point. It’s in, so I want to work to make it as widely adopted and successful as possible. That’s the commit part of it, which is funny because, in an open source world, commit obviously has a double meaning.</p>\n<p>&#8220;But if you think about it, you can apply this to all parts of your life. Debate vigorously and have lots of arguments. Bring up all your worries or thoughts or concerns and hash it out. But once a decision has been made and the decision was made to bring the content endpoints in, don’t re-litigate it. That’s not really helpful to anyone.</p>\n<p>&#8220;Most of all, don’t sabotage it. It’s in, so let’s make it successful.&#8221;</p>\n<h2>Downsides of a Consensus-Driven Model</h2>\n<p>Near the end of the interview, Mullenweg is asked what philosophy, feature, or topic in the WordPress world is not talked about enough. &#8220;The downsides of a consensus-driven model creating products,&#8221; he responded.</p>\n<p>&#8220;I’ve been thinking about it a lot. I think that almost everyone at some point in their career has had a bad manager. And sometimes our reaction to that is to say that no one should be making decisions. There should be no managers, sort of like a more reactionary approach to it because that is true that it does solve the problem of the bad manager.</p>\n<p>&#8220;I think what we miss is the only thing worse than a bad manager is 100 bad managers, which is sometimes what we get when we just try to make decisions or drive development of something like WordPress–which is, at the end of the day, a user product based on who shows up to a dev meeting that day, or what the loudest voices in the room might advocate for.</p>\n<p>&#8220;Even policies that we’ve adopted in the past with WordPress, let’s say the 80/20 rule, which is on our principles page, can be misused and, I think, probably have been misused more the past few years than it has been used in the way it was intended.</p>\n<p>&#8220;Just that kind of getting back to the question of how does this change a user’s life or not, and that reflects itself in an open marketplace through adoption. That is, I think, good to just remind ourselves of regularly because everyone, myself included, can get kind of down in the weeds of a particular ticket or idea we have or idea someone else has that might not be productive.&#8221;</p>\n<p>To hear Mullenweg discuss these topics and more, I highly encourage you to listen to the <a href=\"http://applyfilters.fm/podcast/episode-81/\">full interview</a> which includes a transcript of the show.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Jun 2017 21:00:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Matt: Heroin or Aspirin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://ma.tt/2017/06/heroin-or-aspirin/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://ma.tt/2017/06/heroin-or-aspirin/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:878:\"<blockquote><p>The company Bayer is famous for inventing aspirin in 1898, which is arguably one of the world<img src=\"https://s.w.org/images/core/emoji/2.3/72x72/2019.png\" alt=\"’\" class=\"wp-smiley\" />s most beloved brands, and for good reason. But I was surprised to learn that just two weeks earlier, the same three guys who gave the world aspirin also created Bayer<img src=\"https://s.w.org/images/core/emoji/2.3/72x72/2019.png\" alt=\"’\" class=\"wp-smiley\" />s other big brand, heroin, which was marketed for about eight years as the world<img src=\"https://s.w.org/images/core/emoji/2.3/72x72/2019.png\" alt=\"’\" class=\"wp-smiley\" />s best cough medicine.</p></blockquote>\n<p>From <a href=\"https://mobile.nytimes.com/2017/06/18/books/andrew-essex-talks-about-end-of-advertising.html\">Andrew Essex on his book about the End of Advertising</a>. <i>Hat tip: John Maeda.</i></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 25 Jun 2017 13:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"BuddyPress: BuddyPress 2.9.0 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=266659\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://buddypress.org/2017/06/buddypress-2-9-0-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2980:\"<p>Today sees BP 2.9 move to Beta 2 ( Beta 1 skipped for technical reasons ) testing phase and we would request all plugin authors, theme developers and other interested parties test out this release and feedback any issues found to our <a href=\"https://buddypress.trac.wordpress.org/newticket\"> trac ticket home </a>, or raise on the support forum.</p>\n<p>Amongst other improvements and fixes to look out for are:</p>\n<ul>\n<li>Fixing display of older activity comments.</li>\n<li>Correction of message when removing friends that are not friends.</li>\n<li>Group invites &#8211; omit sending to previously invited members.</li>\n<li>Profile image upload fix for IE Edge breaksIOS fix.</li>\n<li>Correct issue with hidden group &amp; CSS specificity.</li>\n<li>URL compatibility for LightSpeed.</li>\n<li>Fix inability resizing of member avatar for cyrillic character filenames.</li>\n</ul>\n<p>For a full list of commits see <a href=\"https://buddypress.trac.wordpress.org/query?keywords=~&milestone=2.9&group=status&col=id&col=summary&col=keywords&col=owner&col=type&col=priority&col=component&col=version&order=priority\">2.9 tickets</a> A full changelog will be available when we release the final version.</p>\n<p>You can download the plugin to test from the WP repo <a href=\"https://downloads.wordpress.org/plugin/buddypress.2.9.0-beta2.zip\">BP 2.9.0-beta2</a> or grab a copy from our SVN repo.</p>\n<p><strong>Template changes</strong></p>\n<p>In this release there are a number of improvements to templates that add a level of improved a11y performance and markup changes for better semantics &amp; Standards.</p>\n<p>Theme authors may want to pay particular attention to changes to profile field visibility links and the profile field descriptions where significant markup changes are made that effect positioning of these elements &#8211; changesets for these are <a href=\"https://buddypress.trac.wordpress.org/changeset/11617\">r11617</a> &amp; <a href=\"https://buddypress.trac.wordpress.org/changeset/11618\">r11618</a></p>\n<p><strong>Nouveau &#8211; new template pack</strong></p>\n<p>While we were definitely aiming for release of this feature for 2.9, the necessary final fixes and feature enhancements along with the necessary code reviews were going to prove very tight to get finished in time and would have likely meant a degree of rushing. We have decided that as this is such a major new feature, the first new theme in many years and that expectations will be high for it that we should not rush to put out a product that might be even slightly sub optimal.</p>\n<p>However fear not we are very concerned that the project is focussed on through the last stages of 2.9 and has primary focus during the next release cycle to ensure an early completion.</p>\n<p>It is further proposed that we&#8217;ll actually release Nouveau in a much shorter release cycle as 3.0, this way we can get an early release and not have the project just sitting in trunk until the end of the year.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 Jun 2017 20:17:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Hugo Ashmore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: Gutenberg 0.2.0 Released, Adds New Custom HTML and Cover Image Blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72472\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/gutenberg-0-2-0-released-adds-new-custom-html-and-cover-image-blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3385:\"<p>The <a href=\"https://wordpress.org/plugins/gutenberg/\" target=\"_blank\">Gutenberg plugin</a> is moving fast with <a href=\"https://make.wordpress.org/core/2017/06/23/whats-new-in-gutenberg-june-23rd/\" target=\"_blank\">version 0.2.0</a> now available. This is the first release since the plugin was added to the directory last week. It includes two new block types, along with other new features, improvements, and fixes for many bugs that previously severely impaired the editor&#8217;s usability.</p>\n<p>A new <a href=\"https://github.com/WordPress/gutenberg/pull/1391\" target=\"_blank\">Custom HTML</a> block allows users to add HTML and click to see a fast preview within the editor.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/gutenberg-custom-html-block.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/gutenberg-custom-html-preview.png?ssl=1\"><img /></a></p>\n<p>The new <a href=\"https://github.com/WordPress/gutenberg/issues/487\" target=\"_blank\">Cover Image</a> block lets users place an image in the content with the background image fixed by default. Users can also specify text to have overlaid. Gutenberg developers emphasized that this feature should not be confused with the &#8220;Featured Image&#8221; panel which is already working in a similar way to how it has in the past.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/06/gutenberg-cover-image.png?ssl=1\"><img /></a></p>\n<p>While testing the Cover Image block with Twenty Seventeen and Twenty Fifteen, I was unable to get it working correctly on the frontend. Within the editor it works beautifully but once I launched the preview I found that, regardless of which positioning option I chose, I could not get the full image to display. The size of the image&#8217;s output was only as tall as the overlay text. If there was a right way to position it, I was unable to discover it. I checked with the development team and Matías Ventura said they are not loading styles for blocks in the front-end yet. Blocks like Cover Image that need CSS to display properly will not look right at the moment, but the plan is to focus on adding CSS for these this coming week.</p>\n<p>A few of the notable fixes and improvements include the following:</p>\n<ul>\n<li>Added button to delete a block</li>\n<li>Added button to open block settings in the inspector</li>\n<li>Rename “Freeform” block to “Classic Text”</li>\n<li>Added support for pages and custom post types</li>\n<li>Added ability to select all blocks with ctrl/command+A</li>\n<li>Automatically generate wrapper class for styling blocks</li>\n<li>Avoid triggering multi-select on right click</li>\n<li>Avoid being keyboard trapped on editor content</li>\n</ul>\n<p>As of today, Gutenberg has more than 500 active installs. The development team is planning on shipping weekly releases to the WordPress.org plugin. If you want to keep up with the releases, subscribe to the <a href=\"https://make.wordpress.org/core/\" target=\"_blank\">make.wordpress.org/core</a> blog. Feedback is welcome on <a href=\"https://github.com/WordPress/gutenberg\" target=\"_blank\">Gutenberg&#8217;s GitHub repository</a> as well as in the <a href=\"https://wordpress.slack.com/messages/core-editor/\" target=\"_blank\">#core-editor</a> channel on WordPress Slack.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 Jun 2017 03:30:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WPTavern: WordPress 4.9 to Focus on Managing Plugins and Themes, Gutenberg Targeted for 5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72454\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"https://wptavern.com/wordpress-4-9-to-focus-on-managing-plugins-and-themes-gutenberg-targeted-for-5-0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4788:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/planning.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/5ZMT04MIW6\">Oli Dale</a>\n<p>Matt Mullenweg, the overall product lead for core releases in 2017, has published <a href=\"https://make.wordpress.org/core/2017/06/16/4-9-and-gutenberg/\" target=\"_blank\">an overview for what users can expect in WordPress versions 4.9 and 5.0</a>. After the success of 4.8 and the initial release of Gutenberg last week, Mullenweg is aiming to see the plugin installed on 100K+ sites during the next few months before merging it into core. He also suggested that WordPress could put a promo for the plugin in the upcoming 4.8.1 release.</p>\n<p>&#8220;In the meantime I think we can do another user-focused 4.9 release with the theme of editing code and managing plugins and themes, doing v2s and polishing some features we brought into WP last year,&#8221; Mullenweg said. &#8220;Weston and Mel already have some good ideas there, and we can start to discuss and brainstorm at the Dev chat next week. This will also allow the Gutenberg-driven release to be 5.0, which is a nice-to-have but not the primary driver of this decision.&#8221;</p>\n<p>Mullenweg elaborated on changes to the release process in <a href=\"https://ma.tt/2017/06/4-8-and-whats-coming/\" target=\"_blank\">a post on his personal blog</a>. The original idea was for releases to be driven by improvements to the three focus areas (the editor, customizer, and REST API), but the radical changes that Gutenberg introduces to the editing experience means that customization improvements will need to wait until the editor is a little further along:</p>\n<blockquote><p>\nMel and Weston took this as an opportunity to think about not just the “Customizer”, which is a screen and code base within WP, but really thinking in a user-centric way about what it means to customize a site and they identified a number of low-hanging fruits, areas like widgets where we could have a big user impact with relatively little effort.</p>\n<p>WordPress is littered with little inconsistencies and gaps in the user experience that aren’t hard to fix, but are hard to notice the 500th time you’re looking at a screen.</p>\n<p>I didn’t think we’d be able to sustain the effort on the editor and still do a meaningful user release in the meantime, but we did, and I think we can do it again.</p></blockquote>\n<p>During this week&#8217;s core development meeting, contributors brainstormed more specific items for inclusion in 4.9. The ability to schedule customizer changesets is one feature they discussed as a possibility. Customizer component co-maintainer Weston Ruter described the feature as &#8220;adding statuses for changesets: being able to draft a changeset to come back to later, and then to be able to schedule it to go live.&#8221;</p>\n<p>The <a href=\"https://wordpress.org/plugins/customize-snapshots/\" target=\"_blank\">Customize Snapshots</a> feature plugin contains the UI for this and Customize Changesets, the term for the underlying infrastructure required for saving a Customizer session as a draft, <a href=\"https://wptavern.com/wordpress-4-7-to-ship-with-infrastructure-from-the-customize-snapshots-feature-plugin\" target=\"_blank\">was added in WordPress 4.7</a>. Adding the UI in WordPress 4.9 would allow users to share Customizer sessions, preview them outside of the iframe, and schedule them to publish at a future date.</p>\n<p>Andrew Roberts, a contributor to TinyMCE, said they should have a new mobile-optimized UX, which would result in a responsive toolbar, that could land within the proposed 4.9 timeframe.</p>\n<p>&#8220;I would wonder if we couldn&#8217;t tweak the UI to be closer to Gutenberg (e.g. white toolbars),&#8221; Roberts said. &#8220;I had raised this idea before and it was thought it was better to wait until Gutenberg, but I remain of the opinion we could iterate a little bit closer to get users used to it.&#8221;</p>\n<p>Contributors also discussed the possibility of changing the default font in the editor to ease the transition to Gutenberg in the future. Currently, Gutenberg uses system fonts for UI and Noto Serif for the editor text.</p>\n<p>Mel Choyce, who is heading the Customizer focus with Weston Ruter, said she hopes the team can finish the Gallery Widget for 4.9. Current progress on the widget can be found on <a href=\"https://github.com/xwp/wp-core-media-widgets/pull/120\" target=\"_blank\">GitHub</a>.</p>\n<p>WordPress 4.8.1 is tentatively planned for the last week in July, and contributors anticipate including a fix for some issues with the <a href=\"https://core.trac.wordpress.org/ticket/40951\" target=\"_blank\">new Text Widget stripping out code</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Jun 2017 21:57:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: WordPress’ New Gutenberg Editor Now Available as a Plugin for Testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72098\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://wptavern.com/wordpress-new-gutenberg-editor-now-available-as-a-plugin-for-testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9087:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/06/gutenberg.png?ssl=1\"><img /></a></p>\n<p>One of the featured sessions at WordCamp Europe 2017 was Om Malik&#8217;s interview with Matt Mullenweg, followed by a 20-minute Q&amp;A from the audience. After showing a preview of the new Gutenberg editor with dynamic blocks replacing widgets, Mullenweg announced that it is now <a href=\"https://wordpress.org/plugins/gutenberg/\" target=\"_blank\">available as a plugin on WordPress.org</a>.</p>\n<p>Gutenberg has been in development for six months and is ready for testing, but its developers do not recommend using it on production sites. Anyone interested in the future of WordPress will want to take it for a test drive, as the new editor will revolutionize the way users think about creating and editing content. The demo video at WordCamp Europe also showed Gutenberg working smoothly in a mobile context.</p>\n<p>At first glance, it may appear that WordPress is trying to copy its more recent competitors (Medium, Wix, and others) to keep pace, but the 14-year-old software has offered many of these content capabilities for years. Mullenweg explained how the new editor simply unifies the UI into blocks that can be placed anywhere. Gutenberg is set to replace widgets, the HTML UI of shortcodes, and blocks previously offered through the TinyMCE toolbar.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/gutenberg-blocks.png?ssl=1\"><img /></a></p>\n<p>&#8220;We&#8217;ve taken stabs at this before, if you imagine our previous efforts with post formats &#8211; to make it easier to do certain types of media or quote posts or things like that,&#8221; Mullenweg said. &#8220;That whole concept can now flatten to just being a block. Working all that in, it&#8217;s bringing things we&#8217;ve been thinking about for a very long time in WordPress.&#8221;</p>\n<p>If you&#8217;ve ever sat down with a new user to introduce them to WordPress, then you probably answered a long list of painful questions regarding the many varied and confusing ways of creating content. Gutenberg has the potential to make WordPress much easier to use.</p>\n<p>&#8220;Right now WordPress makes you learn a lot of concepts &#8211; shortcodes, widgets, the stuff that exists inside TinyMCE as blocks today &#8211; and people rightly wonder why they can&#8217;t use those things everywhere,&#8221; Mullenweg said. &#8220;What we&#8217;re trying to do is shift it so that you only have to learn about blocks once and once you learn about the image block, that can be in a post, in a sidebar, in a page, in a custom post type, and it will work exactly the same way. Whatever is integrated with it, let&#8217;s say a plugin that brings in your Google Photos or your Dropbox, that will now work everywhere, too.&#8221;</p>\n<p>Mullenweg said his previous attempt at replacing TinyMCE lasted approximately two years and they never ended up shipping it. Getting Gutenberg off the ground at this time allows WordPress to take the best of what competitors in both open source and commercial spaces have been doing, and improve upon it.</p>\n<p>&#8220;Medium started five or six years ago,&#8221; Mullenweg said. &#8220;Browser technology, what you can do, has advanced quite a bit. I think this actually allows us to leapfrog past some of the really great visual editors, because we&#8217;re able to build on the shoulders of things like Medium, Wix, Squarespace, and others that have come before us.&#8221;</p>\n<h3>Gutenberg First Impressions and Concerns</h3>\n<p>The Gutenberg plugin is now active on more than 300 sites and first impressions are rolling in. This is the first time the new block editor has been easily accessible to any user who wants to try it. Gutenberg also offers a somewhat unique testing experience in that it creates its own menu inside WordPress, so users don&#8217;t have to choose between the old editor and the new one. Activating Gutenberg doesn&#8217;t make it an either/or experience and users can test at their own convenience.</p>\n<p>From my initial testing, I found that Gutenberg provides a clean and enjoyable experience. Up until this point many of us couldn&#8217;t fully anticipate what Gutenberg would look like, but the interface is very similar to what one might imagine for an improved &#8220;distraction-free writing experience.&#8221; Gutenberg provides a more minimal UI for both the visual and text editors, although inserting blocks seems to be less functional when using the text editor.</p>\n<p>There are still many bugs and rough edges, but this interface appears to be a natural evolution of WordPress&#8217; content editing experience. It <em>feels</em> like WordPress. The editor pulls in many of the elements that have worked well historically and introduces a minimal UI that makes it possible for anyone to build a beautiful, feature-rich post without knowing any HTML. Gutenberg is the most exciting thing to happen to WordPress in a long time.</p>\n<p>&#8220;The default state is likely my favorite &#8216;Distraction Free Writing&#8217; implementation in WordPress yet,&#8221; WordPress core committer Aaron Jorbin said in <a href=\"https://daily.jorb.in/2017/06/random-thoughts-on-gutenberg/\" target=\"_blank\">a post listing his initial observations</a>.  I’m simultaneously able to focus on my content, and yet I have all the tools I need for writing. I don’t have all the tools I need for content creation.&#8221;</p>\n<p>Matt Cromwell, co-author of GiveWP, also wrote up his <a href=\"https://www.mattcromwell.com/gutenberg-first-impressions/\" target=\"_blank\">first impressions of Gutenberg</a> with high compliments for the new writing experience.</p>\n<p>&#8220;In recent years we’ve seen Medium become the de facto elegant writing experience,&#8221; Cromwell said. &#8220;Medium is able to do that though by limiting the formatting and layout options dramatically. Gutenberg has the potential to allow writing to be as elegant as Medium or more so, plus deliver far more flexibility with layouts and content types.&#8221;</p>\n<p>One area of uncertainty for WordPress developers is how Gutenberg will handle support for plugins and maintain a high level of performance with a large number of custom blocks added.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">I\'ll try again when it has support for plugins. I can\'t see this landing in core if it doesn\'t work with plugins.</p>\n<p>&mdash; Josh Pollock (@Josh412) <a href=\"https://twitter.com/Josh412/status/877913290063663109\">June 22, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">It *should* store the block data as JSON (or serialized object, IDC) into postmeta, but instead it uses regexp to parse HTML and queries DB.</p>\n<p>&mdash; Christian Nikkanen (@k1sul1) <a href=\"https://twitter.com/k1sul1/status/877945432889884672\">June 22, 2017</a></p></blockquote>\n<p></p>\n<p>&#8220;I miss a lot of the meta boxes I’m used to seeing on the screen,&#8221; Aaron Jorbin said. &#8220;Things like Yoast SEO (on some sites) and custom taxonomies are just not shown. If every metabox ever made for WordPress needs to be remade, it sure is going to make developers&#8217; lives a living hell.&#8221;</p>\n<p>Matt Cromwell also detailed a nightmare scenario of having more custom blocks than the current UI can handle.</p>\n<p>&#8220;What happens when you have 25 plugins that all want to load 25 custom blocks into that tiny &#8216;Insert&#8217; dropdown?&#8221; Cromwell said. &#8220;Will there be a search? Or will it just scroll forever?&#8221;</p>\n<p>Mullenweg specifically addressed some of these concerns in his Q&amp;A session at WordCamp Europe.</p>\n<p>&#8220;A lot of people have a lot of things built into the edit screen, so part of the reason we&#8217;re putting it out there as a plugin first and also pushing it so hard to get as many people to install it as possible, is so that everyone who has posting and editing screen adjustments can rethink them to be beautiful within this new framework,&#8221; Mullenweg said.</p>\n<p>Mullenweg anticipates that WordPress will release version 4.9 before merging Gutenberg, because he wants to see it tested on more than 100,000 sites before replacing the edit screen. If all goes well, the new editor could land in WordPress 5.0.</p>\n<p>&#8220;I think that some things that people did, like TinyMCE toolbar things, aren&#8217;t really needed any more,&#8221; Mullenweg said. &#8220;Stuff that people did in the past with custom post types might be better as blocks. It gives us a real opportunity to reimagine a lot of the user interactions and flows that today we&#8217;ve taken for granted on the edit screen for five or six years.&#8221;</p>\n<p>Check out Mullenweg&#8217;s WCEU 2017 interview below to see the live demo of Gutenberg and make sure to take a few minutes to <a href=\"https://wordpress.org/plugins/gutenberg/\" target=\"_blank\">install the plugin</a> to see it in action for yourself.</p>\n<p></p>\n<p></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Jun 2017 22:29:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Post Status: The future of the WordPress economy, and why I’m not worried\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=37734\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://poststatus.com/future-wordpress-economy-im-not-worried/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:13965:\"<p><em><strong>Editor&#8217;s Note</strong>: This is a guest post by Joshua Strebel, the CEO and co-founder of <a href=\"https://pagely.com\">Pagely</a>. Pagely was one of the first managed WordPress hosts and continues to be a market leader. Josh has some thoughts about the WordPress economy, which I asked him to share here for the Post Status audience. He&#8217;s been around for a while, and I think he&#8217;s got a pretty good hold on the state of things. I hope you enjoy his commentary. And if you like this post, you&#8217;ll also enjoy <a href=\"https://poststatus.com/publish\">Post Status Publish</a>.</em></p>\n<hr />\n<p>There’s been some <a href=\"http://chrislema.com/wordpress-economy-shrinking/\">recent speculation</a> on whether or not the WordPress economy is beginning to slump. I would answer &#8216;yes&#8217; and &#8216;no&#8217;; it <em>is</em> clearly evolving, and some areas are contracting while others are growing. I believe we are feeling the effects of<strong> </strong><b>market maturity</b>.</p>\n<p>Are downmarket “one stop shop” alternatives and in house teams the best solution for the future of WordPress? No, because hosting providers, developers, and agencies who specialize in this space are where the concentrated real quality resides, and people are always willing to pay for quality. Ultimately WordPress has staying power because of its ecosystem, so let’s take stock of that.</p>\n<h2>The current state of the WordPress economy</h2>\n<p>In 2017 WordPress is used by major publishers, enterprises, <a href=\"https://pagely.com/solutions/universities/\">universities</a> and even custom SaaS applications. In fact the world’s leaders in business and marketing trends use WordPress (and aren’t necessarily leveraging in house teams to do so). To name a few:</p>\n<ul>\n<li><a href=\"https://newsroom.fb.com/\">Facebook Newsroom</a></li>\n<li><a href=\"http://www.gv.com/\">Google Ventures</a></li>\n<li><a href=\"https://www.mercedes-benz.com/en/\">Mercedes Benz</a></li>\n<li><a href=\"https://techcrunch.com/\">TechCrunch</a></li>\n<li><a href=\"https://www.bloomberg.com/professional/\">Bloomberg Professional</a></li>\n</ul>\n<p>WordPress powers an estimated <a href=\"https://wordpress.org/about/features/\">28% of all websites</a> which run the gamut of single contributor blogs and simple websites to applications and complex portals. That’s nearly 75 million websites built by anyone from the very beginner to the professional with an extremely advanced level of technical skill. WordPress is both easy to use and graceful in its complex abilities to do just about anything you would need a website to do.</p>\n<p>There’s also the community behind WordPress, an ecosystem of people around the world with this one thing in common. As an <a href=\"https://pagely.com/blog/2017/05/citizen-guide-open-source-community/\">open source community</a>, our entire industry is plugged into every update. We can contribute to testing or code. We have all the power to make sure the WordPress economy stays strong and continues to grow.</p>\n<p>New businesses are constantly being formed around plugins, themes and services built specifically for WordPress, with no signs of stopping. In fact, we’ll continue to find more and more creators of WordPress specific companies, with full time jobs elsewhere, using this as an opportunity to contribute to the community.</p>\n<p class=\"lead txt-danger\">However, the near constant flow of new entries into an already saturated market is outstripping demand. The WordPress pie overall is still growing but not quick enough to absorb the new sellers entering into the lower third of the market. The new players are typically unable to challenge the dominant players for a significant market share, and the demands and needs of the customers are also moving up the value chain. Yes, some newcomers do disrupt the established WP players, but it is happening with less frequency, and the barrier is ever higher.</p>\n<h2>Economies ebb and flow: Apple and Airbnb (and WordPress)</h2>\n<p>The companies and brands that have changed the way people live experience low points. Just like the ones we’ve feared will appear in our own industry. But you know these companies well, and they and their economies have persevered.</p>\n<p>Take the classic example, one of the greatest comeback stories of all time: Apple. Apple defied all odds and went from near bankruptcy to the powerhouse hardware leader it is today with over one billion iPhones currently in use. They lost Steve Jobs and many feared they would lose their focus and tumble downward. Instead they’re the <a href=\"http://appleinsider.com/articles/16/10/05/five-years-after-steve-jobs-an-apple-with-the-courage-to-say-no\">largest and most profitable</a> they’ve ever been. Walk down the streets of New York City or San Francisco and you’ll see brick and mortar shops dedicated to alt-genius-bar services and shattered screen replacement. The Apple economy is strong.</p>\n<p>Just like Apple, Airbnb almost flopped, but came out on top. It has an ecosystem of its own with tons of offshoot companies that support various aspects of the community, just like WordPress. After near failure Airbnb now supports a community of over 100 million and is valued at over $30 billion. They also face <a href=\"https://www.bloomberg.com/news/articles/2016-07-11/airbnb-faces-growing-pains-as-it-passes-100-million-users\">growing pains</a> and — at times — volatility, but companies like this — the ones that fundamentally change the way the world works — aren’t going anywhere.</p>\n<p>WordPress itself isn’t in danger of a near flop, but these are valuable examples of economies that fared far worse and still made it through.</p>\n<h2>The core strengths of WordPress</h2>\n<p>WordPress possesses fundamental characteristics that so many of today’s great leaders encompass. All leaders like this are built to support a growing economy for a long time to come.</p>\n<h3>Brand</h3>\n<p>In Pagely&#8217;s own recent user survey, the most important factors for choosing a service were <strong>reliability </strong>and <strong>security</strong>. These are cornerstones of the WordPress brand <em>(haters gonna hate – but core has been really solid for many years in both respects)</em> and reasons why such a large percentage of the internet continues to choose it to power their websites. As a brand, WordPress is synonymous with being one of the most reliable and secure CMS options available. Quality service providers that support WordPress, like Pagely, also often encompass these brand characteristics. We often hear of these same characteristics as pain points from customers trying to work in-house or with downmarket alternatives.</p>\n<h3>Ubiquity</h3>\n<p>WordPress users span nearly every industry in the world. Publishers, Fortune 500 Companies, Music, Fashion, Tech, Politics, you name it. Like I mentioned above, ~75 million websites use WordPress, and they are published in dozens of languages. WordPress is literally a web that has woven itself through the digital and physical world.</p>\n<h3>Community</h3>\n<p>The WordPress community is made up of contributors, coders, engineers, designers, marketing professionals, and every other title necessary to run a business. The community reaches so far that it touches every corner of today’s tech workforce. Not only is the community large, but it cares. We care. The number of blogs and forums dedicated to helping people understand WordPress are impossible to count. Events like WordCamp, LoopConf, Publish, and PressNomics occur all year long and prominent core contributors participate. Don’t hate me for loosely quoting Lincoln. But, it could be said here that “[WordPress] of the people, by the people, for the people shall not perish from the earth.”</p>\n<h2>The WordPress ecosystem rewards quality</h2>\n<p>While the core strengths of WordPress support the service itself, quality is what supports the economy as a whole. And the fact remains that people <em>are</em> willing to pay for quality. To paint the picture, at Pagely a core aspect of our mission is to bring a flexible, friendly, and first-rate experience to all our customers. In staying true to that high standard of quality we’ve seen substantial <a href=\"https://pagely.com/blog/2017/01/pagely-2016-in-review/\">year over year revenue growth since 2014</a>. With an ecosystem that strives for and rewards quality, the larger WordPress economy is in a position to keep growing — and continue to take us along with it.</p>\n<p>Any &#8220;economy&#8221; will ebb and flow, but when a technology powers 28% of something, it has staying power; WordPress and the ecosystem we’ve built around it isn’t going anywhere, <strong>but it is changing</strong>.</p>\n<h2>The ecosystem is maturing — and growing</h2>\n<p>I would argue that after 12+ years the WordPress ecosystem has firmly moved from &#8220;<strong>New market</strong>&#8221; territory where there were wide open spaces for entrants to dominate. As an example, commercial themes really took off in 2008,  managed WordPress hosting came to prominence in 2010, and commercial plugins rose to fame in 2011. These, and most channels in the ecosystem are now clearly defined &#8220;<strong>Existing markets</strong>.&#8221;</p>\n<p>Since 2015 or so, the majors players in each category have been well known, with few exceptions from new entrants claiming significant market share. <strong>Those who are doing this are using <a href=\"https://www.marsdd.com/mars-library/the-four-types-of-market-market-maturity-where-does-your-startups-product-belong/\">strategies</a> common in existing markets: Resegmentation based on price, and resegmentation based on a niche strategy.</strong></p>\n<p>Borrowed from <a href=\"https://www.inc.com/karl-and-bill/6-signs-your-market-is-maturing.html\">this article</a>, we can identify six signs a market is maturing. Not every point applies completely to our ecosystem, but enough do that I believe we can safely make this call.</p>\n<ol>\n<li class=\"mb-1\">Customer needs/desires do not appear to be evolving rapidly.<br />\n– <small class=\"txt-danger\">eCommerce and membership sites are the most recent ‘asks’ that come to mind, and that was a few years ago.</small></li>\n<li class=\"mb-1\">Consolidation by leading competitors is reducing competitive intensity.<br />\n– <small class=\"txt-danger\">GoDaddy, EIG, Envato, and Automattic are rapidly consolidating products and services into their domain</small>.</li>\n<li class=\"mb-1\">Disruptive innovations and new entrants are gaining share only gradually and top out at relatively low levels.<br />\n– <small class=\"txt-danger\">Some really innovative things are happening, but they&#8217;re around the corner and seem slow to pick up traction.</small></li>\n<li class=\"mb-1\">Market shares of leading competitors have solidified and are changing gradually, if at all.<br />\n– <small class=\"txt-danger\">We pretty much know who the leaders are in every category and the price points they own.</small></li>\n<li class=\"mb-1\">Price, brand, and/or channel strategy have supplanted product innovation as key value drivers.<br />\n– <small class=\"txt-danger\">Refining the value proposition to our customers has greater focus at Pagely vs. shipping the latest tech du jour, which is happening just behind the scenes at measured pace.</small></li>\n<li class=\"mb-1\">Cash flows are increasingly turning positive and being returned to investors rather than invested into the market.<br />\n– <small class=\"txt-danger\">Not in all cases, there is still a lot of energy being focused on market expansion.</small></li>\n</ol>\n<span class=\"pullquote alignright\">The pie is still growing overall, but a higher percentage of that growth is being concentrated among the established leaders who do more than the basics.</span>\n<p>The massive low-cost hosting providers are enrolling many thousands of new WordPress users a day. Their product offering is good enough for the price point, their marketing spends are huge, and any new customer starting to use WordPress is landing there.</p>\n<p>It is the same with eCommerce on WordPress — there are just two or three plugins and services absorbing new users.</p>\n<p>In the agency space, the buyers willing to spend capital (enough to sustain a high-end WordPress agency) on WordPress solutions are not buying $500 websites, or $5,000 websites as they once were. They are buying $50K-$1M custom-built WordPress backed applications. The resources and talent required to serve these clients is concentrated at a handful of established and well known shops.</p>\n<p>These examples continue into every segment of the ecosystem.</p>\n<p>WordPress is getting easier and easier to use right out of the box. If the majority of the new WordPress users needs are solved on install (via core, bundled plugins, or the hosting platform) then a wide swath of the current ecosystem is going to shrink.</p>\n<p><strong>In all channels, new market entrants or existing small shops are being out-gunned by the established players, or the buyers needs are being met upon install.</strong></p>\n<h2>Adapt to win</h2>\n<p>So is the WordPress ecosystem shrinking? <strong>Yes, segments of it are and will continue to do so</strong>.</p>\n<p>It’s like in any industry: the car replaced the horse and the robot replaced the factory worker. What was successful in the New Market phase may not work in the more mature, &#8220;Existing Market&#8221; phase we are in.</p>\n<p><strong> Other segments, many not even identified yet, will expand.</strong> There are still big challenges that need to be solved in WordPress, the solutions for which will surely prove to be innovative and profitable. <a href=\"https://www.amazon.com/Blue-Ocean-Strategy-Expanded-Uncontested/dp/1625274491\">Go find the next blue ocean</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Jun 2017 22:00:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Joshua Strebel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"WPTavern: WordPress Marketing Team Launches Case Studies and Usage Survey for Agencies, Clients, and Enterprises\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://wptavern.com/wordpress-marketing-team-launches-case-studies-and-usage-survey-for-agencies-clients-and-enterprises\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5563:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2015/06/survey.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/FI3UYVGNFD\">Lukasz Kowalewski</a>\n<p>WordPress&#8217; Marketing Team has <a href=\"https://make.wordpress.org/marketing/2017/06/15/wordpress-case-studies-and-usage-survey/\" target=\"_blank\">launched a set of surveys</a> to gather case studies and usage data from agencies, clients, and enterprises, with the goal of providing more resources for adoption. The Usage Survey was created to capture feedback on the factors that influenced an organization to select WordPress as well as any barriers to using the software. The team plans to use use the data to provide resources, such as fact sheets, FAQs, case studies, testimonial videos, and other marketing materials.</p>\n<p>During the <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\" target=\"_blank\">State of the Word address in 2016</a>, Matt Mullenweg said the project could no longer get by on &#8220;marketing happenstance&#8221; but needed to form a more coordinated effort to counter the millions of dollars that proprietary systems are spending marketing their products against WordPress. These research surveys are one of the first steps in that direction, along with the <a href=\"https://wptavern.com/matt-mullenweg-proposes-wordpress-growth-council\" target=\"_blank\">WordPress Growth Council</a> that Mullenweg formed to bring together more people with large-scale marketing expertise.</p>\n<p>With the proliferation of user-friendly, DIY commercial website solutions, WordPress has reached a critical time where the project needs to shed its image as a clunky, legacy CMS and demonstrate why it&#8217;s the market leader. This not only requires WordPress to deliver from a technical standpoint, especially in the areas of editing and customization, but also requires the 14-year-old project to step up its marketing efforts.</p>\n<p>WordPress&#8217; Marketing Team exists to &#8220;help people market WordPress as open source software and the WordPress community.&#8221; The need is evident, as even the most experienced WordPress professionals struggle to properly articulate the difference between WordPress.com and the self-hosted software in a way that newcomers can understand. This is an intractable marketing problem for the self-hosted community.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Explain to me in two paragraphs or less the delineation between <a href=\"https://t.co/shm7MBBfUi\">https://t.co/shm7MBBfUi</a>, Jetpack, and <a href=\"https://t.co/w3VOMjx5s9\">https://t.co/w3VOMjx5s9</a>.</p>\n<p>&mdash; Ryan D. Sullivan (@ryandonsullivan) <a href=\"https://twitter.com/ryandonsullivan/status/877350749792903168\">June 21, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">WordPress(dot)org has lost the branding battle with WordPress(dot)com.</p>\n<p>&mdash; Drew Jaynes (@DrewAPicture) <a href=\"https://twitter.com/DrewAPicture/status/877649047456231424\">June 21, 2017</a></p></blockquote>\n<p></p>\n<p>David Skarjune, a contributor on the Marketing Team who helped put the surveys together, <a href=\"https://wordimage.com/articles/marketing-wordpress-as-free-software/\" target=\"_blank\">describes the problem that WordPress professionals face in marketing the free software</a>:</p>\n<blockquote><p>Here we have the classic WordPress.COM and WordPress.ORG duo that encompasses the nature of the WordPress free software system. This twosome drives the project and sometimes it drives us crazy—only because it instills wide-eyed confusion trying to explain these companion entities to the rest of the world. Simple enough: get a free blog at .COM or get free software and help at .ORG. However, free software makes no sense to the average person, and too many writers, marketers, and designers don’t much care how the InterWebs actually operate.</p></blockquote>\n<p>The confusion between WordPress.com and self-hosted WordPress is just one of the many factors that make the software a unique marketing challenge. <a href=\"http://devwp.eu/\" target=\"_blank\">Mario Peshev</a>, CEO of <a href=\"http://devrix.com\" target=\"_blank\">DevriX</a>, identified many more <a href=\"http://devwp.eu/15-obstacles-enterprises-report-wordpress-development-partners/\" target=\"_blank\">obstacles that enterprises find in using WordPress</a>. Several of these include misconceptions about security, scaling, and limitations for functionality beyond blogging. WordPress&#8217; Marketing Team aims to provide agencies with free resources to combat common misconceptions and show real-world examples of where the software is quietly powering enterprise websites behind the scenes.</p>\n<p>If you have an interesting example of how WordPress solved a client&#8217;s needs, feel free to <a href=\"https://docs.google.com/forms/d/e/1FAIpQLSe9cYQRDtJCcI1nphPTfO_Lb7qAGJP68l0_ceyj0uMNzOwI2g/viewform?usp=sf_link\" target=\"_blank\">submit a case study</a>. If you represent an organization that is using WordPress and can offer feedback on why you selected it and any obstacles you continue to face, please take the <a href=\"https://docs.google.com/forms/d/e/1FAIpQLSf--7zTsKrE7nRSMWoCXnYWJQxDD9GjttKsqoPUJ-kuM9XjkA/viewform?usp=sf_link\" target=\"_blank\">WordPress Usage Survey</a>. Both surveys will be open through July 14, 2017, and the results will be published on WordPress.org.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Jun 2017 04:33:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: WPShout Updates and Acquires WPHierarchy.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72233\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wptavern.com/wpshout-updates-and-acquires-wphierarchy-com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1423:\"<p><a href=\"http://wphierarchy.com/\">WPHierarchy.com</a> is a WordPress resource <a href=\"https://wptavern.com/pretty-wordpress-template-hierarchy-diagram\">created</a> by Rami Abraham in 2013. The site is an interactive version of <a href=\"http://wpdaily.co/wp-template-hierarchy-chart/\">Michelle Schulp&#8217;s colorful diagram</a> of WordPress&#8217; template hierarchy. Each template is linked to documentation that explains its function.</p>\n<p>Over the years, WordPress&#8217; template hierarchy has changed. For instance, paged.php no longer comes after archive.php. The site however, hasn&#8217;t kept up with the changes.</p>\n<p>In an effort to keep the site going, updated, and maintained, WPShout has <a href=\"https://wpshout.com/links/wphierarchy-com/\">acquired the domain</a> from Abraham for an undisclosed amount. The team fixed the most of the obvious issues and the site is once again a valuable resource for visualizing the template hierarchy.</p>\n<p><img /></p>\n<p>David Hayes, of WPShout, says they&#8217;re working on collaborating with <a href=\"https://twitter.com/marktimemedia/\">Schulp</a> to visualize and better explain how Custom Templates can be applied to all post types.</p>\n<p>If you&#8217;d like to report an error or want to contribute, you can do so via the <a href=\"https://github.com/pressupinc/wphierarchy\">project&#8217;s Github page</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Jun 2017 00:59:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: WPWeekly Episode 278 – Recap of WordCamp Europe 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=72367&preview=true&preview_id=72367\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wptavern.com/wpweekly-episode-278-recap-of-wordcamp-europe-2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2118:\"<p>In this episode, <a href=\"http://jjj.me/\">John James Jacoby</a> and I are joined by <a href=\"http://coachbirgit.de/\">Coach Birgit Olzem</a>, <a href=\"https://twitter.com/caroleolinger\">Carole Olinger</a>, <a href=\"https://arrowrootmedia.com/\">Jaki Levy</a>, and <a href=\"https://twitter.com/mcdwayne?lang=en\">Dwayne McDaniel</a> who attended <a href=\"https://2017.europe.wordcamp.org/\">WordCamp Europe</a> in Paris, France.</p>\n<p>We discuss contributor day and the effects of having it at the beginning of a WordCamp instead of at the end. Each individual shared their experience attending the event and described what their favorite session was.</p>\n<p>Lunch was provided at WordCamp Europe in paper bags with plastic utensils. With 1,900 attendees, this resulted in a lot of trash. We discussed the impact WordCamps can have on the environment and why larger WordPress events should act as a role model for being as sustainable as possible.</p>\n<p>We also talked about <a href=\"https://wordpress.org/plugins/gutenberg/\">Gutenberg</a>, the <a href=\"https://make.wordpress.org/marketing/\">WordPress marketing team&#8217;s efforts</a>, and the differences between WordCamp US and EU.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/woocommerce-drops-50-renewal-discount-on-subscriptions\">WooCommerce Drops 50% Renewal Discount on Subscriptions</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, June 28th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #278:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Jun 2017 00:12:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"HeroPress: Becoming Known in the WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1927\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:142:\"https://heropress.com/essays/becoming-known-wordpress-community/?utm_source=rss&utm_medium=rss&utm_campaign=becoming-known-wordpress-community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11929:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/06/062117-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I was helping hundreds of people that were using WordPress for their business. That\'s powerful.\" /><h3>So you make websites, right?</h3>\n<p>My name’s Juan and I make websites. I’ve been doing that since my brother came home with a computer’s magazine that had a CD with a copy of Front Page 98. I learned about HTML. Tables. Marquees. Divs. CSS. Flash. ActionScript. JavaScript. PHP-Nuke. phpBB. Blogger. And, finally, in 2008, I learned about WordPress.</p>\n<p>I loved writing and enjoyed having my own blog after seeing that social networks like MySpace or Fotolog weren’t going too far. I kept learning and found the power of WordPress to create more complex sites. I decided that my hobby could be my job. I became a freelancer. I found clients, I made lots of mistakes, I didn’t make much money. I was alone in my small village in the North of Spain: Santoña, in Cantabria.</p>\n<p>I knew I wasn’t the only one creating websites around, but I never thought about meeting people like me. I didn’t know about the real power of Open Source. I was isolated, planning to move with my girlfriend to another city, Pontevedra, and I didn’t have a clue about what was going to happen soon in my life.</p>\n<h3>The power of WordCamps</h3>\n<p>One day I found out that in November of 2015 there was going to be a WordCamp in Santander, a city 50 km. far from my village. An event for WordPress developers and users. That sounded good. I had no idea that that kind of events were happening all around the world. I had no idea about anything related to the WordPress Community. I didn’t know that the Community was even a thing.</p>\n<p>So I went there a Saturday morning and attended to most of the talks.</p>\n<blockquote><p>I remember sitting in the last rows, as if I were hiding so no one would notice that I was there alone.</p></blockquote>\n<p>I didn’t want to say anything stupid and I was just absorbing all I could from the speakers and their presentations.</p>\n<p>After a great talk about theme development I waited for the speaker and I thanked him for all the info. I was nervous. He was a speaker. He was from another league, right? But he was a really nice guy, ‘if you have any doubt, just ask me’. Cool.</p>\n<p>On Sunday we had the Contributor’s Day. And there I was, randomly in the Community table, learning how to organize a Meetup with some people I had just met, Rocío Valdivia and Ibon Azkoitia. Remember these names. They told me that, as I was moving to another city where there wasn’t any WordPress group, I could start one myself.</p>\n<p>My brain: Wait a second. Me? Starting a WordPress Meetup in Pontevedra?</p>\n<p>I took notes and kept enjoying the day. I met many people and, being not very good remembering names, all I could do was following them on Twitter. And signing in the WP Slack channel.</p>\n<p>At the end of the event, Darío, the main organizer asked me about how was the experience. I had loved it. Will you come back? Yeah, but next year… as a speaker!</p>\n<p>My brain, again: As a speaker? Are you really listening to yourself? You hate speaking in public. You’re the most nervous person ever.</p>\n<h3>My first year in the Spanish WordPress Community</h3>\n<p>The days after the event were weird. I started reading about the people I met and I found out that some of them were incredible developers, some of them had thousands of followers in Twitter, some of them had the most important websites about WordPress in our language… And I didn’t have a clue about all that.</p>\n<p>Did it matter? Not at all. These people don’t care about those things and will help you no matter who you are or where you are coming from.</p>\n<p>Moving to a new place was a slow process, so I didn’t have to worry about the Meetup I promised to organize, but the weeks were running and I had no idea about what to talk about in the next WordCamp as I told Darío.</p>\n<p>I started to become a little more involved in the Community. I helped translating plugins to Spanish. The original translation of WooCommerce was made by a drunk robot or similar, so there were thousands of strings to be revised and translated again. It was fun. And a lot of work that I did with the help of Fernando Tellado, an experienced translator and member of the Community.</p>\n<blockquote><p>And I was helping hundreds of people that were using WordPress for their businesses. That’s powerful. I was helping many people.</p></blockquote>\n<p>By that time I was reading many WordPress related blogs and sites and I decided to curate a weekly post with the ten best links (in Spanish and English) I read every week. That’s how I started Enlace Permanente, which is almost now in its #70 edition with many subscribers to the newsletter and followers.</p>\n<p>I kept talking with Ibon, Darío and others in the Slack channels and on September of 2016 we decided to go to WordCamp Seville. I travelled the country from North to South and spent there a fantastic weekend. I shared an AirBnb apartment with Ibon, Mauricio Gelves and Fernan Díez, who became great friends. I met more new people and strengthened the relationship with ‘older’ mates.</p>\n<p>And, as I was finally moving to a new flat in Pontevedra, I decided it was time to start the local Community of the city. A city where I didn’t know any other developer or WordPress user. But… I was sure someone will be there.</p>\n<p>I had the help of Rocío, who works at Automattic and all her time is donated to the WordPress.org Community team, working at WordCamp Central helping Meetup and WordCamp organizers all around the world.</p>\n<blockquote><p>She was extremely helpful and she’s the reason that today in Spain we have more than 40 different Meetups and 5 WordCamps in 2017.</p></blockquote>\n<p>I planned the first event for the end of November, but before, I had to send an email to Darío as the Call for Speakers of WordCamp Santander 2016 was already open. I decided to talk about my experience the last year. ‘From being no one to being a speaker: a year in the Spanish WordPress Community’. That was the title of my talk.</p>\n<p>And yes, I was nervous. I didn’t sleep well the week before. I talked quickly. But I did it. People laughed, people clapped and people enjoyed my story. This story. And they learned about how they could help an awesome Open Source project like WordPress and meet great people at the same time.</p>\n<h3>Becoming a known member of the Community</h3>\n<p>When you become part of a Community for the first time, you easily find that there are small groups within the big one. People that already know each other of past events, of past projects. And maybe you think that it’s not easy to be part of those groups. Or that they won’t accept a new one.</p>\n<p>Well, that didn’t happen to me in the WordPress Community.</p>\n<p>Everyone was ready to say ‘hi’ to the latest addition. Everyone was ready to help with translation doubts. Everyone was ready to share their experience organizing local groups. Or answering questions in the support forums. Or just ready to chit chat. Or to organize a trip for the next WordCamp.</p>\n<p>So I just started doing the same.</p>\n<blockquote><p>And you don’t do it to become a known member of the Community. That’s just a catchy phrase for the post. You do it because it feels good.</p></blockquote>\n<p>Because you meet great developers, designers, freelancers… Because you can help anyone who knows a little less than you, the same way that the people that know more help you.</p>\n<p>In 2017 I was lucky enough to be part of WordCamp Madrid and WordCamp Bilbao, as a volunteer and as a speaker. I had the chance to talk about something that I’m really passionate in Madrid: the open web. I had the chance to speak up about net neutrality, about our contents, about walled gardens, about what we can do to save the web. I shared an important message with my peers.</p>\n<p>And in Bilbao I had the chance to explain the process of creating a WordPress theme from the moment the designer starts wireframing a project. My day to day job. Best practices, advice, tools, how-tos… I showed how I do my job to become better at it and to help others to become better too.</p>\n<p>Also in Pontevedra, we’re around 20-25 people every month in the local Meetup. And in Galicia, the region where I live, I’ve helped creating two more Meetup groups, in Ourense &amp; Lugo. And I’m sure there will be more soon! There are almost 3 million people here, so many WordPress users still to find!</p>\n<h3>And what now?</h3>\n<p>I want to keep having fun and working to make WordPress a better tool and platform for as many people as possible. I want to find more people in the local communities to show them what we have here. And who knows? Maybe organizing a WordCamp in 2018.</p>\n<p>Also, in the next months I would like to find out if it’s possible also to become a more active member of the Global WordPress Community. As English is not our first language and we’re a little shy, probably not many Spanish speakers are known in the WP world. But I’m sure that the steps I did to become part of our national group can be done exactly the same way to be part of the international one, don’t you think?</p>\n<p>So, who knows? Will I go to a WordCamp in the USA or another country next year… as a speaker?</p>\n<p>And you? Are you ready to become part of your local and national Community? It’s easier than you think, I’m sure of that. Just… say it out loud and start doing stuff.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Becoming Known in the WordPress Community\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Becoming%20Known%20in%20the%20WordPress%20Community&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fbecoming-known-wordpress-community%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Becoming Known in the WordPress Community\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fbecoming-known-wordpress-community%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fbecoming-known-wordpress-community%2F&title=Becoming+Known+in+the+WordPress+Community\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Becoming Known in the WordPress Community\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/becoming-known-wordpress-community/&media=https://heropress.com/wp-content/uploads/2017/06/062117-150x150.jpg&description=Becoming Known in the WordPress Community\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Becoming Known in the WordPress Community\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/becoming-known-wordpress-community/\" title=\"Becoming Known in the WordPress Community\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/becoming-known-wordpress-community/\">Becoming Known in the WordPress Community</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Jun 2017 11:30:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Juan Hernando\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: WordCamp Europe 2018 to be Held in Belgrade, Serbia, June 14-16\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72113\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://wptavern.com/wordcamp-europe-2018-to-be-held-in-belgrade-serbia-june-14-16\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1938:\"<p>Belgrade, Serbia will host the sixth edition of WordCamp Europe, June 14-16, 2018. Prior host cities include Leiden, Sofia, Seville, Vienna, and Paris. Attendees and the massive 221-person volunteer crew gave their enthusiastic approval when organizers announced the event would be returning to Eastern Europe next year.</p>\n<blockquote class=\"instagram-media\">\n<div>\n<div>\n<div></div>\n</div>\n<p> <a href=\"https://www.instagram.com/p/BVcncQEhX_g/\" target=\"_blank\">WordCamp Europe 2018 will be in Belgrade, Serbia, June 14-16! &lt;3 #wceu</a></p>\n<p>A post shared by Sarah Gooding (@pollyplummer) on Jun 17, 2017 at 9:18am PDT</p>\n</div>\n</blockquote>\n<p></p>\n<p>The Serbian WordPress community has <a href=\"https://wptavern.com/a-glimpse-into-serbias-rapidly-growing-wordpress-community\" target=\"_blank\">grown exponentially since the first WordPress meetup</a> was held in 2013 at ManageWP&#8217;s offices. Now, Serbia hosts meetups in several cities and many of them are averaging more than 100 attendees. Meetup.com is not very popular in Serbia so the <a href=\"https://www.facebook.com/groups/613503768679500/\" target=\"_blank\">WP Serbia Facebook group</a> is used more frequently to organize community events. The group has grown from 600 members to more than 4,700 during over the past two and a half years.</p>\n<p>At WordCamp Europe I had the opportunity to interview Jenny Beaumont, this year&#8217;s local lead for Paris, along with Milan Ivanović who will lead the local team next year in Serbia. Beaumont shares the challenges of wrangling busy volunteers on the local team and offers Ivanović some advice as he prepares to head up the team in Serbia. Ivanović is eager to acquaint WordPress&#8217; global community with Serbia&#8217;s famous hospitality and sums up why prospective attendees should consider attending in 2018: &#8220;The food!&#8221;</p>\n<div class=\"embed-wrap\"></div>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Jun 2017 05:22:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: WooCommerce Drops 50% Renewal Discount on Subscriptions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72173\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wptavern.com/woocommerce-drops-50-renewal-discount-on-subscriptions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2919:\"<p>Customers who purchased extensions from <a href=\"https://woocommerce.com/\">WooCommerce.com</a> are discovering that the renewal discount of 50% has been removed. Instead, they are now paying full-price.</p>\n<p>The <a href=\"https://woocommerce.com/blog/\">WooCommerce blog</a> and the official <a href=\"https://twitter.com/woocommerce\">Twitter account</a> do not mention anything about the price increase.</p>\n<p>We contacted Automattic and asked if the discount was removed and if customers received prior notice of the price increase. Todd Wilkens, head of WooCommerce, provided the Tavern with the following statement:</p>\n<blockquote><p>All customers receive notification of their upcoming renewal 7 or 15 days before a charge. If anyone received an incorrect price, please contact us immediately and we will make it right. As always, we are committed to making sure WooCommerce is affordable to the widest range of people while maintaining our high level of service and support.</p></blockquote>\n<p>A customer upset by the change contacted WooCommerce&#8217;s support desk and inquired about the price increase. The support representative confirmed that the discount was removed and that customers will need to pay full-price to renew.</p>\n<p>The customer service rep also explained that the change is due to WooCommerce moving to a straight renewal process, similar to other SaaS products. The representative concludes the ticket by saying they&#8217;re monitoring and accepting feedback about the change.</p>\n<img />WooCommerce Customer Support Response\n<p>Nathan Hadsall, who makes a living using WooCommerce, is among those upset by the change. &#8220;I have been a huge WooCommerce supporter and most of my work as a developer is spent working with WooCommerce,&#8221; Hadsall said.</p>\n<p>&#8220;However this type of approach to business is very sad. I have no problem paying for a license despite the fact that GPL software is available cheaper and legally/ethically by other means.</p>\n<p>&#8220;I will still stick to WooCommerce since the core is fantastic and is getting better. The biggest change for me will be the plugins and code I use to extend WooCommerce functionality. I will probably start to look elsewhere.</p>\n<p>&#8220;The biggest gripe I have is with the way WooCommerce does business. WooCommerce has never seemed to care about their customers. Slipping this pricing change in was not an honest move.&#8221;</p>\n<p>Raising prices for renewals is a part of business and something I think many customers expect at some point. However, raising prices on subscriptions that existing customers may have set to auto-renew, without explicitly notifying them about the change, can create a negative, lasting experience.</p>\n<p>If you purchased a subscription on WooCommerce.com and have set it to auto-renew, keep a close eye for your renewal notice.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Jun 2017 02:56:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: Disqus 3.0 Beta Improves Comment Syncing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72176\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wptavern.com/disqus-3-0-beta-improves-comment-syncing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2195:\"<p>When <a href=\"https://wptavern.com/wpweekly-episode-269-interview-with-daniel-ha-ceo-and-co-founder-of-disqus\">we interviewed</a> Daniel Ha, CEO and co-founder of Disqus, earlier this year, he explained why some users were <a href=\"https://wptavern.com/wpweekly-episode-269-interview-with-daniel-ha-ceo-and-co-founder-of-disqus#comment-216978\">reporting problems</a> syncing comments between Disqus and WordPress and that improvements would be coming soon.</p>\n<p>&#8220;We may have taken some services offline to work on them which may have affected those who were trying to sync,&#8221; Ha said.</p>\n<p>Disqus <a href=\"https://blog.disqus.com/disqus-for-wordpress-3.0-plugin-beta-now-available-for-testing\">has released</a> 3.0 Beta 1 that fixes syncing issues and introduces a redesigned settings screen. Disqus 3.0 was rewritten to take advantage of newer APIs in WordPress which will allow for faster iterations of improvements.</p>\n<p>Comments are synced to the WordPress database using a webhook method instead of wp-cron making the process more reliable. This version also supports edited comments and comment states enabling users to see if comments are approved, pending, or deleted.</p>\n<img />Disqus 3.0 Settings Screen\n<p>Disqus 3.0 has a redesigned settings screen that includes shortcuts to frequently visited sections of Disqus&#8217; backend. Disqus replaces the Comments top-level menu item and shortcut links are now available in the WordPress Admin Bar.</p>\n<p>Other improvements to the plugin include:</p>\n<ul>\n<li>Replacing WordPress comments template with Disqus comments</li>\n<li>Replacing WordPress comment count with Disqus comment count</li>\n<li>Automatic closing of WordPress login window when using single sign-on</li>\n</ul>\n<p>The plugin is only available <a href=\"https://github.com/ryanvalentin/disqus-wordpress-plugin/releases/\">via Gitub</a> as the team seeks feedback to identify potential issues before rolling it out to the public. If you discover a bug, you can report it by <a href=\"https://github.com/ryanvalentin/disqus-wordpress-plugin/issues\">opening a new issue</a> on the project&#8217;s Github page.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Jun 2017 07:28:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: Peak Tea Demand\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2017/06/peak-tea-demand/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2017/06/peak-tea-demand/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:459:\"<p>I found this funny anecdote from <a href=\"https://www.cnet.com/news/tesla-is-changing-the-electric-grid/\">a CNET article about the future of power</a>: </p>\n<blockquote><p>Power and utility companies must exactly balance supply with what people consume at any given moment. UK grid operators famously must cope with a demand surge after the TV soap opera &#8220;EastEnders&#8221; ends, when thousands of people start boiling water for tea.</p></blockquote>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 18 Jun 2017 15:59:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: WordCamp Europe 2017 Draws 1900 Attendees from 79 Countries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72127\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/wordcamp-europe-2017-draws-1900-attendees-from-79-countries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5654:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/06/wordcamp-europe-2017-volunteers.jpg?ssl=1\"><img /></a>photo credit: WP Tavern\n<p><a href=\"https://2017.europe.wordcamp.org\" target=\"_blank\">WordCamp Europe</a> was held this weekend in Paris, bringing together 1,900 attendees from 79 countries. Another 1,000 people joined via livestream from 77 countries to make a total audience of 2,900 participants from 92 countries. The number of attendees on the ground was about one third less than original estimates of 3,000, but everyone who wanted a ticket was able to get one. A team of 221 volunteers communicated on Slack behind the scenes to make the event run as smoothly as possible.</p>\n<p>The event&#8217;s 45 organizers made the presentations more accessible to speakers of different languages with live captioning and real-time audio translation.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/06/live-captioning.jpg?ssl=1\"><img /></a>photo credit: WP Tavern\n<p>WordCamp Europe is the leading WordPress event for catching presentations about the ongoing efforts to bring the software to all the languages of the world. A large percentage of attendees were multi-lingual leaders in WordPress&#8217; translation community, resulting in many presentations and lightning talks focused on topics like communication, internationalization, organizing translation sprints, and using inclusive language for interfaces.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/06/petya-wceu-2017.png?ssl=1\"><img /></a>photo credit: <a href=\"https://twitter.com/WCEurope/status/875616228714270726\">WordCamp Europe 2017 Photography Team</a>\n<p>Matt Mullenweg and Om Malik joined the event for a casual Q&amp;A session with attendees wherein Mullenweg showed a demo of the new Gutenberg editor and announced its availability as <a href=\"https://wordpress.org/plugins/gutenberg/\" target=\"_blank\">a plugin on WordPress.org</a>. We&#8217;ll cover their comments on the future of the editor and the open web more in-depth in another post.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/wceu-q-and-a-with-matt-and-om.jpg?ssl=1\"><img /></a></p>\n<p>This year&#8217;s WordCamp Europe sponsors had space for large 360° booths and the opportunity to be featured in 30-second advertisements between sessions. Organizers also arranged for sponsor workshops with a dedicated space for those who purchased the highest sponsorship levels. These workshops included topics like Creating a WordPress Theme for the Masses, Intro to WooCommerce, Jetpack tips, and hosting product demos.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/06/sponsors-wceu.jpg?ssl=1\"><img /></a>photo credit: WP Tavern\n<p>WordCamp Europe had no shortage of swag unique to the event, including a limited edition French plush Wapuu, posters, postcards, socks, stickers for European WordCamps, and other items for sale in the traveling Swag Store. A giant, stuffed French Wapuu made the rounds, appearing in pictures with attendees.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">The fun, family and Wapuu moment  <a href=\"https://twitter.com/WCEurope\">@WCEurope</a>! <a href=\"https://twitter.com/hashtag/getwapuu?src=hash\">#getwapuu</a> <a href=\"https://twitter.com/hashtag/WCEU?src=hash\">#WCEU</a> <a href=\"https://twitter.com/hashtag/wceu2017?src=hash\">#wceu2017</a> <a href=\"https://t.co/eykTMyuiC8\">pic.twitter.com/eykTMyuiC8</a></p>\n<p>&mdash; Anil Gupta (@guptaanilg) <a href=\"https://twitter.com/guptaanilg/status/875969553053962240\">June 17, 2017</a></p></blockquote>\n<p></p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"hi\" dir=\"ltr\">Swag + Wapuu = ❤️ <a href=\"https://t.co/Lg5LGYeHmj\">pic.twitter.com/Lg5LGYeHmj</a></p>\n<p>&mdash; WordCamp Europe (@WCEurope) <a href=\"https://twitter.com/WCEurope/status/875721426753527808\">June 16, 2017</a></p></blockquote>\n<p></p>\n<p><a href=\"https://wptavern.com/wordcamp-europe-2017-kicks-off-with-contributor-day-focused-on-growing-wordpress-through-inclusion\" target=\"_blank\">Contributor Day</a> kicked off the event on Thursday with a strong turnout of 473 attendees. Traditionally, WordCamp contributor days are held on Sunday after the main event, the day following the after party when many who signed up struggle to make it on time &#8211; or at all. WordCamp Europe attendees generally appreciated having the contributor day scheduled before the main conference and the higher attendance numbers demonstrate the success of this arrangement.</p>\n<p>The after party featured a 1930&#8217;s theme at the Pavillon d’Armenonville. Attendees dressed the part and enjoyed a relaxing end to the WordCamp with an evening of dancing and meeting new and old friends.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Maybe the coolest guys at <a href=\"https://twitter.com/hashtag/WCEU?src=hash\">#WCEU</a> After-Party! ❤️<img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f44c.png\" alt=\"👌\" class=\"wp-smiley\" /><a href=\"https://twitter.com/schlessera\">@schlessera</a> <a href=\"https://twitter.com/glueckpress\">@glueckpress</a> <a href=\"https://t.co/p0xDyjyD9N\">pic.twitter.com/p0xDyjyD9N</a></p>\n<p>&mdash; Carole Olinger 🤘 (@CaroleOlinger) <a href=\"https://twitter.com/CaroleOlinger/status/876180870763294721\">June 17, 2017</a></p></blockquote>\n<p></p>\n<p>Organizers anticipate that videos of the presentations will be available next week. We will also be rolling out video interviews with interesting people from the European and global WordPress community in the coming days.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 18 Jun 2017 13:45:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: 10 Lessons Learned From Five Years of Selling WordPress Products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72103\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/10-lessons-learned-from-five-years-of-selling-wordpress-products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7934:\"<p><img />This post was contributed by <a href=\"https://www.rebeccagill.com/\">Rebecca Gill</a>. Rebecca is the founder of <a href=\"https://www.web-savvy-marketing.com/\">Web Savvy Marketing</a>, a web development, design, maintenance, and SEO consulting company based in Michigan and host of the <a href=\"https://www.seobits.fm/\">SEO Bits podcast</a>.</p>\n<p>Rebecca recently <a href=\"https://wptavern.com/9seeds-acquires-web-savvy-marketings-genesis-theme-store\">sold her Genesis Theme store to 9seeds</a>, a store she managed and maintained for five years. In this post, she shares ten lessons learned from selling WordPress products.</p>\n<hr />\n<p>When <a href=\"https://wanderingjon.com/\">Jon Brown</a> and I started talking about Web Savvy Marketing selling its theme store to 9seeds, it became abundantly clear that I wasn’t just selling him a portfolio of Genesis child themes. Anybody can do that. What I was really selling him was an established process and five long years of making mistakes and creating solutions.</p>\n<p>When I launched our theme store and stepped into the world of developing WordPress products, I was beyond naïve. I had no idea what I was getting myself into and I didn’t know how to run a successful e-commerce business.</p>\n<p>But after a lot of mistakes and course corrections, I found stability, a lot of great customers, and more revenue than I expected.</p>\n<p>Today, I&#8217;m sharing my top 10 lessons learned with you, so I can spare you from falling down the same rabbit holes and pitfalls.</p>\n<h2>My 10 Lessons Learned</h2>\n<h3>Reputation Is Everything</h3>\n<p>I didn’t set up out to create a strong reputation and I honestly didn’t know I was doing it. I was just following the rules given to me by my Grandmother and the basics of business I learned while working for my prior employers.</p>\n<p>What I realized was this – having a strong reputation helps you sell, but it also helps keep you out of hot water when things don’t go as you plan. People are more willing to buy from you, become your brand advocates, and forgive you when you make a mistake.</p>\n<h3>A Strong FAQ Page Is Worth Its Weight in Gold</h3>\n<p>I didn’t see this as a necessary page at first, but once I had the same question asked 100 times, I realized I needed to have an easily accessible page that answered common questions. Our comprehensive FAQ page has saved me time, but it also aided in sales. Visitors receive immediate answers to their questions and they are more inclined to hit the buy button while you still have their attention and interest.</p>\n<h3>Thorough Post-sale Communication Is a Requirement</h3>\n<p>During the first year of our store opening, I was flooded with post-sale emails and inquiries. No one was using our support forum and the option of self-service. I was so annoyed and frustrated it wasn’t even funny. And then something happened.</p>\n<p>I realized it wasn’t the buyers’ fault. I realized it was my fault. I had failed to communicate, provide next steps, and set expectations. Once I took ownership over this issue, I created a follow-up sequence that provided post-purchase instructions on where to go and what to do.</p>\n<p>A magical thing happened – or many things actually. I freed up my time because people stopped emailing me and I had happy customers who actually thanked me for all the great follow-up information. That was a win/win if there ever was one.</p>\n<h3>Email Templates Save Oodles of Time</h3>\n<p>Even with my stellar FAQ page and follow-up emails, I still received inquiries from people who asked similar questions. I learned to create email templates for anything I had to answer more than five times. This reduced my response time from five minutes to thirty seconds. This freed up my time and more importantly, it gave faster responses to my customers, so they were happy.</p>\n<h3>Create Systems to Save Sanity</h3>\n<p>I’m slightly <span class=\"st\">obsessive-compulsive</span> and I used this to our advantage with the theme store. I created project templates for any new theme launch and I mimicked the same type of tight structure I have with large custom website builds.</p>\n<p>We had a template full of to-do items, ownership of tasks, and expected turn around times. This made the design, coding, and launch of a theme very systematic. This in turn translated to faster product launches, fewer mistakes, and a reduction in development costs.</p>\n<h3>Strong SEO Is Your Friend</h3>\n<p>I could not have been successful without search engine optimization. I let SEO lead the way for what we would sell, who we would sell it to, and how we would market the final product. Strong SEO helped me select the right themes to develop, get quick sales, and cover my development costs within a few months of each launch.</p>\n<h3>Social Media Is a Time Suck but Worth Every Minute Invested</h3>\n<p>I have a love/hate relationship with social media. I hate that it takes so much time and it can be so emotionally draining. At the same time, I love that it helps you reach customers around the world and it supports the SEO process. Social media was a life raft in many ways and I don’t think the store or sales would have grown without it.</p>\n<h3>If Things Can Go Wrong, They Will Go Wrong</h3>\n<p>I have felt like this has been the norm for us this last year. Hosting, plugins, payment gateways, and third-party software sites have worn me out. And I’ve had a team to fix everything. You have to expect things to fail and you must have a plan to fix them quickly. It’s the nature of life and business. Learn to deal with issues quickly and to address one thing at a time.</p>\n<h3>Grace Goes a Long Way in Diffusing Bad Situations</h3>\n<p>No matter how hard you try and how hard you work, your customers will have bad days. When that happens you might receive the brunt of their emotions. This is called &#8216;transference&#8217; and in most cases it has nothing to do with you or your product.</p>\n<p>You have to recognize this for what it is and handle it with grace. Close your email, walk away from your desk, or do whatever you have to do to not reply in anger. Instead, you need to let the moment pass so you can reply calmly and with grace. In each situation where I&#8217;ve used this tactic, I’ve had the crazy person reply with an apology, tell me they were having a really bad day, and then thank me for keeping my calm.</p>\n<h3>People Will Steal Your Products, So Try Not to Take It Personally</h3>\n<p>People will steal your work and your products. You’ll find your premium digital products sitting for download on forums and it will break your heart. Don’t let it. Address the situation and move on. Don’t let someone else’s bad juju ruin your mood, day, or momentum. It won’t help the situation and it will drive you crazy if you let it.</p>\n<h2>In Hindsight</h2>\n<p>I loved launching and owning our theme store. I didn’t sell it because I hated it or because it wasn’t profitable. I sold it because it was no longer the best fit for our company and me personally, which meant it wasn’t going to service our customers as it should.</p>\n<p>If I had the opportunity to do things over, I would still launch and I’d follow the same path I did over the last five years.</p>\n<p>The theme store brought me some wonderful employees, great online friends, and it brought me deeper into the WordPress community.</p>\n<p>Selling the store was a hard decision, but the right one. In my heart, I knew I wanted to focus the company more on custom development and I wanted to spend more time with my SEO courses and my <a href=\"https://www.seobits.fm/\">new podcast</a>.</p>\n<p>If you’re new to WordPress products and you’re considering launching a new product offering, I encourage you to jump in. Learn from my mistakes, but hold on, because you’re in for a wild ride.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Jun 2017 22:36:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Matt: 4.8 and What’s Coming\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=47440\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://ma.tt/2017/06/4-8-and-whats-coming/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3844:\"<p>Last week <a href=\"https://wordpress.org/news/2017/06/evans/\">we released version 4.8 &#8220;Evans&#8221; of WordPress</a>, as I write this it has had about <a href=\"https://wordpress.org/download/counter/\">4.8 million downloads</a> already. The release was stable and has been received well, and we were able do the merge and beta <a href=\"https://make.wordpress.org/core/4-8/\">a bit faster</a> than we have before.</p>\n<p>When I <a href=\"https://make.wordpress.org/core/2017/01/04/focus-tech-and-design-leads/\">originally wrote about the three focuses for the year</a> (and in <a href=\"https://ma.tt/2016/12/state-of-the-word-2016/\">the State of the Word</a>) I said releases would be driven by improvements in those three areas, and people in particular are anticipating the new Gutenberg editor, so I wanted to talk a bit about what&#8217;s changed and what I&#8217;ve learned in the past few months that caused us to course correct and do an intermediate 4.8 release, and why there will likely be a 4.9 before Gutenberg comes in.</p>\n<p>Right now the vast majority of effort is <a href=\"https://github.com/WordPress/gutenberg\">going into the new editing experience</a>, and the progress has been great, but because we&#8217;re going to use the new editor as the basis for our new customization experience it means that the leads for the customization focus have to wait for Gutenberg to get a bit further along before we can build on that foundation. Mel and Weston took this as an opportunity to think about not just the &#8220;Customizer&#8221;, which is a screen and code base within WP, but really thinking in a user-centric way about what it means to customize a site and they identified a number of low-hanging fruits, areas like widgets where we could have a big user impact with relatively little effort.</p>\n<p>WordPress is littered with little inconsistencies and gaps in the user experience that aren&#8217;t hard to fix, but are hard to notice the 500th time you&#8217;re looking at a screen.</p>\n<p>I didn&#8217;t think we&#8217;d be able to sustain the effort on the editor and still do a meaningful user release in the meantime, but we did, and <a href=\"https://make.wordpress.org/core/2017/06/16/4-9-and-gutenberg/\">I think we can do it again</a>.</p>\n<p>4.8 also brought in a number of developer and accessibility improvements, including <a href=\"https://make.wordpress.org/core/2017/04/23/target-browser-coverage/\">dropping support for old IE versions</a>, but as I mentioned (too harshly) in my <a href=\"https://make.wordpress.org/core/2017/04/13/first-quarter-check-in/\">first quarter check-in</a> there hasn&#8217;t been as much happening on the REST API side of things, but after talking to some folks at WordCamp EU and the community summit before I&#8217;m optimistic about that improving. Something else I didn&#8217;t anticipate was <a href=\"https://make.wordpress.org/core/2016/12/28/supporting-the-future-of-wp-cli/\">wp-cli coming under the wing of WP.org as an official project</a>, which is huge for developers and people building on WP. (It&#8217;s worth mentioning <a href=\"https://github.com/wp-cli/restful\">wp-cli and REST API work great together</a>.)</p>\n<p>To summarize: The main focus of the editor is going great, customization has been getting improvements shipped to users, the wp-cli has become like the third focus, and I&#8217;m optimistic about REST-based development the remainder of the year.</p>\n<p>I&#8217;ll be <a href=\"https://2017.europe.wordcamp.org/session/interview-and-qa/\">on stage at WordCamp Europe in Paris tomorrow afternoon</a> doing a Q&amp;A with <a href=\"https://om.co/\">Om Malik</a> and taking audience questions, will also have a few announcements. You can get to the livestream tomorrow <a href=\"https://2017.europe.wordcamp.org/\">on the WordCamp EU homepage</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Jun 2017 13:33:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"WPTavern: WordCamp Europe 2017 Kicks Off with Contributor Day Focused on Growing WordPress through Inclusion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72072\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://wptavern.com/wordcamp-europe-2017-kicks-off-with-contributor-day-focused-on-growing-wordpress-through-inclusion\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7321:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/wordcamp-europe-venue.jpg?ssl=1\"><img /></a>photo credit: WP Tavern\n<p>Hundreds of WordPress contributors gathered today with space for each team to have its own dedicated room. The Community Summit was held earlier in the week, lending a strong contingent of veteran contributors to this event, ready to use the short time they had together.</p>\n<p>With a high concentration of WordPress expertise gathered in Paris, WCEU organizers were able to include 13 talks and workshops aimed at enriching contributors. For an event that has always focused on serving diverse communities, it&#8217;s no surprise that many of the contributor projects were focused on growing and improving WordPress through accessibility, internationalization, documentation, and inclusion.</p>\n<h3>WP REST API Team is Writing Docs to Make the API More Approachable to New Users and Contributors</h3>\n<p>WP REST API project co-lead Ryan McCue said their team was concentrated on improving documentation to give developers a better understanding of the REST API infrastructure and how it integrates with the rest of WordPress.</p>\n<p>&#8220;The main thing we&#8217;re trying to work on is documentation for this sort of stuff, because we&#8217;re lacking a lot of documentation around the infrastructure,&#8221; McCue said. &#8220;One of the things we don&#8217;t do well is having a way to go from &#8216;I know nothing&#8217; to &#8216;I know this stuff.&#8217; A lot our documentation describes solutions without describing the problem and how you pick a solution.&#8221; Contributors are working on a new set of user guides, which are currently on <a href=\"https://github.com/WP-API\" target=\"_blank\">GitHub</a>, that will eventually be included in the developer handbook.</p>\n<p>McCue said the next major project is completing work on <a href=\"https://github.com/WP-API/OAuth2\" target=\"_blank\">OAuth 2</a>, the new authentication method that will allow users to authorize applications to access data on their sites. He anticipates the team will have a &#8220;very workable plugin&#8221; that could be ready for testing within the next six months.</p>\n<p>&#8220;We need to get this sorted if any of the mobile apps are going to use the REST API,&#8221; McCue said. These apps currently use the existing XML-RPC and WordPress.com APIs. Although OAuth hasn&#8217;t been a major focus so far this year, McCue said the team is looking at changing that going forward.</p>\n<h3>Documentation Team is Working Towards Making HelpHub the Go-To Resource for WordPress Support</h3>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/06/wordcamp-europe-docs-team.png?ssl=1\"><img /></a>photo credit: WordCamp Europe 2017 Photography Team\n<p>Jon Ang, who helped lead the Documentation team, said they have been focused on writing documentation for new contributors, as well as ensuring current docs are gender neutral and not overly technical so that content writers can understand them.</p>\n<p>&#8220;Helping with the project has traditionally been tough, because we don&#8217;t explain how you can get started,&#8221; Ang said. &#8220;We realized this across the entire documentation team. We are great at writing end-user documentation but not great at writing contributor documentation.&#8221;</p>\n<p>One of the major documentation projects they have been working on for the past few years is <a href=\"https://make.wordpress.org/docs/tag/helphub/\" target=\"_blank\">HelpHub</a>, a companion resource to DevHub that will eventually hold all end-user documentation for WordPress. Migration from the codex is complete and the goal is to retire the codex once the project launches. Docs contributors are working towards making HelpHub the first place that users search for assistance before taking to the forums, lifting some of the burden from support volunteers. HelpHub is being designed to be easily searchable, possibly powered by elasticsearch, with inter-connected articles that focus on a single topic with bite-sized content.</p>\n<p>Ang estimates HelpHub is 30% complete in terms of content and 50% in terms of development. The backend is mostly finished and contributors are now working on the frontend. They are also bringing in content experts to write articles on critical topics, such as security. Ang hopes the team can deliver an MVP by the end of this year and finish the project within the next year.</p>\n<h3>Community Team is Working on Redesigning Central.WordCamp.org to be More Useful to the Wider WordPress Community</h3>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/06/wordcamp-europe-2017-community-team-contributors.png?ssl=1\"><img /></a>Community Team Contributors &#8211; photo credit: <a href=\"https://twitter.com/WCEurope/status/875328517000617984\">WordCamp Europe 2017 Photography Team</a>\n<p>A segment of Community Team contributors are working on marketing events better to the wider WordPress community that is not as well-connected with news about the project. As redesign of <a href=\"https://central.wordcamp.org/\" target=\"_blank\">central.wordcamp.org</a> is part of this effort.</p>\n<p>&#8220;Overall, the feeling is that we are not getting in front of the people who need our information the most,&#8221; Global Community Team member <a href=\"https://twitter.com/josephahaden\" target=\"_blank\">Josepha Hayden</a> said. &#8220;Most WordCamps are educational. There is an aspirational aspect to all of them, of course. But the people who could use the information the most are, for example, the people who inherited a WordPress site and don&#8217;t know what to do about that.&#8221;</p>\n<p>After reviewing Google Trends to see what people are actually looking for when they get to a WordCamp site, the Community Team found that most visitors are searching for a WordCamp and the year. The only reason they get to the site is because they already know the event is happening.</p>\n<p>&#8220;The deputies we&#8217;ve spoken to in the last year or so have been echoing this feedback that the problem our WordCamp organizers have is they don&#8217;t have any way to get the information out to attendees better,&#8221; Hayden said. &#8220;If you already know about WordCamps, it&#8217;s easy to find your local WordCamp but if you don&#8217;t, then it&#8217;s not.&#8221;</p>\n<p>The Community Team has begun working on a communication and marketing plan that may include things like automated emails or social media campaigns but their first priority is redesigning central.wordCamp.org.</p>\n<p>&#8220;We realized the first place we need to start is to have a canonical place for them to go,&#8221; Hayden said. &#8220;Central.WordCamp.org was always supposed to be that place but for awhile it had kind of a hybrid audience. We&#8217;re working on identifying the content, who the correct audience is, and what we&#8217;re missing if we want to help somebody who has never heard about any WordPress events.&#8221;</p>\n<p>The discussion around redesigning central.wordcamp.org discussion has been happening for a few years and the team already has a design that was donated. They have the homepage and several other pages complete and hope to have the new site launched by the end of the year.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Jun 2017 00:27:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: Lifted, a WordPress Theme and Plugin Shop for the Marijuana Industry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=72027\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/lifted-a-wordpress-theme-and-plugin-shop-for-the-marijuana-industry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4731:\"<p><a href=\"https://liftedthemes.com/\">Lifted</a> is a new WordPress theme and plugin company founded by <a href=\"http://baltimoredrew.com/\">Drew Poland</a> that caters to the marijuana industry. I reached out to Poland to learn more about his company, his pricing model, and get his perspective on this space in the WordPress ecosystem.</p>\n<p><strong>Why did you decide to get into the marijuana industry with WordPress plugins and themes?</strong></p>\n<p>Two primary reasons. The first is that, I truly believe in its medicinal use and there&#8217;s more than enough research out to support its effectiveness.</p>\n<p>Documentaries like <a href=\"http://www.cnn.com/specials/health/medical-marijuana/index.html\">Weed from CNN and Dr.Sanjay Gupta</a> will bring you to tears watching children like Charlotte Figi, who suffer from extreme epilepsy, almost instantly stop the seizures and become functional with the things most of us take for granted like talking and walking.</p>\n<p>It&#8217;s tough to watch at times but there are a lot of cases from the extreme ones like end of life and debilitating issues, to everyday pain, stress, and PTSD management that make it a valuable alternative to harder, more addictive prescription drugs like Opioids, that are most commonly thrown at these as a solution.</p>\n<p>The second reason is less inspiring. It&#8217;s simply a budding industry with massive room for growth. It&#8217;s really just now coming around and I think will accelerate as it matures and the path will become clearer in terms of what clients need and want. An entire new industry has opened.</p>\n<p><strong>What are some of the technologies used to power your themes?</strong></p>\n<p>Everything is built the WordPress way so everyday users can for the most part, activate a theme and go. For the most part, its page templates, widgets, and some custom fields. If a user is comfortable with those than they can easily use a theme from Lifted.</p>\n<p><strong>Are your themes and plugins GPL licensed or GPL compatible?</strong></p>\n<p>Absolutely! Everything is 100% GPL licensed.</p>\n<p><strong>How did you determine the price range for Grape Ape $129.99-$379.99 and can you provide an ETA on when it might be released? (I don&#8217;t think I&#8217;ve ever seen pre-orders for a theme before)</strong></p>\n<img />Front page of the Grape Ape Theme\n<p>I simply wanted to come in with a product priced on the higher end because I&#8217;m a firm believer that most WordPress products are priced entirely too low.</p>\n<p>I value my time on the highest level since I can&#8217;t make more of it, so a sell low and at volume approach just doesn&#8217;t work for me. I don&#8217;t want to support a $50 theme and the reality is that if this were a custom project for a client, the budget needs to be $10k minimum.</p>\n<p>The estimated release date for Grape Ape is the end of July.</p>\n<p>The pre-order was a result of simply wanting to force myself to get the actual Lifted Themes site up. Otherwise, I would have waited until Grape Ape was complete and then spent entirely too much time on the Lifted site.</p>\n<p>So I had to settle in with a good-looking theme I could live with and later work with my designer to develop something more custom. Had I really wanted to push the pre-order more I would have ramped up marketing months in advance to build up the anticipation and desire for it.</p>\n<p><strong>Based on your research, how crowded is this space when it comes to WordPress themes and plugins?</strong></p>\n<p>I would say it&#8217;s a clear lane and you can drive as fast or as slow as you like. I have been slow-moving up until this point and had the first marijuana plugin on WordPress.org, so there&#8217;s a lot of room.</p>\n<p>The marijuana industry is also not what I would call mature and at the end of the day there is still a stigma in professional settings. So if you are someone building products on the side or have a lot of clients in a specific industry that isn&#8217;t so receptive, you might not feel comfortable broadcasting that you are working in this space.</p>\n<p><strong>Are there any legalities customers should be aware of before using your products?</strong></p>\n<p>If used as intended, no. At its core, Grape Ape is fitted for your typical run of the mill business website, that&#8217;s no different from a coffee shop.</p>\n<p>At the moment, plugins are also in a clear zone. In the future, that may become more of a concern as services and tools are opening their APIs to connect dispensary back office systems with their web presence. That&#8217;s where things start to get tricky, more from a potential patient data view than anything else.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Jun 2017 21:14:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"WPTavern: 9seeds Acquires Web Savvy Marketing’s Genesis Theme Store\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71955\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wptavern.com/9seeds-acquires-web-savvy-marketings-genesis-theme-store\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3761:\"<p><a href=\"https://9seeds.com/\">9seeds</a>, a WordPress development agency <a href=\"https://9seeds.com/the-launch-of-9seeds/\">launched in 2009</a>, has <a href=\"https://9seeds.com/custom-wordpress-development-plugins-genesis-themes/\">acquired</a> Web Savvy Marketing&#8217;s <a href=\"https://www.web-savvy-marketing.com/store/\">theme store</a> for an undisclosed amount. <span class=\"st\">Web Savvy Marketing <a href=\"https://www.web-savvy-marketing.com/2012/03/genesis-child-theme-store/\">launched its theme store</a> in 2012 and currently has a library of 26 themes built on the <a href=\"https://my.studiopress.com/themes/genesis/\">Genesis Framework</a> by StudioPress. </span></p>\n<img />Web Savvy Marketing Theme Store\n<p><span class=\"st\">Chris Cree who helped launch and manage the theme store in 2012 departed from the company in 2016 and moved overseas to <a href=\"https://www.web-savvy-marketing.com/2016/07/saying-goodbye-to-chris-cree/\">create a bible school</a>. As the focus of Web Savvy Marketing shifted towards larger custom development projects and SEO, Rebbecca Gill, founder of Web Savvy Marketing, needed to find a way to <a href=\"https://www.web-savvy-marketing.com/2017/06/investment-strategy-wsm-selling-genesis-theme-store/\">maintain the theme store</a>. </span></p>\n<p>&#8220;I wanted Chris’ vision to live on and I wanted all my babies to continue to flourish and find their way to websites around the world,&#8221; Gill said. &#8220;I was at a crossroads and I didn’t know what to do.</p>\n<p>&#8220;I needed to make sure the company had a solid long-term strategy, but I also needed to protect our loyal theme customers. Five years of sales meant we had a lot of existing buyers who needed ongoing support.&#8221;</p>\n<p>Last year, Gill met Jon Brown, owner of 9seeds, and established a professional relationship.</p>\n<p>&#8220;We have very similar views on business, friendships, and ethics,&#8221; Gill said. &#8220;I liked him right away and I knew I wanted to spend more personal and professional time with him.</p>\n<p>&#8220;And as we grew closer, we started chatting about my struggles with the theme store and his long-term business goals. Before I knew it, he wanted to acquire the theme store and I wanted to give it to him.&#8221;</p>\n<p>9seeds has built a number of custom sites for clients using the Genesis Framework. For those who wanted to leverage existing themes, the company has often referred clients to Web Savvy Marketing&#8217;s theme store.</p>\n<p>&#8220;It took a bit more time of getting to know each other personally before I came to hold the same feelings that others had shared about her,&#8221; Brown said. &#8220;I felt deeply that this was a person I not only wanted to be friends with but wanted to be in business with. It became apparent to both of us that this was a perfect fit.&#8221;</p>\n<p>The acquisition brings the themes in-house and expands 9seeds reach into the WordPress products market.</p>\n<p>&#8220;It’s a win for 9seeds by giving us a springboard into a market we’ve long had our eye on accompanied by the best trail guide in the business showing us the path,&#8221; Brown said.</p>\n<p>&#8220;It’s a win for WSM by freeing Rebecca and her team up to align with where her focus now is on larger custom site builds and SEO consulting.&#8221;</p>\n<p>9seeds is providing support for existing customers and is working on a new theme. The support forums and theme store will migrate to the 9seeds domain later this year.</p>\n<p>To learn more about Brown and his work with 9seeds, <a href=\"https://wptavern.com/wpweekly-episode-276-interview-with-jon-brown-a-traveling-digital-nomad\">listen to episode 276</a> of WordPress Weekly.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Jun 2017 19:18:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"Post Status: An entrepreneurial journey around eCommerce, with Patrick Rauland — Draft Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=37565\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://poststatus.com/entrepreneurial-journey-around-ecommerce-patrick-rauland-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2488:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by the creator and editor of Post Status, Brian Krogsgard, and this week&#8217;s guest host, Patrick Rauland.</p>\n<p>In this episode, Brian and Patrick Rauland discuss the state of eCommerce today, both from a product perspective, and for store owners. They also discuss Patrick’s own journeys in the land of eCommerce, as a former product manager for WooCommerce, a course author for Lynda (now LinkedIn Learning), a consultant, and an online eCommerce conference organizer.</p>\n<p><!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->\n<a href=\"https://audio.simplecast.com/72909.mp3\">https://audio.simplecast.com/72909.mp3</a><br />\n<a href=\"https://audio.simplecast.com/72909.mp3\">Direct Download</a></p>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://www.speakinginbytes.com/\">Patrick&#8217;s programming blog</a></li>\n<li><a href=\"https://www.liftoffsummit.com/\">Lift Off Summit</a></li>\n<li><a href=\"https://neversettle.it/projects/apis/ns-fba-for-woocommerce-premium-wordpress-plugins/\">Amazon FBA for WooCommerce</a></li>\n<li><a href=\"http://www.shipstation.com/\">ShipStation</a></li>\n<li><a href=\"https://www.stitchlabs.com/\">Stitch Labs</a></li>\n<li><a href=\"http://www.tropicalmba.com/\">Tropical MBA</a></li>\n<li><a href=\"https://wooconf.com/\">WooConf</a></li>\n<li><a href=\"http://www.ecommercefuel.com/\">eCommerceFuel</a></li>\n<li><a href=\"https://poststatus.com/publish/\">Post Status Publish</a></li>\n</ul>\n<p><a href=\"https://www.flickr.com/photos/46544223@N05/26247563071/in/photostream/\">Photo Credit</a></p>\n<h3>Sponsor: Pagely</h3>\n<p><a href=\"https://pagely.com\"><span>Pagely</span></a><span> offers best in class managed WordPress hosting, powered by the Amazon Cloud, the Internet’s most reliable infrastructure. Post Status is proudly hosted by Pagely. Thank you to </span><a href=\"https://pagely.com\"><span>Pagely</span></a><span> for being a Post Status partner.</span></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Jun 2017 01:30:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: WPWeekly Episode 277 – WordPress 4.8, Filing Good Bug Reports, and WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=71968&preview=true&preview_id=71968\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://wptavern.com/wpweekly-episode-277-wordpress-4-8-filing-good-bug-reports-and-wp-super-cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3427:\"<p>In this episode, <a href=\"https://jjj.blog/\">John James Jacoby</a> and I start off the show by sending Jesse Peterson our thoughts, prayers, and positive energy. Peterson is a longtime member of the WordPress community, founder of<a href=\"https://www.genesisthe.me/\"> Genesis The.me</a>, and is battling <a href=\"http://www.cffatboy.com/what-is-cystic-fibrosis/\">Cystic Fibrosis</a>. He received the call last Friday to receive a double-lung transplant but the surgery was cancelled after doctors determined the lungs were bad after removing them from the patient. We&#8217;re hoping he gets the call again soon!</p>\n<p>We give insight into what&#8217;s new in WordPress 4.8, provide tips for filing a good bug report, and tell you what to expect in the next major version of WP Super Cache. We discuss Imagely acquiring TeslaThemes and near the end of the show, we talk about the WordPress Community Summit at WordCamp Europe.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/wordpress-4-8-evans-released-featuring-nearby-wordpress-events-new-media-widgets-and-link-boundaries\">WordPress 4.8 “Evans” Released Featuring Nearby WordPress Events, New Media Widgets, and Link Boundaries</a><br />\n<a href=\"https://wptavern.com/harare-zimbabwe-to-host-its-2nd-wordcamp-november-4-2017\">Harare, Zimbabwe to Host Its 2nd WordCamp November 4, 2017</a><br />\n<a href=\"https://wptavern.com/major-update-coming-to-wp-super-cache-new-rest-api-user-friendly-settings-page-and-improvements-to-legacy-file-storage\">Major Update Coming to WP Super Cache: New REST API, User-Friendly Settings Page, and Improvements to Legacy File Storage</a><br />\n<a href=\"https://wptavern.com/imagely-acquires-teslathemes-is-seeking-other-acquisition-opportunities\">Imagely Acquires TeslaThemes, Is Seeking Other Acquisition Opportunities</a></p>\n<h2>Picks of the Week:</h2>\n<p><a href=\"https://wptestdrive.com/\">wpTestDrive</a> allows you to try commercial themes and plugins before purchasing them. wpTestDrive creates a new WordPress instance with admin access where you can test plugins, themes, and their add-ons with or without demo content. It’s free, and test drives stay active for 10 days for registered members or 24 hours for guests. The site uses affiliate links to commercial products to offset the cost of running the site.</p>\n<p><a href=\"https://wordpress.org/plugins/camptix/\">CampTix</a> is a free, open source ticketing plugin for WordPress that powers the ticket purchasing experience on WordCamp.org. Some of its features include, multiple ticket and attendee forms, coupon codes, mass emailing of attendees, exporting data into CSV or XML, refunds, and more.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, June 21st 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #277:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Jun 2017 23:22:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"HeroPress: Trust Yourself\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1915\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://heropress.com/essays/trust-yourself/?utm_source=rss&utm_medium=rss&utm_campaign=trust-yourself\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8453:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/06/061417-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: Be open minded, trust yourself, and talk about what matters to you.\" /><p><em><strong>Editor&#8217;s Note:</strong> Birgit has been a friend of HeroPress since it&#8217;s very beginning. Through the oddities of life she was never able to do an essay. Recently she told me she would have one soon. This is not that essay. Our contributor this week needed some extra time and Birgit said she had something she wanted to write about, so here it is. Many thanks Birgit.</em></p>\n<p>Something is in the air. Do you feel the WordPress vibrations? It&#8217;s shortly before the fifth WordCamp Europe which will be held in Paris this year. The social channels like Twitter &amp; Co. are flooded with pre-event messages. You can feel the emotions of excitement and sadness in the timeline nearby. People share their excitement about their upcoming attendance and others who can&#8217;t make it. I am a person who belongs to both groups.</p>\n<p>But let me begin some months ago to tell you how this came to be. After WordCamp Europe in Vienna last summer I purchased my ticket for WCEU 2017 in Paris directly after the ticket sale was opened. There was no doubt at all I would participate.</p>\n<blockquote><p>How life&#8217;s play changes, it worked out differently than planned.</p></blockquote>\n<p>I&#8217;ve struggled with some health issues over several years. Mostly caused by stress during and after the divorce, as well as some deaths in the vicinity. Nothing really serious, but not ignorable. I thought&#8230; But at the end of the summer last year I got seriously ill. Not the right place for details here, but I had to quit my day job in a small agency because the fixed-term employment contract ended at the same time. Also, I had to reduce any contributions to the WordPress project. I had to reduce my freelancing contracts, too.</p>\n<p>I ran from one medical specialist to the other to find the cause of my illness. I was so frustrated not to be able to work like I&#8217;ve done before and so upset about the brain-fog and the fatigue. It was so depressing. As a mom of five children, it is not funny to be ill. The three youngest kids are living at home with me and my new partner. My oldest daughter bought her own house. But I couldn&#8217;t help her while moving. Can you imagine, how frustrating this could be?</p>\n<p>But hey &#8211; I am a fighter like a lioness. I put everything on the plate, invested my small savings into healing treatments and so on.</p>\n<blockquote><p>To make a long story short, I am getting healthier every day.</p></blockquote>\n<p>We found the cause and the healing treatments are helping like expected. Two operations went well. It is a process, but it&#8217;s going forward.</p>\n<p>Sitting at home without a job is not my thing, so I searched for a new day job. I found a part-time employment in my hometown as a head of a tutoring institute. It is ok, but nothing WordPress related. It secures my existence. But my saving balance allowed no budget for WordCamp travels. I gave up thoughts of attending WordCamp Europe in Paris this year.</p>\n<p>So I decided to offer my ticket.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">I’v to sell my <a href=\"https://twitter.com/hashtag/wceu?src=hash\">#wceu</a> ticket I bought last year. Unless it happens a miracle and there is a sponsor for stay &amp; travel <a href=\"https://twitter.com/WCEurope\">@WCEurope</a> <a href=\"https://t.co/PFWBTtSmlq\">pic.twitter.com/PFWBTtSmlq</a></p>\n<p>&mdash; Coach Birgit Olzem (@CoachBirgit) <a href=\"https://twitter.com/CoachBirgit/status/867323301399588864\">May 24, 2017</a></p></blockquote>\n<p></p>\n<p>The unexpected miracle happened. I found sponsors for travel &amp; stay without active seeking. My generous sponsors rewarded my past contributions to WordPress and Community over several years with this openhearted support. I am so grateful for this.</p>\n<p>Since 2012 I have been an active member of the WordPress Community. First as the main responsible person for the translations of WordPress into German, then as a part of the international Polyglots team. I am also editor and release manager for local German site and I am a member of some other contribution teams in the WordPress ecosystem. I spent a lot of spare time and money on contributions and WordCamp travels.</p>\n<blockquote><p>Perhaps you can imagine how frustrating it was, that I couldn&#8217;t afford to travel to WordCamp Europe.</p></blockquote>\n<p>An event where I can meet a lot of friends I made over the last years. Even more, I was happy to get the generous sponsoring. I am so grateful!</p>\n<p>In the last two years I had to reduce my contribution time and disappeared from the scene, but I followed the changes and enhancements within the community in the background. Nevertheless I wasn&#8217;t forgotten.</p>\n<p>And it&#8217;s not only me who get help to attend to WCEU:</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Today is a completely different day. Largely thanks to <a href=\"https://twitter.com/jdevalk\">@jdevalk</a> (and team <a href=\"https://twitter.com/yoast\">@yoast</a> ) I WILL be attending. Beyond grateful is what I am.</p>\n<p>&mdash; Remkus de Vries (@DeFries) <a href=\"https://twitter.com/DeFries/status/874595421112414208\">June 13, 2017</a></p></blockquote>\n<p></p>\n<p>Everyone has had some downs and some ups. If you ask, there is always someone who is willing to help you. It is an example of a mindset from an open-source community like the WordPress community and it reflects the philosophy. You can get everything, but you have to ask. Only speaking people can be helped.</p>\n<p>Apropos speaking people can get helped:</p>\n<p>I have a dream over some years to contribute to WordPress in full-time as a WordPress Community Manager. There are so many things I can do even if I am not a full-stack developer. Perhaps this miracle happens, too. But at this moment I am sitting on my suitcases to write about the generosity in the WordPress Community. This essay wasn&#8217;t planned, but it happened to have been written.</p>\n<p>I am so grateful for my heroes who made it happen, that I can go to the WordCamp Europe this year.</p>\n<p>There are so many unseen heroes outside who need to be seen.</p>\n<blockquote><p>Be open minded, trust yourself and talk about what matters to you.</p></blockquote>\n<p>There is a light at the end of the tunnel. Be your own hero.</p>\n<p>Beyond everything else: Care about yourself!</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Trust Yourself\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Trust%20Yourself&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Ftrust-yourself%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Trust Yourself\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Ftrust-yourself%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Ftrust-yourself%2F&title=Trust+Yourself\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Trust Yourself\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/trust-yourself/&media=https://heropress.com/wp-content/uploads/2017/06/061417-150x150.jpg&description=Trust Yourself\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Trust Yourself\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/trust-yourself/\" title=\"Trust Yourself\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/trust-yourself/\">Trust Yourself</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Jun 2017 08:00:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Birgit Olzem\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: Imagely Acquires TeslaThemes, Is Seeking Other Acquisition Opportunities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71716\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/imagely-acquires-teslathemes-is-seeking-other-acquisition-opportunities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4432:\"<p>In an effort to diversify and expand into the commercial WordPress theme market, <a href=\"https://www.imagely.com\">Imagely</a>, maintainers of <a href=\"https://www.imagely.com/wordpress-gallery-plugin/\">NextGEN Gallery</a>, <a href=\"https://www.imagely.com/tesla-themes-acquisition/\">have acquired</a> <a href=\"http://teslathemes.com/\">TeslaThemes</a> for an undisclosed amount.</p>\n<p>TeslaThemes <a href=\"https://wptavern.com/interview-with-brand-new-theme-club-teslathemes\">launched in 2013</a> as a theme club and recently celebrated its <a href=\"http://teslathemes.com/blog/teslathemes-anniversary-giveaway-and-redesign-announcement/\">fourth anniversary</a>. The company has 68 themes in its library, including the TeslaThemes framework.</p>\n<p>Eric Danzer, Founder and CEO of Imagely, says no major changes will be happening with TeslaThemes and that their immediate focus will be to provide maintenance and support.</p>\n<p>&#8220;Beyond that, our goal is to do more of what Tesla has already been doing so well &#8211; creating beautiful new themes and continually enhancing the existing themes,&#8221; Danzer said.</p>\n<p>Imagely has been busy this year launching a <a href=\"https://www.imagely.com/websites/\">managed WordPress hosting service</a> for photographers, releasing <a href=\"https://www.imagely.com/wordpress-photography-themes/\">new photography themes</a>, and an <a href=\"https://www.imagely.com/wordpress-lightroom-plugin/\">Adobe Lightroom plugin</a> that allows users to manage NextGEN galleries from within Lightroom.</p>\n<p>Later this year, Imagely plans to release a new version of NextGEN gallery with a redesigned backend interface. The company is also working on a way to add automated print fulfillment to WordPress.</p>\n<p>&#8220;Automated print fulfillment allows photographers to sell prints from their websites, and have those prints automatically delivered via the print lab without any intervention on their part,&#8221; Danzer said.</p>\n<p>&#8220;This functionality drives many large companies in the photo industry &#8211; SmugMug, ShootProof, Pixieset, Zenfolio, Photoshelter, and others. But it&#8217;s not possible yet on WordPress.</p>\n<p>&#8220;Bringing a full print solution to WordPress has the potential to revolutionize the photo industry and make WordPress the default web solution for photographers that it should be.&#8221;</p>\n<p>Marcel Sobieski, co-founder of TeslaThemes, <a href=\"http://teslathemes.com/blog/acquisition/\">thanked customers</a> for their support and confirmed that they exited the company on June 9th.</p>\n<p>&#8220;We built a solid, trusted and valuable business, that is needed on the market and is appreciated both by industry colleagues and clients,&#8221; Sobieski said.</p>\n<p>This is the second exit in the last six months for Sobieski and his team. The sale of TeslaThemes will allow them to focus on a new venture called <a href=\"http://www.wpmatic.io/\">WPMatic.io</a>, a one-on-one WordPress support and development company.</p>\n<p>&#8220;The six years of experience that we have in WordPress is already helping a few hundred clients and tens of companies and agencies in need, right after purchasing a WP Theme from the market,&#8221; Sobieski said.</p>\n<p>&#8220;Soon we will start partnering with some of the best WP Theme Clubs to deliver a unique experience for their clients.&#8221;</p>\n<p>The acquisition of TeslaThemes represents Imagely&#8217;s first major move into the general WordPress products market. The company is also seeking acquisition opportunities for other WordPress plugin and theme companies.</p>\n<p>&#8220;In the coming years, we&#8217;ll be both building and be acquiring a range of other WordPress theme and plugin companies,&#8221; Danzer said.</p>\n<p>&#8220;I&#8217;ll even add a small call here: if you have a solid WordPress product, with a great brand and stable revenue over around $200,000, and you are looking to exit, feel free to reach out to me directly to chat.&#8221;</p>\n<p><strong>Correction: June 14th, 2017</strong> The article incorrectly identifies Imagely as the creators of NextGEN Gallery. Alex Rabe is the creator of NextGEN Gallery and he <a href=\"https://alexrabe.wordpress.com/nextgen-gallery/\">released it in 2007</a>. Photocrati <a href=\"https://www.imagely.com/photocrati-acquires-nextgen-gallery/\">acquired the plugin</a> in February, 2016.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Jun 2017 21:33:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"Akismet: Coming Soon to a Jetpack Near You\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.akismet.com/?p=1942\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://blog.akismet.com/2017/06/13/coming-soon-to-a-jetpack-near-you/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1007:\"<p>If you haven&#8217;t tried Jetpack yet &#8212; our sister plugin &#8212; there&#8217;s never been a better time to add it to your bucket list.</p>\n<p>In the coming weeks we&#8217;ll be announcing a really exciting new addition to Jetpack&#8217;s services and you can <a href=\"https://jetpack.com/know/\">sign up to get early access right here</a>.</p>\n<div id=\"v-Q1CJRnNs-1\" class=\"video-player\">\n</div><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/akismet.wordpress.com/1942/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/akismet.wordpress.com/1942/\" /></a> <img alt=\"\" border=\"0\" src=\"https://pixel.wp.com/b.gif?host=blog.akismet.com&blog=116920&post=1942&subd=akismet&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"https://blog.akismet.com/2017/06/13/coming-soon-to-a-jetpack-near-you/\"><img alt=\"Coming Soon to Jetpack\" src=\"https://videos.files.wordpress.com/Q1CJRnNs/jetpack_30secondsfinal_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Jun 2017 10:00:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Richard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WordCamp for Publishers Opens Up Ticket Sales, 50% Sold in the First Day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71732\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/wordcamp-for-publishers-opens-up-ticket-sales-50-sold-in-the-first-day\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2365:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/wordcamp-for-publishers-2017.png?ssl=1\"><img /></a></p>\n<p>WordCamp for Publishers, the first niche WordCamp to be focused around a specific industry, <a href=\"https://2017-denver.journalist.wordcamp.org/tickets/\" target=\"_blank\">opened up ticket sales</a> today. The event will take place in Denver, Colorado, August 17-19, and organizers have planned for just 230 attendees, due to venue constraints. In less than 24 hours since tickets went on sale, the event is already 50% sold out.</p>\n<p><a href=\"https://2017-denver.journalist.wordcamp.org/speakers/\" target=\"_blank\">Speakers</a> and workshop facilitators have already been selected and published to the event&#8217;s website, featuring publication directors, developers, product managers, and other industry experts.</p>\n<p>The tentative schedule for the WordCamp includes a mixture of presentations, hands-on workshops, and social events to encourage networking and collaboration among publishers.</p>\n<ul>\n<li><strong>Thursday, August 17:</strong> Presentations and workshops, followed by a brewery tour</li>\n<li><strong>Friday, August 18:</strong> Presentations and workshops, followed by an after party</li>\n<li><strong>Saturday, August 19:</strong> Publisher plugin contributor day, followed by a Rockies baseball game</li>\n</ul>\n<p>One of the goals for the event is to encourage those who are maintaining open source tools for publishers to work together towards ensuring a strong future for those projects. Contributing is an important part of the event, as many of the organizers have experience working at or with publishing organizations that heavily rely on open source tools.</p>\n<p>The <a href=\"http://www.denverpost.com/\" target=\"_blank\">Denver Post</a> has donated the venue for the event as an official sponsor and the official hotel is a five-minute walk from there. After purchasing a ticket online, attendees will receive an email with a link to make a reservation at the Sheraton Denver Downtown Hotel, which has a designated block of rooms for WordCampers.</p>\n<p>Organizers expect the event to sell out quickly, so if you&#8217;re thinking of attending, don&#8217;t wait to <a href=\"https://2017-denver.journalist.wordcamp.org/tickets/\" target=\"_blank\">buy your ticket</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Jun 2017 22:05:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Unsplash Updates its License, Raises GPL Compatibility Concerns\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71742\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wptavern.com/unsplash-updates-its-license-raises-gpl-compatibility-concerns\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6631:\"<p><a href=\"https://unsplash.com/\">Unsplash.com</a>, a site that provides high-resolution photos for free, updated its license and the change has people in the WordPress community concerned.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">So unsplash images are no longer public domain. No longer gpl compatible. What does it mean for <a href=\"https://twitter.com/hashtag/WordPressThemes?src=hash\">#WordPressThemes</a>  that uses these images?</p>\n<p>&mdash; Carolina Nymark (@carolinapoena) <a href=\"https://twitter.com/carolinapoena/status/872977081067548672\">June 9, 2017</a></p></blockquote>\n<p></p>\n<p>Prior to the change, Unsplash&#8217;s license stated the following:</p>\n<blockquote><p><span>All photos published on Unsplash are licensed under <a href=\"https://web.archive.org/web/20170530053437/http://creativecommons.org/publicdomain/zero/1.0/\">Creative Commons Zero</a> which means you can copy, modify, distribute and use the photos for free, including commercial purposes, without asking permission from or providing attribution to the photographer or Unsplash.</span></p></blockquote>\n<p>According to GNU.org, the CC0 or Creative Commons Zero license <a href=\"https://www.gnu.org/licenses/license-list.en.html\">is compatible</a> with the GPL.</p>\n<blockquote><p>CC0 is a public domain dedication from Creative Commons. A work released under CC0 is dedicated to the public domain to the fullest extent permitted by law. If that is not possible for any reason, CC0 also provides a lax, permissive license as a fallback. Both public domain works and the lax license provided by CC0 are compatible with the GNU GPL.</p>\n<p>If you want to release your work to the public domain, we recommend you use CC0.</p></blockquote>\n<p>Unsplash&#8217;s new license states (emphasis mine):</p>\n<blockquote><p>All photos published on Unsplash can be used for free. You can use them for commercial and noncommercial purposes. You do not need to ask permission from or provide credit to the photographer or Unsplash, although it is appreciated when possible.</p>\n<p>More precisely, Unsplash grants you a nonexclusive copyright license to download, copy, modify, distribute, perform, and use photos from Unsplash for free, including for commercial purposes, without permission from or attributing the photographer or Unsplash. <strong>This license does not include the right to compile photos from Unsplash to replicate a similar or competing service. </strong></p></blockquote>\n<p>The inability to compile photos from Unsplash to replicate a similar or competing service is a restriction on how the photos can be used, calling into question its compatibility with the GPL.</p>\n<p>Luke Chesser, co-founder of Unsplash, <a href=\"https://twitter.com/lukechesser/status/873146783945416704\">explained on</a> Twitter that individual photos have no restrictions.</p>\n<p>&#8220;The Unsplash license doesn&#8217;t violate GPL and can still be used in WordPress themes,&#8221; Chesser said. &#8220;There are no restrictions on the individual photos.</p>\n<p>&#8220;There is only a restriction on the collection of photos, which doesn&#8217;t even apply unless your intent is to create a similar service.&#8221;</p>\n<p>For example, it&#8217;s ok if someone creates a site that displays the best photos of bridges from Unsplash. But if the site makes those photos available for download, it would <a href=\"https://community.unsplash.com/help-section/do-i-have-to-give-credit-to-a-photographer-when-i-use-their-photo\">violate the license</a>.</p>\n<p>On its FAQ page, Unsplash <a href=\"https://community.unsplash.com/help-section/what-is-the-unsplash-license-and-where-can-i-find-it\">explains why</a> the restriction was put in place:</p>\n<blockquote><p>The fuel that drives Unsplash is the exceptional images that are generously contributed by people from all over the world. Without them, none of this would work. Unsplash would be nothing. We owe everyone who’s contributed a photo not only a thank you but support and empowerment for the gifts they’ve given us.</p>\n<p>Out of respect for our contributors and our ability to uphold our value of empowering creativity, we added this sentence to the Unsplash License.</p>\n<p>We don’t support the mass duplication of Unsplash photos with the purpose of replicating a similar or competing service because it leads to confusion which negatively impacts both the spirit of open creative use and the celebration of Unsplash contributors.</p></blockquote>\n<p>Mass compiling of photos from Unsplash to distribute on other sites has created legal issues in the past. &#8220;Sites that mass duplicate and compile Unsplash photos point support and legal issues back to Unsplash, while continuing to redistribute photos that may be removed on Unsplash,&#8221; the company said.</p>\n<p>The reasons cited by Unsplash for putting the restriction in place are some of the same reasons WordPress plugin developers <a href=\"https://wptavern.com/the-gpl-license-doesnt-provide-the-freedom-to-infringe-registered-trademarks\">register trademarks</a>. The GPL allows the following freedoms.</p>\n<ol start=\"0\">\n<li>The freedom to run the program, for any purpose.</li>\n<li>The freedom to study how the program works, and change it so it does your computing as you wish.</li>\n<li>The freedom to redistribute copies so you can help your neighbor.</li>\n<li>The freedom to distribute copies of your modified versions, giving the community a chance to benefit from your changes.</li>\n</ol>\n<p>Over the years, there have been many instances in the WordPress community where businesses have taken advantage of these freedoms merely to profit from the work of others.</p>\n<p>The reselling of commercial plugins causes confusion in the market and resellers typically point support and other inquiries back to the plugin&#8217;s developers.</p>\n<p>Trademarks give commercial plugin authors measures to protect their brand without violating the GPL. A good example is the <a href=\"http://www.gravityforms.com/trademark/\">GravityForms Trademark page</a> which clearly outlines how its brand can be used and displayed.</p>\n<p>For now, it appears that most people who use Unsplash will be unaffected by the licensing change. However, as long as there is one license that governs the use of images and it has at least one restriction, its compatibility with the GPL will remain in doubt.</p>\n<p><strong>Correction June 14th</strong> Luke Chesser, co-founder of Unsplash, did not say that individual photos are still CC0-licensed but rather, have no restrictions.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Jun 2017 21:27:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:131:\"WPTavern: Major Update Coming to WP Super Cache: New REST API, User-Friendly Settings Page, and Improvements to Legacy File Storage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71718\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"https://wptavern.com/major-update-coming-to-wp-super-cache-new-rest-api-user-friendly-settings-page-and-improvements-to-legacy-file-storage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2550:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2015/04/wp-super-cache.png?ssl=1\"><img /></a></p>\n<p><a href=\"https://wordpress.org/plugins/wp-super-cache/\" target=\"_blank\">WP Super Cache</a>, a WordPress caching plugin maintained by Donncha Ó Caoimh and Automattic, is looking for users to help test the plugin <a href=\"https://odd.blog/2017/06/07/take-a-sneak-peek-at-wp-super-cache/\" target=\"_blank\">ahead of the next major update</a>. Ó Caoimh said the upcoming release is in a &#8220;stable and usable&#8221; state, but with the unusually large number of bug fixes and new features, it could use some testing in different environments.</p>\n<p>WP Super Cache is set to introduce a REST API, which will be useful for situations where administrators are not using wp-admin to manage their sites. The plugin is also <a href=\"https://github.com/Automattic/wp-super-cache/pull/177\" target=\"_blank\">changing the location for storing legacy cache files</a> to the supercache directory.</p>\n<p>&#8220;This makes it easier to manage these files,&#8221; Ó Caoimh said. &#8220;The plugin doesn’t have to search through potentially hundreds of cache files for those that need to be deleted if a page updates or someone leaves a comment. Now all those files will be in the same directory structure the anonymous “supercache” files will be. I’m really excited about this feature as it makes caching for logged-in users/users who comment and caching of pages with parameters so much faster now.&#8221;</p>\n<p>Ó Caoimh is also updating the settings page to make it easier for new users to understand the options. Currently it asks the user to select from mod_rewrite, PHP, or Legacy page caching with little explanation for why a user might opt for a certain delivery method. The new settings page simplifies the language used to describe the caching types.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/06/wp-super-cache-new-settings.png?ssl=1\"><img /></a></p>\n<p>The upcoming release will also <a href=\"https://github.com/Automattic/wp-super-cache/pulls?q=is%3Apr+is%3Aclosed\" target=\"_blank\">fix nearly 100 bugs</a>. As WP Super Cache is one of the most popular WordPress caching solutions and is active on more than a million sites, any problems with a major release will have a far-reaching impact. The latest changes to the plugin are <a href=\"https://github.com/Automattic/wp-super-cache\" target=\"_blank\">available on GitHub</a> for anyone who wants to help test.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Jun 2017 20:04:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: Harare, Zimbabwe to Host Its 2nd WordCamp November 4, 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71314\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wptavern.com/harare-zimbabwe-to-host-its-2nd-wordcamp-november-4-2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3375:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/12/harare.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://www.lonelyplanet.com/zimbabwe/harare\">Lonely Planet</a>\n<p>Harare, Zimbabwe will be <a href=\"https://2017.harare.wordcamp.org/2017/01/18/welcome-to-wordcamp-harare/\" target=\"_blank\">hosting its second WordCamp</a> on November 4, 2017, at <a href=\"http://www.hellenicacademy.ac.zw/\" target=\"_blank\">Hellenic Academy</a>. The city was one of three selected to be part of the <a href=\"https://wptavern.com/wordcamp-incubator-program-to-launch-in-indonesia-zimbabwe-and-columbia\" target=\"_blank\">WordCamp Incubator Program</a> in 2016. Harare&#8217;s first WordCamp was successful in connecting the local WordPress community and inspiring local leaders to carry on with organizing future events.</p>\n<p>Last year the <a href=\"https://www.meetup.com/Harare-WordPress-Meetup/\" target=\"_blank\">Harare WordPress Meetup</a> had 82 members and the group has nearly doubled in size with 142 members today.  Members meet every month and communicate outside of meetings via an active WhatsApp group. The current venue they use was donated by <a href=\"http://motorepublik.co/\" target=\"_blank\">Moto Republik</a>, thanks to one of the members Munya Bloggo, who works there.</p>\n<p>&#8220;It was always the goal of the WordCamp Incubator program to organize an easily-reproducible event that we could organize independently in the years to come,&#8221; 2017 lead organizer <a href=\"https://franksweb.org/\" target=\"_blank\">Thabo Tswana</a> said. &#8220;We expected it of ourselves. Some attendees and organizers actually approached me about the next WordCamp during WordCamp Harare 2016.&#8221;</p>\n<p>Tswana said the turnout at last year&#8217;s event was larger than he expected, because very few attendees booked tickets online. The majority ended up buying tickets at the door on the day of the event, a fairly uncommon scenario for most WordCamps that makes it somewhat difficult to estimate total attendees.</p>\n<p>&#8220;One of the biggest impacts that WordCamp had was introducing us to the WordPress Community,&#8221; Tswana said. &#8220;There are so many WordPress users in Zimbabwe (bloggers, designers, developers) but hardly anyone knew about the WordPress Community or how to contribute to WordPress. We now have a growing meetup group and the local community is starting to become more aware of what WordPress has to offer.&#8221;</p>\n<p>The local community consists primarily of developers and advanced WordPress users and Tswana said he would like see more of them getting involved with contributing. As the majority of meetup members are new to the larger WordPress community, they are still learning about the many ways users can contribute back to the project.</p>\n<p>Two Harare WordPress Meetup members, Kudakwashe Zafevere and Rima Trew, arranged for Hellenic Academy to donate a venue for WordCamp Harare 2017. The facilities are well-suited to hosting a tech event with wifi available.</p>\n<p>&#8220;This year, some local companies and organizations expressed interest in helping us out,&#8221; Tswana said. &#8220;We definitely expect more attendees due to the buzz that was created by last year&#8217;s WordCamp. To sum it all up, more people and organizations are getting involved this year.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Jun 2017 02:33:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"WPTavern: WordPress 4.8 “Evans” Released Featuring Nearby WordPress Events, New Media Widgets, and Link Boundaries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71534\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://wptavern.com/wordpress-4-8-evans-released-featuring-nearby-wordpress-events-new-media-widgets-and-link-boundaries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7169:\"<p><a href=\"https://wordpress.org/news/2017/06/evans/\">WordPress 4.8 &#8220;Evans&#8221;</a> is available for download and is the first major release of the year under the <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\">new release cycle</a>. WordPress 4.8 is named after <a href=\"https://en.wikipedia.org/wiki/Bill_Evans\">William John &#8220;Bill&#8221; Evans</a>, an American jazz pianist.</p>\n<h2>New Image, Video, and Audio Widgets</h2>\n<p>WordPress 4.8 includes <a href=\"https://make.wordpress.org/core/2017/05/26/media-widgets-for-images-video-and-audio/\">three new widgets</a>. All three widgets make it easier to display images, video, or audio  without using HTML. The Text widget now has support for TinyMCE providing rich-text functionality. Similar to the post editor, users have a choice between using a Visual or Text editor with limited formatting options.</p>\n<img />Image, Video, and Enhanced Text Widget\n<p>Because the Text widget uses TinyMCE, it inherits its nuances when it comes to pasting and displaying code. In a <a href=\"https://make.wordpress.org/core/2017/05/23/addition-of-tinymce-to-the-text-widget/\">dev note</a> that explains how TinyMCE was added to the Text Widget, Weston Ruter offers the following notice.</p>\n<blockquote><p>When pasting HTML into the &#8216;Text&#8217; (HTML) tab of the Text widget, any extraneous line breaks should be removed or else unwanted paragraphs and line beaks may result. This is particularly important when you paste in <code>script</code> or <code>style</code> tags (as in the case of 3rd-party JavaScript embeds), since auto-inserted paragraphs will cause script errors; this will be fixed in <span class=\"p2_hovercardify\"><a href=\"https://core.trac.wordpress.org/ticket/2833\">#2833</a></span>.</p>\n<p>This behavior aligns with longstanding behavior in the post editor, so it is not new, although it does differ from how the Text widget has previously behaved. As noted above, for previously existing Text widgets that had the auto-add paragraphs&#8217; checkbox unchecked (and thus the <code>filter</code> instance prop set to <code>false</code>), the previous behavior of not doing <code>wpautop</code> will be maintained: only once the widgets are modified will any extraneous line breaks need to be removed.</p></blockquote>\n<h2>Link Boundaries</h2>\n<p>Adding and editing links in the visual editor is more intuitive thanks to link boundaries. Link boundaries provide a visual representation of where a link begins and ends. This helps prevent adding unnecessary text to the beginning or end of a link.</p>\n<p></p>\n<p></p>\n<h2>See Nearby WordPress Events in the Dashboard</h2>\n<p>One of the pillars of WordPress&#8217; ecosystem is its community of meetups and WordCamps. <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\">In 2016</a>, more than 62,566 people attended a local meetup in 58 countries. About a third of those were new members.</p>\n<p>WordPress 4.8 draws attention to these events by <a href=\"https://make.wordpress.org/community/2017/03/23/showing-upcoming-local-events-in-wp-admin/\">enhancing the News Dashboard widget</a>. The widget will try to automatically guess your location and display meetups and WordCamps that are nearby.</p>\n<img />News Widget Shows Upcoming Meetups and WordCamps\n<p>If the location is incorrect, clicking the Pencil button opens a box where you can type in your city. The bottom of the widget includes links to the <a href=\"https://make.wordpress.org/community/meetups-landing-page\">WordPress Meetup landing page</a>, <a href=\"https://central.wordcamp.org/schedule/\">WordCamp Central Schedule</a>, and the <a href=\"https://wordpress.org/news/\">WordPress.org news blog</a>.</p>\n<h2>Responsive Customizer Sidebar</h2>\n<p>In previous versions of WordPress, the Customizer Sidebar had a maximum width of 300 pixels. In WordPress 4.8, the <a href=\"https://wptavern.com/wordpress-4-8-increases-maximum-width-of-the-customizer-sidebar-to-600-pixels\">Customizer Sidebar is responsive</a> and its width will automatically increase based on the size of the screen up to a maximum of 600 pixels.</p>\n<img />Customizer Sidebar 345 Pixels Wide\n<h2>More Accessible Admin Pages</h2>\n<p>The headers on admin screens are now <a href=\"https://wptavern.com/wordpress-4-8-improves-accessibility-on-admin-screens\">separate elements</a> making it easier for assistive technologies to help people navigate pages.</p>\n<h2>Support Dropped for Internet Explorer Versions 8, 9, and 10</h2>\n<p>WordPress 4.8 <a href=\"https://make.wordpress.org/core/2017/04/23/target-browser-coverage/\">drops support</a> for Internet Explorer versions 8, 9, and 10 as these versions no longer receive security updates and are used by a small percentage of people. WordPress 4.8 will work in these browsers but some features related to TinyMCE will be limited. New features will no longer be tested against these older versions of IE.</p>\n<h2>Noteworthy Changes</h2>\n<ul>\n<li><a href=\"https://make.wordpress.org/core/2017/05/20/editor-api-changes-in-4-8/\">Changes to the Editor API</a></li>\n<li><a href=\"https://make.wordpress.org/core/2017/05/22/removal-of-core-embedding-support-for-wmv-and-wma-file-formats/\">Embeds of WMV and WMA files are no longer supported</a></li>\n<li><a href=\"https://make.wordpress.org/core/2017/05/22/multisite-focused-changes-in-4-8/\">New Capabilities and others enhancements for WordPress Multisite</a></li>\n<li><a href=\"https://make.wordpress.org/core/2017/05/26/tag-cloud-widget-changes-in-4-8/\">Accessibility improvements to the Tag Cloud widget</a></li>\n<li><a href=\"https://make.wordpress.org/core/2017/05/26/media-widgets-for-images-video-and-audio/\">The addition of a Media Widgets API</a></li>\n<li>TinyMCE was updated from version <strong>4.5.6</strong> to version <strong>4.6.2</strong></li>\n<li>Twemoji was updated from version <strong>2.2.2</strong> to version <strong>2.3.0</strong></li>\n<li>zxcvbn was updated from version <strong>1.0</strong> to version <strong>4.4.1</strong></li>\n</ul>\n<p>This release was led by <a href=\"https://matt.blog/\">Matt Mullenweg</a> and <a href=\"https://profiles.wordpress.org/jbpaul17\">Jeff Paul</a>. 346 people contributed to WordPress 4.8 and 106 of them were first time contributors.</p>\n<p>If you think you&#8217;ve discovered a bug in WordPress 4.8, read <a href=\"https://wordpress.org/support/topic/read-this-first-wordpress-4-8-master-list/\">this support thread</a> first to see if it&#8217;s a common issue that&#8217;s already been reported. If not, describe your issue in as much detail as possible and publish it to the <a href=\"https://wordpress.org/support/forum/how-to-and-troubleshooting/\">Troubleshooting section</a> on the support forums.</p>\n<p>As you upgrade your sites today, enjoy <a href=\"https://en.wikipedia.org/wiki/Time_Remembered_(album)\">Time Remembered</a> by Bill Evans, released in 1983.</p>\n<div class=\"embed-wrap\"></div>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Jun 2017 19:29:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: Worona Releases Free WordCamp Europe Paris Guide App\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71494\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/worona-releases-free-wordcamp-europe-paris-guide-app\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4240:\"<p><a href=\"https://www.worona.org/\" target=\"_blank\">Worona</a>, a Madrid-based WordPress startup that builds mobile apps for free, has created an app for WordCamp Europe attendees. The <a href=\"https://blog.worona.org/wceu-paris-guide/\" target=\"_blank\">WCEU Paris Guide app</a> includes location and transportation information, schedules for the event, suggestions on where to eat (restaurants, bistros, a selection of the best cheap eats), a list of top attractions and museums, and nightlife recommendations.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/06/wceu-paris-guide.png?ssl=1\"><img /></a></p>\n<p>Worona has released an <a href=\"https://play.google.com/store/apps/details?id=org.worona.paris.app\" target=\"_blank\">Android app</a> and an <a href=\"https://itunes.apple.com/WebObjects/MZStore.woa/wa/viewSoftware?id=1238819389&mt=8\" target=\"_blank\">iOS app</a> for attendees to download. Currently the app needs to be connected to the internet, but the company is working on supporting an offline mode in the next version, which is rolling out soon.</p>\n<p>&#8220;We used our online platform to turn a WordPress blog (<a href=\"https://paris.worona.org\" target=\"_blank\">paris.worona.org</a>) into a native app,&#8221; Reyes Martínez, Worona&#8217;s marketing and communications specialist, said. &#8220;We use React and fetch the content using the WP-API. The apps are created with <a href=\"https://cordova.apache.org/\" target=\"_blank\">Cordova</a>.&#8221;</p>\n<p>Worona is a relatively new WordPress startup in Europe, having released its first prototype in late 2014. The company offers its mobile app building platform to users for free via its <a href=\"https://wordpress.org/plugins/worona/\" target=\"_blank\">plugin on WordPress.org</a>. The platform turns WordPress sites into native mobile apps that users can publish to the app stores. Worona can also manage the process of publishing the app for a one-time 290€ fee.</p>\n<p>In 2016, Worona had more than 12,000 users from 150 different countries. After launching its new platform four months ago, more than 11,500 users have signed up.</p>\n<p>Martínez said that Worona differs from existing WordPress app builders in that it is free, user-friendly, completely open source, and extensible.</p>\n<p>&#8220;We studied the WordPress ecosystem and the mobile distribution trends during the last three years and realized that other existing solutions, such as AppPresser, are just focused on one or two mobile channels, but not in all of them,&#8221; Martínez said. &#8220;This can be a problem for publishers, as they have to configure the different channels (apps, web apps, AMP, Facebook Instant Articles) one by one and take care of being consistent with all of them. After launching our own beta in 2015 and testing similar solutions, we decided to develop an all-in-one platform with the vision of becoming the leading solution for mobile distribution.&#8221;</p>\n<p>Worona is also aiming to create an ecosystem of extensions and themes for the platform, allowing third-party developers to create new solutions.</p>\n<p>&#8220;The strategy of creating a marketplace of extensions has been successfully accomplished by the WordPress ecosystem before (but not by any of our direct competitors),&#8221; Martínez said. &#8220;WooCommerce, for example, gives you access to a variety of extensions aiming to solve any problems related to your e-commerce. Because it is open-source, these features can be created by any developer or user. The bigger the community, the higher the range of solutions.&#8221;</p>\n<p>Worona is currently a team of five, including two co-founders, a marketing specialist, and two full-stack developers. Most of the team will be at WordCamp Europe. They hope the <a href=\"https://blog.worona.org/wceu-paris-guide/\" target=\"_blank\">WCEU Paris Guide app</a> will be useful for attendees and also provide a good introduction to their product. If you have any feedback that would make the app more useful, make sure to <a href=\"https://blog.worona.org/wceu-paris-guide/\" target=\"_blank\">comment on the announcement</a> and Worona may be able to incorporate user suggestions before the event.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Jun 2017 17:32:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Dev Blog: WordPress 4.8 “Evans”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4770\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wordpress.org/news/2017/06/evans/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:40319:\"<h2>An Update with You in Mind</h2>\n<p><img class=\"aligncenter size-large wp-image-4816\" src=\"https://i0.wp.com/wordpress.org/news/files/2017/06/release-featured-image.png?resize=632%2C316&ssl=1\" alt=\"\" /></p>\n<h3>Gear up for a more intuitive WordPress!</h3>\n<p>Version 4.8 of WordPress, named &#8220;Evans&#8221; in honor of jazz pianist and composer William John &#8220;Bill&#8221; Evans, is available for download or update in your WordPress dashboard. New features in 4.8 add more ways for you to express yourself and represent your brand.</p>\n<p>Though some updates seem minor, they’ve been built by hundreds of contributors with <em>you</em> in mind. Get ready for new features you’ll welcome like an old friend: link improvements, <em>three</em> new media widgets covering images, audio, and video, an updated text widget that supports visual editing, and an upgraded news section in your dashboard which brings in nearby and upcoming WordPress events.</p>\n<hr />\n<h2>Exciting Widget Updates</h2>\n<p><img class=\"size-large wp-image-4776 aligncenter\" src=\"https://i1.wp.com/wordpress.org/news/files/2017/06/widgets-with-all-four.png?resize=632%2C436&ssl=1\" alt=\"\" /></p>\n<h3>Image Widget</h3>\n<p>Adding an image to a widget is now a simple task that is achievable for any WordPress user without needing to know code. Simply insert your image right within the widget settings. Try adding something like a headshot or a photo of your latest weekend adventure — and see it appear automatically.</p>\n<h3>Video Widget</h3>\n<p>A welcome video is a great way to humanize the branding of your website. You can now add any video from the Media Library to a sidebar on your site with the new Video widget. Use this to showcase a welcome video to introduce visitors to your site or promote your latest and greatest content.</p>\n<h3>Audio Widget</h3>\n<p>Are you a podcaster, musician, or avid blogger? Adding a widget with your audio file has never been easier. Upload your audio file to the Media Library, go to the widget settings, select your file, and you’re ready for listeners. This would be a easy way to add a more personal welcome message, too!</p>\n<h3>Rich Text Widget</h3>\n<p>This feature deserves a parade down the center of town! Rich-text editing capabilities are now native for Text widgets. Add a widget anywhere and format away. Create lists, add emphasis, and quickly and easily insert links. Have fun with your newfound formatting powers, and watch what you can accomplish in a short amount of time.</p>\n<hr />\n<h2>Link Boundaries</h2>\n<div id=\"v-8BDWH3QG-1\" class=\"video-player\"><div><img alt=\"Link Boundaries\" src=\"https://videos.files.wordpress.com/8BDWH3QG/3-link-boundaries_dvd.original.jpg?resize=632%2C342\" /></div><p>Link Boundaries</p></div>\n<p>Have you ever tried updating a link, or the text around a link, and found you can&#8217;t seem to edit it correctly? When you edit the text after the link, your new text also ends up linked. Or you edit the text in the link, but your text ends up outside of it. This can be frustrating! With link boundaries, a great new feature, the process is streamlined and your links will work well. You’ll be happier. We promise.</p>\n<hr />\n<h2>Nearby WordPress Events</h2>\n<p><img class=\"aligncenter wp-image-4779 size-large\" src=\"https://i2.wp.com/wordpress.org/news/files/2017/06/events-widget.png?resize=632%2C465&ssl=1\" alt=\"\" /></p>\n<p>Did you know that WordPress has a thriving offline community with groups meeting regularly in more than 400 cities around the world? WordPress now draws your attention to the events that help you continue improving your WordPress skills, meet friends, and, of course, publish!</p>\n<p>This is quickly becoming one of our favorite features. While you are in the dashboard (because you’re running updates and writing posts, right?) all upcoming WordCamps and official WordPress Meetups — local to you — will be displayed.</p>\n<p>Being part of the community can help you improve your WordPress skills and network with people you wouldn&#8217;t otherwise meet. Now you can easily find your local events just by logging in to your dashboard and looking at the new Events and News dashboard widget.</p>\n<hr />\n<h2>Even More Developer Happiness <img src=\"https://s.w.org/images/core/emoji/2.3/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" /></h2>\n<h3><a href=\"https://make.wordpress.org/core/2017/05/17/cleaner-headings-in-the-admin-screens/\">More Accessible Admin Panel Headings</a></h3>\n<p>New CSS rules mean extraneous content (like “Add New” links) no longer need to be included in admin-area headings. These panel headings improve the experience for people using assistive technologies.</p>\n<h3><a href=\"https://make.wordpress.org/core/2017/05/22/removal-of-core-embedding-support-for-wmv-and-wma-file-formats/\">Removal of Core Support for WMV and WMA Files</a></h3>\n<p>As fewer and fewer browsers support Silverlight, file formats which require the presence of the Silverlight plugin are being removed from core support. Files will still display as a download link, but will no longer be embedded automatically.</p>\n<h3><a href=\"https://make.wordpress.org/core/2017/05/22/multisite-focused-changes-in-4-8/\">Multisite Updates</a></h3>\n<p>New capabilities have been introduced to 4.8 with an eye towards removing calls to<br />\n<code>is_super_admin()</code>. Additionally, new hooks and tweaks to more granularly control site and user counts per network have been added.</p>\n<h3><a href=\"https://make.wordpress.org/core/2017/05/23/addition-of-tinymce-to-the-text-widget/\">Text-Editor JavaScript API</a></h3>\n<p>With the addition of TinyMCE to the text widget in 4.8 comes a new JavaScript API for instantiating the editor after page load. This can be used to add an editor instance to any text area, and customize it with buttons and functions. Great for plugin authors!</p>\n<h3><a href=\"https://make.wordpress.org/core/2017/05/26/media-widgets-for-images-video-and-audio/\">Media Widgets API</a></h3>\n<p>The introduction of a new base media widget REST API schema to 4.8 opens up possibilities for even more media widgets (like galleries or playlists) in the future. The three new media widgets are powered by a shared base class that covers most of the interactions with the media modal. That class also makes it easier to create new media widgets and paves the way for more to come.</p>\n<h3><a href=\"https://make.wordpress.org/core/2017/05/16/customizer-sidebar-width-is-now-variable/\">Customizer Width Variable</a></h3>\n<p>Rejoice! New responsive breakpoints have been added to the customizer sidebar to make it wider on high-resolution screens. Customizer controls should use percentage-based widths instead of pixels.</p>\n<hr />\n<h2>The Squad</h2>\n<p>This release was led by <a href=\"https://matt.blog\">Matt</a> and <a href=\"https://profiles.wordpress.org/jbpaul17\">Jeff Paul</a>, with the help of the following fabulous folks. There are 346 contributors with props in this release, with 106 of them contributing for the first time. Pull up some Bill Evans on your music service of choice, and check out some of their profiles:</p>\n<a href=\"https://profiles.wordpress.org/wraithkenny\">[Inactive]</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abrightclearweb\">abrightclearweb</a>, <a href=\"https://profiles.wordpress.org/ibachal\">Achal Jain</a>, <a href=\"https://profiles.wordpress.org/achbed\">achbed</a>, <a href=\"https://profiles.wordpress.org/acmethemes\">Acme Themes</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/adammacias\">adammacias</a>, <a href=\"https://profiles.wordpress.org/mrahmadawais\">Ahmad Awais</a>, <a href=\"https://profiles.wordpress.org/ahmadawais\">ahmadawais</a>, <a href=\"https://profiles.wordpress.org/airesvsg\">airesvsg</a>, <a href=\"https://profiles.wordpress.org/ajoah\">ajoah</a>, <a href=\"https://profiles.wordpress.org/akibjorklund\">Aki Bj&#246;rklund</a>, <a href=\"https://profiles.wordpress.org/akshayvinchurkar\">akshayvinchurkar</a>, <a href=\"https://profiles.wordpress.org/schlessera\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"https://profiles.wordpress.org/xavortm\">Alex Dimitrov</a>, <a href=\"https://profiles.wordpress.org/ironpaperweight\">Alex Hon</a>, <a href=\"https://profiles.wordpress.org/alex27\">alex27</a>, <a href=\"https://profiles.wordpress.org/allancole\">allancole</a>, <a href=\"https://profiles.wordpress.org/arush\">Amanda Rush</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andrewp-2\">Andreas Panag</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rarst\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/andizer\">Andy Meerwaldt</a>, <a href=\"https://profiles.wordpress.org/kelderic\">Andy Mercer</a>, <a href=\"https://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"https://profiles.wordpress.org/aniketpant\">Aniket Pant</a>, <a href=\"https://profiles.wordpress.org/anilbasnet\">Anil Basnet</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta\">Ankit K Gupta</a>, <a href=\"https://profiles.wordpress.org/ahortin\">Anthony Hortin</a>, <a href=\"https://profiles.wordpress.org/antisilent\">antisilent</a>, <a href=\"https://profiles.wordpress.org/atimmer\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/zuige\">Antti Kuosmanen</a>, <a href=\"https://profiles.wordpress.org/apokalyptik\">apokalyptik</a>, <a href=\"https://profiles.wordpress.org/artoliukkonen\">artoliukkonen</a>, <a href=\"https://profiles.wordpress.org/ideag\">Arunas Liuiza</a>, <a href=\"https://profiles.wordpress.org/attitude\">attitude</a>, <a href=\"https://profiles.wordpress.org/backermann\">backermann</a>, <a href=\"https://profiles.wordpress.org/b-07\">Bappi</a>, <a href=\"https://profiles.wordpress.org/bcole808\">Ben Cole</a>, <a href=\"https://profiles.wordpress.org/quasel\">Bernhard Gronau</a>, <a href=\"https://profiles.wordpress.org/kau-boy\">Bernhard Kau</a>, <a href=\"https://profiles.wordpress.org/binarymoon\">binarymoon</a>, <a href=\"https://profiles.wordpress.org/birgire\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw\">BjornW</a>, <a href=\"https://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"https://profiles.wordpress.org/boblinthorst\">boblinthorst</a>, <a href=\"https://profiles.wordpress.org/boboudreau\">boboudreau</a>, <a href=\"https://profiles.wordpress.org/gitlost\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone B. Gorges</a>, <a href=\"https://profiles.wordpress.org/brainstormforce\">Brainstorm Force</a>, <a href=\"https://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brianhogg\">Brian Hogg</a>, <a href=\"https://profiles.wordpress.org/krogsgard\">Brian Krogsgard</a>, <a href=\"https://profiles.wordpress.org/bronsonquick\">Bronson Quick</a>, <a href=\"https://profiles.wordpress.org/sixhours\">Caroline Moore</a>, <a href=\"https://profiles.wordpress.org/caseypatrickdriscoll\">Casey Driscoll</a>, <a href=\"https://profiles.wordpress.org/caspie\">Caspie</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/chaos-engine\">Chaos Engine</a>, <a href=\"https://profiles.wordpress.org/cheeserolls\">cheeserolls</a>, <a href=\"https://profiles.wordpress.org/chesio\">chesio</a>, <a href=\"https://profiles.wordpress.org/ketuchetan\">chetansatasiya</a>, <a href=\"https://profiles.wordpress.org/choongsavvii\">choong</a>, <a href=\"https://profiles.wordpress.org/chouby\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chredd\">chredd</a>, <a href=\"https://profiles.wordpress.org/chrisjean\">Chris Jean</a>, <a href=\"https://profiles.wordpress.org/cmmarslender\">Chris Marslender</a>, <a href=\"https://profiles.wordpress.org/chris_d2d\">Chris Smith</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/chriswiegman\">Chris Wiegman</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">chriscct7</a>, <a href=\"https://profiles.wordpress.org/chriseverson\">chriseverson</a>, <a href=\"https://profiles.wordpress.org/christian1012\">Christian Chung</a>, <a href=\"https://profiles.wordpress.org/cwpnolen\">Christian Nolen</a>, <a href=\"https://profiles.wordpress.org/needle\">Christian Wach</a>, <a href=\"https://profiles.wordpress.org/christophherr\">Christoph Herr</a>, <a href=\"https://profiles.wordpress.org/clarionwpdeveloper\">Clarion Technologies</a>, <a href=\"https://profiles.wordpress.org/claudiosmweb\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiosanches\">Claudio Sanches</a>, <a href=\"https://profiles.wordpress.org/claudiolabarbera\">ClaudioLaBarbera</a>, <a href=\"https://profiles.wordpress.org/codemovementpk\">codemovement.pk</a>, <a href=\"https://profiles.wordpress.org/coderkevin\">coderkevin</a>, <a href=\"https://profiles.wordpress.org/codfish\">codfish</a>, <a href=\"https://profiles.wordpress.org/coreymcollins\">coreymcollins</a>, <a href=\"https://profiles.wordpress.org/curdin\">Curdin Krummenacher</a>, <a href=\"https://profiles.wordpress.org/cgrymala\">Curtiss Grymala</a>, <a href=\"https://profiles.wordpress.org/cdog\">Cătălin Dogaru</a>, <a href=\"https://profiles.wordpress.org/danhgilmore\">danhgilmore</a>, <a href=\"https://profiles.wordpress.org/danielkanchev\">Daniel Kanchev</a>, <a href=\"https://profiles.wordpress.org/danielpietrasik\">Daniel Pietrasik</a>, <a href=\"https://profiles.wordpress.org/mte90\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/dllh\">Daryl L. L. Houston (dllh)</a>, <a href=\"https://profiles.wordpress.org/davepullig\">Dave Pullig</a>, <a href=\"https://profiles.wordpress.org/goto10\">Dave Romsey (goto10)</a>, <a href=\"https://profiles.wordpress.org/davidakennedy\">David A. Kennedy</a>, <a href=\"https://profiles.wordpress.org/turtlepod\">David Chandra Purnama</a>, <a href=\"https://profiles.wordpress.org/dlh\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dglingren\">David Lingren</a>, <a href=\"https://profiles.wordpress.org/davidmosterd\">David Mosterd</a>, <a href=\"https://profiles.wordpress.org/dshanske\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/davidbhayes\">davidbhayes</a>, <a href=\"https://profiles.wordpress.org/folletto\">Davide \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/deeptiboddapati\">deeptiboddapati</a>, <a href=\"https://profiles.wordpress.org/delphinus\">delphinus</a>, <a href=\"https://profiles.wordpress.org/deltafactory\">deltafactory</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/valendesigns\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/pcfreak30\">Derrick Hammer</a>, <a href=\"https://profiles.wordpress.org/derrickkoo\">Derrick Koo</a>, <a href=\"https://profiles.wordpress.org/dimchik\">dimchik</a>, <a href=\"https://profiles.wordpress.org/dineshc\">Dinesh Chouhan</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dipeshkakadiya\">Dipesh Kakadiya</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">dmsnell</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/dotancohen\">Dotan Cohen</a>, <a href=\"https://profiles.wordpress.org/dougwollison\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/doughamlin\">doughamlin</a>, <a href=\"https://profiles.wordpress.org/dreamon11\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/drewapicture\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/duncanjbrown\">duncanjbrown</a>, <a href=\"https://profiles.wordpress.org/dungengronovius\">dungengronovius</a>, <a href=\"https://profiles.wordpress.org/dylanauty\">DylanAuty</a>, <a href=\"https://profiles.wordpress.org/hurtige\">Eddie Hurtig</a>, <a href=\"https://profiles.wordpress.org/oso96_2000\">Eduardo Reveles</a>, <a href=\"https://profiles.wordpress.org/chopinbach\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/electricfeet\">ElectricFeet</a>, <a href=\"https://profiles.wordpress.org/eliorivero\">Elio Rivero</a>, <a href=\"https://profiles.wordpress.org/iseulde\">Ella Iseulde Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/elyobo\">elyobo</a>, <a href=\"https://profiles.wordpress.org/enodekciw\">enodekciw</a>, <a href=\"https://profiles.wordpress.org/enshrined\">enshrined</a>, <a href=\"https://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"https://profiles.wordpress.org/pushred\">Eric Lanehart</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fencer04\">Fencer04</a>, <a href=\"https://profiles.wordpress.org/florianbrinkmann\">Florian Brinkmann</a>, <a href=\"https://profiles.wordpress.org/mista-flo\">Florian TIAR</a>, <a href=\"https://profiles.wordpress.org/foliovision\">FolioVision</a>, <a href=\"https://profiles.wordpress.org/fomenkoandrey\">fomenkoandrey</a>, <a href=\"https://profiles.wordpress.org/frankiet\">Francesco Taurino</a>, <a href=\"https://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"https://profiles.wordpress.org/fjarrett\">Frankie Jarrett</a>, <a href=\"https://profiles.wordpress.org/akeif\">Fred</a>, <a href=\"https://profiles.wordpress.org/frozzare\">Fredrik Forsmo</a>, <a href=\"https://profiles.wordpress.org/fuscata\">fuscata</a>, <a href=\"https://profiles.wordpress.org/gma992\">Gabriel Maldonado</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">Garth Mortensen</a>, <a href=\"https://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/geekysoft\">Geeky Software</a>, <a href=\"https://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"https://profiles.wordpress.org/goranseric\">Goran &#352;erić</a>, <a href=\"https://profiles.wordpress.org/grahamarmfield\">Graham Armfield</a>, <a href=\"https://profiles.wordpress.org/grantderepas\">Grant Derepas</a>, <a href=\"https://profiles.wordpress.org/tivnet\">Gregory Karpinsky (@tivnet)</a>, <a href=\"https://profiles.wordpress.org/hardeepasrani\">Hardeep Asrani</a>, <a href=\"https://profiles.wordpress.org/helen\">Helen Hou-Sandí</a>, <a href=\"https://profiles.wordpress.org/henrywright\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/hiddenpearls\">hiddenpearls</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/hristo-sg\">Hristo Pandjarov</a>, <a href=\"https://profiles.wordpress.org/hugobaeta\">Hugo Baeta</a>, <a href=\"https://profiles.wordpress.org/polevaultweb\">Iain Poulson</a>, <a href=\"https://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianedington\">Ian Edington</a>, <a href=\"https://profiles.wordpress.org/idealien\">idealien</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/imath\">imath</a>, <a href=\"https://profiles.wordpress.org/implenton\">implenton</a>, <a href=\"https://profiles.wordpress.org/ionutst\">Ionut Stanciu</a>, <a href=\"https://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"https://profiles.wordpress.org/ivdimova\">ivdimova</a>, <a href=\"https://profiles.wordpress.org/jdgrimes\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jakept\">Jacob Peattie</a>, <a href=\"https://profiles.wordpress.org/whyisjake\">Jake Spurlock</a>, <a href=\"https://profiles.wordpress.org/jnylen0\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jamesacero\">jamesacero</a>, <a href=\"https://profiles.wordpress.org/japh\">Japh</a>, <a href=\"https://profiles.wordpress.org/jaredcobb\">Jared Cobb</a>, <a href=\"https://profiles.wordpress.org/jayarjo\">jayarjo</a>, <a href=\"https://profiles.wordpress.org/jdolan\">jdolan</a>, <a href=\"https://profiles.wordpress.org/jdoubleu\">jdoubleu</a>, <a href=\"https://profiles.wordpress.org/jblz\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jbpaul17\">Jeff Paul</a>, <a href=\"https://profiles.wordpress.org/cheffheid\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/jimt\">jimt</a>, <a href=\"https://profiles.wordpress.org/jipmoors\">Jip Moors</a>, <a href=\"https://profiles.wordpress.org/jmusal\">jmusal</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joelcj91\">Joel James</a>, <a href=\"https://profiles.wordpress.org/joen\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/johanmynhardt\">johanmynhardt</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/zyphonic\">John Dittmar</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/johnpbloch\">John P. Bloch</a>, <a href=\"https://profiles.wordpress.org/johnpgreen\">johnpgreen</a>, <a href=\"https://profiles.wordpress.org/kenshino\">Jon (Kenshino)</a>, <a href=\"https://profiles.wordpress.org/jonathanbardo\">Jonathan Bardo</a>, <a href=\"https://profiles.wordpress.org/jbrinley\">Jonathan Brinley</a>, <a href=\"https://profiles.wordpress.org/daggerhart\">Jonathan Daggerhart</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonnyauk\">jonnyauk</a>, <a href=\"https://profiles.wordpress.org/jordesign\">jordesign</a>, <a href=\"https://profiles.wordpress.org/jorritschippers\">JorritSchippers</a>, <a href=\"https://profiles.wordpress.org/joefusco\">Joseph Fusco</a>, <a href=\"https://profiles.wordpress.org/jjeaton\">Josh Eaton</a>, <a href=\"https://profiles.wordpress.org/shelob9\">Josh Pollock</a>, <a href=\"https://profiles.wordpress.org/joshcummingsdesign\">joshcummingsdesign</a>, <a href=\"https://profiles.wordpress.org/joshkadis\">joshkadis</a>, <a href=\"https://profiles.wordpress.org/joyously\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"https://profiles.wordpress.org/jrgould\">JRGould</a>, <a href=\"https://profiles.wordpress.org/juanfra\">Juanfra Aldasoro</a>, <a href=\"https://profiles.wordpress.org/juhise\">Juhi Saxena</a>, <a href=\"https://profiles.wordpress.org/nukaga\">Junko Nukaga</a>, <a href=\"https://profiles.wordpress.org/justinbusa\">Justin Busa</a>, <a href=\"https://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"https://profiles.wordpress.org/jshreve\">Justin Shreve</a>, <a href=\"https://profiles.wordpress.org/jtsternberg\">Justin Sternberg</a>, <a href=\"https://profiles.wordpress.org/kadamwhite\">K.Adam White</a>, <a href=\"https://profiles.wordpress.org/kacperszurek\">kacperszurek</a>, <a href=\"https://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"https://profiles.wordpress.org/kalenjohnson\">KalenJohnson</a>, <a href=\"https://profiles.wordpress.org/codebykat\">Kat Hagan</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/keesiemeijer\">keesiemeijer</a>, <a href=\"https://profiles.wordpress.org/kellbot\">kellbot</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/khag7\">Kevin Hagerty</a>, <a href=\"https://profiles.wordpress.org/kwight\">Kirk Wight</a>, <a href=\"https://profiles.wordpress.org/kitchin\">kitchin</a>, <a href=\"https://profiles.wordpress.org/ixkaito\">Kite</a>, <a href=\"https://profiles.wordpress.org/kjbenk\">kjbenk</a>, <a href=\"https://profiles.wordpress.org/knutsp\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/koenschipper\">koenschipper</a>, <a href=\"https://profiles.wordpress.org/kokarn\">kokarn</a>, <a href=\"https://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/kouratoras\">Konstantinos Kouratoras</a>, <a href=\"https://profiles.wordpress.org/kuchenundkakao\">kuchenundkakao</a>, <a href=\"https://profiles.wordpress.org/kuldipem\">kuldipem</a>, <a href=\"https://profiles.wordpress.org/leewillis77\">Lee Willis</a>, <a href=\"https://profiles.wordpress.org/leobaiano\">Leo Baiano</a>, <a href=\"https://profiles.wordpress.org/littlebigthing\">LittleBigThings (Csaba)</a>, <a href=\"https://profiles.wordpress.org/lucasstark\">Lucas Stark</a>, <a href=\"https://profiles.wordpress.org/lukecavanagh\">Luke Cavanagh</a>, <a href=\"https://profiles.wordpress.org/lgedeon\">Luke Gedeon</a>, <a href=\"https://profiles.wordpress.org/lukepettway\">Luke Pettway</a>, <a href=\"https://profiles.wordpress.org/lyubomir_popov\">lyubomir_popov</a>, <a href=\"https://profiles.wordpress.org/mageshp\">mageshp</a>, <a href=\"https://profiles.wordpress.org/mahesh901122\">Mahesh Waghmare</a>, <a href=\"https://profiles.wordpress.org/mangeshp\">Mangesh Parte</a>, <a href=\"https://profiles.wordpress.org/manishsongirkar36\">Manish Songirkar</a>, <a href=\"https://profiles.wordpress.org/mantismamita\">mantismamita</a>, <a href=\"https://profiles.wordpress.org/mbootsman\">Marcel Bootsman</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mariovalney\">Mario Valney</a>, <a href=\"https://profiles.wordpress.org/clorith\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/mbelchev\">Mariyan Belchev</a>, <a href=\"https://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"https://profiles.wordpress.org/mrwweb\">Mark Root-Wiley</a>, <a href=\"https://profiles.wordpress.org/mapk\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"https://profiles.wordpress.org/markshep\">markshep</a>, <a href=\"https://profiles.wordpress.org/matveb\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/matrixik\">matrixik</a>, <a href=\"https://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"https://profiles.wordpress.org/jaworskimatt\">Matt Jaworski</a>, <a href=\"https://profiles.wordpress.org/mattking5000\">Matt King</a>, <a href=\"https://profiles.wordpress.org/veraxus\">Matt van Andel</a>, <a href=\"https://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"https://profiles.wordpress.org/mattheu\">Matthew Haines-Young</a>, <a href=\"https://profiles.wordpress.org/mattyrob\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/maxcutler\">Max Cutler</a>, <a href=\"https://profiles.wordpress.org/maximeculea\">Maxime Culea</a>, <a href=\"https://profiles.wordpress.org/mayukojpn\">Mayo Moriyama</a>, <a href=\"https://profiles.wordpress.org/mckernanin\">mckernanin</a>, <a href=\"https://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mhowell\">mhowell</a>, <a href=\"https://profiles.wordpress.org/michael-arestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michaelarestad\">Michael Arestad</a>, <a href=\"https://profiles.wordpress.org/michalzuber\">michalzuber</a>, <a href=\"https://profiles.wordpress.org/stubgo\">Miina Sikk</a>, <a href=\"https://profiles.wordpress.org/mauteri\">Mike Auteri</a>, <a href=\"https://profiles.wordpress.org/mihai2u\">Mike Crantea</a>, <a href=\"https://profiles.wordpress.org/mdgl\">Mike Glendinning</a>, <a href=\"https://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"https://profiles.wordpress.org/mikelittle\">Mike Little</a>, <a href=\"https://profiles.wordpress.org/mikeschroder\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeviele\">Mike Viele</a>, <a href=\"https://profiles.wordpress.org/dimadin\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/modemlooper\">modemlooper</a>, <a href=\"https://profiles.wordpress.org/batmoo\">Mohammad Jangda</a>, <a href=\"https://profiles.wordpress.org/deremohan\">Mohan Dere</a>, <a href=\"https://profiles.wordpress.org/monikarao\">monikarao</a>, <a href=\"https://profiles.wordpress.org/morettigeorgiev\">morettigeorgiev</a>, <a href=\"https://profiles.wordpress.org/morganestes\">Morgan Estes</a>, <a href=\"https://profiles.wordpress.org/mor10\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">moto hachi ( mt8.biz )</a>, <a href=\"https://profiles.wordpress.org/mrbobbybryant\">mrbobbybryant</a>, <a href=\"https://profiles.wordpress.org/nnaimov\">Naim Naimov</a>, <a href=\"https://profiles.wordpress.org/natereist\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/natewr\">NateWr</a>, <a href=\"https://profiles.wordpress.org/nathanrice\">nathanrice</a>, <a href=\"https://profiles.wordpress.org/nazgul\">Nazgul</a>, <a href=\"https://profiles.wordpress.org/greatislander\">Ned Zimmerman</a>, <a href=\"https://profiles.wordpress.org/krstarica\">net</a>, <a href=\"https://profiles.wordpress.org/nikeo\">Nicolas GUILLAUME</a>, <a href=\"https://profiles.wordpress.org/nikschavan\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nikv\">Nikhil Vimal</a>, <a href=\"https://profiles.wordpress.org/nbachiyski\">Nikolay Bachiyski</a>, <a href=\"https://profiles.wordpress.org/rabmalin\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/noplanman\">noplanman</a>, <a href=\"https://profiles.wordpress.org/nullvariable\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/odie2\">odie2</a>, <a href=\"https://profiles.wordpress.org/odysseygate\">odyssey</a>, <a href=\"https://profiles.wordpress.org/hideokamoto\">Okamoto Hidetaka</a>, <a href=\"https://profiles.wordpress.org/orvils\">orvils</a>, <a href=\"https://profiles.wordpress.org/oskosk\">oskosk</a>, <a href=\"https://profiles.wordpress.org/ottok\">Otto Kek&#228;l&#228;inen</a>, <a href=\"https://profiles.wordpress.org/ovann86\">ovann86</a>, <a href=\"https://profiles.wordpress.org/imnok\">Pantip Treerattanapitak (Nok)</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/patilvikasj\">patilvikasj</a>, <a href=\"https://profiles.wordpress.org/pbearne\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/paulwilde\">Paul Wilde</a>, <a href=\"https://profiles.wordpress.org/pdufour\">pdufour</a>, <a href=\"https://profiles.wordpress.org/piewp\">Perdaan</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/phh\">phh</a>, <a href=\"https://profiles.wordpress.org/php\">php</a>, <a href=\"https://profiles.wordpress.org/delawski\">Piotr Delawski</a>, <a href=\"https://profiles.wordpress.org/pippinsplugins\">pippinsplugins</a>, <a href=\"https://profiles.wordpress.org/pjgalbraith\">pjgalbraith</a>, <a href=\"https://profiles.wordpress.org/pkevan\">pkevan</a>, <a href=\"https://profiles.wordpress.org/pratikchaskar\">Pratik</a>, <a href=\"https://profiles.wordpress.org/pressionate\">Pressionate</a>, <a href=\"https://profiles.wordpress.org/presskopp\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/procodewp\">procodewp</a>, <a href=\"https://profiles.wordpress.org/rachelbaker\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rahulsprajapati\">Rahul Prajapati</a>, <a href=\"https://profiles.wordpress.org/superpoincare\">Ramanan</a>, <a href=\"https://profiles.wordpress.org/ramiabraham\">ramiabraham</a>, <a href=\"https://profiles.wordpress.org/ranh\">ranh</a>, <a href=\"https://profiles.wordpress.org/redsand\">Red Sand Media Group</a>, <a href=\"https://profiles.wordpress.org/youknowriad\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rianrietveld\">Rian Rietveld</a>, <a href=\"https://profiles.wordpress.org/iamfriendly\">Richard Tape</a>, <a href=\"https://profiles.wordpress.org/rpayne7264\">Robert D Payne</a>, <a href=\"https://profiles.wordpress.org/iamjolly\">Robert Jolly</a>, <a href=\"https://profiles.wordpress.org/rnoakes3rd\">Robert Noakes</a>, <a href=\"https://profiles.wordpress.org/d4z_c0nf\">Rocco Aliberti</a>, <a href=\"https://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"https://profiles.wordpress.org/rommelxcastro\">Rommel Castro</a>, <a href=\"https://profiles.wordpress.org/fronaldaraujo\">Ronald Ara&#250;jo</a>, <a href=\"https://profiles.wordpress.org/magicroundabout\">Ross Wintle</a>, <a href=\"https://profiles.wordpress.org/guavaworks\">Roy Sivan</a>, <a href=\"https://profiles.wordpress.org/ryankienstra\">Ryan Kienstra</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/ryanplas\">Ryan Plas</a>, <a href=\"https://profiles.wordpress.org/welcher\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/samikeijonen\">Sami Keijonen</a>, <a href=\"https://profiles.wordpress.org/solarissmoke\">Samir Shah</a>, <a href=\"https://profiles.wordpress.org/samuelsidler\">Samuel Sidler</a>, <a href=\"https://profiles.wordpress.org/sandesh055\">Sandesh</a>, <a href=\"https://profiles.wordpress.org/smyoon315\">Sang-Min Yoon</a>, <a href=\"https://profiles.wordpress.org/sanketparmar\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/pollyplummer\">Sarah Gooding</a>, <a href=\"https://profiles.wordpress.org/sayedwp\">Sayed Taqui</a>, <a href=\"https://profiles.wordpress.org/schrapel\">schrapel</a>, <a href=\"https://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scrappyhuborg\">scrappy@hub.org</a>, <a href=\"https://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"https://profiles.wordpress.org/seancjones\">seancjones</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sgr33n\">Sergio De Falco</a>, <a href=\"https://profiles.wordpress.org/sfpt\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shayanys\">shayanys</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/shprink\">shprink</a>, <a href=\"https://profiles.wordpress.org/simonlampen\">simonlampen</a>, <a href=\"https://profiles.wordpress.org/skippy\">skippy</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/snacking\">snacking</a>, <a href=\"https://profiles.wordpress.org/solal\">solal</a>, <a href=\"https://profiles.wordpress.org/soean\">Soren Wrede</a>, <a href=\"https://profiles.wordpress.org/sstoqnov\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/metodiew\">Stanko Metodiev</a>, <a href=\"https://profiles.wordpress.org/sharkomatic\">Steph</a>, <a href=\"https://profiles.wordpress.org/sswells\">Steph Wells</a>, <a href=\"https://profiles.wordpress.org/sillybean\">Stephanie Leary</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/stevenkword\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/stevenlinx\">stevenlinx</a>, <a href=\"https://profiles.wordpress.org/sudar\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/patilswapnilv\">Swapnil V. Patil</a>, <a href=\"https://profiles.wordpress.org/swapnild\">swapnild</a>, <a href=\"https://profiles.wordpress.org/szaqal21\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/takahashi_fumiki\">Takahashi Fumiki</a>, <a href=\"https://profiles.wordpress.org/miyauchi\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tapsboy\">tapsboy</a>, <a href=\"https://profiles.wordpress.org/tlovett1\">Taylor Lovett</a>, <a href=\"https://profiles.wordpress.org/team\">team</a>, <a href=\"https://profiles.wordpress.org/tg29359\">tg29359</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/the\">the</a>, <a href=\"https://profiles.wordpress.org/themeshaper\">themeshaper</a>, <a href=\"https://profiles.wordpress.org/thenbrent\">thenbrent</a>, <a href=\"https://profiles.wordpress.org/thomaswm\">thomaswm</a>, <a href=\"https://profiles.wordpress.org/tfrommen\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/tierra\">tierra</a>, <a href=\"https://profiles.wordpress.org/tnash\">Tim Nash</a>, <a href=\"https://profiles.wordpress.org/timmydcrawford\">Timmy Crawford</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timph\">timph</a>, <a href=\"https://profiles.wordpress.org/tkama\">Tkama</a>, <a href=\"https://profiles.wordpress.org/tnegri\">tnegri</a>, <a href=\"https://profiles.wordpress.org/tomauger\">Tom Auger</a>, <a href=\"https://profiles.wordpress.org/tjnowell\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tomdxw\">tomdxw</a>, <a href=\"https://profiles.wordpress.org/toro_unit\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/zodiac1978\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/transl8or\">transl8or</a>, <a href=\"https://profiles.wordpress.org/traversal\">traversal</a>, <a href=\"https://profiles.wordpress.org/wpsmith\">Travis Smith</a>, <a href=\"https://profiles.wordpress.org/nmt90\">Triet Minh</a>, <a href=\"https://profiles.wordpress.org/trishasalas\">Trisha Salas</a>, <a href=\"https://profiles.wordpress.org/tristangemus\">tristangemus</a>, <a href=\"https://profiles.wordpress.org/truongwp\">truongwp</a>, <a href=\"https://profiles.wordpress.org/tsl143\">tsl143</a>, <a href=\"https://profiles.wordpress.org/tywayne\">Ty Carlson</a>, <a href=\"https://profiles.wordpress.org/grapplerulrich\">Ulrich</a>, <a href=\"https://profiles.wordpress.org/utkarshpatel\">Utkarsh</a>, <a href=\"https://profiles.wordpress.org/valeriutihai\">Valeriu Tihai</a>, <a href=\"https://profiles.wordpress.org/vishalkakadiya\">Vishal Kakadiya</a>, <a href=\"https://profiles.wordpress.org/vortfu\">vortfu</a>, <a href=\"https://profiles.wordpress.org/vrundakansara-1\">Vrunda Kansara</a>, <a href=\"https://profiles.wordpress.org/webbgaraget\">webbgaraget</a>, <a href=\"https://profiles.wordpress.org/webmandesign\">WebMan Design &#124; Oliver Juhas</a>, <a href=\"https://profiles.wordpress.org/websupporter\">websupporter</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/earnjam\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton\">williampatton</a>, <a href=\"https://profiles.wordpress.org/wolly\">Wolly aka Paolo Valenti</a>, <a href=\"https://profiles.wordpress.org/yale01\">yale01</a>, <a href=\"https://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/yogasukma\">Yoga Sukma</a>, <a href=\"https://profiles.wordpress.org/oxymoron\">Zach Wills</a>, <a href=\"https://profiles.wordpress.org/tollmanz\">Zack Tollman</a>, <a href=\"https://profiles.wordpress.org/vanillalounge\">Ze Fontainhas</a>, <a href=\"https://profiles.wordpress.org/zhildzik\">zhildzik</a>, and <a href=\"https://profiles.wordpress.org/zsusag\">zsusag</a>.\n<p>&nbsp;</p>\n<p>Finally, thanks to all the community translators who worked on WordPress 4.8. Their efforts bring WordPress 4.8 fully translated to 38 languages at release time with more on the way.</p>\n<p>Do you want to report on WordPress 4.8? <a href=\"https://s.w.org/images/core/4.8/wp-4-8_press-kit.zip\">We&#8217;ve compiled a press kit</a> featuring information about the release features, and some media assets to help you along.</p>\n<p>If you want to follow along or help out, check out <a href=\"https://make.wordpress.org/\">Make WordPress</a> and our <a href=\"https://make.wordpress.org/core/\">core development blog</a>. Thanks for choosing WordPress — we hope you enjoy!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Jun 2017 14:49:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: Holler Box: A Smart Notification Plugin for WordPress Websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=71490\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://wptavern.com/holler-box-a-smart-notification-plugin-for-wordpress-websites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4373:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/06/holler-box.png?ssl=1\"><img /></a></p>\n<p>Scott Bolinger, co-founder of <a href=\"http://apppresser.com/\" target=\"_blank\">AppPresser</a>, has launched a new sales and conversion tool for WordPress websites called <a href=\"http://hollerwp.com/\" target=\"_blank\">Holler Box</a>. The plugin offers a lightweight, elegant popup message for capturing email addresses, displaying a (fake) live chat, or announcing a sale or event.</p>\n<p>Bolinger designed it to be non-intrusive &#8211; it&#8217;s not the kind of modal dialog that obscures content with an animated box in the middle of the page. Holler Box appears at the bottom right-hand of the page by default.</p>\n<p>After finding other WordPress popup plugins to be too complex for his needs, Bolinger decided to create his own solution for displaying a quick notification on his websites.</p>\n<p>&#8220;I’m a developer, and even adding a simple banner or popup to my site is not easy,&#8221; Bolinger said. I have to write the code, test locally, push to staging, test there, then push to production and do a final test. When I want to remove the message, I have to reverse the process. I’m busy, and that takes time.&#8221;</p>\n<p>Bolinger made it so that creating a new Holler Box is as easy as writing a new blog post. The content editing screen includes a meta box with options for customizing the display.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/06/holler-box-meta-box.png?ssl=1\"><img /></a></p>\n<p>The &#8220;Advanced Settings&#8221; meta box allows users to set pages where the notification should be displayed, limit to logged-in only or logged-out visitors, set the display for new or returning visitors, and customize the delay based on time or scrolling. It also gives options for when the Holler Box should disappear and how often it should be shown to each visitor.</p>\n<p>Holler Box is capable of a wide range of uses. A few examples include the following:</p>\n<ul>\n<li><strong>(Fake) Live Chat with Opt-in</strong>\n<p>Show a live chat box to collect customer questions and emails, without having to actually deal with the hassle of live chat. As soon as your visitor types a question, an email opt-in pops up so you can follow up with them at a convenient time.</li>\n<li><strong>Polls and Forms</strong>\n<p>Embed anything into your Holler Box, including a feedback form or poll.</li>\n<li><strong>Interactivity</strong>\n<p>Add a link, video, contact form, or simple opt-in form that integrates with major email providers like MailChimp and Convertkit.</li>\n</ul>\n<p>Below is an example of how the MailChimp email opt-in form works:</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/06/holler-box.gif?ssl=1\"><img /></a></p>\n<p>Holler Box also tracks impressions and conversions (link clicks and message opens) so that users can see how well their notifications are performing and optimize them as needed.</p>\n<p>The <a href=\"https://wordpress.org/plugins/holler-box/\" target=\"_blank\">free version on WordPress.org</a> has an impressive number of customization options, but Bolinger also plans to release a Pro version that will include additional features, such as an option for a header banner, more advanced display filters, automatic message deactivation, advanced email opt-in features, more conversion data, and support.</p>\n<p>&#8220;Holler Box aims to be more stylish and easier to use than existing options,&#8221; Bolinger said. &#8220;I use it when I need to make an announcement without spending a lot of time in a complex tool.&#8221; He said he could see the plugin working well side-by-side with well-established popup plugin competitors like OptinMonster.</p>\n<p>Bolinger said Holler Box is not affiliated with AppPresser, but he plans to use it as a sales tool on all of his sites. The plugin&#8217;s unique feature set is something he found missing in WordPress&#8217; marketplace for sales/conversion tools.</p>\n<p>&#8220;I think Holler Box will increase sales and conversions without being as disruptive as other popups,&#8221; Bolinger said. &#8220;The sale notification popup and faux live chat feature are really unique. It’s how I want to communicate with my audience &#8211; hopefully other people feel the same.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Jun 2017 01:37:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WPWeekly Episode 276 – Interview with Jon Brown, a Traveling Digital Nomad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=71482&preview=true&preview_id=71482\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/wpweekly-episode-276-interview-with-jon-brown-a-traveling-digital-nomad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2848:\"<p>In this episode, <a href=\"http://jjj.me/\">John James Jacoby</a> and I are joined by <a href=\"https://www.wanderingjon.com/\">Jon Brown</a>. Brown is a <a href=\"https://9seeds.com/author/jbrown/\">developer and author</a> for <a href=\"https://9seeds.com/\">9seeds</a>, a WordPress development agency. Brown describes what it&#8217;s like to work remotely and offers tips on how to stay productive while traveling. He tells us what items he can&#8217;t travel without. We also get his take on recent developments and debates going on in the WordPress community.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/open-sourcing-mental-illness-surpases-50k-fundraising-goal\">Open Sourcing Mental Illness Surpasses $50K Fundraising Goal</a><br />\n<a href=\"https://wptavern.com/vue-js-creator-evan-you-weighs-in-on-wordpress-javascript-framework-discussion\">Vue.js Creator Evan You Weighs in on WordPress JavaScript Framework Discussion</a><br />\n<a href=\"https://wptavern.com/wordcamp-europe-2017-livestream-tickets-now-available\">WordCamp Europe 2017 Livestream Tickets Now Available</a><br />\n<a href=\"https://wptavern.com/wpforms-acquires-wp-mail-smtp-plugin\">WPForms Acquires WP Mail SMTP Plugin</a><br />\n<a href=\"https://wptavern.com/versionpress-launches-versionpress-com-to-fund-open-source-project\">VersionPress Launches VersionPress.com to Fund Open Source Project</a></p>\n<h2>Picks of the Week:</h2>\n<p><a href=\"https://generatewp.com/\">GenerateWP</a> is a collection of tools that generates code for Shortcodes, Post Types, Meta Boxes, Taxonomies, Term Meta, and Post Statuses.</p>\n<p><a href=\"https://wordpress.org/plugins/holler-box/\">Holler Box</a> enables users to create customizable marketing messages to display to site visitors. Use Holler Box to convert website visitors, upsell customers, and get messages out to the right people at the right time.</p>\n<p><a href=\"https://wpperformanceprofiler.interconnectit.com/\">WP Performance Profiler</a> is a plugin by Interconnect.it that helps developers optimize the performance of WordPress sites running on PHP 5.3 to 5.6.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, June 14th 3:00 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\" rel=\"noopener\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #276:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Jun 2017 01:10:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"Post Status: Teaching what you learn with Joe Casabona — Draft Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=37463\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://poststatus.com/teaching-learn-joe-casabona-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1627:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by the creator and editor of Post Status, Brian Krogsgard, and this week&#8217;s guest host, Joe Casabona.</p>\n<p>Brian and Joe discuss the way they have learned WordPress over the years, and how they’ve gone about sharing and teaching what they’ve learned. They focus mostly on front-end parts of WordPress development.</p>\n<p><a href=\"https://audio.simplecast.com/72351.mp3\">https://audio.simplecast.com/72351.mp3</a><br />\n<a href=\"https://audio.simplecast.com/72351.mp3\">Direct Download</a></p>\n<h3>Links</h3>\n<ul>\n<li><a href=\"https://wpinonemonth.com/\">WP in one month</a></li>\n<li><a href=\"https://casabona.org/\">Casabona.org</a></li>\n<li><a href=\"http://howibuilt.it/\">How I Built It</a></li>\n<li><a href=\"http://wesbos.com/\">WesBos.com</a></li>\n</ul>\n<h3>Sponsor: Yoast</h3>\n<p>Yoast SEO Premium gives you 24/7 support from a great support team and extra features such as a redirect manager, recommended internal links, tutorial videos and integration with Google Webmaster Tools! Check out <a href=\"https://yoast.com/\">Yoast SEO Premium</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Jun 2017 17:33:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"Donncha: Take a sneak peek at WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://odd.blog/?p=89500269\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://odd.blog/2017/06/07/take-a-sneak-peek-at-wp-super-cache/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4302:\"<p>WP Super Cache is a full page caching plugin for WordPress that makes your site faster, and helps deal with unexpected surges in traffic.</p>\n<p>Over the last few months we&#8217;ve been busy <a href=\"https://github.com/Automattic/wp-super-cache/\">working on the plugin</a> to add new features and fix bugs and we can almost call it ready. It&#8217;s stable and usable and runs on this site but we would love more people to test it out before we release a new version.</p>\n<p>Here&#8217;s just some of the new features and bug fixes we&#8217;ve been working on:</p>\n<ul>\n<li> The plugin was based on WP-Cache which stored cache files in a single directory, and those (legacy caching) files were for the most part stored the same way all this time but now they&#8217;re being placed in the supercache directories (<a href=\"https://github.com/Automattic/wp-super-cache/pull/177\">#177</a>). This makes it easier to manage these files. The plugin doesn&#8217;t have to search through potentially hundreds of cache files for those that need to be deleted if a page updates or someone leaves a comment. Now all those files will be in the same directory structure the anonymous &#8220;supercache&#8221; files will be. I&#8217;m really excited about this feature as it makes caching for logged in users/users who comment and caching of pages with parameters so much faster now.</li>\n<li> We&#8217;re adding a <a href=\"https://developer.wordpress.org/rest-api/\">REST API</a> to the plugin because in the future not everyone is going to use wp-admin to take care of their sites. Take a look in the <a href=\"https://github.com/Automattic/wp-super-cache/tree/master/rest\">rest directory</a> for the code we&#8217;re working on.</li>\n<li> Debug logs now have a username and password to protect them from prying eyes.</li>\n<li> And many <a href=\"https://github.com/Automattic/wp-super-cache/pulls?q=is%3Apr+is%3Aclosed\">bugs fixed</a> over the last few months.</li>\n</ul>\n<p>Since &#8220;legacy caching&#8221; or &#8220;WP-Cache caching&#8221; is now more maintainable and faster we <a href=\"https://github.com/Automattic/wp-super-cache/issues/224\">want to change the language</a> describing how the plugin caches and delivers pages. </p>\n<p><a href=\"https://odd.blog/files/2017/06/Screen-Shot-2017-06-07-at-17.35.25.png\"><img /></a></p>\n<p>Currently the plugin asks you to choose between mod_rewrite, PHP and &#8220;Legacy page caching&#8221; which isn&#8217;t really useful. Most users won&#8217;t recognise those terms. It&#8217;s also not accurate as &#8220;legacy page caching&#8221; is active all the time as long as caching is enabled.<br />\nInstead we should have &#8220;Standard Caching&#8221; and &#8220;Super Caching&#8221;. Super Caching will then have simple and expert delivery methods.</p>\n<p>Simple delivery is through PHP, while expert delivery uses mod_rewrite rules which means the .htaccess file has to be updated and hopefully the warning below it will discourage casual users from testing it.</p>\n<p>Due to the huge number of changes in the plugin we really need people to give it a try and check if everything works ok. The <a href=\"https://github.com/Automattic/wp-super-cache/pull/255\">changes to the settings page</a> will hopefully make it easier for new users to get to grips with it too.</p>\n<p>You can find the newest code <a href=\"https://github.com/Automattic/wp-super-cache\">on Github</a>. The changes to the settings page are in <a href=\"https://github.com/Automattic/wp-super-cache/pull/255\">#255</a> if you want to comment on them. </p>\n<p>Thanks in advance! 🙂</p>\n\n<p><strong>Related Posts</strong><ul><li> <a href=\"https://odd.blog/2011/10/19/preload-categories-and-custom-post-content/\" rel=\"bookmark\" title=\"Permanent Link: Preload categories and custom post content\">Preload categories and custom post content</a></li><li> <a href=\"https://odd.blog/2008/10/24/wp-super-cache-084-the-garbage-collector/\" rel=\"bookmark\" title=\"Permanent Link: WP Super Cache 0.8.4, the garbage collector\">WP Super Cache 0.8.4, the garbage collector</a></li><li> <a href=\"https://odd.blog/2009/01/09/wp-super-cache-087/\" rel=\"bookmark\" title=\"Permanent Link: WP Super Cache 0.8.7\">WP Super Cache 0.8.7</a></li></ul></p>\n<p><a href=\"https://odd.blog/\" rel=\"external nofollow\">Source</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Jun 2017 17:24:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Donncha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 05 Jul 2017 12:10:45 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Wed, 05 Jul 2017 11:45:09 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130911010210\";}', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(2653, '_site_transient_timeout_browser_ba081c70c62b1a73f7586809b37ba98f', '1499861216', 'no'),
(2654, '_site_transient_browser_ba081c70c62b1a73f7586809b37ba98f', 'a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"59.0.3071.115\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}', 'no'),
(143, 'widget_widget-custom-posts', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(144, 'widget_widget-image-grid', 'a:2:{i:1;a:9:{s:5:\"title\";s:0:\"\";s:10:\"terms_type\";s:13:\"category_name\";s:9:\"post_sort\";s:4:\"date\";s:11:\"post_number\";s:1:\"4\";s:11:\"post_offset\";s:1:\"0\";s:12:\"title_length\";s:1:\"5\";s:14:\"columns_number\";s:1:\"4\";s:13:\"items_padding\";s:2:\"50\";s:13:\"category_name\";a:1:{i:0;s:17:\"shortcode-central\";}}s:12:\"_multiwidget\";i:1;}', 'yes'),
(145, 'widget_swanxy_widget_instagram', 'a:2:{i:1;a:5:{s:5:\"title\";s:9:\"Instagram\";s:3:\"tag\";s:14:\"tm_monstroid_2\";s:13:\"image_counter\";s:1:\"8\";s:15:\"display_caption\";a:1:{s:21:\"display_caption_check\";s:5:\"false\";}s:12:\"display_date\";a:1:{s:18:\"display_date_check\";s:5:\"false\";}}s:12:\"_multiwidget\";i:1;}', 'yes'),
(146, 'widget_swanxy_widget_smart_slider', 'a:2:{i:1;a:26:{s:5:\"title\";s:0:\"\";s:10:\"terms_type\";s:8:\"category\";s:14:\"posts_per_page\";s:1:\"5\";s:10:\"post_title\";s:5:\"false\";s:7:\"content\";s:5:\"false\";s:11:\"more_button\";s:5:\"false\";s:16:\"more_button_text\";s:9:\"Read more\";s:10:\"trim_words\";s:2:\"15\";s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:3:\"755\";s:11:\"orientation\";s:10:\"horizontal\";s:14:\"slide_distance\";s:1:\"0\";s:14:\"slide_duration\";s:3:\"500\";s:10:\"slide_fade\";s:5:\"false\";s:10:\"navigation\";s:4:\"true\";s:15:\"fade_navigation\";s:4:\"true\";s:10:\"pagination\";s:4:\"true\";s:8:\"autoplay\";s:4:\"true\";s:10:\"fullScreen\";s:5:\"false\";s:7:\"shuffle\";s:5:\"false\";s:4:\"loop\";s:4:\"true\";s:10:\"thumbnails\";s:5:\"false\";s:19:\"thumbnails_position\";s:6:\"bottom\";s:17:\"thumbnails_arrows\";s:5:\"false\";s:10:\"categories\";a:1:{i:0;s:5:\"theme\";}s:16:\"title_trim_words\";s:2:\"10\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(147, 'widget_swanxy_widget_subscribe_follow', 'a:4:{i:1;a:16:{s:16:\"enable_subscribe\";a:1:{s:16:\"enable_subscribe\";s:4:\"true\";}s:15:\"subscribe_title\";s:10:\"Newsletter\";s:17:\"subscribe_message\";s:145:\"Whether you are an industry pro, working on the side of a client or just need to get all the latest news in the industry - this newsletter helps.\";s:15:\"subscribe_input\";s:24:\"Enter please your e-mail\";s:16:\"subscribe_submit\";s:10:\"SUBSCRIBE!\";s:17:\"subscribe_success\";s:27:\"You successfully subscribed\";s:13:\"enable_follow\";a:1:{s:13:\"enable_follow\";s:4:\"true\";}s:12:\"follow_title\";s:9:\"Follow us\";s:14:\"follow_message\";s:0:\"\";s:17:\"enable_background\";a:1:{s:17:\"enable_background\";s:5:\"false\";}s:16:\"background_image\";s:0:\"\";s:23:\"invert_text_colorscheme\";a:1:{s:23:\"invert_text_colorscheme\";s:5:\"false\";}s:19:\"background_position\";s:6:\"center\";s:17:\"background_repeat\";s:9:\"no-repeat\";s:15:\"background_size\";s:5:\"cover\";s:16:\"background_color\";s:0:\"\";}i:2;a:16:{s:16:\"enable_subscribe\";a:1:{s:16:\"enable_subscribe\";s:4:\"true\";}s:15:\"subscribe_title\";s:18:\"Follow our updates\";s:17:\"subscribe_message\";s:145:\"Whether you are an industry pro, working on the side of a client or just need to get all the latest news in the industry - this newsletter helps.\";s:15:\"subscribe_input\";s:24:\"Enter please your e-mail\";s:16:\"subscribe_submit\";s:10:\"Subscribe!\";s:17:\"subscribe_success\";s:27:\"You successfully subscribed\";s:13:\"enable_follow\";a:1:{s:13:\"enable_follow\";s:5:\"false\";}s:12:\"follow_title\";s:6:\"Follow\";s:14:\"follow_message\";s:0:\"\";s:17:\"enable_background\";a:1:{s:17:\"enable_background\";s:5:\"false\";}s:16:\"background_image\";s:0:\"\";s:23:\"invert_text_colorscheme\";a:1:{s:23:\"invert_text_colorscheme\";s:4:\"true\";}s:19:\"background_position\";s:6:\"center\";s:17:\"background_repeat\";s:9:\"no-repeat\";s:15:\"background_size\";s:5:\"cover\";s:16:\"background_color\";s:7:\"#000000\";}i:3;a:16:{s:16:\"enable_subscribe\";a:1:{s:16:\"enable_subscribe\";s:4:\"true\";}s:15:\"subscribe_title\";s:0:\"\";s:17:\"subscribe_message\";s:0:\"\";s:15:\"subscribe_input\";s:24:\"Enter please your e-mail\";s:16:\"subscribe_submit\";s:10:\"Subscribe!\";s:17:\"subscribe_success\";s:27:\"You successfully subscribed\";s:13:\"enable_follow\";a:1:{s:13:\"enable_follow\";s:5:\"false\";}s:12:\"follow_title\";s:6:\"Follow\";s:14:\"follow_message\";s:0:\"\";s:17:\"enable_background\";a:1:{s:17:\"enable_background\";s:5:\"false\";}s:16:\"background_image\";s:0:\"\";s:23:\"invert_text_colorscheme\";a:1:{s:23:\"invert_text_colorscheme\";s:5:\"false\";}s:19:\"background_position\";s:6:\"center\";s:17:\"background_repeat\";s:9:\"no-repeat\";s:15:\"background_size\";s:5:\"cover\";s:16:\"background_color\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(148, 'widget_swanxy-widget-taxonomy-tiles', 'a:2:{i:1;a:8:{s:5:\"title\";s:0:\"\";s:10:\"terms_type\";s:8:\"category\";s:18:\"description_length\";s:1:\"0\";s:15:\"show_post_count\";a:1:{s:21:\"show_post_count_check\";s:4:\"true\";}s:11:\"layout_type\";s:5:\"tiles\";s:14:\"columns_number\";s:1:\"2\";s:13:\"items_padding\";s:2:\"50\";s:8:\"category\";a:5:{i:0;s:2:\"11\";i:1;s:2:\"12\";i:2;s:2:\"10\";i:3;s:2:\"13\";i:4;s:1:\"3\";}}s:12:\"_multiwidget\";i:1;}', 'yes'),
(149, 'widget_swanxy_widget_featured_posts_block', 'a:2:{i:1;a:6:{s:5:\"title\";s:0:\"\";s:6:\"layout\";s:8:\"layout-2\";s:9:\"posts_ids\";s:18:\"13,112,114,125,123\";s:10:\"checkboxes\";a:6:{s:5:\"title\";s:4:\"true\";s:7:\"excerpt\";s:5:\"false\";s:10:\"categories\";s:5:\"false\";s:4:\"tags\";s:5:\"false\";s:6:\"author\";s:4:\"true\";s:4:\"date\";s:4:\"true\";}s:12:\"title_length\";s:2:\"30\";s:14:\"excerpt_length\";s:2:\"15\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(150, 'widget_swanxy_widget_news_smart_box', 'a:2:{i:1;a:15:{s:5:\"title\";s:0:\"\";s:11:\"layout_type\";s:13:\"layout_type_2\";s:10:\"terms_type\";s:8:\"category\";s:16:\"current_category\";s:17:\"shortcode-central\";s:11:\"current_tag\";s:6:\"events\";s:14:\"posts_per_page\";s:1:\"6\";s:16:\"trim_title_chars\";s:2:\"25\";s:18:\"trim_content_words\";s:1:\"0\";s:24:\"current_title_visibility\";s:5:\"false\";s:15:\"date_visibility\";s:4:\"true\";s:17:\"author_visibility\";s:4:\"true\";s:18:\"comment_visibility\";s:5:\"false\";s:22:\"more_button_visibility\";s:5:\"false\";s:16:\"more_button_text\";s:9:\"Read more\";s:10:\"categories\";a:2:{i:0;s:17:\"shortcode-central\";i:1;s:5:\"theme\";}}s:12:\"_multiwidget\";i:1;}', 'yes'),
(151, 'widget_swanxy_widget_playlist_slider', 'a:2:{i:1;a:12:{s:5:\"title\";s:0:\"\";s:10:\"terms_type\";s:13:\"category_name\";s:14:\"posts_per_page\";s:1:\"0\";s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:3:\"500\";s:18:\"thumbnail_controls\";s:1:\"1\";s:15:\"slider_controls\";s:1:\"1\";s:12:\"title_length\";s:2:\"10\";s:18:\"thumb_title_length\";s:1:\"5\";s:9:\"mate_data\";a:5:{s:4:\"date\";s:4:\"true\";s:6:\"author\";s:4:\"true\";s:8:\"comments\";s:4:\"true\";s:8:\"category\";s:4:\"true\";s:8:\"post_tag\";s:4:\"true\";}s:15:\"thumb_mate_data\";a:3:{s:4:\"date\";s:4:\"true\";s:6:\"author\";s:4:\"true\";s:8:\"comments\";s:4:\"true\";}s:13:\"category_name\";a:3:{i:0;s:17:\"parallax-sections\";i:1;s:17:\"shortcode-central\";i:2;s:5:\"theme\";}}s:12:\"_multiwidget\";i:1;}', 'yes'),
(152, 'widget_swanxy_contact_information_widget', 'a:3:{i:1;a:2:{s:5:\"title\";s:8:\"Contacts\";s:19:\"contact_information\";a:5:{s:6:\"item-0\";a:2:{s:4:\"icon\";s:0:\"\";s:5:\"value\";s:64:\"<strong>Address:</strong> 4578 Marmora Road, Glasgow, \r\nD04 89GR\";}s:6:\"item-1\";a:2:{s:4:\"icon\";s:0:\"\";s:5:\"value\";s:95:\"<strong>Phones:</strong> <a href=\"tel:#\">(800) 123-0045</a>; <a href=\"tel:#\">(800) 123-0046</a>\";}s:6:\"item-4\";a:2:{s:4:\"icon\";s:0:\"\";s:5:\"value\";s:56:\"<strong>Fax:</strong> <a href=\"tel:#\">(800) 123-0045</a>\";}s:6:\"item-2\";a:2:{s:4:\"icon\";s:0:\"\";s:5:\"value\";s:65:\"<strong>E-mail:</strong> <a href=\"mailto:#\">info@demolink.org</a>\";}s:6:\"item-3\";a:2:{s:4:\"icon\";s:0:\"\";s:5:\"value\";s:47:\"<strong>We are open:</strong> Mn-Fr: 10 am-8 pm\";}}}i:2;a:2:{s:5:\"title\";s:19:\"Contact Information\";s:19:\"contact_information\";a:5:{s:6:\"item-0\";a:2:{s:4:\"icon\";s:0:\"\";s:5:\"value\";s:64:\"<strong>Address:</strong> 4578 Marmora Road, Glasgow, \r\nD04 89GR\";}s:6:\"item-1\";a:2:{s:4:\"icon\";s:0:\"\";s:5:\"value\";s:113:\"<strong>Phones:</strong> <a href=\"tel:8001230045\">(800) 123-0045</a>; <a href=\"tel:8001230046\">(800) 123-0046</a>\";}s:6:\"item-2\";a:2:{s:4:\"icon\";s:0:\"\";s:5:\"value\";s:56:\"<strong>Fax:</strong> <a href=\"tel:#\">(800) 123-0045</a>\";}s:6:\"item-3\";a:2:{s:4:\"icon\";s:0:\"\";s:5:\"value\";s:81:\"<strong>E-mail:</strong> <a href=\"mailto:info@demolink.org\">info@demolink.org</a>\";}s:6:\"item-4\";a:2:{s:4:\"icon\";s:0:\"\";s:5:\"value\";s:47:\"<strong>We are open:</strong> Mn-Fr: 10 am-8 pm\";}}}s:12:\"_multiwidget\";i:1;}', 'yes'),
(1782, 'tm_active_skin', 'a:2:{s:4:\"skin\";s:7:\"skin-16\";s:4:\"type\";s:4:\"full\";}', 'no'),
(167, 'cherry_projects_options', 'a:26:{s:14:\"listing-layout\";s:11:\"grid-layout\";s:12:\"loading-mode\";s:20:\"ajax-pagination-mode\";s:17:\"loading-animation\";s:25:\"loading-animation-move-up\";s:15:\"hover-animation\";s:12:\"simple-scale\";s:14:\"filter-visible\";s:4:\"true\";s:11:\"filter-type\";s:8:\"category\";s:13:\"category-list\";a:0:{}s:9:\"tags-list\";a:0:{}s:20:\"order-filter-visible\";s:5:\"false\";s:26:\"order-filter-default-value\";s:4:\"desc\";s:28:\"orderby-filter-default-value\";s:4:\"date\";s:12:\"posts-format\";s:15:\"post-format-all\";s:13:\"column-number\";s:1:\"3\";s:13:\"post-per-page\";s:1:\"9\";s:11:\"item-margin\";s:2:\"50\";s:22:\"justified-fixed-height\";s:3:\"300\";s:16:\"masonry-template\";s:27:\"masonry-default-skin16.tmpl\";s:13:\"grid-template\";s:24:\"grid-default-skin16.tmpl\";s:18:\"justified-template\";s:29:\"justified-default-skin16.tmpl\";s:23:\"cascading-grid-template\";s:34:\"cascading-grid-default-skin16.tmpl\";s:13:\"list-template\";s:24:\"list-default-skin16.tmpl\";s:22:\"standard-post-template\";s:34:\"standard-post-template-skin16.tmpl\";s:19:\"image-post-template\";s:31:\"image-post-template-skin16.tmpl\";s:21:\"gallery-post-template\";s:33:\"gallery-post-template-skin16.tmpl\";s:19:\"audio-post-template\";s:31:\"audio-post-template-skin16.tmpl\";s:19:\"video-post-template\";s:31:\"video-post-template-skin16.tmpl\";}', 'yes'),
(159, 'recently_activated', 'a:1:{s:47:\"rvg-optimize-database/rvg-optimize-database.php\";i:1499264126;}', 'yes'),
(1972, 'widget_akismet_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(2700, '_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a', '1499274764', 'no'),
(2701, '_site_transient_poptags_40cd750bba9870f18aada2478b24840a', 'O:8:\"stdClass\":100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4344;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2484;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2353;}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:2176;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:1821;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1586;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1564;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1430;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1345;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1332;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1325;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1268;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1261;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1110;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1051;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1040;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:989;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:934;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:816;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:795;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:794;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:768;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:762;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:667;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:658;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:657;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:650;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:645;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:636;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:632;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:615;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:596;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:593;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:582;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:582;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:572;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:571;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:560;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:553;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:537;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:535;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:532;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:519;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:507;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:500;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:493;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:489;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:477;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:468;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:468;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:465;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:463;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:441;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:436;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:435;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:435;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:433;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:421;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:420;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:410;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:406;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:402;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:399;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:399;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:397;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:394;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:378;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:377;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:370;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:369;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:350;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:341;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:332;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:331;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:330;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:326;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:325;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:322;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:320;}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";i:320;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:319;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:314;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:308;}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";i:297;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:297;}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";i:291;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:290;}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";i:288;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:288;}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";i:283;}s:6:\"author\";a:3:{s:4:\"name\";s:6:\"author\";s:4:\"slug\";s:6:\"author\";s:5:\"count\";i:282;}s:7:\"adsense\";a:3:{s:4:\"name\";s:7:\"adsense\";s:4:\"slug\";s:7:\"adsense\";s:5:\"count\";i:277;}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";i:277;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:276;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:273;}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";i:273;}s:14:\"administration\";a:3:{s:4:\"name\";s:14:\"administration\";s:4:\"slug\";s:14:\"administration\";s:5:\"count\";i:265;}s:7:\"captcha\";a:3:{s:4:\"name\";s:7:\"captcha\";s:4:\"slug\";s:7:\"captcha\";s:5:\"count\";i:264;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:263;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:263;}}', 'no'),
(1332, 'ewww_image_optimizer_background_optimization', '1', 'yes'),
(1333, 'wp_ewwwio_media_optimize_batch_a', '', 'no'),
(1412, 'ewww_image_optimizer_scanning_attachments', 'a:0:{}', 'no'),
(165, 'tm_dashboard_tracker_last_send', '1494424193', 'yes'),
(168, 'cherry_projects_options_default', 'a:26:{s:14:\"listing-layout\";s:11:\"grid-layout\";s:12:\"loading-mode\";s:20:\"ajax-pagination-mode\";s:17:\"loading-animation\";s:25:\"loading-animation-move-up\";s:15:\"hover-animation\";s:12:\"simple-scale\";s:14:\"filter-visible\";s:4:\"true\";s:11:\"filter-type\";s:8:\"category\";s:13:\"category-list\";a:0:{}s:9:\"tags-list\";a:0:{}s:20:\"order-filter-visible\";s:5:\"false\";s:26:\"order-filter-default-value\";s:4:\"desc\";s:28:\"orderby-filter-default-value\";s:4:\"date\";s:12:\"posts-format\";s:15:\"post-format-all\";s:13:\"column-number\";s:1:\"3\";s:13:\"post-per-page\";s:1:\"9\";s:11:\"item-margin\";s:2:\"50\";s:22:\"justified-fixed-height\";s:3:\"300\";s:16:\"masonry-template\";s:20:\"masonry-default.tmpl\";s:13:\"grid-template\";s:17:\"grid-default.tmpl\";s:18:\"justified-template\";s:22:\"justified-default.tmpl\";s:23:\"cascading-grid-template\";s:27:\"cascading-grid-default.tmpl\";s:13:\"list-template\";s:17:\"list-default.tmpl\";s:22:\"standard-post-template\";s:27:\"standard-post-template.tmpl\";s:19:\"image-post-template\";s:24:\"image-post-template.tmpl\";s:21:\"gallery-post-template\";s:26:\"gallery-post-template.tmpl\";s:19:\"audio-post-template\";s:24:\"audio-post-template.tmpl\";s:19:\"video-post-template\";s:24:\"video-post-template.tmpl\";}', 'yes'),
(170, 'cherry-team', 'a:8:{s:12:\"archive-page\";s:0:\"\";s:18:\"archive-page-shows\";s:5:\"posts\";s:14:\"posts-per-page\";i:9;s:15:\"archive-columns\";i:3;s:15:\"single-template\";s:6:\"single\";s:17:\"single-image-size\";s:9:\"thumbnail\";s:16:\"listing-template\";s:7:\"default\";s:18:\"listing-image-size\";s:9:\"thumbnail\";}', 'yes'),
(171, 'cherry-team_default', 'a:8:{s:12:\"archive-page\";s:0:\"\";s:18:\"archive-page-shows\";s:5:\"posts\";s:14:\"posts-per-page\";i:9;s:15:\"archive-columns\";i:3;s:15:\"single-template\";s:6:\"single\";s:17:\"single-image-size\";s:9:\"thumbnail\";s:16:\"listing-template\";s:7:\"default\";s:18:\"listing-image-size\";s:9:\"thumbnail\";}', 'yes'),
(251, 'widget_mprm_menu_item', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(252, 'widget_mprm_category', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(253, 'widget_mprm_cart_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(261, 'widget_mp-timetable', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(174, 'cherry-services', 'a:8:{s:12:\"archive-page\";s:1:\"0\";s:18:\"archive-page-shows\";s:5:\"posts\";s:14:\"posts-per-page\";s:1:\"9\";s:15:\"archive-columns\";s:1:\"3\";s:15:\"single-template\";s:6:\"single\";s:17:\"single-image-size\";s:14:\"swanxy-thumb-l\";s:16:\"listing-template\";s:7:\"default\";s:18:\"listing-image-size\";s:14:\"swanxy-thumb-m\";}', 'no'),
(175, 'cherry-services_default', 'a:8:{s:12:\"archive-page\";s:0:\"\";s:18:\"archive-page-shows\";s:5:\"posts\";s:14:\"posts-per-page\";i:9;s:15:\"archive-columns\";i:3;s:15:\"single-template\";s:6:\"single\";s:17:\"single-image-size\";s:9:\"thumbnail\";s:16:\"listing-template\";s:7:\"default\";s:18:\"listing-image-size\";s:9:\"thumbnail\";}', 'no'),
(181, 'tm_style_switcher_swanxy_defaults', 'a:2:{s:5:\"theme\";s:6:\"swanxy\";s:4:\"mods\";a:244:{i:0;b:0;s:12:\"show_tagline\";b:0;s:16:\"totop_visibility\";b:1;s:14:\"page_preloader\";b:1;s:16:\"header_logo_type\";s:5:\"image\";s:15:\"header_logo_url\";s:25:\"%s/assets/images/logo.png\";s:22:\"retina_header_logo_url\";N;s:23:\"header_logo_font_family\";s:22:\"Montserrat, sans-serif\";s:22:\"header_logo_font_style\";s:6:\"normal\";s:23:\"header_logo_font_weight\";s:3:\"900\";s:21:\"header_logo_font_size\";i:20;s:25:\"header_logo_character_set\";s:5:\"latin\";s:23:\"breadcrumbs_visibillity\";b:0;s:29:\"breadcrumbs_front_visibillity\";b:0;s:22:\"breadcrumbs_page_title\";b:1;s:21:\"breadcrumbs_path_type\";s:8:\"minified\";s:19:\"header_social_links\";b:0;s:19:\"footer_social_links\";b:1;s:23:\"blog_post_share_buttons\";b:0;s:25:\"single_post_share_buttons\";b:1;s:16:\"page_layout_type\";s:9:\"fullwidth\";s:15:\"container_width\";i:1404;s:13:\"sidebar_width\";s:3:\"1/4\";s:22:\"regular_accent_color_1\";s:7:\"#0bd9fe\";s:22:\"regular_accent_color_2\";s:7:\"#0bb8fd\";s:22:\"regular_accent_color_3\";s:7:\"#5a8eee\";s:18:\"regular_text_color\";s:7:\"#8b8d9e\";s:18:\"regular_link_color\";s:7:\"#0bd9fe\";s:24:\"regular_link_hover_color\";s:7:\"#1a1b29\";s:16:\"regular_h1_color\";s:7:\"#1a1b29\";s:16:\"regular_h2_color\";s:7:\"#1a1b29\";s:16:\"regular_h3_color\";s:7:\"#1a1b29\";s:16:\"regular_h4_color\";s:7:\"#1a1b29\";s:16:\"regular_h5_color\";s:7:\"#1a1b29\";s:16:\"regular_h6_color\";s:7:\"#0bd9fe\";s:21:\"invert_accent_color_1\";s:7:\"#ffffff\";s:21:\"invert_accent_color_2\";s:7:\"#1a1b29\";s:21:\"invert_accent_color_3\";s:7:\"#ffffff\";s:17:\"invert_text_color\";s:7:\"#8b8d9e\";s:17:\"invert_link_color\";s:7:\"#5a8eee\";s:23:\"invert_link_hover_color\";s:7:\"#0bd9fe\";s:15:\"invert_h1_color\";s:7:\"#ffffff\";s:15:\"invert_h2_color\";s:7:\"#ffffff\";s:15:\"invert_h3_color\";s:7:\"#ffffff\";s:15:\"invert_h4_color\";s:7:\"#ffffff\";s:15:\"invert_h5_color\";s:7:\"#ffffff\";s:15:\"invert_h6_color\";s:7:\"#ffffff\";s:16:\"body_font_family\";s:21:\"Open Sans, sans-serif\";s:15:\"body_font_style\";s:6:\"normal\";s:16:\"body_font_weight\";s:3:\"400\";s:14:\"body_font_size\";i:16;s:16:\"body_line_height\";d:1.6875;s:19:\"body_letter_spacing\";s:1:\"0\";s:18:\"body_character_set\";s:5:\"latin\";s:15:\"body_text_align\";s:4:\"left\";s:14:\"h1_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h1_font_style\";s:6:\"normal\";s:14:\"h1_font_weight\";s:3:\"900\";s:12:\"h1_font_size\";i:144;s:14:\"h1_line_height\";s:3:\"1.1\";s:17:\"h1_letter_spacing\";d:-0.02;s:16:\"h1_character_set\";s:5:\"latin\";s:13:\"h1_text_align\";s:7:\"inherit\";s:14:\"h2_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h2_font_style\";s:6:\"normal\";s:14:\"h2_font_weight\";s:3:\"900\";s:12:\"h2_font_size\";i:40;s:14:\"h2_line_height\";d:1.1000000000000001;s:17:\"h2_letter_spacing\";s:1:\"0\";s:16:\"h2_character_set\";s:5:\"latin\";s:13:\"h2_text_align\";s:7:\"inherit\";s:14:\"h3_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h3_font_style\";s:6:\"normal\";s:14:\"h3_font_weight\";s:3:\"300\";s:12:\"h3_font_size\";i:40;s:14:\"h3_line_height\";d:1.1000000000000001;s:17:\"h3_letter_spacing\";s:1:\"0\";s:16:\"h3_character_set\";s:5:\"latin\";s:13:\"h3_text_align\";s:7:\"inherit\";s:14:\"h4_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h4_font_style\";s:6:\"normal\";s:14:\"h4_font_weight\";s:3:\"800\";s:12:\"h4_font_size\";i:24;s:14:\"h4_line_height\";d:1.4199999999999999;s:17:\"h4_letter_spacing\";s:1:\"0\";s:16:\"h4_character_set\";s:5:\"latin\";s:13:\"h4_text_align\";s:7:\"inherit\";s:14:\"h5_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h5_font_style\";s:6:\"normal\";s:14:\"h5_font_weight\";s:3:\"500\";s:12:\"h5_font_size\";i:16;s:14:\"h5_line_height\";d:1.875;s:17:\"h5_letter_spacing\";d:0.02;s:16:\"h5_character_set\";s:5:\"latin\";s:13:\"h5_text_align\";s:7:\"inherit\";s:14:\"h6_font_family\";s:22:\"Montserrat, sans-serif\";s:13:\"h6_font_style\";s:6:\"normal\";s:14:\"h6_font_weight\";s:3:\"900\";s:12:\"h6_font_size\";i:14;s:14:\"h6_line_height\";d:1.9299999999999999;s:17:\"h6_letter_spacing\";d:0.80000000000000004;s:16:\"h6_character_set\";s:5:\"latin\";s:13:\"h6_text_align\";s:7:\"inherit\";s:23:\"breadcrumbs_font_family\";s:21:\"Open Sans, sans-serif\";s:22:\"breadcrumbs_font_style\";s:6:\"normal\";s:23:\"breadcrumbs_font_weight\";s:3:\"400\";s:21:\"breadcrumbs_font_size\";i:14;s:23:\"breadcrumbs_line_height\";s:3:\"1.5\";s:26:\"breadcrumbs_letter_spacing\";s:1:\"0\";s:25:\"breadcrumbs_character_set\";s:5:\"latin\";s:15:\"header_bg_color\";s:7:\"#0e0e16\";s:15:\"header_bg_image\";N;s:16:\"header_bg_repeat\";s:9:\"no-repeat\";s:20:\"header_bg_position_x\";s:6:\"center\";s:20:\"header_bg_attachment\";s:6:\"scroll\";s:18:\"header_layout_type\";s:7:\"style-3\";s:14:\"top_panel_text\";s:23:\"Premium WordPress Theme\";s:16:\"top_panel_search\";b:0;s:12:\"top_panel_bg\";s:7:\"#ffffff\";s:18:\"header_menu_sticky\";b:1;s:22:\"header_menu_attributes\";b:0;s:23:\"hidden_menu_items_title\";s:4:\"More\";s:16:\"sidebar_position\";s:9:\"fullwidth\";s:17:\"mailchimp_api_key\";s:37:\"0fabd7822dcc3cb8547dcf9109750d92-us10\";s:17:\"mailchimp_list_id\";s:10:\"2a6603b219\";s:10:\"ads_header\";s:0:\"\";s:20:\"ads_home_before_loop\";s:0:\"\";s:23:\"ads_post_before_content\";s:0:\"\";s:24:\"ads_post_before_comments\";s:0:\"\";s:15:\"footer_logo_url\";s:32:\"%s/assets/images/footer-logo.png\";s:16:\"footer_copyright\";s:32:\"%%site-name%% Theme © %%year%%.\";s:21:\"footer_widget_columns\";s:1:\"3\";s:18:\"footer_layout_type\";s:7:\"default\";s:17:\"footer_widgets_bg\";s:7:\"#171825\";s:9:\"footer_bg\";s:7:\"#0e0e16\";s:16:\"blog_layout_type\";s:7:\"default\";s:17:\"blog_sticky_label\";s:8:\"Featured\";s:18:\"blog_posts_content\";s:7:\"excerpt\";s:19:\"blog_featured_image\";s:5:\"small\";s:19:\"blog_read_more_text\";s:9:\"Read more\";s:16:\"blog_post_author\";b:1;s:22:\"blog_post_publish_date\";b:1;s:20:\"blog_post_categories\";b:1;s:14:\"blog_post_tags\";b:0;s:18:\"blog_post_comments\";b:0;s:18:\"single_post_author\";b:1;s:24:\"single_post_publish_date\";b:1;s:22:\"single_post_categories\";b:1;s:16:\"single_post_tags\";b:0;s:20:\"single_post_comments\";b:0;s:19:\"single_author_block\";b:1;s:16:\"background_color\";s:6:\"ffffff\";s:18:\"body_font_weight_2\";s:3:\"600\";s:22:\"single_post_navigation\";b:1;s:25:\"related_posts_block_title\";s:12:\"Latest Posts\";s:21:\"related_posts_visible\";b:0;s:19:\"related_posts_count\";s:1:\"2\";s:18:\"related_posts_grid\";s:1:\"2\";s:19:\"related_posts_title\";b:1;s:21:\"related_posts_content\";s:4:\"hide\";s:26:\"related_posts_title_length\";s:2:\"10\";s:28:\"related_posts_content_length\";s:2:\"25\";s:16:\"single_post_type\";s:7:\"default\";s:18:\"nav_menu_locations\";a:4:{s:6:\"social\";i:90;s:6:\"footer\";i:88;s:4:\"main\";i:89;s:3:\"top\";i:91;}s:22:\"content_container_type\";s:9:\"fullwidth\";s:21:\"header_container_type\";s:9:\"fullwidth\";s:21:\"footer_container_type\";s:9:\"fullwidth\";s:29:\"footer_widget_area_visibility\";b:1;s:19:\"footer_contact_info\";s:273:\"<div class=\\\"info-block\\\">Address: 4578 Marmora Road, Glasgow, D04 89GR</div><div class=\\\"info-block\\\">Phones: <a href=\\\"tel:#\\\">(800) 123-0045</a>; <a href=\\\"tel:#\\\">(800) 123-0046</a></div><div class=\\\"info-block\\\">E-mail: <a href=\\\"mailto:#\\\">info@demolink.org</a></div>\";s:22:\"footer_logo_visibility\";b:1;s:30:\"footer_contact_info_visibility\";b:1;s:22:\"footer_menu_visibility\";b:1;s:19:\"top_menu_visibility\";b:1;s:20:\"top_panel_visibility\";b:0;s:21:\"footer_contact_text_1\";s:36:\"4578 Marmora Road, Glasgow, D04 89GR\";s:21:\"footer_contact_text_2\";s:96:\"<a href=\"tel:(800) 123-0045\">(800) 123-0045</a>; <a href=\"tel:(800) 123-0046\">(800) 123-0046</a>\";s:21:\"footer_contact_text_3\";s:56:\"<a href=\"mailto:info@demolink.org\">info@demolink.org</a>\";s:21:\"footer_contact_icon_1\";s:0:\"\";s:21:\"footer_contact_icon_2\";s:0:\"\";s:21:\"header_contact_text_1\";s:36:\"4578 Marmora Road, Glasgow, D04 89GR\";s:21:\"header_contact_text_2\";s:96:\"<a href=\"tel:(800) 123-0045\">(800) 123-0045</a>; <a href=\"tel:(800) 123-0046\">(800) 123-0046</a>\";s:21:\"header_contact_text_3\";s:17:\"Mn-Fr: 10 am-8 pm\";s:31:\"header_contact_block_visibility\";b:0;s:15:\"header_btn_text\";s:10:\"Buy theme!\";s:13:\"header_search\";b:0;s:22:\"header_invert_logo_url\";s:32:\"%s/assets/images/invert-logo.png\";s:22:\"invert_header_logo_url\";s:32:\"%s/assets/images/invert-logo.png\";s:16:\"meta_font_family\";s:21:\"Open Sans, sans-serif\";s:15:\"meta_font_style\";s:6:\"normal\";s:16:\"meta_font_weight\";s:3:\"400\";s:14:\"meta_font_size\";i:14;s:16:\"meta_line_height\";d:1.5;s:19:\"meta_letter_spacing\";s:1:\"0\";s:18:\"meta_character_set\";s:5:\"latin\";s:16:\"blog_sticky_icon\";s:15:\"linearicon-star\";s:16:\"blog_sticky_type\";s:4:\"icon\";s:21:\"tm_pb_layouts_updated\";s:3:\"yes\";s:39:\"tm_updated_layouts_built_for_post_types\";s:3:\"yes\";s:30:\"tm_pb_predefined_layouts_added\";s:2:\"on\";s:34:\"tm_pb_predefined_layouts_version_2\";s:2:\"on\";s:18:\"header_transparent\";b:0;s:26:\"header_invert_color_scheme\";b:1;s:25:\"header_transparent_layout\";b:0;s:16:\"more_button_type\";s:4:\"text\";s:16:\"more_button_icon\";s:13:\"fa-arrow-down\";s:21:\"more_button_image_url\";s:0:\"\";s:31:\"footer_contact_block_visibility\";b:0;s:17:\"page_404_bg_color\";s:7:\"#5a8eee\";s:18:\"page_404_bg_repeat\";s:9:\"no-repeat\";s:22:\"page_404_bg_attachment\";s:6:\"scroll\";s:22:\"page_404_bg_position_x\";s:6:\"center\";s:17:\"page_404_bg_image\";s:27:\"%s/assets/images/bg_404.jpg\";s:22:\"header_contact_label_2\";s:7:\"Phones:\";s:22:\"header_contact_label_1\";s:8:\"Address:\";s:22:\"header_contact_label_3\";s:12:\"We are open:\";s:15:\"onsale_badge_bg\";s:7:\"#ff596d\";s:17:\"featured_badge_bg\";s:7:\"#ffc045\";s:12:\"new_badge_bg\";s:7:\"#000000\";s:24:\"related_posts_categories\";b:1;s:18:\"related_posts_tags\";b:1;s:27:\"related_posts_comment_count\";b:1;s:15:\"include_css_url\";s:0:\"\";s:12:\"skin_css_url\";s:0:\"\";s:10:\"skin_style\";s:6:\"skin16\";s:19:\"header_woo_elements\";b:1;s:14:\"header_btn_url\";s:1:\"#\";s:21:\"header_btn_visibility\";b:0;s:21:\"header_contact_icon_1\";s:21:\"linearicon-map-marker\";s:21:\"header_contact_icon_2\";s:20:\"linearicon-telephone\";s:21:\"header_contact_icon_3\";s:17:\"linearicon-clock3\";s:16:\"more_button_text\";s:4:\"More\";s:28:\"retina_more_button_image_url\";N;s:22:\"footer_contact_label_1\";s:8:\"Address:\";s:22:\"footer_contact_label_2\";s:7:\"Phones:\";s:21:\"footer_contact_icon_3\";s:0:\"\";s:22:\"footer_contact_label_3\";s:7:\"E-mail:\";s:19:\"related_posts_image\";b:1;s:20:\"related_posts_author\";b:1;s:26:\"related_posts_publish_date\";b:1;s:18:\"woo_column_numbers\";s:1:\"4\";s:29:\"invert_retina_header_logo_url\";b:0;s:16:\"gradient_color_1\";b:0;s:16:\"gradient_color_2\";b:0;s:18:\"custom_css_post_id\";i:-1;}}', 'yes'),
(186, 'widget_bbp_login_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(187, 'widget_bbp_views_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(188, 'widget_bbp_search_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(189, 'widget_bbp_forums_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(190, 'widget_bbp_topics_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(191, 'widget_bbp_replies_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(192, 'widget_bbp_stats_widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(193, '_bbp_private_forums', 'a:0:{}', 'yes'),
(194, '_bbp_hidden_forums', 'a:0:{}', 'yes'),
(195, '_bbp_db_version', '250', 'yes'),
(199, 'bp-xprofile-base-group-name', 'Base', 'yes'),
(200, 'bp-xprofile-fullname-field-name', 'Name', 'yes'),
(201, 'bp-blogs-first-install', '', 'yes'),
(202, 'bp-disable-profile-sync', '', 'yes'),
(203, 'hide-loggedout-adminbar', '', 'yes'),
(204, 'bp-disable-avatar-uploads', '', 'yes'),
(205, 'bp-disable-cover-image-uploads', '', 'yes'),
(206, 'bp-disable-group-avatar-uploads', '', 'yes'),
(207, 'bp-disable-group-cover-image-uploads', '', 'yes'),
(208, 'bp-disable-account-deletion', '', 'yes'),
(209, 'bp-disable-blogforum-comments', '1', 'yes'),
(210, '_bp_theme_package_id', 'legacy', 'yes'),
(211, 'bp-emails-unsubscribe-salt', 'JjdKN2NjKFdJU1p4cTpqPHhGcCB5LkFYJCR1NCxvTyxAfDw5P205cGJBYSNkeCw/QUFaeUpqZiRmZHhlLGk9IQ==', 'yes'),
(212, 'bp_restrict_group_creation', '', 'yes'),
(213, '_bp_enable_akismet', '1', 'yes'),
(214, '_bp_enable_heartbeat_refresh', '1', 'yes'),
(215, '_bp_force_buddybar', '', 'yes'),
(216, '_bp_retain_bp_default', '', 'yes'),
(217, '_bp_ignore_deprecated_code', '1', 'yes'),
(218, 'widget_bp_core_login_widget', '', 'yes'),
(219, 'widget_bp_core_members_widget', '', 'yes'),
(220, 'widget_bp_core_whos_online_widget', '', 'yes'),
(221, 'widget_bp_core_recently_active_widget', '', 'yes'),
(222, 'widget_bp_groups_widget', '', 'yes'),
(223, 'widget_bp_messages_sitewide_notices_widget', '', 'yes'),
(495, 'mprm_capabilities_version', '0.0.0', 'yes'),
(230, 'bp-active-components', 'a:6:{s:8:\"xprofile\";s:1:\"1\";s:8:\"settings\";s:1:\"1\";s:8:\"activity\";s:1:\"1\";s:13:\"notifications\";s:1:\"1\";s:6:\"groups\";s:1:\"1\";s:7:\"members\";s:1:\"1\";}', 'yes'),
(231, 'bp-pages', 'a:3:{s:8:\"activity\";i:1824;s:7:\"members\";i:1825;s:6:\"groups\";i:1886;}', 'yes'),
(232, '_bp_db_version', '11105', 'yes'),
(236, 'widget_booked_calendar', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(238, 'booked_version_check', '1.9.7', 'yes'),
(361, '_transient_woocommerce_cache_excluded_uris', 'a:0:{}', 'yes'),
(243, 'external_updates-booked', 'O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1494424578;s:14:\"checkedVersion\";s:5:\"1.9.7\";s:6:\"update\";O:8:\"stdClass\":7:{s:2:\"id\";i:0;s:4:\"slug\";s:6:\"booked\";s:7:\"version\";s:6:\"1.9.12\";s:8:\"homepage\";s:20:\"https://getbooked.io\";s:12:\"download_url\";s:55:\"http://boxyupdates.com/get/?action=download&slug=booked\";s:14:\"upgrade_notice\";N;s:8:\"filename\";s:17:\"booked/booked.php\";}}', 'no'),
(247, 'mprm_db_version', '2.0.0', 'yes'),
(248, 'mprm_settings', 'a:25:{s:8:\"currency\";s:3:\"USD\";s:13:\"template_mode\";s:5:\"theme\";s:14:\"customer_phone\";s:1:\"1\";s:8:\"gateways\";a:2:{s:6:\"paypal\";s:1:\"1\";s:6:\"manual\";s:1:\"1\";}s:15:\"item_quantities\";s:1:\"1\";s:16:\"shipping_address\";s:1:\"1\";s:16:\"enable_ajax_cart\";s:1:\"1\";s:15:\"default_gateway\";s:6:\"manual\";s:14:\"checkout_color\";s:7:\"inherit\";s:16:\"checkout_padding\";s:12:\"mprm-inherit\";s:17:\"currency_position\";s:6:\"before\";s:19:\"thousands_separator\";s:1:\",\";s:17:\"decimal_separator\";s:1:\".\";s:15:\"number_decimals\";s:1:\"2\";s:14:\"accepted_cards\";a:5:{s:10:\"mastercard\";s:10:\"Mastercard\";s:4:\"visa\";s:4:\"Visa\";s:15:\"americanexpress\";s:16:\"American Express\";s:8:\"discover\";s:8:\"Discover\";s:6:\"paypal\";s:6:\"PayPal\";}s:20:\"checkout_include_tax\";s:2:\"no\";s:14:\"checkout_label\";s:8:\"Purchase\";s:16:\"add_to_cart_text\";s:11:\"Add to Cart\";s:12:\"buy_now_text\";s:7:\"Buy Now\";s:13:\"category_view\";s:4:\"grid\";s:13:\"purchase_page\";s:4:\"3333\";s:12:\"success_page\";s:4:\"3334\";s:12:\"failure_page\";s:4:\"3336\";s:21:\"purchase_history_page\";s:4:\"3335\";s:12:\"button_style\";s:6:\"button\";}', 'yes'),
(442, 'mp_timetable_general', 'a:1:{s:10:\"theme_mode\";s:5:\"theme\";}', 'yes'),
(249, 'mprm_use_php_sessions', '1', 'yes'),
(720, 'nav_menu_options', 'a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}', 'yes'),
(257, 'tribe_last_save_post', '1494426753', 'yes'),
(258, 'tribe_events_calendar_options', 'a:4:{s:14:\"schema-version\";s:3:\"3.9\";s:27:\"recurring_events_are_hidden\";s:6:\"hidden\";s:21:\"previous_ecp_versions\";a:1:{i:0;s:1:\"0\";}s:18:\"latest_ecp_version\";s:5:\"4.5.1\";}', 'yes'),
(259, 'widget_tribe-events-list-widget', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(499, 'rewrite_rules', 'a:290:{s:19:\"projects-archive/?$\";s:28:\"index.php?post_type=projects\";s:49:\"projects-archive/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=projects&feed=$matches[1]\";s:44:\"projects-archive/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=projects&feed=$matches[1]\";s:36:\"projects-archive/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=projects&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:7:\"team/?$\";s:24:\"index.php?post_type=team\";s:37:\"team/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=team&feed=$matches[1]\";s:32:\"team/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=team&feed=$matches[1]\";s:24:\"team/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=team&paged=$matches[1]\";s:18:\"cherry-services/?$\";s:35:\"index.php?post_type=cherry-services\";s:48:\"cherry-services/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=cherry-services&feed=$matches[1]\";s:43:\"cherry-services/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=cherry-services&feed=$matches[1]\";s:35:\"cherry-services/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=cherry-services&paged=$matches[1]\";s:15:\"testimonials/?$\";s:35:\"index.php?post_type=tm-testimonials\";s:45:\"testimonials/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=tm-testimonials&feed=$matches[1]\";s:40:\"testimonials/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=tm-testimonials&feed=$matches[1]\";s:32:\"testimonials/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=tm-testimonials&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:44:\"projects-archive/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"projects-archive/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"projects-archive/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"projects-archive/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"projects-archive/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"projects-archive/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"projects-archive/([^/]+)/embed/?$\";s:41:\"index.php?projects=$matches[1]&embed=true\";s:37:\"projects-archive/([^/]+)/trackback/?$\";s:35:\"index.php?projects=$matches[1]&tb=1\";s:57:\"projects-archive/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?projects=$matches[1]&feed=$matches[2]\";s:52:\"projects-archive/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?projects=$matches[1]&feed=$matches[2]\";s:45:\"projects-archive/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?projects=$matches[1]&paged=$matches[2]\";s:52:\"projects-archive/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?projects=$matches[1]&cpage=$matches[2]\";s:42:\"projects-archive/([^/]+)/wc-api(/(.*))?/?$\";s:49:\"index.php?projects=$matches[1]&wc-api=$matches[3]\";s:48:\"projects-archive/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"projects-archive/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"projects-archive/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?projects=$matches[1]&page=$matches[2]\";s:33:\"projects-archive/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"projects-archive/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"projects-archive/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"projects-archive/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"projects-archive/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"projects-archive/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"projects_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?projects_category=$matches[1]&feed=$matches[2]\";s:53:\"projects_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?projects_category=$matches[1]&feed=$matches[2]\";s:34:\"projects_category/([^/]+)/embed/?$\";s:50:\"index.php?projects_category=$matches[1]&embed=true\";s:46:\"projects_category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?projects_category=$matches[1]&paged=$matches[2]\";s:28:\"projects_category/([^/]+)/?$\";s:39:\"index.php?projects_category=$matches[1]\";s:53:\"projects_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?projects_tag=$matches[1]&feed=$matches[2]\";s:48:\"projects_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?projects_tag=$matches[1]&feed=$matches[2]\";s:29:\"projects_tag/([^/]+)/embed/?$\";s:45:\"index.php?projects_tag=$matches[1]&embed=true\";s:41:\"projects_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?projects_tag=$matches[1]&paged=$matches[2]\";s:23:\"projects_tag/([^/]+)/?$\";s:34:\"index.php?projects_tag=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:32:\"team/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"team/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"team/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"team/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"team/([^/]+)/embed/?$\";s:37:\"index.php?team=$matches[1]&embed=true\";s:25:\"team/([^/]+)/trackback/?$\";s:31:\"index.php?team=$matches[1]&tb=1\";s:45:\"team/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?team=$matches[1]&feed=$matches[2]\";s:40:\"team/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?team=$matches[1]&feed=$matches[2]\";s:33:\"team/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&paged=$matches[2]\";s:40:\"team/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?team=$matches[1]&cpage=$matches[2]\";s:30:\"team/([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?team=$matches[1]&wc-api=$matches[3]\";s:36:\"team/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"team/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:29:\"team/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?team=$matches[1]&page=$matches[2]\";s:21:\"team/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"team/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"team/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"team/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"group/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?group=$matches[1]&feed=$matches[2]\";s:41:\"group/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?group=$matches[1]&feed=$matches[2]\";s:22:\"group/([^/]+)/embed/?$\";s:38:\"index.php?group=$matches[1]&embed=true\";s:34:\"group/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?group=$matches[1]&paged=$matches[2]\";s:16:\"group/([^/]+)/?$\";s:27:\"index.php?group=$matches[1]\";s:43:\"cherry-services/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"cherry-services/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"cherry-services/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"cherry-services/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"cherry-services/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"cherry-services/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"cherry-services/([^/]+)/embed/?$\";s:48:\"index.php?cherry-services=$matches[1]&embed=true\";s:36:\"cherry-services/([^/]+)/trackback/?$\";s:42:\"index.php?cherry-services=$matches[1]&tb=1\";s:56:\"cherry-services/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?cherry-services=$matches[1]&feed=$matches[2]\";s:51:\"cherry-services/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?cherry-services=$matches[1]&feed=$matches[2]\";s:44:\"cherry-services/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?cherry-services=$matches[1]&paged=$matches[2]\";s:51:\"cherry-services/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?cherry-services=$matches[1]&cpage=$matches[2]\";s:41:\"cherry-services/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?cherry-services=$matches[1]&wc-api=$matches[3]\";s:47:\"cherry-services/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"cherry-services/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"cherry-services/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?cherry-services=$matches[1]&page=$matches[2]\";s:32:\"cherry-services/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"cherry-services/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"cherry-services/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"cherry-services/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"cherry-services/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"cherry-services/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:65:\"cherry-services_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?cherry-services_category=$matches[1]&feed=$matches[2]\";s:60:\"cherry-services_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?cherry-services_category=$matches[1]&feed=$matches[2]\";s:41:\"cherry-services_category/([^/]+)/embed/?$\";s:57:\"index.php?cherry-services_category=$matches[1]&embed=true\";s:53:\"cherry-services_category/([^/]+)/page/?([0-9]{1,})/?$\";s:64:\"index.php?cherry-services_category=$matches[1]&paged=$matches[2]\";s:35:\"cherry-services_category/([^/]+)/?$\";s:46:\"index.php?cherry-services_category=$matches[1]\";s:40:\"testimonials/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"testimonials/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"testimonials/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"testimonials/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"testimonials/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"testimonials/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"testimonials/([^/]+)/embed/?$\";s:48:\"index.php?tm-testimonials=$matches[1]&embed=true\";s:33:\"testimonials/([^/]+)/trackback/?$\";s:42:\"index.php?tm-testimonials=$matches[1]&tb=1\";s:53:\"testimonials/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?tm-testimonials=$matches[1]&feed=$matches[2]\";s:48:\"testimonials/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?tm-testimonials=$matches[1]&feed=$matches[2]\";s:41:\"testimonials/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?tm-testimonials=$matches[1]&paged=$matches[2]\";s:48:\"testimonials/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?tm-testimonials=$matches[1]&cpage=$matches[2]\";s:38:\"testimonials/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?tm-testimonials=$matches[1]&wc-api=$matches[3]\";s:44:\"testimonials/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"testimonials/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"testimonials/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?tm-testimonials=$matches[1]&page=$matches[2]\";s:29:\"testimonials/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"testimonials/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"testimonials/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"testimonials/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"testimonials/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"testimonials/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"tm-testimonials/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?tm-testimonials_category=$matches[1]&feed=$matches[2]\";s:58:\"tm-testimonials/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:63:\"index.php?tm-testimonials_category=$matches[1]&feed=$matches[2]\";s:39:\"tm-testimonials/category/(.+?)/embed/?$\";s:57:\"index.php?tm-testimonials_category=$matches[1]&embed=true\";s:51:\"tm-testimonials/category/(.+?)/page/?([0-9]{1,})/?$\";s:64:\"index.php?tm-testimonials_category=$matches[1]&paged=$matches[2]\";s:33:\"tm-testimonials/category/(.+?)/?$\";s:46:\"index.php?tm-testimonials_category=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=814&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:31:\".+?/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\".+?/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\".+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\".+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\".+?/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"(.+?)/([^/]+)/embed/?$\";s:63:\"index.php?category_name=$matches[1]&name=$matches[2]&embed=true\";s:26:\"(.+?)/([^/]+)/trackback/?$\";s:57:\"index.php?category_name=$matches[1]&name=$matches[2]&tb=1\";s:46:\"(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:41:\"(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:34:\"(.+?)/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&paged=$matches[3]\";s:41:\"(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?category_name=$matches[1]&name=$matches[2]&cpage=$matches[3]\";s:31:\"(.+?)/([^/]+)/wc-api(/(.*))?/?$\";s:71:\"index.php?category_name=$matches[1]&name=$matches[2]&wc-api=$matches[4]\";s:35:\".+?/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:46:\".+?/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:30:\"(.+?)/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?category_name=$matches[1]&name=$matches[2]&page=$matches[3]\";s:20:\".+?/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:30:\".+?/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:50:\".+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:45:\".+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\".+?/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:14:\"(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:26:\"(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:33:\"(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&cpage=$matches[2]\";s:23:\"(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:8:\"(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";}', 'yes'),
(264, 'woocommerce_default_country', 'GB', 'yes'),
(265, 'woocommerce_allowed_countries', 'all', 'yes'),
(266, 'woocommerce_all_except_countries', '', 'yes'),
(267, 'woocommerce_specific_allowed_countries', '', 'yes'),
(268, 'woocommerce_ship_to_countries', '', 'yes'),
(269, 'woocommerce_specific_ship_to_countries', '', 'yes'),
(270, 'woocommerce_default_customer_address', 'geolocation', 'yes'),
(271, 'woocommerce_calc_taxes', 'no', 'yes'),
(272, 'woocommerce_demo_store', 'no', 'yes'),
(273, 'woocommerce_demo_store_notice', 'This is a demo store for testing purposes &mdash; no orders shall be fulfilled.', 'no'),
(274, 'woocommerce_currency', 'GBP', 'yes'),
(275, 'woocommerce_currency_pos', 'left', 'yes'),
(276, 'woocommerce_price_thousand_sep', ',', 'yes'),
(277, 'woocommerce_price_decimal_sep', '.', 'yes'),
(278, 'woocommerce_price_num_decimals', '2', 'yes'),
(279, 'woocommerce_weight_unit', 'kg', 'yes'),
(280, 'woocommerce_dimension_unit', 'cm', 'yes'),
(281, 'woocommerce_enable_review_rating', 'yes', 'yes'),
(282, 'woocommerce_review_rating_required', 'yes', 'no'),
(283, 'woocommerce_review_rating_verification_label', 'yes', 'no'),
(284, 'woocommerce_review_rating_verification_required', 'no', 'no'),
(285, 'woocommerce_shop_page_id', '2400', 'yes'),
(286, 'woocommerce_shop_page_display', '', 'yes'),
(287, 'woocommerce_category_archive_display', '', 'yes'),
(288, 'woocommerce_default_catalog_orderby', 'menu_order', 'yes'),
(289, 'woocommerce_cart_redirect_after_add', 'no', 'yes'),
(290, 'woocommerce_enable_ajax_add_to_cart', 'yes', 'yes'),
(291, 'shop_catalog_image_size', 'a:3:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}', 'yes'),
(292, 'shop_single_image_size', 'a:3:{s:5:\"width\";s:3:\"535\";s:6:\"height\";s:3:\"714\";s:4:\"crop\";i:1;}', 'yes'),
(293, 'shop_thumbnail_image_size', 'a:3:{s:5:\"width\";s:2:\"89\";s:6:\"height\";s:3:\"120\";s:4:\"crop\";i:1;}', 'yes'),
(294, 'woocommerce_manage_stock', 'yes', 'yes'),
(295, 'woocommerce_hold_stock_minutes', '60', 'no'),
(296, 'woocommerce_notify_low_stock', 'yes', 'no'),
(297, 'woocommerce_notify_no_stock', 'yes', 'no'),
(298, 'woocommerce_stock_email_recipient', 'm@m.com', 'no'),
(299, 'woocommerce_notify_low_stock_amount', '2', 'no'),
(300, 'woocommerce_notify_no_stock_amount', '0', 'yes'),
(301, 'woocommerce_hide_out_of_stock_items', 'no', 'yes'),
(302, 'woocommerce_stock_format', '', 'yes'),
(303, 'woocommerce_file_download_method', 'force', 'no'),
(304, 'woocommerce_downloads_require_login', 'no', 'no'),
(305, 'woocommerce_downloads_grant_access_after_payment', 'yes', 'no'),
(306, 'woocommerce_prices_include_tax', 'no', 'yes'),
(307, 'woocommerce_tax_based_on', 'shipping', 'yes'),
(308, 'woocommerce_shipping_tax_class', 'inherit', 'yes'),
(309, 'woocommerce_tax_round_at_subtotal', 'no', 'yes'),
(310, 'woocommerce_tax_classes', 'Reduced rate\r\nZero rate', 'yes'),
(311, 'woocommerce_tax_display_shop', 'excl', 'yes'),
(312, 'woocommerce_tax_display_cart', 'excl', 'no'),
(313, 'woocommerce_price_display_suffix', '', 'yes'),
(314, 'woocommerce_tax_total_display', 'itemized', 'no'),
(315, 'woocommerce_enable_shipping_calc', 'yes', 'no'),
(316, 'woocommerce_shipping_cost_requires_address', 'no', 'no'),
(317, 'woocommerce_ship_to_destination', 'billing', 'no'),
(318, 'woocommerce_shipping_debug_mode', 'no', 'no'),
(319, 'woocommerce_enable_coupons', 'yes', 'yes'),
(320, 'woocommerce_calc_discounts_sequentially', 'no', 'no'),
(321, 'woocommerce_enable_guest_checkout', 'yes', 'no'),
(322, 'woocommerce_force_ssl_checkout', 'no', 'yes'),
(323, 'woocommerce_unforce_ssl_checkout', 'no', 'yes'),
(324, 'woocommerce_cart_page_id', '2403', 'yes'),
(325, 'woocommerce_checkout_page_id', '2407', 'yes'),
(326, 'woocommerce_terms_page_id', '2409', 'no'),
(327, 'woocommerce_checkout_pay_endpoint', 'order-pay', 'yes'),
(328, 'woocommerce_checkout_order_received_endpoint', 'order-received', 'yes'),
(329, 'woocommerce_myaccount_add_payment_method_endpoint', 'add-payment-method', 'yes'),
(330, 'woocommerce_myaccount_delete_payment_method_endpoint', 'delete-payment-method', 'yes'),
(331, 'woocommerce_myaccount_set_default_payment_method_endpoint', 'set-default-payment-method', 'yes'),
(332, 'woocommerce_myaccount_page_id', '', 'yes'),
(333, 'woocommerce_enable_signup_and_login_from_checkout', 'yes', 'no'),
(334, 'woocommerce_enable_myaccount_registration', 'no', 'no'),
(335, 'woocommerce_enable_checkout_login_reminder', 'yes', 'no'),
(336, 'woocommerce_registration_generate_username', 'yes', 'no'),
(337, 'woocommerce_registration_generate_password', 'no', 'no'),
(338, 'woocommerce_myaccount_orders_endpoint', 'orders', 'yes'),
(339, 'woocommerce_myaccount_view_order_endpoint', 'view-order', 'yes'),
(340, 'woocommerce_myaccount_downloads_endpoint', 'downloads', 'yes'),
(341, 'woocommerce_myaccount_edit_account_endpoint', 'edit-account', 'yes'),
(342, 'woocommerce_myaccount_edit_address_endpoint', 'edit-address', 'yes'),
(343, 'woocommerce_myaccount_payment_methods_endpoint', 'payment-methods', 'yes'),
(344, 'woocommerce_myaccount_lost_password_endpoint', 'lost-password', 'yes'),
(345, 'woocommerce_logout_endpoint', 'customer-logout', 'yes'),
(346, 'woocommerce_email_from_name', 'Reflax', 'no'),
(347, 'woocommerce_email_from_address', 'm@m.com', 'no'),
(348, 'woocommerce_email_header_image', '', 'no'),
(349, 'woocommerce_email_footer_text', 'Reflax - Powered by WooCommerce', 'no'),
(350, 'woocommerce_email_base_color', '#96588a', 'no'),
(351, 'woocommerce_email_background_color', '#f7f7f7', 'no'),
(352, 'woocommerce_email_body_background_color', '#ffffff', 'no'),
(353, 'woocommerce_email_text_color', '#3c3c3c', 'no'),
(354, 'woocommerce_api_enabled', 'yes', 'yes'),
(360, 'woocommerce_admin_notices', 'a:1:{i:0;s:13:\"theme_support\";}', 'yes'),
(2277, 'woocommerce_db_version', '3.0.7', 'yes'),
(2278, 'woocommerce_version', '3.0.7', 'yes'),
(364, '_transient_woocommerce_webhook_ids', 'a:0:{}', 'yes'),
(365, 'widget_woocommerce_widget_cart', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(366, 'widget_woocommerce_layered_nav_filters', 'a:2:{i:1;a:1:{s:5:\"title\";s:14:\"Active Filters\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(367, 'widget_woocommerce_layered_nav', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(368, 'widget_woocommerce_price_filter', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(369, 'widget_woocommerce_product_categories', 'a:2:{i:1;a:7:{s:5:\"title\";s:10:\"Categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(370, 'widget_woocommerce_product_search', 'a:2:{i:1;a:1:{s:5:\"title\";s:6:\"Search\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(371, 'widget_woocommerce_product_tag_cloud', 'a:2:{i:1;a:1:{s:5:\"title\";s:4:\"Tags\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(372, 'widget_woocommerce_products', 'a:3:{i:1;a:7:{s:5:\"title\";s:17:\"Featured Products\";s:6:\"number\";i:2;s:4:\"show\";s:8:\"featured\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}i:2;a:7:{s:5:\"title\";s:16:\"Special Products\";s:6:\"number\";i:2;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(373, 'widget_woocommerce_rating_filter', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(374, 'widget_woocommerce_recent_reviews', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(375, 'widget_woocommerce_recently_viewed_products', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(376, 'widget_woocommerce_top_rated_products', 'a:2:{i:1;a:2:{s:5:\"title\";s:18:\"Top Rated Products\";s:6:\"number\";i:2;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(380, 'tm_wc_ajax_filters_grid_list_enable', 'yes', 'yes'),
(381, 'tm_wc_ajax_filters_ordering_enable', 'yes', 'yes'),
(382, 'tm_wc_ajax_filters_pagination_enable', 'yes', 'yes'),
(383, 'tm_wc_ajax_filters_loadmore_enable', 'yes', 'yes'),
(384, 'tm_wc_ajax_filters_loadmore_label', 'Load more', 'yes'),
(385, 'tm_wc_ajax_filters_loadmore_treshold', '20', 'yes'),
(386, 'tm_wc_ajax_filters_loadmore_treshold_mobile', '20', 'yes'),
(387, 'woocommerce_meta_box_errors', 'a:0:{}', 'yes'),
(388, 'widget_tm_woo_ajax_filters', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(390, 'tm_woocompare_page', '2102', 'yes'),
(391, 'tm_woowishlist_page', '2101', 'yes'),
(392, 'tm_woocompare_enable', 'yes', 'yes'),
(393, 'tm_woocompare_show_in_catalog', 'yes', 'yes'),
(394, 'tm_woocompare_show_in_single', 'yes', 'yes'),
(395, 'tm_woocompare_compare_text', 'Add to Compare', 'yes'),
(396, 'tm_woocompare_remove_text', 'Remove from Compare', 'yes'),
(397, 'tm_woocompare_page_btn_text', 'Compare products', 'yes'),
(398, 'tm_woocompare_empty_btn_text', 'Empty compare', 'yes'),
(399, 'tm_woocompare_empty_text', 'No products found to compare.', 'yes'),
(400, 'tm_woocompare_page_template', 'page.tmpl', 'yes'),
(401, 'tm_woocompare_widget_template', 'widget.tmpl', 'yes'),
(402, 'tm_woowishlist_enable', 'yes', 'yes'),
(403, 'tm_woowishlist_show_in_catalog', 'yes', 'yes'),
(404, 'tm_woowishlist_show_in_single', 'yes', 'yes'),
(405, 'tm_woowishlist_add_text', 'Add to Wishlist', 'yes'),
(406, 'tm_woowishlist_added_text', 'Added to Wishlist', 'yes'),
(407, 'tm_woowishlist_page_btn_text', 'Go to my wishlist', 'yes'),
(408, 'tm_woowishlist_empty_text', 'No products added to wishlist.', 'yes'),
(409, 'tm_woowishlist_cols', '1', 'yes'),
(410, 'tm_woowishlist_page_template', 'page.tmpl', 'yes'),
(411, 'tm_woowishlist_widget_template', 'widget.tmpl', 'yes'),
(412, 'widget_tm_woocompare_recent_compare_list', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(413, 'widget_tm_woocommerce_wishlist', 'a:1:{s:12:\"_multiwidget\";i:1;}', 'yes'),
(415, 'widget___tm_products_carousel_widget', 'a:2:{i:1;a:20:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";i:8;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;s:16:\"tm_filter_by_cat\";s:3:\"all\";s:16:\"tm_filter_by_tag\";s:3:\"all\";s:35:\"tm_products_carousel_widget_visible\";i:4;s:32:\"tm_products_carousel_widget_meta\";s:0:\"\";s:33:\"tm_products_carousel_widget_title\";i:1;s:33:\"tm_products_carousel_widget_price\";i:1;s:32:\"tm_products_carousel_widget_desc\";i:1;s:38:\"tm_products_carousel_widget_desc_limit\";i:10;s:31:\"tm_products_carousel_widget_tag\";i:1;s:31:\"tm_products_carousel_widget_cat\";i:1;s:38:\"tm_products_carousel_widget_navigation\";s:0:\"\";s:34:\"tm_products_carousel_widget_arrows\";i:1;s:38:\"tm_products_carousel_widget_pagination\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(416, 'widget___tm_products_smart_box_widget', 'a:2:{i:1;a:7:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";i:3;s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;s:16:\"tm_filter_by_cat\";a:1:{i:0;s:3:\"all\";}}s:12:\"_multiwidget\";i:1;}', 'yes'),
(417, 'widget___tm_banners_grid_widget', 'a:2:{i:1;a:7:{s:5:\"title\";s:0:\"\";s:7:\"banners\";s:24:\"2695,2696,2697,2698,2699\";s:13:\"banners_links\";s:16:\"[\"\",\"\",\"\",\"\",\"\"]\";s:13:\"links_targets\";s:9:\"0,0,0,0,0\";s:6:\"titles\";s:44:\"QmFubmVy,QmFubmVy,QmFubmVy,QmFubmVy,QmFubmVy\";s:5:\"texts\";s:4:\",,,,\";s:12:\"banners_grid\";s:51:\"[{\"w\":4,\"h\":[1,1]},{\"w\":4,\"h\":2},{\"w\":4,\"h\":[1,1]}]\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(418, 'widget___tm_custom_menu_widget', 'a:4:{i:1;a:4:{s:5:\"title\";s:8:\"Clothing\";s:8:\"nav_menu\";i:19;s:2:\"id\";i:2700;s:5:\"class\";s:0:\"\";}i:2;a:4:{s:5:\"title\";s:8:\"Lingerie\";s:8:\"nav_menu\";i:19;s:2:\"id\";i:2701;s:5:\"class\";s:0:\"\";}i:3;a:4:{s:5:\"title\";s:11:\"Accessories\";s:8:\"nav_menu\";i:19;s:2:\"id\";i:2702;s:5:\"class\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(419, 'widget_woocommerce_image_product_categories', 'a:2:{i:1;a:9:{s:5:\"title\";s:18:\"Product Categories\";s:7:\"orderby\";s:4:\"name\";s:5:\"count\";i:0;s:10:\"hide_empty\";i:0;s:41:\"tm_categories_carousel_widget_only_parent\";i:0;s:37:\"tm_categories_carousel_widget_visible\";i:4;s:40:\"tm_categories_carousel_widget_navigation\";s:0:\"\";s:36:\"tm_categories_carousel_widget_arrows\";i:1;s:40:\"tm_categories_carousel_widget_pagination\";i:0;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(420, 'widget_tm_about_store_widget', 'a:2:{i:1;a:7:{s:5:\"title\";s:11:\"About Store\";s:4:\"text\";s:479:\"<span>We  want to be a denim brand first of all</span>\r\nWith the company\'s history dating 10 years back, we always felt desire to tell some kind of complete story with our clothes. So the original style mixed with an androgynous feel of a modern day makes us what we actually are. \r\nWe like the design part of the clothes as much as you do. We are also sure that the visual appeal of any wardrobe item can be easily integrated with the practicality and a balance can be achieved.\";s:6:\"filter\";b:0;s:13:\"enable_button\";b:0;s:10:\"button_url\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:2:\"id\";i:2727;}s:12:\"_multiwidget\";i:1;}', 'yes'),
(422, 'toastie_smsb_fb', 'true', 'yes'),
(423, 'toastie_smsb_tw', 'true', 'yes'),
(424, 'toastie_smsb_gp', 'true', 'yes'),
(425, 'toastie_smsb_pi', 'true', 'yes'),
(426, 'toastie_smsb_tu', 'true', 'yes'),
(427, 'toastie_smsb_li', 'true', 'yes'),
(428, 'toastie_smsb_st', 'true', 'yes'),
(429, 'toastie_smsb_vk', 'true', 'yes'),
(430, 'toastie_smsb_em', 'true', 'yes'),
(431, 'toastie_smsb_format', 'button', 'yes'),
(432, 'toastie_smsb_title', '', 'yes'),
(433, 'toastie_smsb_email', 'I%20saw%20this%20and%20thought%20of%20you!%20', 'yes'),
(434, 'toastie_smsb_opengraph', 'false', 'yes'),
(483, '_transient_product_query-transient-version', '1494425803', 'yes'),
(1671, 'category_children', 'a:0:{}', 'yes'),
(449, 'mp_menu_tag_children', 'a:0:{}', 'yes'),
(471, 'mp_ingredient_children', 'a:0:{}', 'yes'),
(465, 'mp_menu_category_children', 'a:0:{}', 'yes'),
(456, 'group_children', 'a:0:{}', 'yes'),
(1268, 'projects_category_children', 'a:0:{}', 'yes'),
(1286, 'cherry-services_category_children', 'a:0:{}', 'yes'),
(468, 'tm-testimonials_category_children', 'a:0:{}', 'yes'),
(472, 'tribe_events_cat_children', 'a:0:{}', 'yes'),
(477, 'product_cat_children', 'a:0:{}', 'yes');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(484, 'cache', 'a:5:{s:5:\"terms\";a:61:{s:40:\"f09790460e601895ed4f694d98ff66c372083604\";i:31;s:40:\"f6d20ad5566c3fb24f19831606e5b4bd9dfa6a06\";i:32;s:40:\"befa6b2e0880de67524cfc5fc8ab17cbd026d420\";i:33;s:40:\"caf25edf5644530fe4cda04c9e2294c0568b3bb2\";i:34;s:40:\"bd8927332c0ffb7aee11a1771d3fe5f8cc9ea6aa\";i:35;s:40:\"9f379ec3a0491bbe7b8f420db83d80052b77a76b\";i:36;s:40:\"4f82ae6a6cb73ff06ad967c936fad21ae3f01147\";i:37;s:40:\"d7ed3705a716a294861ce642ae2529338cdfe925\";i:38;s:40:\"788fd19bf1a278fd108d712f1c6e19937751338a\";i:39;s:40:\"a211d85934badf9e320d3223e915ea1005420124\";i:40;s:40:\"35ea613e950a154dfe35bb7c51610590e2861ae7\";i:41;s:40:\"abcb78dd217c62c618935163de193bc43169303e\";i:42;s:40:\"c514fcd027dbd1ec8af938e572270e8992f7b23b\";i:43;s:40:\"c3056cdf015027638aee64e1b5aae96dc886c3f6\";i:44;s:40:\"f9755451751ad3cb21f7df69b20b7533288a8bc1\";i:45;s:40:\"e0063dc5718d2f47ffdaac0023864374761b3d23\";i:46;s:40:\"d8b94012f4afdb81ea2fa6a8891f3c2723dab834\";i:47;s:40:\"009abab84fee4e12b66c7ca796bfa156d18fcee6\";i:48;s:40:\"5b272c19e72740539749b92add229b376443b4ab\";i:49;s:40:\"2eb0e3db66ef066289f9fe02f0f90b0e8f9cdcb2\";i:50;s:40:\"4004b80f0af60239aa305962a12c3a9d6b898449\";i:51;s:40:\"9916251d47dfb727823eebb03a584d37ade7f0fa\";i:52;s:40:\"c42a2636462f516544d5b4ea4d20db0f89ad1fff\";i:53;s:40:\"674d1f30fd8630379a5f3eabd04fb3d37edb510b\";i:54;s:40:\"4eb248432af3d3904ebf1d0fdd19800bb7eed6c3\";i:55;s:40:\"4cb78004e15df245267ca67e84b4e9c4f3efc43d\";i:56;s:40:\"53dd32db12b74d8f3ccd79ee36c79c53f4a1ecef\";i:57;s:40:\"b15f6720bc1432b72b6b986521268238cdc19ba6\";i:58;s:40:\"955bc5fc678aaadc4691c23ea929920cf4336079\";i:59;s:40:\"44a84b10b6ae989959070832b92e86981d980b49\";i:60;s:40:\"c494f011b5693edfee8e3928170a626dc763dc92\";i:61;s:40:\"d74aa8e27213ee3d38b014c7b3f9f4ef76c26ea0\";i:62;s:40:\"52cb6f4ac0d3a9a6492f80d50fb40b8d3b3e7b9e\";i:63;s:40:\"b30aa31037b340068077b785014fc98732945242\";i:64;s:40:\"6575b31fee4880e0ddee9994c6ca09bb79f58a8b\";i:65;s:40:\"3b4ef3e046098b2798f8cf3a66dee11be563061f\";i:66;s:40:\"2a82dd4929a3f32b2e326d0e8b48d205c5ee2457\";i:67;s:40:\"c29742997780317f340db57402a32c1c375da1c0\";i:68;s:40:\"5347a2e9b99425a74ed1c4241d4a19860bba2ab5\";i:69;s:40:\"aa4b4bad8d8a02a96009d8182dd0fa6da326a2e3\";i:70;s:40:\"4a8052a9623caf07299c3496a330f8def5a7a153\";i:71;s:40:\"35fb6af9a8e4420dcf9dfaf522b3b162c12aeb6c\";i:72;s:40:\"3f1d4cf0013c1033c698246ca31357a4fd06f86b\";i:73;s:40:\"3db6f24a8521e92fe0c91927ce5f88d22152f28d\";i:74;s:40:\"286f825650457d481f7e311076712670920bb782\";i:75;s:40:\"cf5d3b6398b0c5e4bff2f46d757f7a7aabc25424\";i:76;s:40:\"90589139f84f1f1caadac35349c18e9fdcce4734\";i:77;s:40:\"46897095e379f20d13c61fd77835a90e82e0ef10\";i:78;s:40:\"3da72a7319fe6df87a89cbcd1b43fec1e538a860\";i:79;s:40:\"c1a4efc945a3832ad34bcc11db724d9a27dd2e62\";i:80;s:40:\"b9783e0d79f76a7166b05bd674ed16c100340197\";i:81;s:40:\"18751fd8537b3a53b0e84ca428be1c6f9c0022c3\";i:82;s:40:\"47f42fe38fed2d780c2b4ac5c6fb644d24b5b336\";i:83;s:40:\"fe3f822965de07f7382987d703424a50673e0dc9\";i:84;s:40:\"0005ee56144a1921ab7c539b0d57fe3a9c113d4c\";i:85;s:40:\"38d702957bae0dc1f47b1f3dd233c4f00dc90500\";i:86;s:40:\"8f99e0e38f63ff23f837768e6b24f26e0fe51123\";i:87;s:40:\"37daec4cc97be397d57b22296fc2620b037114f0\";i:88;s:40:\"b7cc11150b6ad0e6f8bfaa74adfd4691ca25a982\";i:89;s:40:\"5cc7d3a7c5b55c63c725b523616e3516375c2925\";i:90;s:40:\"e81c2db1b6ab29122fa7308bc81fc7cb7bbfafcd\";i:91;}s:7:\"term_id\";a:61:{i:11;i:31;i:12;i:32;i:10;i:33;i:13;i:34;i:3;i:35;i:14;i:36;i:58;i:37;i:4;i:38;i:5;i:39;i:92;i:40;i:40;i:41;i:110;i:42;i:111;i:43;i:80;i:44;i:65;i:45;i:90;i:46;i:32;i:47;i:112;i:48;i:113;i:49;i:114;i:50;i:66;i:51;i:36;i:52;i:21;i:53;i:22;i:54;i:23;i:55;i:115;i:56;i:116;i:57;i:38;i:58;i:33;i:59;i:30;i:60;i:35;i:61;i:117;i:62;i:37;i:63;i:118;i:64;i:119;i:65;i:34;i:66;i:108;i:67;i:109;i:68;i:72;i:69;i:73;i:70;i:120;i:71;i:31;i:72;i:39;i:73;i:76;i:74;i:101;i:75;i:26;i:76;i:27;i:77;i:29;i:78;i:121;i:79;i:77;i:80;i:122;i:81;i:123;i:82;i:63;i:83;i:69;i:84;i:71;i:85;i:74;i:86;i:78;i:87;i:19;i:88;i:17;i:89;i:18;i:90;i:20;i:91;}s:9:\"term_slug\";a:53:{s:17:\"new-page-examples\";i:31;s:17:\"parallax-sections\";i:32;s:15:\"retina-homepage\";i:33;s:17:\"shortcode-central\";i:34;s:5:\"theme\";i:78;s:24:\"ultimate-font-collection\";i:36;s:6:\"events\";i:37;s:5:\"style\";i:75;s:11:\"accessories\";i:83;s:10:\"calendar-1\";i:41;s:13:\"chefs-special\";i:42;s:7:\"chicken\";i:43;s:7:\"class-1\";i:44;s:7:\"class-2\";i:45;s:7:\"class-3\";i:46;s:5:\"clean\";i:47;s:8:\"desserts\";i:48;s:6:\"drinks\";i:49;s:4:\"eggs\";i:50;s:7:\"fashion\";i:51;s:6:\"global\";i:52;s:7:\"group-1\";i:53;s:7:\"group-2\";i:54;s:7:\"group-3\";i:55;s:5:\"lemon\";i:56;s:12:\"main-courses\";i:57;s:6:\"module\";i:58;s:10:\"not_global\";i:59;s:7:\"project\";i:60;s:7:\"regular\";i:61;s:4:\"rice\";i:62;s:3:\"row\";i:63;s:6:\"salmon\";i:64;s:4:\"salt\";i:65;s:7:\"section\";i:66;s:8:\"service1\";i:67;s:10:\"services-2\";i:68;s:5:\"shoes\";i:85;s:5:\"skirt\";i:70;s:8:\"starters\";i:71;s:14:\"testimonials-1\";i:76;s:14:\"testimonials-2\";i:77;s:5:\"thyme\";i:79;s:5:\"trend\";i:80;s:5:\"water\";i:81;s:9:\"wordpress\";i:82;s:3:\"men\";i:84;s:5:\"sport\";i:86;s:5:\"women\";i:87;s:6:\"footer\";i:88;s:4:\"main\";i:89;s:6:\"social\";i:90;s:3:\"top\";i:91;}s:5:\"posts\";a:606:{i:6;i:25;i:17;i:26;i:18;i:27;i:19;i:28;i:20;i:29;i:21;i:30;i:22;i:31;i:57;i:57;i:99;i:99;i:108;i:108;i:109;i:109;i:110;i:110;i:111;i:111;i:118;i:118;i:128;i:128;i:129;i:129;i:162;i:162;i:163;i:163;i:204;i:204;i:205;i:205;i:206;i:206;i:218;i:218;i:221;i:221;i:222;i:222;i:237;i:237;i:240;i:240;i:248;i:248;i:302;i:302;i:399;i:399;i:426;i:426;i:531;i:531;i:606;i:606;i:607;i:607;i:608;i:608;i:666;i:666;i:676;i:676;i:678;i:678;i:756;i:756;i:773;i:773;i:779;i:779;i:780;i:780;i:781;i:781;i:858;i:858;i:859;i:859;i:860;i:860;i:861;i:861;i:862;i:862;i:863;i:863;i:881;i:881;i:882;i:882;i:883;i:883;i:884;i:884;i:888;i:888;i:889;i:889;i:890;i:890;i:891;i:891;i:892;i:892;i:893;i:893;i:957;i:957;i:958;i:958;i:959;i:959;i:1189;i:1189;i:1194;i:1194;i:1216;i:1216;i:1266;i:1266;i:1295;i:1295;i:1297;i:1297;i:1298;i:1298;i:1299;i:1299;i:1312;i:1312;i:1328;i:1328;i:1359;i:1359;i:1414;i:1414;i:1473;i:1473;i:1768;i:1768;i:1965;i:1965;i:1996;i:1996;i:2112;i:2112;i:2113;i:2113;i:2114;i:2114;i:2115;i:2115;i:2116;i:2116;i:2117;i:2117;i:2118;i:2118;i:2119;i:2119;i:2121;i:2121;i:2122;i:2122;i:2123;i:2123;i:2124;i:2124;i:2125;i:2125;i:2126;i:2126;i:2127;i:2127;i:2128;i:2128;i:2129;i:2129;i:2130;i:2130;i:2131;i:2131;i:2132;i:2132;i:2133;i:2133;i:2134;i:2134;i:2135;i:2135;i:2136;i:2136;i:2137;i:2137;i:2138;i:2138;i:2139;i:2139;i:2140;i:2140;i:2141;i:2141;i:2142;i:2142;i:2143;i:2143;i:2144;i:2144;i:2145;i:2145;i:2146;i:2146;i:2147;i:2147;i:2148;i:2148;i:2149;i:2149;i:2150;i:2150;i:2151;i:2151;i:2152;i:2152;i:2153;i:2153;i:2154;i:2154;i:2155;i:2155;i:2156;i:2156;i:2157;i:2157;i:2158;i:2158;i:2159;i:2159;i:2160;i:2160;i:2161;i:2161;i:2162;i:2162;i:2163;i:2163;i:2164;i:2164;i:2165;i:2165;i:2166;i:2166;i:2167;i:2167;i:2168;i:2168;i:2169;i:2169;i:2170;i:2170;i:2171;i:2171;i:2172;i:2172;i:2173;i:2173;i:2174;i:2174;i:2175;i:2175;i:2176;i:2176;i:2177;i:2177;i:2178;i:2178;i:2179;i:2179;i:2180;i:2180;i:2181;i:2181;i:2182;i:2182;i:2183;i:2183;i:2184;i:2184;i:2185;i:2185;i:2186;i:2186;i:2187;i:2187;i:2188;i:2188;i:2189;i:2189;i:2190;i:2190;i:2191;i:2191;i:2192;i:2192;i:2201;i:2201;i:2232;i:2232;i:2254;i:2254;i:2255;i:2255;i:2269;i:2269;i:2295;i:2295;i:2307;i:2307;i:2316;i:2316;i:2378;i:2378;i:2391;i:2391;i:2416;i:2416;i:2417;i:2417;i:2418;i:2418;i:2419;i:2419;i:2420;i:2420;i:2421;i:2421;i:2436;i:2436;i:2437;i:2437;i:2443;i:2443;i:2557;i:2557;i:2695;i:2695;i:2696;i:2696;i:2697;i:2697;i:2698;i:2698;i:2699;i:2699;i:2700;i:2700;i:2701;i:2701;i:2702;i:2702;i:2727;i:2727;i:2758;i:2758;i:2763;i:2763;i:2766;i:2766;i:2767;i:2767;i:2769;i:2769;i:2770;i:2770;i:2772;i:2772;i:2773;i:2773;i:2775;i:2775;i:2777;i:2777;i:2778;i:2778;i:2779;i:2779;i:1808;i:1808;i:1809;i:1809;i:2781;i:2781;i:2782;i:2782;i:3116;i:3116;i:3117;i:3117;i:3135;i:3135;i:3157;i:3157;i:3158;i:3158;i:3159;i:3159;i:3160;i:3160;i:3161;i:3161;i:3162;i:3162;i:3187;i:3187;i:3188;i:3188;i:3413;i:3413;i:3414;i:3414;i:3423;i:3423;i:3424;i:3424;i:3425;i:3425;i:1810;i:1810;i:1811;i:1811;i:1812;i:1812;i:1813;i:1813;i:1814;i:1814;i:1815;i:1815;i:1816;i:1816;i:1817;i:1817;i:1818;i:1818;i:1819;i:1819;i:1820;i:1820;i:1821;i:1821;i:1822;i:1822;i:1823;i:1823;i:1826;i:1826;i:1827;i:1827;i:1828;i:1828;i:1829;i:1829;i:1830;i:1830;i:1831;i:1831;i:1832;i:1832;i:1833;i:1833;i:1834;i:1834;i:1835;i:1835;i:1836;i:1836;i:1837;i:1837;i:1838;i:1838;i:1839;i:1839;i:1840;i:1840;i:1841;i:1841;i:1842;i:1842;i:1843;i:1843;i:1844;i:1844;i:1845;i:1845;i:1846;i:1846;i:1847;i:1847;i:1848;i:1848;i:1849;i:1849;i:1850;i:1850;i:1851;i:1851;i:1852;i:1852;i:1853;i:1853;i:1854;i:1854;i:1855;i:1855;i:1856;i:1856;i:1857;i:1857;i:1888;i:1888;i:2878;i:2878;i:2912;i:2912;i:2913;i:2913;i:2914;i:2914;i:2915;i:2915;i:2916;i:2916;i:2932;i:2932;i:2933;i:2933;i:2934;i:2934;i:3174;i:3174;i:3175;i:3175;i:3510;i:3510;i:3512;i:3512;i:102;i:102;i:103;i:103;i:245;i:245;i:664;i:664;i:665;i:665;i:667;i:667;i:668;i:668;i:669;i:669;i:1481;i:1481;i:1761;i:1761;i:3156;i:3156;i:3163;i:3163;i:3166;i:3166;i:3167;i:3167;i:3168;i:3168;i:3169;i:3169;i:3170;i:3170;i:3171;i:3171;i:3172;i:3172;i:3173;i:3173;i:104;i:104;i:105;i:105;i:106;i:106;i:107;i:107;i:131;i:131;i:140;i:140;i:141;i:141;i:143;i:143;i:144;i:144;i:145;i:145;i:146;i:146;i:150;i:150;i:155;i:155;i:191;i:191;i:192;i:192;i:216;i:216;i:257;i:257;i:258;i:258;i:275;i:275;i:294;i:294;i:313;i:313;i:321;i:321;i:335;i:335;i:515;i:515;i:516;i:516;i:517;i:517;i:518;i:518;i:519;i:519;i:522;i:522;i:525;i:525;i:528;i:528;i:550;i:550;i:551;i:551;i:552;i:552;i:553;i:553;i:809;i:809;i:810;i:810;i:816;i:816;i:910;i:910;i:912;i:912;i:913;i:913;i:915;i:915;i:946;i:946;i:984;i:984;i:1190;i:1190;i:1224;i:1224;i:1859;i:1859;i:1864;i:1864;i:1869;i:1869;i:1880;i:1880;i:1884;i:1884;i:1885;i:1885;i:1887;i:1887;i:2402;i:2402;i:2457;i:2457;i:2585;i:2585;i:2588;i:2588;i:2589;i:2589;i:2590;i:2590;i:2591;i:2591;i:2586;i:2586;i:2587;i:2587;i:2592;i:2592;i:2593;i:2593;i:2594;i:2594;i:2595;i:2595;i:2596;i:2596;i:2597;i:2597;i:2642;i:2642;i:2643;i:2643;i:2707;i:2707;i:2708;i:2708;i:2709;i:2709;i:2710;i:2710;i:2711;i:2711;i:2712;i:2712;i:2713;i:2713;i:2714;i:2714;i:2715;i:2715;i:2716;i:2716;i:2717;i:2717;i:2718;i:2718;i:2719;i:2719;i:2720;i:2720;i:2721;i:2721;i:2722;i:2722;i:2723;i:2723;i:2724;i:2724;i:2726;i:2726;i:2794;i:2794;i:2795;i:2795;i:2796;i:2796;i:2797;i:2797;i:2798;i:2798;i:2977;i:2977;i:2978;i:2978;i:2979;i:2979;i:2980;i:2980;i:2981;i:2981;i:2982;i:2982;i:2983;i:2983;i:2984;i:2984;i:2985;i:2985;i:2986;i:2986;i:2987;i:2987;i:2988;i:2988;i:2989;i:2989;i:2990;i:2990;i:2991;i:2991;i:2992;i:2992;i:2993;i:2993;i:2994;i:2994;i:2995;i:2995;i:2996;i:2996;i:2997;i:2997;i:3010;i:3010;i:3013;i:3013;i:3139;i:3139;i:3270;i:3270;i:3298;i:3298;i:164;i:164;i:181;i:181;i:214;i:214;i:253;i:253;i:255;i:255;i:270;i:270;i:276;i:276;i:296;i:296;i:3299;i:3299;i:3300;i:3300;i:3301;i:3301;i:3302;i:3302;i:3304;i:3304;i:3305;i:3305;i:3393;i:3393;i:3394;i:3394;i:3395;i:3395;i:3396;i:3396;i:3397;i:3397;i:3398;i:3398;i:318;i:318;i:326;i:326;i:342;i:342;i:371;i:371;i:379;i:379;i:411;i:411;i:441;i:441;i:458;i:458;i:474;i:474;i:541;i:541;i:543;i:543;i:545;i:545;i:547;i:547;i:802;i:802;i:805;i:805;i:812;i:812;i:814;i:814;i:824;i:824;i:826;i:826;i:842;i:842;i:916;i:916;i:953;i:953;i:1020;i:1020;i:1214;i:1214;i:1262;i:1262;i:1283;i:1283;i:1286;i:1286;i:1290;i:1290;i:1306;i:1306;i:1319;i:1319;i:1341;i:1341;i:1363;i:1363;i:1385;i:1385;i:1391;i:1391;i:1412;i:1412;i:1440;i:1440;i:1762;i:1762;i:1797;i:1797;i:1824;i:1824;i:1825;i:1825;i:1886;i:1886;i:1959;i:1959;i:1987;i:1987;i:2042;i:2042;i:2056;i:2056;i:2086;i:2086;i:2098;i:2098;i:2101;i:2101;i:2102;i:2102;i:2400;i:2400;i:2403;i:2403;i:2407;i:2407;i:2409;i:2409;i:2598;i:2598;i:2633;i:2633;i:2690;i:2690;i:3134;i:3134;i:3333;i:3333;i:3334;i:3334;i:3335;i:3335;i:1;i:3513;i:7;i:3514;i:8;i:3515;i:9;i:3516;i:10;i:3517;i:11;i:3518;i:12;i:3519;i:13;i:3520;i:14;i:3521;i:15;i:3522;i:16;i:3523;i:112;i:112;i:114;i:114;i:116;i:116;i:119;i:119;i:121;i:121;i:123;i:123;i:125;i:125;i:3336;i:3336;i:3532;i:3532;i:343;i:343;i:344;i:344;i:345;i:345;i:346;i:346;i:347;i:347;i:349;i:349;i:350;i:350;i:351;i:351;i:352;i:352;i:353;i:353;i:354;i:354;i:355;i:355;i:372;i:372;i:373;i:373;i:374;i:374;i:375;i:375;i:376;i:376;i:2110;i:2110;i:2111;i:2111;i:2120;i:2120;i:2340;i:2340;i:2341;i:2341;i:2342;i:2342;i:2343;i:2343;i:2344;i:2344;i:2345;i:2345;i:2347;i:2347;i:2348;i:2348;i:2352;i:2352;i:2353;i:2353;i:2354;i:2354;i:2357;i:2357;i:2358;i:2358;i:2360;i:2360;i:2361;i:2361;i:2362;i:2362;i:2366;i:2366;i:2367;i:2367;i:2368;i:2368;i:2369;i:2369;i:1176;i:1176;i:1177;i:1177;i:1178;i:1178;i:1179;i:1179;i:1180;i:1180;i:1181;i:1181;i:1182;i:1182;i:1184;i:1184;i:1185;i:1185;i:1186;i:1186;i:1187;i:1187;i:1188;i:1188;i:2370;i:2370;i:2371;i:2371;i:2372;i:2372;i:2373;i:2373;i:2375;i:2375;i:2441;i:2441;i:2442;i:2442;i:3520;i:3533;i:947;i:947;i:948;i:948;i:949;i:949;i:950;i:950;i:951;i:951;i:952;i:952;i:1081;i:1081;i:1083;i:1083;i:1084;i:1084;i:1085;i:1085;i:1441;i:1441;i:1442;i:1442;i:1443;i:1443;i:1444;i:1444;i:1445;i:1445;i:1446;i:1446;i:3515;i:3534;i:3516;i:3535;i:3521;i:3536;i:3523;i:3537;i:1465;i:1465;i:1468;i:1468;i:1469;i:1469;i:1866;i:1866;i:1867;i:1867;i:3514;i:3538;i:3517;i:3539;i:3518;i:3540;}s:8:\"comments\";a:24:{i:5;i:2;i:6;i:3;i:7;i:4;i:37;i:5;i:38;i:6;i:39;i:7;i:40;i:8;i:41;i:9;i:42;i:10;i:43;i:11;i:44;i:12;i:45;i:13;i:46;i:14;i:47;i:15;i:48;i:16;i:49;i:17;i:50;i:18;i:51;i:19;i:52;i:20;i:53;i:21;i:54;i:22;i:55;i:23;i:35;i:24;i:36;i:25;}}', 'yes'),
(1049, 'cherry-projects-db-version', '1.2.3', 'yes'),
(782, 'widget_cherry_socialize_widget_instagram', 'a:3:{i:2;a:12:{s:5:\"title\";s:12:\"Latest Works\";s:8:\"endpoint\";s:7:\"hashtag\";s:7:\"hashtag\";s:12:\"62222_reflax\";s:4:\"self\";s:0:\"\";s:13:\"photo_counter\";s:1:\"6\";s:10:\"photo_size\";s:3:\"low\";s:10:\"photo_link\";s:4:\"true\";s:15:\"display_caption\";a:1:{s:21:\"display_caption_check\";s:5:\"false\";}s:14:\"caption_length\";s:2:\"10\";s:12:\"display_date\";a:1:{s:18:\"display_date_check\";s:5:\"false\";}s:9:\"follow_us\";a:1:{s:15:\"follow_us_check\";s:5:\"false\";}s:15:\"follow_us_label\";s:9:\"Follow Us\";}i:3;a:12:{s:5:\"title\";s:12:\"Latest Works\";s:8:\"endpoint\";s:7:\"hashtag\";s:7:\"hashtag\";s:12:\"62222_reflax\";s:4:\"self\";s:0:\"\";s:13:\"photo_counter\";s:1:\"6\";s:10:\"photo_size\";s:3:\"low\";s:10:\"photo_link\";s:4:\"true\";s:15:\"display_caption\";a:1:{s:21:\"display_caption_check\";s:5:\"false\";}s:14:\"caption_length\";s:2:\"10\";s:12:\"display_date\";a:1:{s:18:\"display_date_check\";s:5:\"false\";}s:9:\"follow_us\";a:1:{s:15:\"follow_us_check\";s:5:\"false\";}s:15:\"follow_us_label\";s:9:\"Follow Us\";}s:12:\"_multiwidget\";i:1;}', 'yes'),
(765, '_transient_wc_count_comments', 'O:8:\"stdClass\":7:{s:14:\"total_comments\";i:0;s:3:\"all\";i:0;s:9:\"moderated\";i:0;s:8:\"approved\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}', 'yes'),
(2703, '_site_transient_timeout_theme_roots', '1499265787', 'no'),
(2704, '_site_transient_theme_roots', 'a:4:{s:6:\"swanxy\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}', 'no');
INSERT INTO `wp_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(886, 'tm_builder_fonts', 'a:809:{s:7:\"ABeeZee\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Abel\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Abhaya Libre\";a:3:{s:6:\"styles\";s:19:\"400,500,600,700,800\";s:13:\"character_set\";s:23:\"sinhala,latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Abril Fatface\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Aclonica\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Acme\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Actor\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Adamina\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Advent Pro\";a:3:{s:6:\"styles\";s:27:\"100,200,300,400,500,600,700\";s:13:\"character_set\";s:21:\"latin-ext,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Aguafina Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Akronim\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Aladin\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Aldrich\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Alef\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:12:\"hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Alegreya\";a:3:{s:6:\"styles\";s:38:\"400,italic,700,700italic,900,900italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Alegreya SC\";a:3:{s:6:\"styles\";s:38:\"400,italic,700,700italic,900,900italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Alegreya Sans\";a:3:{s:6:\"styles\";s:94:\"100,100italic,300,300italic,400,italic,500,500italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Alegreya Sans SC\";a:3:{s:6:\"styles\";s:94:\"100,100italic,300,300italic,400,italic,500,500italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Alex Brush\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Alfa Slab One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Alice\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Alike\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Alike Angular\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Allan\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Allerta\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Allerta Stencil\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Allura\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Almendra\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Almendra Display\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Almendra SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Amarante\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Amaranth\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Amatic SC\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Amatica SC\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:22:\"latin-ext,hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Amethysta\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Amiko\";a:3:{s:6:\"styles\";s:11:\"400,600,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Amiri\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:12:\"arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Amita\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Anaheim\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Andada\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Andika\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:48:\"cyrillic-ext,latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Angkor\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:24:\"Annie Use Your Telescope\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Anonymous Pro\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:30:\"latin-ext,cyrillic,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Antic\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Antic Didone\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Antic Slab\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Anton\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Arapey\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Arbutus\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Arbutus Slab\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:19:\"Architects Daughter\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Archivo Black\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Archivo Narrow\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Aref Ruqaa\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:12:\"arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Arima Madurai\";a:3:{s:6:\"styles\";s:31:\"100,200,300,400,500,700,800,900\";s:13:\"character_set\";s:32:\"latin-ext,tamil,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Arimo\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:71:\"cyrillic-ext,latin-ext,hebrew,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Arizonia\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Armata\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Artifika\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Arvo\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Arya\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Asap\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Asar\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Asset\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Assistant\";a:3:{s:6:\"styles\";s:23:\"200,300,400,600,700,800\";s:13:\"character_set\";s:12:\"hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Astloch\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Asul\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Athiti\";a:3:{s:6:\"styles\";s:23:\"200,300,400,500,600,700\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Atma\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:23:\"latin-ext,bengali,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Atomic Age\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Aubrey\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Audiowide\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Autour One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Average\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Average Sans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:19:\"Averia Gruesa Libre\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Averia Libre\";a:3:{s:6:\"styles\";s:38:\"300,300italic,400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Averia Sans Libre\";a:3:{s:6:\"styles\";s:38:\"300,300italic,400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Averia Serif Libre\";a:3:{s:6:\"styles\";s:38:\"300,300italic,400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Bad Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:14:\"cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Baloo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:37:\"latin-ext,devanagari,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Baloo Bhai\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:35:\"gujarati,latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Baloo Bhaina\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:32:\"latin-ext,oriya,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Baloo Chettan\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:36:\"latin-ext,malayalam,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Baloo Da\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:34:\"latin-ext,bengali,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Baloo Paaji\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:35:\"latin-ext,latin,vietnamese,gurmukhi\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Baloo Tamma\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:34:\"latin-ext,latin,vietnamese,kannada\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Baloo Thambi\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:32:\"latin-ext,tamil,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Balthazar\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Bangers\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Basic\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Battambang\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Baumans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Bayon\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Belgrano\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Belleza\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"BenchNine\";a:3:{s:6:\"styles\";s:11:\"300,400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Bentham\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Berkshire Swash\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Bevan\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Bigelow Rules\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Bigshot One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Bilbo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Bilbo Swash Caps\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"BioRhyme\";a:3:{s:6:\"styles\";s:19:\"200,300,400,700,800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"BioRhyme Expanded\";a:3:{s:6:\"styles\";s:19:\"200,300,400,700,800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Biryani\";a:3:{s:6:\"styles\";s:27:\"200,300,400,600,700,800,900\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Bitter\";a:3:{s:6:\"styles\";s:14:\"400,italic,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Black Ops One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Bokor\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Bonbon\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Boogaloo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Bowlby One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Bowlby One SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Brawler\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Bree Serif\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Bubblegum Sans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Bubbler One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Buda\";a:3:{s:6:\"styles\";s:3:\"300\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Buenard\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Bungee\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Bungee Hairline\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Bungee Inline\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Bungee Outline\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Bungee Shade\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Butcherman\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Butterfly Kids\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Cabin\";a:3:{s:6:\"styles\";s:52:\"400,italic,500,500italic,600,600italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Cabin Condensed\";a:3:{s:6:\"styles\";s:15:\"400,500,600,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Cabin Sketch\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Caesar Dressing\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Cagliostro\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Cairo\";a:3:{s:6:\"styles\";s:23:\"200,300,400,600,700,900\";s:13:\"character_set\";s:22:\"latin-ext,arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Calligraffitti\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Cambay\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Cambo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Candal\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Cantarell\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Cantata One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Cantora One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Capriola\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Cardo\";a:3:{s:6:\"styles\";s:14:\"400,italic,700\";s:13:\"character_set\";s:31:\"latin-ext,greek,latin,greek-ext\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Carme\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Carrois Gothic\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Carrois Gothic SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Carter One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Catamaran\";a:3:{s:6:\"styles\";s:35:\"100,200,300,400,500,600,700,800,900\";s:13:\"character_set\";s:21:\"latin-ext,tamil,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Caudex\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:31:\"latin-ext,greek,latin,greek-ext\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Caveat\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Caveat Brush\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Cedarville Cursive\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Ceviche One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Changa\";a:3:{s:6:\"styles\";s:27:\"200,300,400,500,600,700,800\";s:13:\"character_set\";s:22:\"latin-ext,arabic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Changa One\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Chango\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Chathura\";a:3:{s:6:\"styles\";s:19:\"100,300,400,700,800\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Chau Philomene One\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Chela One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Chelsea Market\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Chenla\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Cherry Cream Soda\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Cherry Swash\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Chewy\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Chicle\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Chivo\";a:3:{s:6:\"styles\";s:24:\"400,italic,900,900italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Chonburi\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:31:\"latin-ext,thai,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Cinzel\";a:3:{s:6:\"styles\";s:11:\"400,700,900\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Cinzel Decorative\";a:3:{s:6:\"styles\";s:11:\"400,700,900\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Clicker Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:4:\"Coda\";a:3:{s:6:\"styles\";s:7:\"400,800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Coda Caption\";a:3:{s:6:\"styles\";s:3:\"800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Codystar\";a:3:{s:6:\"styles\";s:7:\"300,400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Coiny\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:32:\"latin-ext,tamil,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Combo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Comfortaa\";a:3:{s:6:\"styles\";s:11:\"300,400,700\";s:13:\"character_set\";s:43:\"cyrillic-ext,latin-ext,cyrillic,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Coming Soon\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Concert One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Condiment\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Content\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Contrail One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Convergence\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Cookie\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Copse\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Corben\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Cormorant\";a:3:{s:6:\"styles\";s:66:\"300,300italic,400,italic,500,500italic,600,600italic,700,700italic\";s:13:\"character_set\";s:35:\"latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:18:\"Cormorant Garamond\";a:3:{s:6:\"styles\";s:66:\"300,300italic,400,italic,500,500italic,600,600italic,700,700italic\";s:13:\"character_set\";s:35:\"latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Cormorant Infant\";a:3:{s:6:\"styles\";s:66:\"300,300italic,400,italic,500,500italic,600,600italic,700,700italic\";s:13:\"character_set\";s:35:\"latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Cormorant SC\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:35:\"latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Cormorant Unicase\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:35:\"latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Cormorant Upright\";a:3:{s:6:\"styles\";s:19:\"300,400,500,600,700\";s:13:\"character_set\";s:26:\"latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Courgette\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Cousine\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:71:\"cyrillic-ext,latin-ext,hebrew,cyrillic,greek,latin,greek-ext,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Coustard\";a:3:{s:6:\"styles\";s:7:\"400,900\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:21:\"Covered By Your Grace\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Crafty Girls\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Creepster\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Crete Round\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Crimson Text\";a:3:{s:6:\"styles\";s:38:\"400,italic,600,600italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Croissant One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Crushed\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Cuprum\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Cutive\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Cutive Mono\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Damion\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Dancing Script\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Dangrek\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"David Libre\";a:3:{s:6:\"styles\";s:11:\"400,500,700\";s:13:\"character_set\";s:33:\"latin-ext,hebrew,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"Dawning of a New Day\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Days One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Dekko\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Delius\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:17:\"Delius Swash Caps\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:14:\"Delius Unicase\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Della Respira\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Denk One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Devonshire\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Dhurjati\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:12:\"latin,telugu\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Didact Gothic\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:53:\"cyrillic-ext,latin-ext,cyrillic,greek,latin,greek-ext\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Diplomata\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Diplomata SC\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Domine\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Donegal One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Doppio One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Dorsa\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Dosis\";a:3:{s:6:\"styles\";s:27:\"200,300,400,500,600,700,800\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Dr Sugiyama\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Droid Sans\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Droid Sans Mono\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Droid Serif\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Duru Sans\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Dynalight\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"EB Garamond\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:48:\"cyrillic-ext,latin-ext,cyrillic,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Eagle Lake\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Eater\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Economica\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Eczar\";a:3:{s:6:\"styles\";s:19:\"400,500,600,700,800\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Ek Mukta\";a:3:{s:6:\"styles\";s:27:\"200,300,400,500,600,700,800\";s:13:\"character_set\";s:26:\"latin-ext,devanagari,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"El Messiri\";a:3:{s:6:\"styles\";s:15:\"400,500,600,700\";s:13:\"character_set\";s:21:\"arabic,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Electrolize\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Elsie\";a:3:{s:6:\"styles\";s:7:\"400,900\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Elsie Swash Caps\";a:3:{s:6:\"styles\";s:7:\"400,900\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Emblema One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Emilys Candy\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Engagement\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Englebert\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Enriqueta\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Erica One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Esteban\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"Euphoria Script\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Ewert\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:3:\"Exo\";a:3:{s:6:\"styles\";s:122:\"100,100italic,200,200italic,300,300italic,400,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Exo 2\";a:3:{s:6:\"styles\";s:122:\"100,100italic,200,200italic,300,300italic,400,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic\";s:13:\"character_set\";s:24:\"latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:13:\"Expletus Sans\";a:3:{s:6:\"styles\";s:52:\"400,italic,500,500italic,600,600italic,700,700italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Fanwood Text\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Farsan\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:35:\"gujarati,latin-ext,latin,vietnamese\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fascinate\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Fascinate Inline\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Faster One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Fasthand\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fauna One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Federant\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Federo\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Felipa\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Fenix\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Finger Paint\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fira Mono\";a:3:{s:6:\"styles\";s:7:\"400,700\";s:13:\"character_set\";s:43:\"cyrillic-ext,latin-ext,cyrillic,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fira Sans\";a:3:{s:6:\"styles\";s:52:\"300,300italic,400,italic,500,500italic,700,700italic\";s:13:\"character_set\";s:43:\"cyrillic-ext,latin-ext,cyrillic,greek,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Fjalla One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fjord One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Flamenco\";a:3:{s:6:\"styles\";s:7:\"300,400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Flavors\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:10:\"Fondamento\";a:3:{s:6:\"styles\";s:10:\"400,italic\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Fontdiner Swanky\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:5:\"Forum\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:37:\"cyrillic-ext,latin-ext,cyrillic,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Francois One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:16:\"Frank Ruhl Libre\";a:3:{s:6:\"styles\";s:19:\"300,400,500,700,900\";s:13:\"character_set\";s:22:\"latin-ext,hebrew,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:12:\"Freckle Face\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:20:\"Fredericka the Great\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:11:\"Fredoka One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Freehand\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"khmer\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Fresca\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Frijole\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:7:\"Fruktur\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"Fugaz One\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"latin\";s:4:\"type\";s:10:\"sans-serif\";}s:9:\"GFS Didot\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:5:\"greek\";s:4:\"type\";s:10:\"sans-serif\";}s:15:\"GFS Neohellenic\";a:3:{s:6:\"styles\";s:24:\"400,italic,700,700italic\";s:13:\"character_set\";s:5:\"greek\";s:4:\"type\";s:10:\"sans-serif\";}s:8:\"Gabriela\";a:3:{s:6:\"styles\";s:3:\"400\";s:13:\"character_set\";s:15:\"latin-ext,latin\";s:4:\"type\";s:10:\"sans-serif\";}s:6:\"Gafata\";a:3:{s: